/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

abstract class MemoryCollection
implements Serializable {
    LinkedList array;
    ClassElement.Memory memory;
    private Element insertionMark;
    private boolean insertAfter;
    private String propertyName;
    private Object[] template;
    static final long serialVersionUID = -9215370960397120952L;

    public MemoryCollection(ClassElement.Memory memory, String string, Object[] objectArray) {
        this.memory = memory;
        this.propertyName = string;
        this.template = objectArray;
    }

    Collection makeClones(Object[] objectArray) {
        List list = this.array == null ? Collections.EMPTY_LIST : this.array;
        HashSet hashSet = new HashSet(list.size() * 4 / 3 + 1);
        Object object = list.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            hashSet.add(e);
        }
        object = new ArrayList(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (!hashSet.contains(object2)) {
                object.add(this.clone(object2));
                continue;
            }
            object.add(object2);
        }
        return object;
    }

    Collection cloneElements(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(this.clone(objectArray[i]));
        }
        return arrayList;
    }

    protected abstract Object clone(Object var1);

    public void change(Object[] objectArray, int n) {
        Collection<Object> collection;
        switch (n) {
            case 1: {
                collection = this.cloneElements(objectArray);
                break;
            }
            case -1: {
                collection = Arrays.asList(objectArray);
                break;
            }
            case 0: {
                collection = this.makeClones(objectArray);
                break;
            }
            default: {
                return;
            }
        }
        this.change(collection, n);
    }

    protected void change(Collection collection, int n) {
        boolean bl;
        switch (n) {
            case 1: {
                boolean bl2 = bl = collection.size() > 0;
                if (this.array != null) {
                    if (this.insertionMark != null) {
                        int n2 = this.array.indexOf(this.insertionMark);
                        if (n2 == -1) {
                            this.insertionMark = null;
                            n2 = this.array.size();
                        } else if (this.insertAfter) {
                            ++n2;
                        }
                        this.array.addAll(n2, collection);
                        break;
                    }
                    this.array.addAll(collection);
                    break;
                }
            }
            case 0: {
                bl = collection.size() > 0 || this.array != null && this.array.size() > 0;
                this.array = new LinkedList(collection);
                this.insertionMark = null;
                break;
            }
            case -1: {
                Element element = null;
                if (this.insertionMark != null && collection.contains(this.insertionMark)) {
                    HashSet hashSet = new HashSet(collection.size() * 4 / 3);
                    hashSet.addAll(collection);
                    int n3 = this.array.indexOf(this.insertionMark);
                    if (n3 == -1) {
                        this.insertionMark = null;
                    } else {
                        Object e;
                        ListIterator listIterator = this.array.listIterator(n3);
                        while (listIterator.hasNext()) {
                            e = listIterator.next();
                            if (hashSet.contains(e)) continue;
                            element = (Element)e;
                            this.insertAfter = false;
                            break;
                        }
                        if (element == null) {
                            listIterator = this.array.listIterator(n3);
                            while (listIterator.hasPrevious()) {
                                e = listIterator.previous();
                                if (hashSet.contains(e)) continue;
                                element = (Element)e;
                                this.insertAfter = true;
                                break;
                            }
                        }
                    }
                    this.insertionMark = element;
                }
                bl = this.array != null && this.array.removeAll(collection);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (bl) {
            this.memory.firePropertyChange(this.propertyName, null, null);
        }
    }

    public Object[] toArray() {
        if (this.array == null) {
            return this.template;
        }
        return this.array.toArray(this.template);
    }

    void markCurrent(Element element, boolean bl) {
        this.insertionMark = element;
        this.insertAfter = bl;
    }

    static class Class
    extends Member {
        private static final ClassElement[] EMPTY = new ClassElement[0];
        static final long serialVersionUID = 3206093459760846163L;

        public Class(ClassElement.Memory memory) {
            super(memory, "classes", EMPTY);
        }

        public MemberElement find(Identifier identifier, Type[] typeArray) {
            if (this.array == null) {
                return null;
            }
            Iterator iterator = this.array.iterator();
            while (iterator.hasNext()) {
                String string;
                ClassElement classElement = (ClassElement)iterator.next();
                Identifier identifier2 = classElement.getName();
                if (identifier.getFullName().equals(identifier2.getFullName())) {
                    return classElement;
                }
                if (!identifier.getName().equals(identifier2.getName()) || !(string = identifier.getFullName()).equals(identifier.getName())) continue;
                return classElement;
            }
            return null;
        }

        protected Object clone(Object object) {
            ClassElement.Memory memory = new ClassElement.Memory((ClassElement)object);
            ClassElement classElement = new ClassElement((ClassElement.Impl)memory, this.memory.getClassElement());
            memory.initialize((ClassElement)object);
            return classElement;
        }
    }

    static class Field
    extends Member {
        private static final FieldElement[] EMPTY = new FieldElement[0];
        static final long serialVersionUID = 5747776340409139399L;

        public Field(ClassElement.Memory memory) {
            super(memory, "fields", EMPTY);
        }

        protected Object clone(Object object) {
            return new FieldElement(new FieldElement.Memory((FieldElement)object), this.memory.getClassElement());
        }
    }

    static class Method
    extends Member {
        private static final MethodElement[] EMPTY = new MethodElement[0];
        static final long serialVersionUID = -745714645316747109L;

        public Method(ClassElement.Memory memory) {
            super(memory, "methods", EMPTY);
        }

        protected Object clone(Object object) {
            return new MethodElement(new MethodElement.Memory((MethodElement)object), this.memory.getClassElement());
        }
    }

    static class Constructor
    extends Member {
        private static final ConstructorElement[] EMPTY = new ConstructorElement[0];
        static final long serialVersionUID = 4314343816469864217L;

        public Constructor(ClassElement.Memory memory) {
            super(memory, "constructors", EMPTY);
        }

        protected Object clone(Object object) {
            ConstructorElement.Memory memory = new ConstructorElement.Memory((ConstructorElement)object);
            Identifier identifier = this.memory.getName();
            if (identifier != null) {
                memory.setName(Identifier.create(identifier.getName()));
            }
            return new ConstructorElement(memory, this.memory.getClassElement());
        }
    }

    static abstract class Member
    extends MemoryCollection {
        static final long serialVersionUID = 7875426480834524238L;

        public Member(ClassElement.Memory memory, String string, Object[] objectArray) {
            super(memory, string, objectArray);
        }

        public MemberElement find(Identifier identifier, Type[] typeArray) {
            if (this.array == null) {
                return null;
            }
            Iterator iterator = this.array.iterator();
            while (iterator.hasNext()) {
                MemberElement memberElement = (MemberElement)iterator.next();
                if (identifier != null && !identifier.equals(memberElement.getName()) || typeArray != null && !Member.equalTypes(typeArray, memberElement)) continue;
                return memberElement;
            }
            return null;
        }

        private static boolean equalTypes(Type[] typeArray, MemberElement memberElement) {
            MethodParameter[] methodParameterArray = ((ConstructorElement)memberElement).getParameters();
            if (methodParameterArray.length != typeArray.length) {
                return false;
            }
            int n = methodParameterArray.length;
            for (int i = 0; i < n; ++i) {
                if (methodParameterArray[i].getType().equals(typeArray[i])) continue;
                return false;
            }
            return true;
        }
    }

    static final class Initializer
    extends MemoryCollection {
        private static final InitializerElement[] EMPTY = new InitializerElement[0];
        static final long serialVersionUID = 5715072242254795093L;

        public Initializer(ClassElement.Memory memory) {
            super(memory, "initializers", EMPTY);
        }

        protected Object clone(Object object) {
            return new InitializerElement(new InitializerElement.Memory((InitializerElement)object), this.memory.getClassElement());
        }
    }

    static final class Interface
    extends MemoryCollection {
        Interface(ClassElement.Memory memory) {
            super(memory, "interfaces", new Identifier[0]);
        }

        Collection makeClones(Object[] objectArray) {
            return Arrays.asList(objectArray);
        }

        Collection cloneElements(Object[] objectArray) {
            return Arrays.asList(objectArray);
        }

        protected Object clone(Object object) {
            return object;
        }
    }
}

