/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class MethodElement
extends ConstructorElement {
    private static final ElementFormat HEADER_FORMAT = new ElementFormat("{m,,\" \"}{r} {n}({a}){e,\" throws \",}");
    static final long serialVersionUID = 2366156788906032138L;

    public MethodElement() {
        this(new Memory(), null);
    }

    public MethodElement(Impl impl, ClassElement classElement) {
        super(impl, classElement);
    }

    public Object clone() {
        return new MethodElement(new Memory(this), null);
    }

    final Impl getMethodImpl() {
        return (Impl)this.impl;
    }

    public Type getReturn() {
        return this.getMethodImpl().getReturn();
    }

    public void setReturn(Type type) throws SourceException {
        this.getMethodImpl().setReturn(type);
    }

    public int getModifiersMask() {
        if (this.isDeclaredInInterface()) {
            return 1025;
        }
        return 1343;
    }

    public final void setName(Identifier identifier) throws SourceException {
        ClassElement classElement = this.getDeclaringClass();
        if (classElement != null) {
            MethodParameter[] methodParameterArray = this.getParameters();
            Type[] typeArray = new Type[methodParameterArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = methodParameterArray[i].getType();
            }
            MethodElement methodElement = classElement.getMethod(identifier, typeArray);
            if (methodElement != null && methodElement != this) {
                String string = NbBundle.getMessage((Class)ElementFormat.class, (String)"FMT_EXC_RenameMethod", (Object)classElement.getName().getName(), (Object)identifier);
                this.throwSourceException(string);
            }
        }
        super.setName(identifier);
    }

    ElementFormat getFormat() {
        return HEADER_FORMAT;
    }

    void printerMark(ElementPrinter elementPrinter, int n) throws ElementPrinterInterruptException {
        elementPrinter.markMethod(this, n);
    }

    static class Memory
    extends ConstructorElement.Memory
    implements Impl {
        private Type type;
        static final long serialVersionUID = 2015834437815195149L;

        Memory() {
            this.type = Type.VOID;
        }

        Memory(MethodElement methodElement) {
            super(methodElement);
            this.type = methodElement.getReturn();
        }

        public Type getReturn() {
            return this.type;
        }

        public void setReturn(Type type) {
            Type type2 = this.type;
            this.type = type;
            this.firePropertyChange("return", type2, type);
        }

        public Object readResolve() {
            return new MethodElement(this, null);
        }
    }

    public static final class Key
    extends ConstructorElement.Key {
        private Identifier name;
        private Type returnType;

        public Key(Identifier identifier, Type[] typeArray) {
            super(typeArray);
            this.name = identifier;
        }

        public Key(Identifier identifier, Type[] typeArray, Type type) {
            this(identifier, typeArray);
            this.returnType = type;
        }

        public Key(MethodElement methodElement) {
            super(methodElement);
            this.name = methodElement.getName();
        }

        public Key(MethodElement methodElement, boolean bl) {
            this(methodElement);
            if (bl) {
                this.returnType = methodElement.getReturn();
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (!this.name.equals(key.name) || !super.equals(object)) {
                return false;
            }
            if (this.returnType == null || key.returnType == null) {
                return true;
            }
            return this.returnType.equals(key.returnType);
        }

        public int hashCode() {
            return super.hashCode() ^ this.name.getFullName().hashCode();
        }
    }

    public static interface Impl
    extends ConstructorElement.Impl {
        public static final long serialVersionUID = 7273573865765501815L;

        public Type getReturn();

        public void setReturn(Type var1) throws SourceException;
    }
}

