/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openide.filesystems.FileObject;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.util.Utilities;

public final class Type
implements Cloneable,
Serializable {
    private static final int T_BOOLEAN = 1;
    private static final int T_INT = 2;
    private static final int T_CHAR = 3;
    private static final int T_BYTE = 4;
    private static final int T_SHORT = 5;
    private static final int T_LONG = 6;
    private static final int T_FLOAT = 7;
    private static final int T_DOUBLE = 8;
    private static final int T_VOID = 9;
    private static final int T_CLASS = 16;
    private static final int T_ARRAY = 32;
    private static final int T_PRIMITIVE = 15;
    public static final Type VOID = new Type(9);
    public static final Type BOOLEAN = new Type(1);
    public static final Type INT = new Type(2);
    public static final Type CHAR = new Type(3);
    public static final Type BYTE = new Type(4);
    public static final Type SHORT = new Type(5);
    public static final Type LONG = new Type(6);
    public static final Type FLOAT = new Type(7);
    public static final Type DOUBLE = new Type(8);
    private static HashMap text2type = new HashMap();
    private static final String L_VOID = "void";
    private static final String L_BOOLEAN = "boolean";
    private static final String L_INT = "int";
    private static final String L_CHAR = "char";
    private static final String L_BYTE = "byte";
    private static final String L_SHORT = "short";
    private static final String L_LONG = "long";
    private static final String L_FLOAT = "float";
    private static final String L_DOUBLE = "double";
    private static final String[] PRIMITIVE_NAMES = new String[]{"void", "boolean", "int", "char", "byte", "short", "long", "float", "double"};
    private int kind;
    private Type elementType = null;
    private Identifier classType = null;
    static final long serialVersionUID = 8997425134968958367L;

    private Type(int n) {
        this.kind = n;
    }

    private Type(Type type) {
        this.kind = 32;
        this.elementType = type;
    }

    private Type(Identifier identifier) {
        this.kind = 16;
        this.classType = identifier;
    }

    private Object readResolve() {
        switch (this.kind) {
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return INT;
            }
            case 3: {
                return CHAR;
            }
            case 4: {
                return BYTE;
            }
            case 5: {
                return SHORT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return VOID;
            }
            case 16: {
                return Type.createClass(this.classType);
            }
            case 32: {
                return Type.createArray(this.elementType);
            }
        }
        throw new InternalError();
    }

    public static String[] getTypesNames() {
        return PRIMITIVE_NAMES;
    }

    public static Type createArray(Type type) {
        return new Type(type);
    }

    public static Type createClass(Identifier identifier) {
        return new Type(identifier);
    }

    public static Type createFromClass(Class clazz) {
        if (clazz.isArray()) {
            return Type.createArray(Type.createFromClass(clazz.getComponentType()));
        }
        if (clazz.isPrimitive()) {
            if (Void.TYPE.equals(clazz)) {
                return VOID;
            }
            if (Boolean.TYPE.equals(clazz)) {
                return BOOLEAN;
            }
            if (Integer.TYPE.equals(clazz)) {
                return INT;
            }
            if (Character.TYPE.equals(clazz)) {
                return CHAR;
            }
            if (Byte.TYPE.equals(clazz)) {
                return BYTE;
            }
            if (Short.TYPE.equals(clazz)) {
                return SHORT;
            }
            if (Long.TYPE.equals(clazz)) {
                return LONG;
            }
            if (Float.TYPE.equals(clazz)) {
                return FLOAT;
            }
            if (Double.TYPE.equals(clazz)) {
                return DOUBLE;
            }
            throw new InternalError();
        }
        return Type.createClass(Identifier.create(Type.getClassIdentifier(clazz)));
    }

    private static String getClassIdentifier(Class clazz) {
        if (clazz.getDeclaringClass() == null) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        clazz = clazz.getDeclaringClass();
        do {
            stringBuffer.setCharAt(clazz.getName().length(), '.');
        } while ((clazz = clazz.getDeclaringClass()) != null);
        return stringBuffer.toString();
    }

    public static Type parse(String string) throws IllegalArgumentException {
        Object object;
        if (string.endsWith(".TYPE")) {
            int n = string.length();
            Object object2 = object = string.startsWith("java.lang.") ? string.substring(10, n - 5) : string.substring(0, n - 5);
            if ("Void".equals(object)) {
                return VOID;
            }
            if ("Boolean".equals(object)) {
                return BOOLEAN;
            }
            if ("Integer".equals(object)) {
                return INT;
            }
            if ("Character".equals(object)) {
                return CHAR;
            }
            if ("Byte".equals(object)) {
                return BYTE;
            }
            if ("Short".equals(object)) {
                return SHORT;
            }
            if ("Long".equals(object)) {
                return LONG;
            }
            if ("Float".equals(object)) {
                return FLOAT;
            }
            if ("Double".equals(object)) {
                return DOUBLE;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []", true);
        object = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) continue;
            switch (n) {
                case 0: {
                    object = (Type)text2type.get(string2);
                    if (object == null) {
                        int n2;
                        String string3 = string2;
                        if (string3.length() == 0) {
                            throw new IllegalArgumentException();
                        }
                        do {
                            String string4;
                            if ((n2 = string3.indexOf(".")) == -1) {
                                string4 = string3;
                            } else {
                                string4 = string3.substring(0, n2);
                                string3 = string3.substring(n2 + 1, string3.length());
                            }
                            if (string4.length() != 0 && Utilities.isJavaIdentifier((String)string4)) continue;
                            throw new IllegalArgumentException();
                        } while (n2 != -1);
                        object = Type.createClass(Identifier.create(string2));
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    if (!string2.equals("[")) {
                        throw new IllegalArgumentException();
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    if (!string2.equals("]")) {
                        throw new IllegalArgumentException();
                    }
                    object = Type.createArray((Type)object);
                    n = 1;
                }
            }
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        return object;
    }

    public boolean isPrimitive() {
        return (this.kind & 0xF) != 0;
    }

    public boolean isArray() {
        return this.kind == 32;
    }

    public boolean isClass() {
        return this.kind == 16;
    }

    public Type getElementType() throws IllegalStateException {
        if (this.isArray()) {
            return this.elementType;
        }
        throw new IllegalStateException();
    }

    public Identifier getClassName() throws IllegalStateException {
        if (this.isClass()) {
            return this.classType;
        }
        throw new IllegalStateException();
    }

    public Class toClass() throws ClassNotFoundException {
        return this.toClass(null);
    }

    public Class toClass(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.isPrimitive()) {
            switch (this.kind) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Integer.TYPE;
                }
                case 3: {
                    return Character.TYPE;
                }
                case 4: {
                    return Byte.TYPE;
                }
                case 5: {
                    return Short.TYPE;
                }
                case 6: {
                    return Long.TYPE;
                }
                case 7: {
                    return Float.TYPE;
                }
                case 8: {
                    return Double.TYPE;
                }
            }
            return Void.TYPE;
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (this.isClass()) {
            return Class.forName(this.classType.getFullName(), true, classLoader);
        }
        String string = "";
        Type type = this;
        while (type.isArray()) {
            string = string + "[";
            type = type.getElementType();
        }
        string = type.isClass() ? string + "L" + type.classType.getFullName() + ";" : string + Type.getPrimitiveCode(type.kind);
        return Class.forName(string, true, classLoader);
    }

    StringBuffer getAsString(StringBuffer stringBuffer, boolean bl) {
        if (this.isPrimitive()) {
            switch (this.kind) {
                case 1: {
                    return stringBuffer.append(L_BOOLEAN);
                }
                case 2: {
                    return stringBuffer.append(L_INT);
                }
                case 3: {
                    return stringBuffer.append(L_CHAR);
                }
                case 4: {
                    return stringBuffer.append(L_BYTE);
                }
                case 5: {
                    return stringBuffer.append(L_SHORT);
                }
                case 6: {
                    return stringBuffer.append(L_LONG);
                }
                case 7: {
                    return stringBuffer.append(L_FLOAT);
                }
                case 8: {
                    return stringBuffer.append(L_DOUBLE);
                }
            }
            return stringBuffer.append(L_VOID);
        }
        if (this.isClass()) {
            return stringBuffer.append(bl ? this.classType.getSourceName() : this.classType.getFullName());
        }
        return this.elementType.getAsString(stringBuffer, bl).append("[]");
    }

    private static String getPrimitiveCode(int n) {
        switch (n) {
            case 1: {
                return "Z";
            }
            case 2: {
                return "I";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "B";
            }
            case 5: {
                return "S";
            }
            case 6: {
                return "J";
            }
            case 7: {
                return "F";
            }
            case 8: {
                return "D";
            }
        }
        return "V";
    }

    public String getSourceString() {
        return this.getAsString(new StringBuffer(), true).toString();
    }

    public String getFullString() {
        return this.getAsString(new StringBuffer(), false).toString();
    }

    public String toString() {
        return this.getSourceString();
    }

    public final String getVMClassName() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation is not more supported. Use Type.getVMClassName(FileObject)");
    }

    public final String getVMClassName(FileObject fileObject) throws UnsupportedOperationException {
        if (this.isPrimitive()) {
            throw new UnsupportedOperationException("Primitive types unsupported");
        }
        return this.internalGetVMName(false, fileObject);
    }

    public final Identifier getTypeIdentifier() throws UnsupportedOperationException {
        if (this.isPrimitive() || this.isArray()) {
            throw new UnsupportedOperationException("Only class types supported");
        }
        return this.classType;
    }

    private String internalGetVMName(boolean bl, FileObject fileObject) {
        if (!this.isArray()) {
            String string = this.classType.getFullName();
            ClassElement classElement = ClassElement.forName(string, fileObject);
            if (classElement == null) {
                if (bl) {
                    return string.replace('.', '/');
                }
                return string;
            }
            return bl ? classElement.getSignature() : classElement.getVMName();
        }
        int n = 0;
        Type type = this;
        do {
            ++n;
        } while ((type = type.getElementType()).isArray());
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[');
        }
        if (type.isPrimitive()) {
            stringBuffer.append(Type.getPrimitiveCode(type.kind));
        } else {
            stringBuffer.append('L');
            stringBuffer.append(type.internalGetVMName(bl, fileObject));
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public final String getSignature() {
        throw new UnsupportedOperationException("Operation is not more supported. Use Type.getSignature(FileObject)");
    }

    public final String getSignature(FileObject fileObject) {
        if (this.isPrimitive()) {
            return Type.getPrimitiveCode(this.kind);
        }
        if (this.isClass()) {
            String string = this.classType.getFullName();
            ClassElement classElement = ClassElement.forName(string, fileObject);
            if (classElement != null) {
                string = classElement.getSignature();
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
            stringBuffer.append('L');
            stringBuffer.append(string);
            stringBuffer.append(';');
            return stringBuffer.toString();
        }
        return this.internalGetVMName(true, fileObject);
    }

    public boolean compareTo(Type type, boolean bl) {
        if (type.kind != this.kind) {
            return false;
        }
        switch (this.kind) {
            case 32: {
                return type.getElementType().compareTo(this.getElementType(), bl);
            }
            case 16: {
                return type.getClassName().compareTo(this.getClassName(), bl);
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof Type ? this.compareTo((Type)object, false) : false;
    }

    public int hashCode() {
        switch (this.kind) {
            case 32: {
                return this.getElementType().hashCode() << 1;
            }
            case 16: {
                return this.getClassName().hashCode();
            }
        }
        return System.identityHashCode(this);
    }

    static {
        text2type.put(L_VOID, VOID);
        text2type.put(L_BOOLEAN, BOOLEAN);
        text2type.put(L_INT, INT);
        text2type.put(L_CHAR, CHAR);
        text2type.put(L_BYTE, BYTE);
        text2type.put(L_SHORT, SHORT);
        text2type.put(L_LONG, LONG);
        text2type.put(L_FLOAT, FLOAT);
        text2type.put(L_DOUBLE, DOUBLE);
    }
}

