/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.openide.cookies.FilterCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.ClassElementFilter;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ClassChildren
extends Children.Keys
implements FilterCookie {
    private static int PPP_MASK = 7;
    protected static HashMap propToFilter;
    private static Comparator comparator;
    protected ClassElement element;
    protected ClassElementFilter filter;
    protected ElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private ElementListener propL;
    protected Collection[] cpl;
    private boolean nodesInited = false;

    public ClassChildren(ClassElement classElement) {
        this(DefaultFactory.READ_WRITE, classElement);
    }

    public ClassChildren(ElementNodeFactory elementNodeFactory, ClassElement classElement) {
        this.element = classElement;
        this.factory = elementNodeFactory;
        this.filter = null;
    }

    public Class getFilterClass() {
        return ClassElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object object) {
        if (!(object instanceof ClassElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (ClassElementFilter)object;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected void addNotify() {
        if (this.wPropL == null) {
            this.propL = new ElementListener(this);
            this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
        }
        this.refreshAllKeys();
        this.element.addPropertyChangeListener(this.wPropL);
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    private Node hookNodeName(Node node) {
        MemberElement memberElement = (MemberElement)node.getCookie(MemberElement.class);
        if (memberElement != null) {
            memberElement.addPropertyChangeListener(this.propL);
        }
        return node;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof MethodElement) {
            return new Node[]{this.hookNodeName(this.factory.createMethodNode((MethodElement)object))};
        }
        if (object instanceof FieldElement) {
            return new Node[]{this.hookNodeName(this.factory.createFieldNode((FieldElement)object))};
        }
        if (object instanceof ConstructorElement) {
            return new Node[]{this.hookNodeName(this.factory.createConstructorNode((ConstructorElement)object))};
        }
        if (object instanceof ClassElement) {
            return new Node[]{this.hookNodeName(this.factory.createClassNode((ClassElement)object))};
        }
        if (object instanceof InitializerElement) {
            return new Node[]{this.hookNodeName(this.factory.createInitializerNode((InitializerElement)object))};
        }
        return new Node[0];
    }

    protected void refreshAllKeys() {
        this.cpl = new Collection[this.getOrder().length];
        this.refreshKeys(255);
    }

    protected void refreshKeys(int n) {
        int[] nArray = this.getOrder();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & n) != 0 || this.cpl[i] == null) {
                this.cpl[i] = this.getKeysOfType(nArray[i]);
                linkedList.addAll(this.cpl[i]);
                continue;
            }
            linkedList.addAll(this.cpl[i]);
        }
        ElementListener elementListener = this.propL;
        if (elementListener != null) {
            elementListener.updateElements(linkedList);
        }
        this.setKeys(linkedList);
    }

    protected Collection getKeysOfType(int n) {
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        if ((n & 0x40) != 0) {
            linkedList.add(this.element.getSuperclass());
        }
        if ((n & 0x80) != 0) {
            linkedList.addAll(Arrays.asList(this.element.getInterfaces()));
        }
        if ((n & 0x10) != 0) {
            this.filterModifiers(this.element.getFields(), linkedList);
        }
        if ((n & 8) != 0) {
            this.filterModifiers(this.element.getConstructors(), linkedList);
            linkedList.addAll(Arrays.asList(this.element.getInitializers()));
        }
        if ((n & 0x20) != 0) {
            this.filterModifiers(this.element.getMethods(), linkedList);
        }
        if ((n & 6) != 0) {
            this.filterClassModifiers(this.element.getClasses(), linkedList, n);
        }
        if (this.filter == null || this.filter.isSorted()) {
            Collections.sort(linkedList, comparator);
        }
        return linkedList;
    }

    protected int[] getOrder() {
        return this.filter == null || this.filter.getOrder() == null ? ClassElementFilter.DEFAULT_ORDER : this.filter.getOrder();
    }

    private int getModifierFilter() {
        if (this.filter == null) {
            return 65543;
        }
        return this.filter.getModifiers();
    }

    private void filterModifiers(MemberElement[] memberElementArray, Collection collection) {
        int n = this.getModifierFilter();
        int n2 = memberElementArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = memberElementArray[i].getModifiers();
            if ((n3 & PPP_MASK) == 0) {
                n3 += 65536;
            }
            if ((n3 & n) == 0) continue;
            collection.add(memberElementArray[i]);
        }
    }

    private void filterClassModifiers(ClassElement[] classElementArray, Collection collection, int n) {
        int n2 = this.getModifierFilter();
        int n3 = classElementArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = classElementArray[i].getModifiers();
            if ((n4 & PPP_MASK) == 0) {
                n4 += 65536;
            }
            if ((n4 & n2) == 0) continue;
            if (classElementArray[i].isClass()) {
                if ((n & 2) == 0) continue;
                collection.add(classElementArray[i]);
                continue;
            }
            if ((n & 4) == 0) continue;
            collection.add(classElementArray[i]);
        }
    }

    static {
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof MemberElement) {
                    if (object2 instanceof MemberElement) {
                        return ((MemberElement)object).getName().getName().compareToIgnoreCase(((MemberElement)object2).getName().getName());
                    }
                    return -1;
                }
                if (object2 instanceof MemberElement) {
                    return 1;
                }
                return 0;
            }
        };
        propToFilter = new HashMap();
        propToFilter.put("classes", new Integer(6));
        propToFilter.put("methods", new Integer(32));
        propToFilter.put("fields", new Integer(16));
        propToFilter.put("constructors", new Integer(8));
        propToFilter.put("initializers", new Integer(8));
    }

    private static final class ElementListener
    extends WeakReference
    implements Runnable,
    PropertyChangeListener {
        Collection elements;

        ElementListener(ClassChildren classChildren) {
            super(classChildren, Utilities.activeReferenceQueue());
        }

        ClassChildren getClassChildren() {
            Object t = this.get();
            return (ClassChildren)((Object)t);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n;
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            ClassChildren classChildren = this.getClassChildren();
            if (classChildren == null) {
                return;
            }
            if (object != classChildren.element) {
                if (!(object instanceof MemberElement) || string != null && "name" != string) return;
                n = object instanceof MethodElement ? 32 : (object instanceof ConstructorElement ? 8 : (object instanceof FieldElement ? 16 : 6));
            } else {
                Integer n2 = (Integer)propToFilter.get(string);
                if (n2 == null) {
                    return;
                }
                n = n2;
            }
            classChildren.refreshKeys(n);
        }

        void updateElements(Collection collection) {
            this.elements = collection;
        }

        public void run() {
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Element)) continue;
                Element element = (Element)e;
                element.removePropertyChangeListener(this);
            }
        }
    }
}

