/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementBeanModel;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassCustomizer
extends JPanel {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)ClassCustomizer.class);
    private static final String[] COMMON_TYPES = new String[]{"java.lang.Object", "java.awt.Component", "javax.swing.JComponent", "javax.swing.JPanel"};
    ClassElement element;
    boolean isOK = true;
    private JPanel classPanel;
    private JLabel jLabel1;
    private JTextField nameTextField;
    private JLabel jLabel2;
    private JComboBox superClassCombo;
    private JPanel typePanel;
    private JRadioButton classRadioButton;
    private JRadioButton interfaceRadioButton;
    private JPanel jPanel3;
    private JPanel modifierPanel;
    private JPanel interfacesPanel;

    public ClassCustomizer(ClassElement classElement) {
        this.element = classElement;
        this.initComponents();
        this.classPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_ClassFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.typePanel.setBorder(new TitledBorder(bundle.getString("CTL_ClassType")));
        this.modifierPanel.setBorder(new TitledBorder(bundle.getString("CTL_Modifiers")));
        this.interfacesPanel.setBorder(new TitledBorder(bundle.getString("CTL_Interfaces")));
        this.modifierPanel.add((Component)ElementBeanModel.createModifiersPanel(classElement), "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.classRadioButton);
        buttonGroup.add(this.interfaceRadioButton);
        Identifier identifier = classElement.getSuperclass();
        this.superClassCombo.setSelectedItem(identifier == null ? "" : identifier.getFullName());
        if (classElement.isClass()) {
            this.classRadioButton.setSelected(true);
        } else {
            this.interfaceRadioButton.setSelected(true);
            this.superClassCombo.setEnabled(false);
        }
        this.classRadioButton.setEnabled(false);
        this.interfaceRadioButton.setEnabled(false);
        this.nameTextField.setText(classElement.getName().getName());
        this.interfacesPanel.add((Component)ElementBeanModel.createPropertyPanel(classElement, "interfaces"), "Center");
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.classPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.superClassCombo = new JComboBox<String>(COMMON_TYPES);
        this.typePanel = new JPanel();
        this.classRadioButton = new JRadioButton();
        this.interfaceRadioButton = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.modifierPanel = new JPanel();
        this.interfacesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.classPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Name"));
        this.jLabel1.setLabelFor(this.nameTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 0, 0, 8);
        gridBagConstraints.anchor = 13;
        this.classPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ClassCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.classPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_Superclass"));
        this.jLabel2.setLabelFor(this.superClassCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        gridBagConstraints.anchor = 13;
        this.classPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.superClassCombo.setEditable(true);
        this.superClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassCustomizer.this.superClassComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.classPanel.add((Component)this.superClassCombo, gridBagConstraints);
        this.typePanel.setLayout(new GridBagLayout());
        this.classRadioButton.setText(bundle.getString("CTL_Class"));
        this.classRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassCustomizer.this.switchClassAndInterface(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(4, 8, 4, 4);
        this.typePanel.add((Component)this.classRadioButton, gridBagConstraints2);
        this.interfaceRadioButton.setText(bundle.getString("CTL_Interface"));
        this.interfaceRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassCustomizer.this.switchClassAndInterface(actionEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(4, 4, 4, 8);
        this.typePanel.add((Component)this.interfaceRadioButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        this.classPanel.add((Component)this.typePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        this.classPanel.add((Component)this.jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        this.add((Component)this.classPanel, gridBagConstraints3);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints3);
        this.interfacesPanel.setLayout(new BorderLayout());
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        this.add((Component)this.interfacesPanel, gridBagConstraints3);
    }

    private void superClassComboActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string;
        block7: {
            Identifier identifier = this.element.getSuperclass();
            string = identifier == null ? "" : identifier.getFullName();
            Object object = this.superClassCombo.getSelectedItem();
            if (object == null) {
                this.superClassCombo.setSelectedItem(string);
                return;
            }
            final String string2 = object.toString();
            bl = false;
            try {
                if (!string.equals(string2)) {
                    try {
                        SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                            public void run() throws SourceException {
                                ClassCustomizer.this.element.setSuperclass(string2.equals("") ? null : Identifier.create(string2));
                            }
                        });
                        bl = true;
                    }
                    catch (SourceException sourceException) {
                        ErrorManager.getDefault().notify((Throwable)sourceException);
                    }
                    break block7;
                }
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            }
        }
        this.isOK = bl;
        if (!bl) {
            this.superClassCombo.setSelectedItem(string);
        }
    }

    private void switchClassAndInterface(ActionEvent actionEvent) {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        void var5_8;
        if (focusEvent != null && focusEvent.isTemporary()) {
            return;
        }
        String string = this.nameTextField.getText();
        String string2 = this.element.getName().getName();
        boolean bl = false;
        Object var5_5 = null;
        if (Utilities.isJavaIdentifier((String)string)) {
            if (string2.equals(string)) return;
            final Identifier identifier = Identifier.create(string);
            try {
                SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ClassCustomizer.this.element.setName(identifier);
                    }
                });
                bl = true;
            }
            catch (SourceException sourceException) {
                SourceException sourceException2 = sourceException;
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
        if (var5_8 == null) return;
        ErrorManager.getDefault().notify((Throwable)var5_8);
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ClassNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClassNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_ClassCustomizerDialog");
    }

    public boolean isOK() {
        this.superClassComboActionPerformed(null);
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }
}

