/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import [Lorg.openide.src.Identifier;;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassCustomizer;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class ClassElementNode
extends MemberElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"classOrInterface"};
    static /* synthetic */ Class class$org$openide$src$Element;

    public ClassElementNode(ClassElement classElement, Children children, boolean bl) {
        super(classElement, children, bl);
        this.setElementFormat0(classElement.isInterface() ? sourceOptions.getInterfaceElementFormat() : sourceOptions.getClassElementFormat());
    }

    public HelpCtx getHelpCtx() {
        if (((ClassElement)this.element).isClassOrInterface()) {
            return new HelpCtx("org.openide.src.nodes.ClassNode");
        }
        return new HelpCtx("org.openide.src.nodes.InterfaceNode");
    }

    protected String resolveIconBase() {
        return ((ClassElement)this.element).isInterface() ? "org/openide/src/resources/interface" : "org/openide/src/resources/class";
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getHintElementFormat() {
        return ((ClassElement)this.element).isInterface() ? sourceOptions.getInterfaceElementLongFormat() : sourceOptions.getClassElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createModifiersProperty(this.writeable));
        set.put(this.createNameProperty(this.writeable));
        if (((ClassElement)this.element).isClass()) {
            set.put(this.createSuperclassProperty(this.writeable));
        }
        set.put(this.createInterfacesProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                ClassElement classElement = (ClassElement)ClassElementNode.this.element;
                if (classElement.getDeclaringClass() != null) {
                    classElement.getDeclaringClass().removeClass(classElement);
                } else {
                    classElement.getSource().removeClass(classElement);
                }
            }
        });
        super.destroy();
    }

    public Component getCustomizer() {
        return new ClassCustomizer((ClassElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        if (this.isWriteable()) {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                this.createMultiPasteTypes(transferable, list, 1);
                this.createMultiPasteTypes(transferable, list, 6);
                return;
            }
            for (int i = 0; i <= 1; ++i) {
                final boolean bl = i == 1;
                final Element element = (Element)NodeTransfer.cookie((Transferable)transferable, (int)(bl ? 6 : 1), (Class)(class$org$openide$src$Element == null ? ClassElementNode.class$("org.openide.src.Element") : class$org$openide$src$Element));
                if (element == null || !ClassElementNode.isValidElement(element)) continue;
                list.add(new PasteType(){

                    public Transferable paste() throws IOException {
                        ClassElementNode.this.pasteElement(element, bl);
                        return bl ? ExTransferable.EMPTY : null;
                    }
                });
            }
        }
        super.createPasteTypes(transferable, list);
    }

    private static boolean isValidElement(Element element) {
        Element.Impl2 impl2 = (Element.Impl2)element.getCookie(Element.Impl2.class);
        return impl2 == null || impl2.isValid();
    }

    private void createMultiPasteTypes(Transferable transferable, List list, int n) {
        Element element;
        Node node;
        MultiTransferObject multiTransferObject;
        try {
            multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        int n2 = multiTransferObject.getCount();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < n2 && (node = NodeTransfer.node((Transferable)multiTransferObject.getTransferableAt(i), (int)n)) != null && (element = (Element)node.getCookie(class$org$openide$src$Element == null ? ClassElementNode.class$("org.openide.src.Element") : class$org$openide$src$Element)) != null && ClassElementNode.isValidElement(element) && (element instanceof MemberElement || element instanceof InitializerElement); ++i) {
            this.addNodeCandidate(linkedList, element);
        }
        if (linkedList.isEmpty()) {
            return;
        }
        list.add(new SourceEditSupport.ClassMultiPasteType(this, linkedList, (n & 6) > 0));
    }

    private void addNodeCandidate(Collection collection, Element element) {
        ClassElement classElement = this.findEnclosingClass(element);
        SourceElement sourceElement = classElement.getSource();
        String string = classElement.getName().getFullName();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            ClassElement classElement2 = this.findEnclosingClass(element2);
            if (classElement2.getSource() != sourceElement) continue;
            if (classElement2 == classElement) {
                if (element2 == classElement2) {
                    return;
                }
                if (element != classElement) break;
                iterator.remove();
                continue;
            }
            String string2 = classElement2.getName().getFullName();
            if (string.startsWith(string2)) {
                if (classElement2 != element2) continue;
                return;
            }
            if (!string2.startsWith(string)) continue;
            if (classElement != element) break;
            iterator.remove();
        }
        collection.add(element);
    }

    private ClassElement findEnclosingClass(Element element) {
        if (element instanceof ClassElement) {
            return (ClassElement)element;
        }
        if (element instanceof MemberElement) {
            return ((MemberElement)element).getDeclaringClass();
        }
        if (element instanceof InitializerElement) {
            return ((InitializerElement)element).getDeclaringClass();
        }
        return null;
    }

    PropertyChangeListener createElementListener() {
        return new ClassElementListener();
    }

    void pasteElement(final Element element, final boolean bl) throws IOException {
        final boolean[] blArray = new boolean[]{false};
        if (element instanceof ClassElement) {
            ClassElement classElement = (ClassElement)element;
            for (ClassElement classElement2 = (ClassElement)this.element; classElement2 != null; classElement2 = classElement2.getDeclaringClass()) {
                if (classElement != classElement2) continue;
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Recursion detected"), bundle.getString("ERR_RecursePaste"));
            }
        }
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                Element element2;
                ClassElement classElement = (ClassElement)ClassElementNode.this.element;
                if (element instanceof InitializerElement) {
                    element2 = (InitializerElement)element;
                    classElement.addInitializer((InitializerElement)element2);
                }
                if (element instanceof FieldElement) {
                    classElement.addField((FieldElement)element);
                } else if (element instanceof MethodElement) {
                    element2 = (MethodElement)element;
                    if (((ClassElement)ClassElementNode.this.element).isInterface()) {
                        if (bl && ((ConstructorElement)element2).getBody() != null && !((ConstructorElement)element2).getBody().trim().equals("") && !ClassElementNode.this.isPastingConfirmed((MethodElement)element2)) {
                            blArray[0] = true;
                            return;
                        }
                        element2 = (MethodElement)((MethodElement)element2).clone();
                        ((ConstructorElement)element2).setBody(null);
                    } else if (((ConstructorElement)element2).getBody() == null) {
                        element2 = (MethodElement)((MethodElement)element2).clone();
                        ((ConstructorElement)element2).setBody("");
                    }
                    classElement.addMethod((MethodElement)element2);
                } else if (element instanceof ConstructorElement) {
                    classElement.addConstructor((ConstructorElement)element);
                } else if (element instanceof ClassElement) {
                    element2 = (ClassElement)element;
                    classElement.addClass((ClassElement)element2);
                    ClassElement classElement2 = classElement.getClass(Identifier.create(((MemberElement)element2).getName().getName()));
                    if (((MemberElement)element2).getDeclaringClass() == null && classElement2 != null) {
                        classElement2.setModifiers(classElement2.getModifiers() | 8);
                    }
                }
            }
        });
        if (bl && !blArray[0]) {
            Element element2;
            ClassElement classElement;
            SourceElement sourceElement = null;
            if (element instanceof InitializerElement) {
                classElement = ((InitializerElement)element).getDeclaringClass();
            } else if (element instanceof MemberElement) {
                classElement = ((MemberElement)element).getDeclaringClass();
                if (element instanceof ClassElement) {
                    element2 = (ClassElement)element;
                    sourceElement = ((ClassElement)element2).getSource();
                }
            } else {
                classElement = null;
            }
            if (sourceElement == null && classElement != null) {
                sourceElement = classElement.getSource();
            }
            element2 = sourceElement;
            SourceEditSupport.ExceptionalRunnable exceptionalRunnable = new SourceEditSupport.ExceptionalRunnable((SourceElement)element2){
                private final /* synthetic */ SourceElement val$classSource;
                {
                    this.val$classSource = sourceElement;
                }

                public void run() throws SourceException {
                    if (element instanceof InitializerElement) {
                        InitializerElement initializerElement = (InitializerElement)element;
                        if (classElement != null) {
                            classElement.removeInitializer(initializerElement);
                        }
                    } else if (element instanceof MemberElement) {
                        if (classElement != null) {
                            if (element instanceof FieldElement) {
                                classElement.removeField((FieldElement)element);
                            } else if (element instanceof MethodElement) {
                                classElement.removeMethod((MethodElement)element);
                            } else if (element instanceof ConstructorElement) {
                                classElement.removeConstructor((ConstructorElement)element);
                            } else if (element instanceof ClassElement) {
                                classElement.removeClass((ClassElement)element);
                            }
                        } else if (element instanceof ClassElement && this.val$classSource != null) {
                            this.val$classSource.removeClass((ClassElement)element);
                        }
                    }
                }
            };
            if (sourceElement == null) {
                try {
                    exceptionalRunnable.run();
                }
                catch (SourceException sourceException) {
                    throw new IOException(sourceException.getMessage());
                }
            } else {
                SourceEditSupport.invokeAtomicAsUser(element, exceptionalRunnable);
            }
        }
    }

    private boolean isPastingConfirmed(MethodElement methodElement) {
        String string = NbBundle.getMessage((Class)ClassElementNode.class, (String)"TIT_PastingMethod");
        String string2 = NbBundle.getMessage((Class)ClassElementNode.class, (String)"CONFIRM_DeleteMethodBody", (Object)methodElement.getName());
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation));
    }

    protected Node.Property createSuperclassProperty(boolean bl) {
        return new ElementNode.ElementProp("superclass", String.class, bl){

            public Object getValue() {
                Identifier identifier = ((ClassElement)ClassElementNode.this.element).getSuperclass();
                return identifier == null ? "" : identifier.getFullName();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Type type;
                super.setValue(object);
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                String string = ((String)object).trim();
                if (string != null && !"".equals(string) && !(type = Type.parse(string)).isClass()) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ClassElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, string){
                    private final /* synthetic */ String val$str;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$str = string;
                    }

                    public void run() throws SourceException {
                        Identifier identifier = this.val$str.equals("") ? null : Identifier.create(this.val$str);
                        ((ClassElement)5.access$200(this.this$1).element).setSuperclass(identifier);
                    }
                });
            }

            static /* synthetic */ ClassElementNode access$200(5 var0) {
                return var0.ClassElementNode.this;
            }
        };
    }

    protected Node.Property createInterfacesProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("interfaces", Identifier;.class, bl){

            public Object getValue() {
                return ((ClassElement)ClassElementNode.this.element).getInterfaces();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ClassElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((ClassElement)7.access$300(this.this$1).element).setInterfaces((Identifier[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ClassElementNode access$300(7 var0) {
                return var0.ClassElementNode.this;
            }
        };
        if (((ClassElement)this.element).isInterface()) {
            elementProp.setDisplayName(bundle.getString("PROP_superInterfaces"));
            elementProp.setShortDescription(bundle.getString("HINT_superInterfaces"));
        }
        elementProp.setValue("changeImmediate", Boolean.FALSE);
        return elementProp;
    }

    public NewType[] getNewTypes() {
        if (this.writeable) {
            return SourceEditSupport.createNewTypes((ClassElement)this.element);
        }
        return super.getNewTypes();
    }

    public Transferable clipboardCopy() {
        ExTransferable.Single single = NodeTransfer.transferable((Node)this, (int)1);
        ExTransferable exTransferable = ExTransferable.create((Transferable)single);
        exTransferable.put(NodeTransfer.createPaste((NodeTransfer.Paste)new SourceEditSupport.PackagePaste((ClassElement)this.element, false)));
        return exTransferable;
    }

    public Transferable clipboardCut() {
        ExTransferable.Single single = NodeTransfer.transferable((Node)this, (int)4);
        ExTransferable exTransferable = ExTransferable.create((Transferable)single);
        exTransferable.put(NodeTransfer.createPaste((NodeTransfer.Paste)new SourceEditSupport.PackagePaste((ClassElement)this.element, true)));
        return exTransferable;
    }

    private class ClassElementListener
    extends ElementNode.ElementListener {
        private ClassElementListener() {
            super(ClassElementNode.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("classOrInterface")) {
                ClassElementNode.this.setElementFormat(((ClassElement)ClassElementNode.this.element).isClass() ? ElementNode.sourceOptions.getClassElementFormat() : ElementNode.sourceOptions.getInterfaceElementFormat());
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

