/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import [Lorg.openide.src.Identifier;;
import [Lorg.openide.src.MethodParameter;;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.MethodCustomizer;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class ConstructorElementNode
extends MemberElementNode {
    public ConstructorElementNode(ConstructorElement constructorElement, boolean bl) {
        super(constructorElement, Children.LEAF, bl);
        this.setElementFormat0(sourceOptions.getConstructorElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.ConstructorNode");
    }

    protected String resolveIconBase() {
        int n = ((ConstructorElement)this.element).getModifiers();
        if (Modifier.isPrivate(n)) {
            return "org/openide/src/resources/constructorPrivate";
        }
        if (Modifier.isProtected(n)) {
            return "org/openide/src/resources/constructorProtected";
        }
        if (Modifier.isPublic(n)) {
            return "org/openide/src/resources/constructorPublic";
        }
        return "org/openide/src/resources/constructorPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return sourceOptions.getConstructorElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createModifiersProperty(this.writeable));
        set.put(this.createNameProperty(false));
        set.put(this.createParametersProperty(this.writeable));
        set.put(this.createExceptionsProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        if (!(this.element instanceof MethodElement)) {
            SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                public void run() throws SourceException {
                    ConstructorElement constructorElement = (ConstructorElement)ConstructorElementNode.this.element;
                    constructorElement.getDeclaringClass().removeConstructor(constructorElement);
                }
            });
        }
        super.destroy();
    }

    public boolean canRename() {
        return false;
    }

    public Component getCustomizer() {
        return new MethodCustomizer((ConstructorElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createParametersProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("parameters", MethodParameter;.class, bl){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getParameters();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof MethodParameter[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((ConstructorElement)2.access$000(this.this$1).element).setParameters((MethodParameter[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ConstructorElementNode access$000(2 var0) {
                return var0.ConstructorElementNode.this;
            }
        };
        elementProp.setValue("changeImmediate", Boolean.FALSE);
        return elementProp;
    }

    protected Node.Property createExceptionsProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("exceptions", Identifier;.class, bl){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getExceptions();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((ConstructorElement)4.access$100(this.this$1).element).setExceptions((Identifier[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ConstructorElementNode access$100(4 var0) {
                return var0.ConstructorElementNode.this;
            }
        };
        elementProp.setValue("changeImmediate", Boolean.FALSE);
        return elementProp;
    }
}

