/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.ClassChildren;
import org.openide.src.nodes.ClassElementFilter;
import org.openide.src.nodes.ClassElementNode;
import org.openide.src.nodes.ConstructorElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FieldElementNode;
import org.openide.src.nodes.IconStrings;
import org.openide.src.nodes.InitializerElementNode;
import org.openide.src.nodes.MethodElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class DefaultFactory
implements ElementNodeFactory,
IconStrings {
    public static final DefaultFactory READ_WRITE = new DefaultFactory(true);
    public static final DefaultFactory READ_ONLY = new DefaultFactory(false);
    private static final Object CATEGORY_FIELDS = new Object();
    private static final Object CATEGORY_METHODS = new Object();
    private static final Object CATEGORY_CONSTRUCTORS = new Object();
    private static final Collection CLASS_CATEGORIES = new Vector(3, 0);
    private static final Collection INTERFACE_CATEGORIES;
    private static final int FILTER_CATEGORIES = 4096;
    private boolean writeable;
    private static final SystemAction[] CATEGORY_ACTIONS;
    static final int[][] FILTERS;
    static final String[] NAMES;
    static final String[] SHORTDESCRS;
    static final String[] CATEGORY_ICONS;

    public DefaultFactory(boolean bl) {
        this.writeable = bl;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public Node createMethodNode(MethodElement methodElement) {
        return new MethodElementNode(methodElement, this.writeable);
    }

    public Node createConstructorNode(ConstructorElement constructorElement) {
        return new ConstructorElementNode(constructorElement, this.writeable);
    }

    public Node createFieldNode(FieldElement fieldElement) {
        return new FieldElementNode(fieldElement, this.writeable);
    }

    public Node createInitializerNode(InitializerElement initializerElement) {
        return new InitializerElementNode(initializerElement, this.writeable);
    }

    public Node createClassNode(ClassElement classElement) {
        return new ClassElementNode(classElement, this.createClassChildren(classElement), this.writeable);
    }

    protected Children createClassChildren(ClassElement classElement) {
        return this.createClassChildren(classElement, this.writeable ? READ_WRITE : READ_ONLY);
    }

    protected final Children createClassChildren(ClassElement classElement, ElementNodeFactory elementNodeFactory) {
        if (ElementNode.sourceOptions.getCategoriesUsage()) {
            CategorizingChildren categorizingChildren = new CategorizingChildren(elementNodeFactory, classElement, this.writeable);
            ClassElementFilter classElementFilter = new ClassElementFilter();
            classElementFilter.setOrder(new int[]{2, 4, 4096});
            categorizingChildren.setFilter(classElementFilter);
            return categorizingChildren;
        }
        return new ClassChildren(elementNodeFactory, classElement);
    }

    public Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(ElementNode.bundle.getString("Wait"));
        abstractNode.setIconBase("org/openide/src/resources/wait");
        return abstractNode;
    }

    public Node createErrorNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setName(ElementNode.bundle.getString("Error"));
        abstractNode.setIconBase("org/openide/src/resources/error");
        return abstractNode;
    }

    static {
        CLASS_CATEGORIES.add(CATEGORY_FIELDS);
        CLASS_CATEGORIES.add(CATEGORY_CONSTRUCTORS);
        CLASS_CATEGORIES.add(CATEGORY_METHODS);
        INTERFACE_CATEGORIES = new Vector(2, 0);
        INTERFACE_CATEGORIES.add(CATEGORY_FIELDS);
        INTERFACE_CATEGORIES.add(CATEGORY_METHODS);
        CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
        FILTERS = new int[][]{{16}, {8}, {32}};
        NAMES = new String[]{ElementNode.bundle.getString("Fields"), ElementNode.bundle.getString("Constructors"), ElementNode.bundle.getString("Methods")};
        SHORTDESCRS = new String[]{ElementNode.bundle.getString("Fields_HINT"), ElementNode.bundle.getString("Constructors_HINT"), ElementNode.bundle.getString("Methods_HINT")};
        CATEGORY_ICONS = new String[]{"org/openide/src/resources/variables", "org/openide/src/resources/constructors", "org/openide/src/resources/methods"};
    }

    static class ElementCategoryNode
    extends AbstractNode {
        ClassElement element;
        int newTypeIndex;

        ElementCategoryNode(int n, ElementNodeFactory elementNodeFactory, ClassElement classElement, boolean bl) {
            this(n, new ClassChildren(elementNodeFactory, classElement));
            this.element = classElement;
            this.newTypeIndex = bl ? n : -1;
            switch (n) {
                case 0: {
                    this.setName("Fields");
                    break;
                }
                case 1: {
                    this.setName("Constructors");
                    break;
                }
                case 2: {
                    this.setName("Methods");
                }
            }
        }

        private ElementCategoryNode(int n, ClassChildren classChildren) {
            super((Children)classChildren);
            this.setDisplayName(NAMES[n]);
            this.setShortDescription(SHORTDESCRS[n]);
            ClassElementFilter classElementFilter = new ClassElementFilter();
            classElementFilter.setOrder(FILTERS[n]);
            classChildren.setFilter(classElementFilter);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[n]);
        }

        public boolean canCopy() {
            return false;
        }

        public NewType[] getNewTypes() {
            if (!SourceEditSupport.isWriteable(this.element)) {
                return new NewType[0];
            }
            switch (this.newTypeIndex) {
                case 0: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(this.element, 1)};
                }
                case 1: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(this.element, 0), new SourceEditSupport.ElementNewType(this.element, 2)};
                }
                case 2: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(this.element, 3)};
                }
            }
            return super.getNewTypes();
        }

        public void createPasteTypes(Transferable transferable, List list) {
            Node node = this.getParentNode();
            if (node == null || !(node instanceof ClassElementNode)) {
                return;
            }
            ((ClassElementNode)node).createPasteTypes(transferable, list);
        }
    }

    static class CategorizingChildren
    extends ClassChildren {
        boolean writeable;

        CategorizingChildren(ElementNodeFactory elementNodeFactory, ClassElement classElement, boolean bl) {
            super(elementNodeFactory, classElement);
            this.writeable = bl;
        }

        protected Node[] createNodes(Object object) {
            if (object == CATEGORY_FIELDS) {
                return new Node[]{new ElementCategoryNode(0, this.factory, this.element, this.writeable)};
            }
            if (object == CATEGORY_METHODS) {
                return new Node[]{new ElementCategoryNode(2, this.factory, this.element, this.writeable)};
            }
            if (object == CATEGORY_CONSTRUCTORS) {
                return new Node[]{new ElementCategoryNode(1, this.factory, this.element, this.writeable)};
            }
            return super.createNodes(object);
        }

        protected Collection getKeysOfType(int n) {
            if (n != 4096) {
                return super.getKeysOfType(n);
            }
            if (this.element.isClassOrInterface()) {
                return CLASS_CATEGORIES;
            }
            return INTERFACE_CATEGORIES;
        }

        static {
            ClassChildren.propToFilter.put("classOrInterface", new Integer(4096));
        }
    }
}

