/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.Element;
import org.openide.src.MemberElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.SourceEditSupport;

class ElementBeanModel
extends PropertySupport.Reflection {
    private Element bean;
    private PropertyEditor editor;
    private boolean isRunningAtomic = false;

    public ElementBeanModel(Element element, String string) throws NoSuchMethodException {
        this(element, ElementBeanModel.findInfo(element, string));
    }

    public ElementBeanModel(Element element, PropertyDescriptor propertyDescriptor) throws NoSuchMethodException {
        super((Object)element, propertyDescriptor.getPropertyType(), propertyDescriptor.getName());
        this.setPropertyEditorClass(propertyDescriptor.getPropertyEditorClass());
        this.bean = element;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = super.getPropertyEditor();
        }
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(final Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.isRunningAtomic) {
            super.setValue(object);
            return;
        }
        SourceElement sourceElement = SourceEditSupport.findSource(this.bean);
        if (sourceElement == null) {
            super.setValue(object);
            return;
        }
        final InvocationTargetException[] invocationTargetExceptionArray = new InvocationTargetException[1];
        final IllegalAccessException[] illegalAccessExceptionArray = new IllegalAccessException[1];
        try {
            this.isRunningAtomic = true;
            sourceElement.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ElementBeanModel.this.setValue(object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetExceptionArray[0] = invocationTargetException;
                        ErrorManager.getDefault().annotate((Throwable)invocationTargetException, invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessExceptionArray[0] = illegalAccessException;
                    }
                }
            });
        }
        catch (SourceException sourceException) {
            invocationTargetExceptionArray[0] = new InvocationTargetException(sourceException);
            ErrorManager.getDefault().annotate((Throwable)invocationTargetExceptionArray[0], (Throwable)sourceException);
        }
        finally {
            this.isRunningAtomic = false;
        }
        if (invocationTargetExceptionArray[0] != null) {
            throw invocationTargetExceptionArray[0];
        }
        if (illegalAccessExceptionArray[0] != null) {
            throw illegalAccessExceptionArray[0];
        }
    }

    private static PropertyDescriptor findInfo(Object object, String string) throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                return propertyDescriptorArray[i];
            }
            throw new IllegalArgumentException("No property named " + string + " in class " + object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, (Throwable)introspectionException);
            throw illegalArgumentException;
        }
    }

    public static PropertyPanel createPropertyPanel(MemberElement memberElement, String string) {
        try {
            PropertyPanel propertyPanel = new PropertyPanel((Node.Property)new ElementBeanModel((Element)memberElement, string), 2);
            return propertyPanel;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalStateException illegalStateException = new IllegalStateException("Corrupted code");
            illegalStateException.initCause(noSuchMethodException);
            throw illegalStateException;
        }
    }

    public static PropertyPanel createModifiersPanel(MemberElement memberElement) {
        PropertyPanel propertyPanel = ElementBeanModel.createPropertyPanel(memberElement, "modifiers");
        PropertyEditor propertyEditor = propertyPanel.getProperty().getPropertyEditor();
        if (propertyEditor instanceof ModifierEditor) {
            ((ModifierEditor)((Object)propertyEditor)).setMask(memberElement.getModifiersMask());
        }
        return propertyPanel;
    }
}

