/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementProperties;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.IconStrings;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.src.nodes.SourceOptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public abstract class ElementNode
extends AbstractNode
implements IconStrings,
ElementProperties {
    static ResourceBundle bundle = NbBundle.getBundle((Class)ElementNode.class);
    private static ElementFormat invalidFormat;
    protected static final SourceOptions sourceOptions;
    private static final String[] ICON_AFFECTING_PROPERTIES;
    protected Element element;
    protected ElementFormat elementFormat = new ElementFormat("");
    protected boolean writeable;
    private transient PropertyChangeListener listener;

    public ElementNode(Element element, Children children, boolean bl) {
        super(children);
        this.element = element;
        this.writeable = bl;
        this.setIconBase(this.resolveIconBase());
        this.setDisplayName(this.getElementFormat().format(element));
        this.listener = this.createElementListener();
        element.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)element));
        this.displayFormat = null;
    }

    public String getShortDescription() {
        try {
            return this.getHintElementFormat().format(this.element);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.getShortDescription();
        }
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public final ElementFormat getElementFormat() {
        return this.elementFormat;
    }

    public final void setElementFormat(ElementFormat elementFormat) {
        this.setDisplayName(elementFormat.format(this.element));
        this.elementFormat = elementFormat;
    }

    final void setElementFormat0(ElementFormat elementFormat) {
        try {
            this.setElementFormat(elementFormat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setElementFormat(ElementNode.getInvalidFormat());
        }
    }

    static ElementFormat getInvalidFormat() {
        if (invalidFormat != null) {
            return invalidFormat;
        }
        invalidFormat = new ElementFormat(bundle.getString("FMT_InvalidFormat"));
        return invalidFormat;
    }

    protected abstract ElementFormat getHintElementFormat();

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ElementNode.class);
    }

    public boolean canRename() {
        return this.isWriteable();
    }

    public boolean canDestroy() {
        return this.isWriteable();
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put((ExTransferable.Single)new ElementStringTransferable());
        return exTransferable;
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.isWriteable()) {
            throw new IOException();
        }
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCut());
        exTransferable.put((ExTransferable.Single)new ElementStringTransferable());
        return exTransferable;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.isWriteable();
    }

    public void setActions(SystemAction[] systemActionArray) {
        this.systemActions = systemActionArray;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie == null) {
            cookie = this.element.getCookie(clazz);
        }
        return cookie;
    }

    public boolean equals(Object object) {
        return object instanceof ElementNode && this.element.equals(((ElementNode)object).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public Node.Handle getHandle() {
        Node.Handle handle = super.getHandle();
        if (handle != null) {
            return handle;
        }
        if (this.element instanceof SourceElement) {
            return null;
        }
        return new ElementNodeHandle(this.element, this.writeable, this.elementFormat);
    }

    boolean isWriteable() {
        return this.writeable && SourceEditSupport.isWriteable(this.element);
    }

    void superSetName(String string) {
        super.setName(string);
    }

    void superPropertyChange(String string, Object object, Object object2) {
        if (this.hasPropertyChangeListener() && (string == null || this.findPropertyNames().contains(string))) {
            super.firePropertyChange(string, object, object2);
        }
    }

    private Set findPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Node.PropertySet[] propertySetArray = this.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.PropertySet propertySet = propertySetArray[i];
            Node.Property[] propertyArray = propertySet.getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                Node.Property property = propertyArray[j];
                hashSet.add(property.getName());
            }
        }
        return hashSet;
    }

    public Node.PropertySet[] getPropertySets() {
        return super.getPropertySets();
    }

    void superShortDescriptionChange(String string, String string2) {
        super.fireShortDescriptionChange(string, string2);
    }

    PropertyChangeListener createElementListener() {
        return new ElementListener();
    }

    static /* synthetic */ void access$100(ElementNode elementNode) {
        elementNode.fireNodeDestroyed();
    }

    static {
        sourceOptions = (SourceOptions)SourceOptions.findObject((Class)SourceOptions.class, (boolean)true);
        ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    }

    static abstract class ElementProp
    extends PropertySupport {
        public ElementProp(String string, Class clazz, boolean bl) {
            super(string, clazz, bundle.getString("PROP_" + string), bundle.getString("HINT_" + string), true, bl);
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(bundle.getString("MSG_Cannot_Write"));
            }
        }

        void runAtomic(Element element, SourceEditSupport.ExceptionalRunnable exceptionalRunnable) throws InvocationTargetException {
            try {
                SourceEditSupport.runAsUser(element, exceptionalRunnable);
            }
            catch (SourceException sourceException) {
                throw new InvocationTargetException(sourceException);
            }
        }
    }

    class ElementListener
    implements PropertyChangeListener {
        ElementListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Mutex.EVENT.writeAccess(new Runnable(this, propertyChangeEvent){
                private final /* synthetic */ PropertyChangeEvent val$evt;
                private final /* synthetic */ ElementListener this$1;
                {
                    this.this$1 = elementListener;
                    this.val$evt = propertyChangeEvent;
                }

                public void run() {
                    String string = this.val$evt.getPropertyName();
                    if (string == null) {
                        ElementListener.access$000(this.this$1).setDisplayName(ElementListener.access$000(this.this$1).getElementFormat().format(ElementListener.access$000((ElementListener)this.this$1).element));
                        ElementListener.access$000(this.this$1).setIconBase(ElementListener.access$000(this.this$1).resolveIconBase());
                    } else {
                        if ("valid".equals(string)) {
                            ElementNode.access$100(ElementListener.access$000(this.this$1));
                            return;
                        }
                        if (ElementListener.access$000(this.this$1).getElementFormat().dependsOnProperty(string)) {
                            ElementListener.access$000(this.this$1).setDisplayName(ElementListener.access$000(this.this$1).getElementFormat().format(ElementListener.access$000((ElementListener)this.this$1).element));
                        }
                        String[] stringArray = ElementListener.access$000(this.this$1).getIconAffectingProperties();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!stringArray[i].equals(string)) continue;
                            ElementListener.access$000(this.this$1).setIconBase(ElementListener.access$000(this.this$1).resolveIconBase());
                            break;
                        }
                        if (string.equals("name")) {
                            try {
                                ElementListener.access$000(this.this$1).superSetName(((MemberElement)ElementListener.access$000((ElementListener)this.this$1).element).getName().toString());
                            }
                            catch (ClassCastException classCastException) {}
                        } else if (string.equals("cookie")) {
                            ElementListener.access$000(this.this$1).superFireCookieChange();
                            return;
                        }
                    }
                    if (ElementListener.access$000(this.this$1).getHintElementFormat().dependsOnProperty(this.val$evt.getPropertyName())) {
                        ElementListener.access$000(this.this$1).superShortDescriptionChange("", ElementListener.access$000(this.this$1).getShortDescription());
                    }
                    ElementListener.access$000(this.this$1).superPropertyChange(this.val$evt.getPropertyName(), this.val$evt.getOldValue(), this.val$evt.getNewValue());
                }
            });
        }

        static /* synthetic */ ElementNode access$000(ElementListener elementListener) {
            return elementListener.ElementNode.this;
        }
    }

    private static final class ElementNodeHandle
    implements Node.Handle {
        private static final long serialVersionUID = 910667289626540L;
        private Element element;
        private boolean writable;
        private ElementFormat elementFormat;

        public ElementNodeHandle(Element element, boolean bl, ElementFormat elementFormat) {
            this.element = element;
            this.writable = bl;
            this.elementFormat = elementFormat;
        }

        public Node getNode() throws IOException {
            Node node;
            DefaultFactory defaultFactory = new DefaultFactory(this.writable);
            if (this.element instanceof ClassElement) {
                node = defaultFactory.createClassNode((ClassElement)this.element);
            } else if (this.element instanceof ConstructorElement) {
                node = defaultFactory.createConstructorNode((ConstructorElement)this.element);
            } else if (this.element instanceof FieldElement) {
                node = defaultFactory.createFieldNode((FieldElement)this.element);
            } else if (this.element instanceof InitializerElement) {
                node = defaultFactory.createInitializerNode((InitializerElement)this.element);
            } else if (this.element instanceof MethodElement) {
                node = defaultFactory.createMethodNode((MethodElement)this.element);
            } else {
                throw new IOException("what is element " + this.element + "? cannot restore node");
            }
            if (node instanceof ElementNode) {
                ((ElementNode)node).setElementFormat(this.elementFormat);
            }
            return node;
        }

        public String toString() {
            return "ElementNodeHandle[" + this.element + "]";
        }
    }

    class ElementStringTransferable
    extends ExTransferable.Single {
        ElementStringTransferable() {
            super(DataFlavor.stringFlavor);
        }

        protected Object getData() {
            return ElementNode.this.element.toString();
        }
    }
}

