/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.FieldCustomizer;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class FieldElementNode
extends MemberElementNode {
    public FieldElementNode(FieldElement fieldElement, boolean bl) {
        super(fieldElement, Children.LEAF, bl);
        this.setElementFormat0(sourceOptions.getFieldElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.FieldNode");
    }

    protected String resolveIconBase() {
        int n = ((FieldElement)this.element).getModifiers();
        if (!Modifier.isStatic(n)) {
            if (Modifier.isPrivate(n)) {
                return "org/openide/src/resources/variablePrivate";
            }
            if (Modifier.isProtected(n)) {
                return "org/openide/src/resources/variableProtected";
            }
            if (Modifier.isPublic(n)) {
                return "org/openide/src/resources/variablePublic";
            }
            return "org/openide/src/resources/variablePackage";
        }
        if (Modifier.isPrivate(n)) {
            return "org/openide/src/resources/variableStPrivate";
        }
        if (Modifier.isProtected(n)) {
            return "org/openide/src/resources/variableStProtected";
        }
        if (Modifier.isPublic(n)) {
            return "org/openide/src/resources/variableStPublic";
        }
        return "org/openide/src/resources/variableStPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return sourceOptions.getFieldElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createModifiersProperty(this.writeable));
        set.put(this.createNameProperty(this.writeable));
        set.put(this.createTypeProperty(this.writeable));
        set.put(this.createInitValueProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                FieldElement fieldElement = (FieldElement)FieldElementNode.this.element;
                fieldElement.getDeclaringClass().removeField(fieldElement);
            }
        });
        super.destroy();
    }

    public Component getCustomizer() {
        return new FieldCustomizer((FieldElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createTypeProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("type", Type.class, bl){

            public Object getValue() {
                return ((FieldElement)FieldElementNode.this.element).getType();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(FieldElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((FieldElement)2.access$000(this.this$1).element).setType((Type)this.val$val);
                    }
                });
            }

            static /* synthetic */ FieldElementNode access$000(2 var0) {
                return var0.FieldElementNode.this;
            }
        };
        elementProp.setValue("acceptVoidType", Boolean.FALSE);
        return elementProp;
    }

    protected Node.Property createInitValueProperty(boolean bl) {
        return new ElementNode.ElementProp("initValue", String.class, bl){

            public Object getValue() {
                return ((FieldElement)FieldElementNode.this.element).getInitValue();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(FieldElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((FieldElement)4.access$100(this.this$1).element).setInitValue((String)this.val$val);
                    }
                });
            }

            static /* synthetic */ FieldElementNode access$100(4 var0) {
                return var0.FieldElementNode.this;
            }
        };
    }
}

