/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementBeanModel;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MethodCustomizer
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle((Class)MethodCustomizer.class);
    private static final String[] COMMON_TYPES = new String[]{"void", "String", "boolean", "char", "int", "long", "byte", "short", "float", "double"};
    ConstructorElement element;
    MethodElement method;
    boolean isOK = true;
    private JPanel methodPanel;
    private JLabel jLabel1;
    private JTextField nameTextField;
    private JLabel jLabel2;
    private JComboBox returnCombo;
    private JPanel jPanel1;
    private JPanel modifierPanel;
    private JPanel paramsPanel;
    private JPanel exceptionsPanel;

    public MethodCustomizer(ConstructorElement constructorElement) {
        this.element = constructorElement;
        this.method = constructorElement instanceof MethodElement ? (MethodElement)constructorElement : null;
        this.initComponents();
        this.methodPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_MethodFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.modifierPanel.setBorder(new TitledBorder(bundle.getString("CTL_Modifiers")));
        this.paramsPanel.setBorder(new TitledBorder(bundle.getString("CTL_Parameters")));
        this.exceptionsPanel.setBorder(new TitledBorder(bundle.getString("CTL_Exceptions")));
        PropertyPanel propertyPanel = ElementBeanModel.createModifiersPanel(constructorElement);
        Node.Property property = propertyPanel.getProperty();
        String string = String.valueOf('\uffff');
        property.setValue("ModifierPanel_Modifier_Abstract_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Final_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Static_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Synchronized_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Transient_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Volatile_Mnemonic", string);
        property.setValue("ModifierPanel_Modifier_Native_Mnemonic", string);
        this.modifierPanel.add((Component)propertyPanel, "Center");
        this.nameTextField.setText(constructorElement.getName().toString());
        if (this.method == null) {
            this.nameTextField.setEnabled(false);
            this.returnCombo.setEnabled(false);
        } else {
            this.returnCombo.setSelectedItem(this.method.getReturn().toString());
        }
        PropertyPanel propertyPanel2 = ElementBeanModel.createPropertyPanel(constructorElement, "parameters");
        property = propertyPanel2.getProperty();
        property.setValue("mnemonic_Add", bundle.getString("CTL_Parameters_Mnemonic_Add"));
        property.setValue("mnemonic_Remove", bundle.getString("CTL_Parameters_Mnemonic_Remove"));
        property.setValue("mnemonic_Up", bundle.getString("CTL_Parameters_Mnemonic_Up"));
        property.setValue("mnemonic_Down", bundle.getString("CTL_Parameters_Mnemonic_Down"));
        property.setValue("mnemonic_Edit", bundle.getString("CTL_Parameters_Mnemonic_Edit"));
        this.paramsPanel.add((Component)propertyPanel2, "Center");
        PropertyPanel propertyPanel3 = ElementBeanModel.createPropertyPanel(constructorElement, "exceptions");
        property = propertyPanel3.getProperty();
        property.setValue("mnemonic_Add", bundle.getString("CTL_Exceptions_Mnemonic_Add"));
        property.setValue("mnemonic_Remove", bundle.getString("CTL_Exceptions_Mnemonic_Remove"));
        property.setValue("mnemonic_Up", bundle.getString("CTL_Exceptions_Mnemonic_Up"));
        property.setValue("mnemonic_Down", bundle.getString("CTL_Exceptions_Mnemonic_Down"));
        property.setValue("mnemonic_Edit", bundle.getString("CTL_Exceptions_Mnemonic_Edit"));
        this.exceptionsPanel.add((Component)propertyPanel3, "Center");
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_MethodType_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int n = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.methodPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jPanel1 = new JPanel();
        this.modifierPanel = new JPanel();
        this.paramsPanel = new JPanel();
        this.exceptionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.methodPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Name"));
        this.jLabel1.setLabelFor(this.nameTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 8, 8);
        gridBagConstraints.anchor = 13;
        this.methodPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodCustomizer.this.nameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 8, 0);
        gridBagConstraints.weightx = 1.0;
        this.methodPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_ReturnType"));
        this.jLabel2.setLabelFor(this.returnCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints.anchor = 13;
        this.methodPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodCustomizer.this.returnComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.methodPanel.add((Component)this.returnCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.methodPanel.add((Component)this.jPanel1, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.add((Component)this.methodPanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints2);
        this.paramsPanel.setLayout(new BorderLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.paramsPanel, gridBagConstraints2);
        this.exceptionsPanel.setLayout(new BorderLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.exceptionsPanel, gridBagConstraints2);
    }

    private void returnComboActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Type type;
        block8: {
            if (this.method == null) {
                return;
            }
            Object object = this.returnCombo.getSelectedItem();
            type = this.method.getReturn();
            bl = false;
            if (object != null) {
                try {
                    final Type type2 = Type.parse(object.toString());
                    if (!type.equals(type2)) {
                        try {
                            SourceEditSupport.runAsUser(this.method, new SourceEditSupport.ExceptionalRunnable(){

                                public void run() throws SourceException {
                                    MethodCustomizer.this.method.setReturn(type2);
                                }
                            });
                            bl = true;
                        }
                        catch (SourceException sourceException) {
                            ErrorManager.getDefault().notify((Throwable)sourceException);
                        }
                        break block8;
                    }
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                    ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
                }
            }
        }
        this.isOK = bl;
        if (!bl) {
            this.returnCombo.setSelectedItem(type.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nameTextFieldFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && focusEvent.isTemporary() || this.method == null) {
            return;
        }
        String string = this.nameTextField.getText();
        String string2 = this.method.getName().toString();
        boolean bl = false;
        IllegalArgumentException illegalArgumentException = null;
        if (Utilities.isJavaIdentifier((String)string)) {
            if (string2.equals(string)) return;
            final Identifier identifier = Identifier.create(string);
            try {
                SourceEditSupport.runAsUser(this.method, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        MethodCustomizer.this.method.setName(identifier);
                    }
                });
                bl = true;
            }
            catch (SourceException sourceException) {
                ErrorManager.getDefault().notify((Throwable)sourceException);
            }
        } else {
            illegalArgumentException = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        this.isOK = bl;
        if (!bl) {
            this.nameTextField.setText(string2);
        }
        if (illegalArgumentException == null) return;
        ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_MethodNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_MethodCustomizerDialog");
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        this.returnComboActionPerformed(null);
        return this.isOK;
    }
}

