/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ConstructorElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class MethodElementNode
extends ConstructorElementNode {
    public MethodElementNode(MethodElement methodElement, boolean bl) {
        super(methodElement, bl);
        this.setElementFormat0(sourceOptions.getMethodElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.MethodNode");
    }

    protected String resolveIconBase() {
        int n = ((MethodElement)this.element).getModifiers();
        if (Modifier.isStatic(n)) {
            if (Modifier.isPrivate(n)) {
                return "org/openide/src/resources/methodStPrivate";
            }
            if (Modifier.isProtected(n)) {
                return "org/openide/src/resources/methodStProtected";
            }
            if (Modifier.isPublic(n)) {
                return "org/openide/src/resources/methodStPublic";
            }
            return "org/openide/src/resources/methodStPackage";
        }
        if (Modifier.isPrivate(n)) {
            return "org/openide/src/resources/methodPrivate";
        }
        if (Modifier.isProtected(n)) {
            return "org/openide/src/resources/methodProtected";
        }
        if (Modifier.isPublic(n)) {
            return "org/openide/src/resources/methodPublic";
        }
        return "org/openide/src/resources/methodPackage";
    }

    public boolean canRename() {
        return true;
    }

    protected ElementFormat getHintElementFormat() {
        return sourceOptions.getMethodElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createModifiersProperty(this.writeable));
        set.put(this.createNameProperty(this.writeable));
        set.put(this.createParametersProperty(this.writeable));
        set.put(this.createReturnProperty(this.writeable));
        set.put(this.createExceptionsProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                MethodElement methodElement = (MethodElement)MethodElementNode.this.element;
                methodElement.getDeclaringClass().removeMethod(methodElement);
            }
        });
        super.destroy();
    }

    protected Node.Property createReturnProperty(boolean bl) {
        return new ElementNode.ElementProp("return", Type.class, bl){

            public Object getValue() {
                return ((MethodElement)MethodElementNode.this.element).getReturn();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MethodElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((MethodElement)2.access$000(this.this$1).element).setReturn((Type)this.val$val);
                    }
                });
            }

            static /* synthetic */ MethodElementNode access$000(2 var0) {
                return var0.MethodElementNode.this;
            }
        };
    }
}

