/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.options.SystemOption;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class SourceOptions
extends SystemOption {
    private static final int lastCompatibleVersionTag = 1;
    private static final int currentVersionTag = 1;
    private static ResourceBundle bundle;
    private static final byte T_INITIALIZER = 0;
    private static final byte T_FIELD = 1;
    private static final byte T_CONSTRUCTOR = 2;
    private static final byte T_METHOD = 3;
    private static final byte T_CLASS = 4;
    private static final byte T_INTERFACE = 5;
    static final String[] PROP_NAMES;
    static Element[] TEST_ELEMENTS;
    private static final ElementFormat[] DEFAULT_FORMATS_SHORT;
    private static final ElementFormat[] DEFAULT_FORMATS_LONG;
    private ElementFormat[] formats = new ElementFormat[6];
    private int version;
    public static final String PROP_INITIALIZER_FORMAT;
    public static final String PROP_FIELD_FORMAT;
    public static final String PROP_CONSTRUCTOR_FORMAT;
    public static final String PROP_METHOD_FORMAT;
    public static final String PROP_CLASS_FORMAT;
    public static final String PROP_INTERFACE_FORMAT;
    public static final String PROP_CATEGORIES_USAGE = "categoriesUsage";
    private static boolean categories;
    static final long serialVersionUID = -2120623049071035434L;

    private static synchronized void loadBundle() {
        if (bundle != null) {
            return;
        }
        bundle = NbBundle.getBundle((Class)SourceOptions.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultFormats() {
        if (DEFAULT_FORMATS_SHORT[0] != null) {
            return;
        }
        Class clazz = SourceOptions.class;
        synchronized (clazz) {
            if (DEFAULT_FORMATS_SHORT[0] != null) {
                return;
            }
            SourceOptions.loadBundle();
            for (int i = 0; i < 6; ++i) {
                SourceOptions.DEFAULT_FORMATS_SHORT[i] = new ElementFormat(bundle.getString("SHORT_" + PROP_NAMES[i]));
                SourceOptions.DEFAULT_FORMATS_LONG[i] = new ElementFormat(bundle.getString("LONG_" + PROP_NAMES[i]));
            }
        }
    }

    private void clearElementFormats() {
        this.formats = new ElementFormat[6];
    }

    public String displayName() {
        SourceOptions.loadBundle();
        return bundle.getString("MSG_sourceOptions");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceOptions.class);
    }

    public void setInitializerElementFormat(ElementFormat elementFormat) {
        this.setElementFormat((byte)0, elementFormat);
    }

    public ElementFormat getInitializerElementFormat() {
        return this.getElementFormat(0);
    }

    public void setFieldElementFormat(ElementFormat elementFormat) {
        this.setElementFormat((byte)1, elementFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementFormat getElementFormat(int n) {
        SourceOptions sourceOptions = this;
        synchronized (sourceOptions) {
            if (this.formats[n] != null) {
                return this.formats[n];
            }
            if (this.isWriteExternal()) {
                return null;
            }
        }
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_SHORT[n];
    }

    public ElementFormat getFieldElementFormat() {
        return this.getElementFormat(1);
    }

    public void setConstructorElementFormat(ElementFormat elementFormat) {
        this.setElementFormat((byte)2, elementFormat);
    }

    public ElementFormat getConstructorElementFormat() {
        return this.getElementFormat(2);
    }

    public void setMethodElementFormat(ElementFormat elementFormat) {
        this.setElementFormat((byte)3, elementFormat);
    }

    public ElementFormat getMethodElementFormat() {
        return this.getElementFormat(3);
    }

    public void setClassElementFormat(ElementFormat elementFormat) {
        this.setElementFormat((byte)4, elementFormat);
    }

    public ElementFormat getClassElementFormat() {
        return this.getElementFormat(4);
    }

    public void setInterfaceElementFormat(ElementFormat elementFormat) {
        this.setElementFormat((byte)5, elementFormat);
    }

    public ElementFormat getInterfaceElementFormat() {
        return this.getElementFormat(5);
    }

    public ElementFormat getInitializerElementLongFormat() {
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_LONG[0];
    }

    public ElementFormat getFieldElementLongFormat() {
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_LONG[1];
    }

    public ElementFormat getConstructorElementLongFormat() {
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_LONG[2];
    }

    public ElementFormat getMethodElementLongFormat() {
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_LONG[3];
    }

    public ElementFormat getClassElementLongFormat() {
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_LONG[4];
    }

    public ElementFormat getInterfaceElementLongFormat() {
        SourceOptions.loadDefaultFormats();
        return DEFAULT_FORMATS_LONG[5];
    }

    public void setCategoriesUsage(boolean bl) {
        categories = bl;
    }

    public boolean getCategoriesUsage() {
        return categories;
    }

    private static synchronized Element getTestElement(int n) {
        if (TEST_ELEMENTS == null) {
            Element[] elementArray = new Element[6];
            try {
                elementArray[0] = new InitializerElement();
                FieldElement fieldElement = new FieldElement();
                Identifier identifier = Identifier.create("foo");
                fieldElement.setName(identifier);
                fieldElement.setType(Type.INT);
                elementArray[1] = fieldElement;
                MethodElement methodElement = new MethodElement();
                methodElement.setName(identifier);
                methodElement.setReturn(Type.VOID);
                elementArray[3] = methodElement;
                elementArray[2] = new ConstructorElement();
                ClassElement classElement = new ClassElement();
                classElement.setName(identifier);
                elementArray[4] = elementArray[5] = classElement;
                TEST_ELEMENTS = elementArray;
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
        return TEST_ELEMENTS[n];
    }

    private void setElementFormat(byte by, ElementFormat elementFormat) {
        ElementFormat elementFormat2 = this.formats[by];
        if (elementFormat != null) {
            Element element = SourceOptions.getTestElement(by);
            try {
                elementFormat.format(element);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_IllegalElementFormat"), null, null);
            }
        }
        this.formats[by] = elementFormat;
        this.firePropertyChange(PROP_NAMES[by], elementFormat2, this.formats[by]);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.version);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            this.version = objectInput.readInt();
        }
        if (this.version < 1) {
            this.clearElementFormats();
            this.version = 1;
        }
    }

    static {
        PROP_NAMES = new String[]{"initializerElementFormat", "fieldElementFormat", "constructorElementFormat", "methodElementFormat", "classElementFormat", "interfaceElementFormat"};
        DEFAULT_FORMATS_SHORT = new ElementFormat[6];
        DEFAULT_FORMATS_LONG = new ElementFormat[6];
        PROP_INITIALIZER_FORMAT = PROP_NAMES[0];
        PROP_FIELD_FORMAT = PROP_NAMES[1];
        PROP_CONSTRUCTOR_FORMAT = PROP_NAMES[2];
        PROP_METHOD_FORMAT = PROP_NAMES[3];
        PROP_CLASS_FORMAT = PROP_NAMES[4];
        PROP_INTERFACE_FORMAT = PROP_NAMES[5];
        categories = true;
    }
}

