/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingDebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.debugger.SessionProvider;

public final class DebuggerManager {
    public static final String PROP_BREAKPOINTS_INIT = "breakpointsInit";
    public static final String PROP_BREAKPOINTS = "breakpoints";
    public static final String PROP_CURRENT_ENGINE = "currentEngine";
    public static final String PROP_CURRENT_SESSION = "currentSession";
    public static final String PROP_SESSIONS = "sessions";
    public static final String PROP_DEBUGGER_ENGINES = "debuggerEngines";
    public static final String PROP_WATCHES = "watches";
    public static final String PROP_WATCHES_INIT = "watchesInit";
    private static DebuggerManager debuggerManager;
    private Session currentSession;
    private DebuggerEngine currentEngine;
    private List sessions = new ArrayList();
    private Set engines = new HashSet();
    private Vector breakpoints = new Vector();
    private boolean breakpointsInitialized = false;
    private Vector watches = new Vector();
    private boolean watchesInitialized = false;
    private SessionListener sessionListener = new SessionListener();
    private Vector listeners = new Vector();
    private HashMap listenersMap = new HashMap();
    private ActionsManager actionsManager = null;
    private Lookup lookup = new Lookup.MetaInf(null);
    private boolean listerersLoaded = false;
    static /* synthetic */ Class class$org$netbeans$spi$debugger$DebuggerEngineProvider;
    static /* synthetic */ Class class$org$netbeans$spi$debugger$DelegatingDebuggerEngineProvider;

    public static synchronized DebuggerManager getDebuggerManager() {
        if (debuggerManager == null) {
            debuggerManager = new DebuggerManager();
        }
        return debuggerManager;
    }

    private DebuggerManager() {
    }

    public synchronized ActionsManager getActionsManager() {
        if (this.actionsManager == null) {
            this.actionsManager = new ActionsManager(this.lookup);
        }
        return this.actionsManager;
    }

    public List lookup(String string, Class clazz) {
        return this.lookup.lookup(string, clazz);
    }

    public Object lookupFirst(String string, Class clazz) {
        return this.lookup.lookupFirst(string, clazz);
    }

    public DebuggerEngine[] startDebugging(DebuggerInfo debuggerInfo) {
        Object object;
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList<DebuggerEngine> arrayList2 = new ArrayList<DebuggerEngine>();
        Lookup lookup = debuggerInfo.getLookup();
        Lookup lookup2 = debuggerInfo.getLookup();
        arrayList.addAll(lookup.lookup(null, SessionProvider.class));
        arrayList.addAll(lookup.lookup(null, DelegatingSessionProvider.class));
        Object object2 = null;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            Object object3;
            object = null;
            if (arrayList.get(n) instanceof DelegatingSessionProvider) {
                object = ((DelegatingSessionProvider)arrayList.get(n)).getSession(debuggerInfo);
                lookup = new Lookup.Compound(lookup, ((Session)object).privateLookup);
            } else {
                object3 = (SessionProvider)arrayList.get(n);
                object2 = object = new Session(((SessionProvider)object3).getSessionName(), ((SessionProvider)object3).getLocationName(), ((SessionProvider)object3).getTypeID(), ((SessionProvider)object3).getServices(), lookup);
                lookup = ((Session)object).getLookup();
                lookup2 = ((Session)object).getLookup();
                this.addSession((Session)object);
            }
            object3 = new ArrayList();
            ((ArrayList)object3).addAll(lookup2.lookup(null, class$org$netbeans$spi$debugger$DebuggerEngineProvider == null ? DebuggerManager.class$("org.netbeans.spi.debugger.DebuggerEngineProvider") : class$org$netbeans$spi$debugger$DebuggerEngineProvider));
            ((ArrayList)object3).addAll(lookup2.lookup(null, class$org$netbeans$spi$debugger$DelegatingDebuggerEngineProvider == null ? DebuggerManager.class$("org.netbeans.spi.debugger.DelegatingDebuggerEngineProvider") : class$org$netbeans$spi$debugger$DelegatingDebuggerEngineProvider));
            int n3 = ((ArrayList)object3).size();
            for (int i = 0; i < n3; ++i) {
                Object object4;
                DebuggerEngine debuggerEngine = null;
                String[] stringArray = null;
                if (((ArrayList)object3).get(i) instanceof DebuggerEngineProvider) {
                    object4 = (DebuggerEngineProvider)((ArrayList)object3).get(i);
                    Object[] objectArray = ((DebuggerEngineProvider)object4).getServices();
                    debuggerEngine = new DebuggerEngine(((DebuggerEngineProvider)((ArrayList)object3).get(i)).getEngineTypeID(), (Session)object, objectArray, lookup);
                    stringArray = ((DebuggerEngineProvider)object4).getLanguages();
                    ((DebuggerEngineProvider)object4).setDestructor(debuggerEngine.new DebuggerEngine.Destructor());
                    arrayList2.add(debuggerEngine);
                } else {
                    object4 = (DelegatingDebuggerEngineProvider)((ArrayList)object3).get(i);
                    stringArray = ((DelegatingDebuggerEngineProvider)object4).getLanguages();
                    debuggerEngine = ((DelegatingDebuggerEngineProvider)object4).getEngine();
                    ((DelegatingDebuggerEngineProvider)object4).setDestructor(debuggerEngine.new DebuggerEngine.Destructor());
                }
                int n4 = stringArray.length;
                for (int j = 0; j < n4; ++j) {
                    ((Session)object).addLanguage(stringArray[j], debuggerEngine);
                }
            }
        }
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerEngine)arrayList2.get(n)).getActionsManager().postAction(ActionsManager.ACTION_START);
        }
        if (object2 != null) {
            this.setCurrentSession((Session)object2);
        }
        object = new DebuggerEngine[arrayList2.size()];
        return arrayList2.toArray((T[])object);
    }

    public void finishAllSessions() {
        Session[] sessionArray = this.getSessions();
        if (sessionArray.length == 0) {
            return;
        }
        int n = sessionArray.length;
        for (int i = 0; i < n; ++i) {
            sessionArray[i].getCurrentEngine().getActionsManager().doAction(ActionsManager.ACTION_KILL);
        }
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSession(Session session) {
        DebuggerEngine debuggerEngine;
        DebuggerEngine debuggerEngine2;
        Session session2;
        Session session3;
        List list = this.sessions;
        synchronized (list) {
            if (session != null) {
                int n;
                int n2 = this.sessions.size();
                for (n = 0; n < n2 && session != this.sessions.get(n); ++n) {
                }
                if (n == n2) {
                    return;
                }
            }
            if (session == (session3 = this.getCurrentSession())) {
                return;
            }
            this.currentSession = session2 = session;
            debuggerEngine2 = this.currentEngine;
            debuggerEngine = null;
            if (this.getCurrentSession() != null) {
                debuggerEngine = this.getCurrentSession().getCurrentEngine();
            }
            this.currentEngine = debuggerEngine;
        }
        if (debuggerEngine2 != debuggerEngine) {
            this.firePropertyChange(PROP_CURRENT_ENGINE, debuggerEngine2, debuggerEngine);
        }
        this.firePropertyChange(PROP_CURRENT_SESSION, session3, session2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions() {
        List list = this.sessions;
        synchronized (list) {
            return this.sessions.toArray(new Session[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerEngine[] getDebuggerEngines() {
        Set set = this.engines;
        synchronized (set) {
            return this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentEngine;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        this.initBreakpoints();
        this.breakpoints.addElement(breakpoint);
        this.fireBreakpointCreated(breakpoint);
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        this.initBreakpoints();
        this.breakpoints.removeElement(breakpoint);
        breakpoint.disposeOut();
        this.fireBreakpointRemoved(breakpoint);
    }

    public Breakpoint[] getBreakpoints() {
        this.initBreakpoints();
        return this.breakpoints.toArray(new Breakpoint[0]);
    }

    public Watch createWatch(String string) {
        this.initWatches();
        Watch watch = new Watch(string);
        this.watches.addElement(watch);
        this.fireWatchCreated(watch);
        return watch;
    }

    public Watch[] getWatches() {
        this.initWatches();
        return this.watches.toArray(new Watch[0]);
    }

    public void removeAllWatches() {
        this.initWatches();
        Vector vector = (Vector)this.watches.clone();
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            ((Watch)vector.elementAt(i)).remove();
        }
    }

    void removeWatch(Watch watch) {
        this.initWatches();
        this.watches.removeElement(watch);
        this.fireWatchRemoved(watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String string, Object object, Object object2) {
        int n;
        Vector vector;
        this.initDebuggerManagerListeners();
        Vector vector2 = (Vector)this.listeners.clone();
        Serializable serializable = this.listenersMap;
        synchronized (serializable) {
            vector = (Vector)this.listenersMap.get(string);
            if (vector != null) {
                vector = (Vector)vector.clone();
            }
        }
        serializable = new PropertyChangeEvent(this, string, object, object2);
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
        }
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
            }
        }
    }

    public void addDebuggerListener(DebuggerManagerListener debuggerManagerListener) {
        this.listeners.addElement(debuggerManagerListener);
    }

    public void removeDebuggerListener(DebuggerManagerListener debuggerManagerListener) {
        this.listeners.removeElement(debuggerManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(String string, DebuggerManagerListener debuggerManagerListener) {
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            Vector<DebuggerManagerListener> vector = (Vector<DebuggerManagerListener>)this.listenersMap.get(string);
            if (vector == null) {
                vector = new Vector<DebuggerManagerListener>();
                this.listenersMap.put(string, vector);
            }
            vector.addElement(debuggerManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(String string, DebuggerManagerListener debuggerManagerListener) {
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            Vector vector = (Vector)this.listenersMap.get(string);
            if (vector == null) {
                return;
            }
            vector.removeElement(debuggerManagerListener);
            if (vector.size() == 0) {
                this.listenersMap.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpointCreated(Breakpoint breakpoint) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_BREAKPOINTS, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).breakpointAdded(breakpoint);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_BREAKPOINTS);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).breakpointAdded(breakpoint);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpointRemoved(Breakpoint breakpoint) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_BREAKPOINTS, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).breakpointRemoved(breakpoint);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_BREAKPOINTS);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).breakpointRemoved(breakpoint);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBreakpoints() {
        ArrayList<Breakpoint> arrayList;
        Vector vector = this.breakpoints;
        synchronized (vector) {
            Vector vector2;
            int n;
            if (this.breakpointsInitialized) {
                return;
            }
            this.breakpointsInitialized = true;
            this.initDebuggerManagerListeners();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_BREAKPOINTS_INIT, null, null);
            arrayList = new ArrayList<Breakpoint>();
            Vector vector3 = (Vector)this.listeners.clone();
            int n2 = vector3.size();
            for (n = 0; n < n2; ++n) {
                arrayList.addAll(Arrays.asList(((DebuggerManagerListener)vector3.elementAt(n)).initBreakpoints()));
                ((DebuggerManagerListener)vector3.elementAt(n)).propertyChange(propertyChangeEvent);
            }
            HashMap hashMap = this.listenersMap;
            synchronized (hashMap) {
                vector2 = (Vector)this.listenersMap.get(PROP_BREAKPOINTS_INIT);
            }
            if (vector2 != null) {
                vector2 = (Vector)vector2.clone();
                n2 = vector2.size();
                for (n = 0; n < n2; ++n) {
                    arrayList.addAll(Arrays.asList(((DebuggerManagerListener)vector2.elementAt(n)).initBreakpoints()));
                    ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
                }
            }
            this.breakpoints.addAll(arrayList);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.fireBreakpointCreated((Breakpoint)arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatchCreated(Watch watch) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_WATCHES, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).watchAdded(watch);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_WATCHES);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).watchAdded(watch);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatchRemoved(Watch watch) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_WATCHES, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).watchRemoved(watch);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_WATCHES);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).watchRemoved(watch);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWatches() {
        Vector vector;
        int n;
        Serializable serializable = this.watches;
        synchronized (serializable) {
            if (this.watchesInitialized) {
                return;
            }
            this.watchesInitialized = true;
        }
        serializable = new PropertyChangeEvent(this, PROP_WATCHES_INIT, null, null);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).initWatches();
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_WATCHES_INIT);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).initWatches();
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange((PropertyChangeEvent)serializable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionAdded(Session session, Session[] sessionArray, Session[] sessionArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_SESSIONS, sessionArray, sessionArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).sessionAdded(session);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_SESSIONS);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).sessionAdded(session);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionRemoved(Session session, Session[] sessionArray, Session[] sessionArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_SESSIONS, sessionArray, sessionArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).sessionRemoved(session);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_SESSIONS);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).sessionRemoved(session);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineAdded(DebuggerEngine debuggerEngine, DebuggerEngine[] debuggerEngineArray, DebuggerEngine[] debuggerEngineArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_DEBUGGER_ENGINES, debuggerEngineArray, debuggerEngineArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).engineAdded(debuggerEngine);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_DEBUGGER_ENGINES);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).engineAdded(debuggerEngine);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineRemoved(DebuggerEngine debuggerEngine, DebuggerEngine[] debuggerEngineArray, DebuggerEngine[] debuggerEngineArray2) {
        Vector vector;
        int n;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_DEBUGGER_ENGINES, debuggerEngineArray, debuggerEngineArray2);
        Vector vector2 = (Vector)this.listeners.clone();
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            ((DebuggerManagerListener)vector2.elementAt(n)).engineRemoved(debuggerEngine);
            ((DebuggerManagerListener)vector2.elementAt(n)).propertyChange(propertyChangeEvent);
        }
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            vector = (Vector)this.listenersMap.get(PROP_DEBUGGER_ENGINES);
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                ((DebuggerManagerListener)vector.elementAt(n)).engineRemoved(debuggerEngine);
                ((DebuggerManagerListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDebuggerManagerListeners() {
        HashMap hashMap = this.listenersMap;
        synchronized (hashMap) {
            if (this.listerersLoaded) {
                return;
            }
            this.listerersLoaded = true;
            List list = this.lookup.lookup(null, LazyDebuggerManagerListener.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                LazyDebuggerManagerListener lazyDebuggerManagerListener = (LazyDebuggerManagerListener)list.get(i);
                String[] stringArray = lazyDebuggerManagerListener.getProperties();
                if (stringArray == null || stringArray.length == 0) {
                    this.addDebuggerListener(lazyDebuggerManagerListener);
                    continue;
                }
                int n2 = stringArray.length;
                for (int j = 0; j < n2; ++j) {
                    this.addDebuggerListener(stringArray[j], lazyDebuggerManagerListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(Session session) {
        Session[] sessionArray;
        Session[] sessionArray2;
        List list = this.sessions;
        synchronized (list) {
            sessionArray2 = this.getSessions();
            int n = sessionArray2.length;
            for (int i = 0; i < n; ++i) {
                if (session != sessionArray2[i]) continue;
                return;
            }
            sessionArray = new Session[sessionArray2.length + 1];
            System.arraycopy(sessionArray2, 0, sessionArray, 0, sessionArray2.length);
            sessionArray[sessionArray2.length] = session;
            this.sessions.add(session);
            session.addPropertyChangeListener(this.sessionListener);
        }
        this.fireSessionAdded(session, sessionArray2, sessionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(Session session) {
        DebuggerEngine debuggerEngine;
        DebuggerEngine debuggerEngine2;
        Session[] sessionArray;
        Session[] sessionArray2;
        List list = this.sessions;
        synchronized (list) {
            int n;
            sessionArray2 = this.getSessions();
            Session session2 = null;
            int n2 = sessionArray2.length;
            for (n = 0; n < n2 && sessionArray2[n] != session; ++n) {
                if (session2 != null) continue;
                session2 = sessionArray2[n];
            }
            if (n == n2) {
                return;
            }
            if (session == this.getCurrentSession()) {
                if (session2 == null && n2 > 1) {
                    session2 = sessionArray2[1];
                }
                this.setCurrentSession(session2);
            }
            sessionArray = new Session[sessionArray2.length - 1];
            System.arraycopy(sessionArray2, 0, sessionArray, 0, n);
            if (sessionArray2.length - n > 1) {
                System.arraycopy(sessionArray2, n + 1, sessionArray, n, sessionArray2.length - n - 1);
            }
            this.sessions.remove(n);
            session.removePropertyChangeListener(this.sessionListener);
            debuggerEngine2 = this.currentEngine;
            debuggerEngine = null;
            if (this.getCurrentSession() != null) {
                debuggerEngine = this.getCurrentSession().getCurrentEngine();
            }
            this.currentEngine = debuggerEngine;
        }
        if (debuggerEngine2 != debuggerEngine) {
            this.firePropertyChange(PROP_CURRENT_ENGINE, debuggerEngine2, debuggerEngine);
        }
        this.fireSessionRemoved(session, sessionArray2, sessionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEngine(DebuggerEngine debuggerEngine) {
        DebuggerEngine[] debuggerEngineArray;
        DebuggerEngine[] debuggerEngineArray2;
        Set set = this.engines;
        synchronized (set) {
            if (this.engines.contains(debuggerEngine)) {
                return;
            }
            debuggerEngineArray2 = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
            this.engines.add(debuggerEngine);
            debuggerEngineArray = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
        this.fireEngineAdded(debuggerEngine, debuggerEngineArray2, debuggerEngineArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEngine(DebuggerEngine debuggerEngine) {
        DebuggerEngine[] debuggerEngineArray;
        DebuggerEngine[] debuggerEngineArray2;
        Set set = this.engines;
        synchronized (set) {
            if (!this.engines.contains(debuggerEngine)) {
                return;
            }
            debuggerEngineArray2 = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
            this.engines.remove(debuggerEngine);
            debuggerEngineArray = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
        this.fireEngineRemoved(debuggerEngine, debuggerEngineArray2, debuggerEngineArray);
    }

    private class SessionListener
    implements PropertyChangeListener {
        private SessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof Session) {
                DebuggerEngine debuggerEngine;
                DebuggerEngine debuggerEngine2;
                if (!propertyChangeEvent.getPropertyName().equals("currentLanguage") && !propertyChangeEvent.getPropertyName().equals("supportedLanguages")) {
                    return;
                }
                Object object = DebuggerManager.this.sessions;
                synchronized (object) {
                    debuggerEngine2 = DebuggerManager.this.currentEngine;
                    debuggerEngine = null;
                    if (DebuggerManager.this.getCurrentSession() != null) {
                        debuggerEngine = DebuggerManager.this.getCurrentSession().getCurrentEngine();
                    }
                    DebuggerManager.this.currentEngine = debuggerEngine;
                }
                if (debuggerEngine != debuggerEngine2) {
                    DebuggerManager.this.firePropertyChange(DebuggerManager.PROP_CURRENT_ENGINE, debuggerEngine2, debuggerEngine);
                }
                if (((Session)(object = (Session)propertyChangeEvent.getSource())).getSupportedLanguages().length == 0) {
                    DebuggerManager.this.removeSession((Session)object);
                }
            }
        }
    }
}

