/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;

abstract class Lookup
implements ContextProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.registration") != null;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$api$debugger$Lookup;

    Lookup() {
    }

    abstract List lookup(String var1, Class var2, Set var3);

    abstract Set getHiddenItems(String var1, Class var2);

    public Object lookupFirst(String string, Class clazz) {
        List list = this.lookup(string, clazz);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List lookup(String string, Class clazz) {
        return this.lookup(string, clazz, Collections.EMPTY_SET);
    }

    static class MetaInf
    extends Lookup {
        private static final String HIDDEN = "-hidden";
        private String rootFolder;
        private HashMap registrationCache = new HashMap();
        private HashMap instanceCache = new HashMap();
        private Lookup context;

        MetaInf(String string) {
            this.rootFolder = string;
        }

        void setContext(Lookup lookup) {
            this.context = lookup;
        }

        List lookup(String string, Class clazz, Set set) {
            List list = this.list(string, clazz);
            HashSet hashSet = new HashSet(list);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)list.get(i);
                if (string2.endsWith(HIDDEN) || hashSet.contains(string2 + HIDDEN)) continue;
                Object object = null;
                object = this.instanceCache.get(string2);
                if (object == null) {
                    object = this.createInstance(string2);
                    this.instanceCache.put(string2, object);
                }
                if (object == null) continue;
                arrayList.add(object);
            }
            return arrayList;
        }

        Set getHiddenItems(String string, Class clazz) {
            Iterator iterator = this.list(string, clazz).iterator();
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.endsWith(HIDDEN)) continue;
                hashSet.add(string2.substring(0, string2.length() - 7));
            }
            return hashSet;
        }

        private List list(String string, Class clazz) {
            String string2 = clazz.getName();
            String string3 = "META-INF/debugger/" + (this.rootFolder == null ? "" : this.rootFolder + "/") + (string == null ? "" : string + "/") + string2;
            if (!this.registrationCache.containsKey(string3)) {
                this.registrationCache.put(string3, this.loadMetaInf(string3));
            }
            return (List)this.registrationCache.get(string3);
        }

        private ArrayList loadMetaInf(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                ClassLoader classLoader = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Lookup.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                String string2 = "\nR lookup " + string;
                Enumeration<URL> enumeration = classLoader.getResources(string);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = uRL.openStream();
                    if (inputStream == null) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        if (!string3.startsWith("#") && string3.length() != 0) {
                            if (verbose) {
                                string2 = string2 + "\nR  service " + string3 + " found";
                            }
                            arrayList.add(string3);
                        }
                        string3 = bufferedReader.readLine();
                    }
                }
                if (verbose) {
                    System.out.println(string2);
                }
                return arrayList;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new InternalError("Can not read from Meta-inf!");
            }
        }

        private Object createInstance(String string) {
            try {
                Object object;
                ClassLoader classLoader = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Lookup.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                String string2 = null;
                if (string.endsWith("()")) {
                    int n = string.lastIndexOf(46);
                    if (n < 0) {
                        ErrorManager.getDefault().log("Bad service - dot before method name is missing: '" + string + "'.");
                        return null;
                    }
                    string2 = string.substring(n + 1, string.length() - 2).trim();
                    string = string.substring(0, n);
                }
                Class<?> clazz = classLoader.loadClass(string);
                Object object2 = null;
                if (string2 != null) {
                    object = null;
                    if (this.context != null) {
                        try {
                            object = clazz.getDeclaredMethod(string2, class$org$netbeans$api$debugger$Lookup == null ? (class$org$netbeans$api$debugger$Lookup = Lookup.class$("org.netbeans.api.debugger.Lookup")) : class$org$netbeans$api$debugger$Lookup);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (object == null) {
                        try {
                            object = clazz.getDeclaredMethod(string2, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (object != null) {
                        Object[] objectArray;
                        if (object.getParameterTypes().length == 0) {
                            objectArray = new Object[]{};
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = this.context;
                        }
                        object2 = object.invoke(null, objectArray);
                    }
                }
                if (object2 == null && this.context != null) {
                    object = clazz.getConstructors();
                    int n = ((Constructor<?>[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Constructor<?> constructor = object[i];
                        if (constructor.getParameterTypes().length != 1) continue;
                        try {
                            object2 = constructor.newInstance(this.context);
                            continue;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (!verbose) continue;
                            System.out.println("\nservice: " + string);
                            illegalAccessException.printStackTrace();
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (!verbose) continue;
                            System.out.println("\nservice: " + string);
                            illegalArgumentException.printStackTrace();
                        }
                    }
                }
                if (object2 == null) {
                    object2 = clazz.newInstance();
                }
                if (verbose) {
                    System.out.println("\nR  instance " + object2 + " created");
                }
                return object2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)classNotFoundException, "The service " + string + " is not found."));
            }
            catch (InstantiationException instantiationException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)instantiationException, "The service " + string + " can not be instantiated."));
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)illegalAccessException, "The service " + string + " can not be accessed."));
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)invocationTargetException, "The service " + string + " can not be created."));
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)exceptionInInitializerError, "The service " + string + " can not be initialized."));
            }
            return null;
        }
    }

    static class Compound
    extends Lookup {
        private Lookup l1;
        private Lookup l2;

        Compound(Lookup lookup, Lookup lookup2) {
            this.l1 = lookup;
            this.l2 = lookup2;
            this.setContext(this);
        }

        List lookup(String string, Class clazz, Set set) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.l1.lookup(string, clazz, set));
            arrayList.addAll(this.l2.lookup(string, clazz, set));
            return arrayList;
        }

        Set getHiddenItems(String string, Class clazz) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.l1.getHiddenItems(string, clazz).iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            iterator = this.l2.getHiddenItems(string, clazz).iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            return hashSet;
        }

        void setContext(Lookup lookup) {
            if (this.l1 instanceof Compound) {
                ((Compound)this.l1).setContext(lookup);
            }
            if (this.l1 instanceof MetaInf) {
                ((MetaInf)this.l1).setContext(lookup);
            }
            if (this.l2 instanceof Compound) {
                ((Compound)this.l2).setContext(lookup);
            }
            if (this.l2 instanceof MetaInf) {
                ((MetaInf)this.l2).setContext(lookup);
            }
        }
    }

    static class Instance
    extends Lookup {
        private Object[] services;

        Instance(Object[] objectArray) {
            this.services = objectArray;
        }

        List lookup(String string, Class clazz, Set set) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = this.services.length;
            for (int i = 0; i < n; ++i) {
                if (!clazz.isAssignableFrom(this.services[i].getClass()) || set.contains(this.services[i].getClass().getName())) continue;
                arrayList.add(this.services[i]);
                if (!verbose) continue;
                System.out.println("\nR  instance " + this.services[i] + " found");
            }
            return arrayList;
        }

        Set getHiddenItems(String string, Class clazz) {
            return Collections.EMPTY_SET;
        }
    }
}

