/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class Properties {
    private static Properties defaultProperties;
    static /* synthetic */ Class class$org$netbeans$api$debugger$Properties$Reader;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static synchronized Properties getDefault() {
        if (defaultProperties == null) {
            defaultProperties = new PropertiesImpl();
        }
        return defaultProperties;
    }

    public abstract String getString(String var1, String var2);

    public abstract void setString(String var1, String var2);

    public abstract int getInt(String var1, int var2);

    public abstract void setInt(String var1, int var2);

    public abstract char getChar(String var1, char var2);

    public abstract void setChar(String var1, char var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void setFloat(String var1, float var2);

    public abstract long getLong(String var1, long var2);

    public abstract void setLong(String var1, long var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void setDouble(String var1, double var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract byte getByte(String var1, byte var2);

    public abstract void setByte(String var1, byte var2);

    public abstract short getShort(String var1, short var2);

    public abstract void setShort(String var1, short var2);

    public abstract Object getObject(String var1, Object var2);

    public abstract void setObject(String var1, Object var2);

    public abstract Object[] getArray(String var1, Object[] var2);

    public abstract void setArray(String var1, Object[] var2);

    public abstract Collection getCollection(String var1, Collection var2);

    public abstract void setCollection(String var1, Collection var2);

    public abstract Map getMap(String var1, Map var2);

    public abstract void setMap(String var1, Map var2);

    public abstract Properties getProperties(String var1);

    private static class DelegatingProperties
    extends Properties {
        private Properties delegatingProperties;
        private String root;

        DelegatingProperties(Properties properties, String string) {
            this.delegatingProperties = properties;
            this.root = string;
        }

        public String getString(String string, String string2) {
            return this.delegatingProperties.getString(this.root + '.' + string, string2);
        }

        public void setString(String string, String string2) {
            this.delegatingProperties.setString(this.root + '.' + string, string2);
        }

        public int getInt(String string, int n) {
            return this.delegatingProperties.getInt(this.root + '.' + string, n);
        }

        public void setInt(String string, int n) {
            this.delegatingProperties.setInt(this.root + '.' + string, n);
        }

        public byte getByte(String string, byte by) {
            return this.delegatingProperties.getByte(this.root + '.' + string, by);
        }

        public void setByte(String string, byte by) {
            this.delegatingProperties.setByte(this.root + '.' + string, by);
        }

        public char getChar(String string, char c) {
            return this.delegatingProperties.getChar(this.root + '.' + string, c);
        }

        public void setChar(String string, char c) {
            this.delegatingProperties.setChar(this.root + '.' + string, c);
        }

        public boolean getBoolean(String string, boolean bl) {
            return this.delegatingProperties.getBoolean(this.root + '.' + string, bl);
        }

        public void setBoolean(String string, boolean bl) {
            this.delegatingProperties.setBoolean(this.root + '.' + string, bl);
        }

        public short getShort(String string, short s) {
            return this.delegatingProperties.getShort(this.root + '.' + string, s);
        }

        public void setShort(String string, short s) {
            this.delegatingProperties.setShort(this.root + '.' + string, s);
        }

        public long getLong(String string, long l) {
            return this.delegatingProperties.getLong(this.root + '.' + string, l);
        }

        public void setLong(String string, long l) {
            this.delegatingProperties.setLong(this.root + '.' + string, l);
        }

        public double getDouble(String string, double d) {
            return this.delegatingProperties.getDouble(this.root + '.' + string, d);
        }

        public void setDouble(String string, double d) {
            this.delegatingProperties.setDouble(this.root + '.' + string, d);
        }

        public float getFloat(String string, float f) {
            return this.delegatingProperties.getFloat(this.root + '.' + string, f);
        }

        public void setFloat(String string, float f) {
            this.delegatingProperties.setFloat(this.root + '.' + string, f);
        }

        public Object getObject(String string, Object object) {
            return this.delegatingProperties.getObject(this.root + '.' + string, object);
        }

        public void setObject(String string, Object object) {
            this.delegatingProperties.setObject(this.root + '.' + string, object);
        }

        public Object[] getArray(String string, Object[] objectArray) {
            return this.delegatingProperties.getArray(this.root + '.' + string, objectArray);
        }

        public void setArray(String string, Object[] objectArray) {
            this.delegatingProperties.setArray(this.root + '.' + string, objectArray);
        }

        public Collection getCollection(String string, Collection collection) {
            return this.delegatingProperties.getCollection(this.root + '.' + string, collection);
        }

        public void setCollection(String string, Collection collection) {
            this.delegatingProperties.setCollection(this.root + '.' + string, collection);
        }

        public Map getMap(String string, Map map) {
            return this.delegatingProperties.getMap(this.root + '.' + string, map);
        }

        public void setMap(String string, Map map) {
            this.delegatingProperties.setMap(this.root + '.' + string, map);
        }

        public Properties getProperties(String string) {
            return new DelegatingProperties(this.delegatingProperties, this.root + '.' + string);
        }
    }

    private static class PropertiesImpl
    extends Properties {
        private static final Object BAD_OBJECT = new Object();
        private static final String BAD_STRING = "";
        private static final Map BAD_MAP = new HashMap();
        private static final Collection BAD_COLLECTION = new ArrayList();
        private static final Object[] BAD_ARRAY = new Object[0];
        private HashMap register;
        private PrimitiveRegister impl = new PrimitiveRegister();
        private static ClassLoader classLoader;

        private PropertiesImpl() {
        }

        private void initReaders() {
            this.register = new HashMap();
            Iterator iterator = DebuggerManager.getDebuggerManager().lookup(null, class$org$netbeans$api$debugger$Properties$Reader == null ? (class$org$netbeans$api$debugger$Properties$Reader = Properties.class$("org.netbeans.api.debugger.Properties$Reader")) : class$org$netbeans$api$debugger$Properties$Reader).iterator();
            while (iterator.hasNext()) {
                Reader reader = (Reader)iterator.next();
                String[] stringArray = reader.getSupportedClassNames();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.register.put(stringArray[i], reader);
                }
            }
        }

        private Reader findReader(String string) {
            Reader reader;
            if (this.register == null) {
                this.initReaders();
            }
            if ((reader = (Reader)this.register.get(string)) != null) {
                return reader;
            }
            Class<?> clazz = null;
            try {
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
            for (clazz = PropertiesImpl.getClassLoader().loadClass(string); clazz != null && this.register.get(clazz.getName()) == null; clazz = clazz.getSuperclass()) {
            }
            if (clazz != null) {
                reader = (Reader)this.register.get(clazz.getName());
            }
            return reader;
        }

        public String getString(String string, String string2) {
            String string3 = this.impl.getProperty(string, null);
            if (string3 == null) {
                return string2;
            }
            if (!string3.startsWith("\"")) {
                System.out.println("Can not read string " + string3 + ".");
                return string2;
            }
            return string3.substring(1, string3.length() - 1);
        }

        public void setString(String string, String string2) {
            if (string2 != null) {
                this.impl.setProperty(string, "\"" + string2 + "\"");
            } else {
                this.impl.setProperty(string, string2);
            }
        }

        public int getInt(String string, int n) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return n;
            }
            int n2 = Integer.parseInt(string2);
            return n2;
        }

        public void setInt(String string, int n) {
            this.impl.setProperty(string, Integer.toString(n));
        }

        public char getChar(String string, char c) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return c;
            }
            char c2 = string2.charAt(0);
            return c2;
        }

        public void setChar(String string, char c) {
            this.impl.setProperty(string, BAD_STRING + c);
        }

        public float getFloat(String string, float f) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return f;
            }
            float f2 = Float.parseFloat(string2);
            return f2;
        }

        public void setFloat(String string, float f) {
            this.impl.setProperty(string, Float.toString(f));
        }

        public long getLong(String string, long l) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return l;
            }
            long l2 = Long.parseLong(string2);
            return l2;
        }

        public void setLong(String string, long l) {
            this.impl.setProperty(string, Long.toString(l));
        }

        public double getDouble(String string, double d) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return d;
            }
            double d2 = Double.parseDouble(string2);
            return d2;
        }

        public void setDouble(String string, double d) {
            this.impl.setProperty(string, Double.toString(d));
        }

        public boolean getBoolean(String string, boolean bl) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return bl;
            }
            boolean bl2 = string2.equals("true");
            return bl2;
        }

        public void setBoolean(String string, boolean bl) {
            this.impl.setProperty(string, bl ? "true" : "false");
        }

        public byte getByte(String string, byte by) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return by;
            }
            byte by2 = Byte.parseByte(string2);
            return by2;
        }

        public void setByte(String string, byte by) {
            this.impl.setProperty(string, Byte.toString(by));
        }

        public short getShort(String string, short s) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return s;
            }
            short s2 = Short.parseShort(string2);
            return s2;
        }

        public void setShort(String string, short s) {
            this.impl.setProperty(string, Short.toString(s));
        }

        public Object getObject(String string, Object object) {
            Reader reader;
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return object;
            }
            if (string2.equals("# null")) {
                return null;
            }
            if (string2 == null) {
                return object;
            }
            if (!string2.startsWith("# ")) {
                if (string2.startsWith("\"")) {
                    String string3 = this.getString(string, BAD_STRING);
                    if (string3 == BAD_STRING) {
                        return object;
                    }
                    return string3;
                }
                System.out.println("Can not read object " + string2 + ". No reader registered for type " + string2 + ".");
                return object;
            }
            string2 = string2.substring(2);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz != null) {
                if ((class$java$util$Map == null ? (class$java$util$Map = Properties.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
                    Map map = this.getMap(string, BAD_MAP);
                    if (map == BAD_MAP) {
                        return object;
                    }
                    return map;
                }
                if ((array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Properties.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).isAssignableFrom(clazz)) {
                    Object[] objectArray = this.getArray(string, BAD_ARRAY);
                    if (objectArray == BAD_ARRAY) {
                        return object;
                    }
                    return objectArray;
                }
                if ((class$java$util$Collection == null ? (class$java$util$Collection = Properties.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
                    Collection collection = this.getCollection(string, BAD_COLLECTION);
                    if (collection == BAD_COLLECTION) {
                        return object;
                    }
                    return collection;
                }
            }
            if ((reader = this.findReader(string2)) == null) {
                System.out.println("Can not read object. No reader registered for type " + string2 + ".");
                return object;
            }
            return reader.read(string2, this.getProperties(string));
        }

        public void setObject(String string, Object object) {
            if (object == null) {
                this.impl.setProperty(string, "# null");
                return;
            }
            if (object instanceof String) {
                this.setString(string, (String)object);
                return;
            }
            if (object instanceof Map) {
                this.setMap(string, (Map)object);
                return;
            }
            if (object instanceof Collection) {
                this.setCollection(string, (Collection)object);
                return;
            }
            if (object instanceof Object[]) {
                this.setArray(string, (Object[])object);
                return;
            }
            Reader reader = this.findReader(object.getClass().getName());
            if (reader == null) {
                System.out.println("Can not write object " + object);
                return;
            }
            reader.write(object, this.getProperties(string));
            this.impl.setProperty(string, "# " + object.getClass().getName());
        }

        public Object[] getArray(String string, Object[] objectArray) {
            String string2 = this.impl.getProperty(string, null);
            String string3 = this.impl.getProperty(string + ".array_type", null);
            Properties properties = this.getProperties(string);
            int n = properties.getInt("length", -1);
            if (n < 0) {
                return objectArray;
            }
            Object[] objectArray2 = null;
            try {
                objectArray2 = (Object[])Array.newInstance(PropertiesImpl.getClassLoader().loadClass(string3), n);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                objectArray2 = new Object[n];
            }
            for (int i = 0; i < n; ++i) {
                Object object = properties.getObject(BAD_STRING + i, BAD_OBJECT);
                if (object == BAD_OBJECT) {
                    return objectArray;
                }
                objectArray2[i] = object;
            }
            return objectArray2;
        }

        public void setArray(String string, Object[] objectArray) {
            this.impl.setProperty(string, "# array");
            this.impl.setProperty(string + ".array_type", objectArray.getClass().getComponentType().getName());
            if (objectArray == null) {
                return;
            }
            Properties properties = this.getProperties(string);
            int n = objectArray.length;
            properties.setInt("length", n);
            for (int i = 0; i < n; ++i) {
                properties.setObject(BAD_STRING + i, objectArray[i]);
            }
        }

        public Collection getCollection(String string, Collection collection) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return collection;
            }
            if (!string2.startsWith("# ")) {
                return collection;
            }
            Collection collection2 = null;
            try {
                collection2 = (Collection)Class.forName(string2.substring(2)).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return collection;
            }
            catch (InstantiationException instantiationException) {
                return collection;
            }
            catch (IllegalAccessException illegalAccessException) {
                return collection;
            }
            Properties properties = this.getProperties(string);
            int n = properties.getInt("length", 0);
            for (int i = 0; i < n; ++i) {
                Object object = properties.getObject(BAD_STRING + i, BAD_OBJECT);
                if (object == BAD_OBJECT) {
                    return collection;
                }
                collection2.add(object);
            }
            return collection2;
        }

        public void setCollection(String string, Collection collection) {
            if (collection == null) {
                return;
            }
            this.impl.setProperty(string, "# " + collection.getClass().getName());
            if (collection == null) {
                return;
            }
            Properties properties = this.getProperties(string);
            Iterator iterator = collection.iterator();
            int n = 0;
            properties.setInt("length", collection.size());
            while (iterator.hasNext()) {
                properties.setObject(BAD_STRING + n, iterator.next());
                ++n;
            }
        }

        public Map getMap(String string, Map map) {
            String string2 = this.impl.getProperty(string, null);
            if (string2 == null) {
                return map;
            }
            if (!string2.startsWith("# ")) {
                return map;
            }
            Map map2 = null;
            try {
                map2 = (Map)Class.forName(string2.substring(2)).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return map;
            }
            catch (InstantiationException instantiationException) {
                return map;
            }
            catch (IllegalAccessException illegalAccessException) {
                return map;
            }
            Properties properties = this.getProperties(string);
            int n = properties.getInt("length", 0);
            for (int i = 0; i < n; ++i) {
                Object object = properties.getObject(BAD_STRING + i + "-key", BAD_OBJECT);
                if (object == BAD_OBJECT) {
                    return map;
                }
                Object object2 = properties.getObject(BAD_STRING + i + "-value", BAD_OBJECT);
                if (object2 == BAD_OBJECT) {
                    return map;
                }
                map2.put(object, object2);
            }
            return map2;
        }

        public void setMap(String string, Map map) {
            if (map == null) {
                return;
            }
            this.impl.setProperty(string, "# " + map.getClass().getName());
            if (map == null) {
                return;
            }
            Properties properties = this.getProperties(string);
            Iterator iterator = map.keySet().iterator();
            int n = 0;
            properties.setInt("length", map.size());
            while (iterator.hasNext()) {
                Object k = iterator.next();
                properties.setObject(BAD_STRING + n + "-key", k);
                properties.setObject(BAD_STRING + n + "-value", map.get(k));
                ++n;
            }
        }

        public Properties getProperties(String string) {
            return new DelegatingProperties(this, string);
        }

        private static ClassLoader getClassLoader() {
            if (classLoader == null) {
                classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Properties.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            }
            return classLoader;
        }
    }

    private static class PrimitiveRegister {
        private HashMap properties = new HashMap();
        private boolean isInitialized = false;
        private RequestProcessor.Task task;

        private PrimitiveRegister() {
        }

        protected String getProperty(String string, String string2) {
            if (!this.isInitialized) {
                this.load();
            }
            this.isInitialized = true;
            String string3 = (String)this.properties.get(string);
            if (string3 != null) {
                return string3;
            }
            return string2;
        }

        protected void setProperty(String string, String string2) {
            if (!this.isInitialized) {
                this.load();
            }
            this.properties.put(string, string2);
            this.save();
        }

        private void load() {
            BufferedReader bufferedReader = null;
            try {
                FileObject fileObject;
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                FileObject fileObject2 = fileSystem.findResource("Services");
                if (fileObject2 == null) {
                    fileObject2 = fileSystem.getRoot();
                }
                if ((fileObject = fileObject2.getFileObject("org-netbeans-modules-debugger-Settings", "properties")) == null) {
                    fileObject = fileObject2.createData("org-netbeans-modules-debugger-Settings", "properties");
                }
                InputStream inputStream = fileObject.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                while (string != null) {
                    int n = string.indexOf(58);
                    if (n > 0) {
                        this.properties.put(string.substring(0, n), string.substring(n + 1));
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private synchronized void save() {
            if (this.task == null) {
                this.task = new RequestProcessor("Debugger Properties Save RP", 1).create(new Runnable(){

                    public void run() {
                        this.saveIn();
                    }
                });
            }
            this.task.schedule(4000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void saveIn() {
            PrintWriter printWriter = null;
            FileLock fileLock = null;
            try {
                try {
                    FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services");
                    FileObject fileObject2 = fileObject.getFileObject("org-netbeans-modules-debugger-Settings", "properties");
                    if (fileObject2 == null) {
                        fileObject2 = fileObject.createData("org-netbeans-modules-debugger-Settings", "properties");
                    }
                    fileLock = fileObject2.lock();
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    printWriter = new PrintWriter(outputStream);
                    Set set = this.properties.keySet();
                    ArrayList arrayList = new ArrayList(set);
                    Collections.sort(arrayList);
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        String string = (String)arrayList.get(i);
                        Object v = this.properties.get(string);
                        if (v == null) continue;
                        printWriter.println("" + string + ":" + v);
                    }
                    printWriter.flush();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)iOException, "Can not save debugger settings."));
                    Object var13_14 = null;
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    if (fileLock == null) return;
                    fileLock.releaseLock();
                    return;
                }
                Object var13_13 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                if (fileLock == null) return;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                if (fileLock == null) throw throwable;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
        }
    }

    public static interface Reader {
        public String[] getSupportedClassNames();

        public Object read(String var1, Properties var2);

        public void write(Object var1, Properties var2);
    }
}

