/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;

public final class Session {
    public static final String PROP_CURRENT_LANGUAGE = "currentLanguage";
    public static final String PROP_SUPPORTED_LANGUAGES = "supportedLanguages";
    private String name;
    private String locationName;
    private DebuggerEngine currentDebuggerEngine;
    private String currentLanguage;
    private String[] languages;
    private DebuggerEngine[] engines;
    private PropertyChangeSupport pcs;
    private Lookup lookup;
    Lookup privateLookup;

    Session(String string, String string2, String string3, Object[] objectArray, Lookup lookup) {
        this.name = string;
        this.locationName = string2;
        this.languages = new String[0];
        this.engines = new DebuggerEngine[0];
        this.pcs = new PropertyChangeSupport(this);
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = this;
        this.privateLookup = new Lookup.Compound(new Lookup.Instance(objectArray2), new Lookup.MetaInf(string3));
        this.lookup = new Lookup.Compound(lookup, this.privateLookup);
    }

    public String getName() {
        return this.name;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentDebuggerEngine;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String[] getSupportedLanguages() {
        return this.languages;
    }

    public List lookup(String string, Class clazz) {
        return this.lookup.lookup(string, clazz);
    }

    public Object lookupFirst(String string, Class clazz) {
        return this.lookup.lookupFirst(string, clazz);
    }

    public void kill() {
        HashSet<DebuggerEngine> hashSet = new HashSet<DebuggerEngine>(Arrays.asList(this.engines));
        Iterator<DebuggerEngine> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            iterator.next().getActionsManager().doAction(ActionsManager.ACTION_KILL);
        }
    }

    public DebuggerEngine getEngineForLanguage(String string) {
        int n = this.languages.length;
        for (int i = 0; i < n; ++i) {
            if (!this.languages[i].equals(string)) continue;
            return this.engines[i];
        }
        return null;
    }

    public void setCurrentLanguage(String string) {
        int n = this.languages.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.languages[i])) continue;
            String string2 = this.currentLanguage;
            this.currentLanguage = string;
            this.currentDebuggerEngine = this.engines[i];
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, string2, this.currentLanguage);
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    void addLanguage(String string, DebuggerEngine debuggerEngine) {
        int n = this.languages.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.languages[i])) continue;
            this.engines[i] = debuggerEngine;
            return;
        }
        String[] stringArray = new String[this.languages.length + 1];
        DebuggerEngine[] debuggerEngineArray = new DebuggerEngine[this.engines.length + 1];
        System.arraycopy(this.languages, 0, stringArray, 0, this.languages.length);
        System.arraycopy(this.engines, 0, debuggerEngineArray, 0, this.engines.length);
        stringArray[this.languages.length] = string;
        debuggerEngineArray[this.engines.length] = debuggerEngine;
        String[] stringArray2 = this.languages;
        this.languages = stringArray;
        this.engines = debuggerEngineArray;
        DebuggerManager.getDebuggerManager().addEngine(debuggerEngine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, stringArray2, this.languages);
        if (this.currentLanguage == null) {
            this.setCurrentLanguage(string);
        }
    }

    void removeEngine(DebuggerEngine debuggerEngine) {
        if (this.engines.length == 0) {
            return;
        }
        int n = this.engines.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<DebuggerEngine> arrayList2 = new ArrayList<DebuggerEngine>();
        for (int i = 0; i < n; ++i) {
            if (debuggerEngine.equals(this.engines[i])) continue;
            arrayList.add(this.languages[i]);
            arrayList2.add(this.engines[i]);
        }
        String[] stringArray = this.languages;
        this.languages = arrayList.toArray(new String[arrayList.size()]);
        this.engines = arrayList2.toArray(new DebuggerEngine[arrayList2.size()]);
        DebuggerManager.getDebuggerManager().removeEngine(debuggerEngine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, stringArray, this.languages);
    }

    void removeLanguage(String string, DebuggerEngine debuggerEngine) {
        int n;
        int n2 = this.languages.length;
        for (n = 0; n < n2; ++n) {
            if (!string.equals(this.languages[n])) continue;
            if (this.engines[n] == debuggerEngine) break;
            throw new IllegalArgumentException();
        }
        if (n >= n2) {
            return;
        }
        String[] stringArray = new String[n2 - 1];
        DebuggerEngine[] debuggerEngineArray = new DebuggerEngine[n2 - 1];
        if (n > 0) {
            System.arraycopy(this.languages, 0, stringArray, 0, n);
            System.arraycopy(this.engines, 0, debuggerEngineArray, 0, n);
        }
        System.arraycopy(this.languages, n + 1, stringArray, n, n2 - n - 1);
        System.arraycopy(this.engines, n + 1, debuggerEngineArray, n, n2 - n - 1);
        String[] stringArray2 = this.languages;
        this.languages = stringArray;
        this.engines = debuggerEngineArray;
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, stringArray2, this.languages);
        n2 = this.engines.length;
        for (n = 0; n < n2; ++n) {
            if (this.engines[n] != debuggerEngine) continue;
            return;
        }
        DebuggerManager.getDebuggerManager().removeEngine(debuggerEngine);
    }

    public String toString() {
        return "" + this.getClass().getName() + " " + this.getLocationName() + ":" + this.getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

