/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import javax.swing.SwingUtilities;
import org.netbeans.modules.autoupdate.AutoCheckInfo;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.AvailableUpdateVisualizerProvider;
import org.netbeans.modules.autoupdate.ConnectingErrorDialog;
import org.netbeans.modules.autoupdate.ProblemsVisualizerProvider;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AutoChecker
implements Runnable,
Wizard.Validator {
    private Settings settings;
    private Updates updates;
    private HashMap allUpdates = new HashMap();
    private static final Random RANDOM;
    static AutoChecker autoChecker;
    private boolean canceled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void doCheck() {
        autoChecker.run();
    }

    AutoChecker() {
        this.settings = Settings.getShared();
    }

    void install() {
        Autoupdater.installUpdateChecker(this);
        autoChecker = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AutoCheckInfo autoCheckInfo;
        this.canceled = false;
        if (!(this.settings.getIdeIdentity() instanceof String)) {
            String string;
            int n;
            block10: {
                n = RANDOM.nextInt();
                if (n < 0) {
                    n = -(n + 1);
                }
                string = "";
                try {
                    FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/productid");
                    if (fileObject == null) break block10;
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        string = bufferedReader.readLine().trim();
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.settings.setIdeIdentity(string + Integer.toString(n));
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        if (!this.timeToCheck()) {
            return;
        }
        if (this.settings.isAskBefore() && !(autoCheckInfo = new AutoCheckInfo(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Before"), 1)).showDialog(true)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                AutoChecker.this.runInner();
            }
        });
    }

    void runInner() {
        Wizard.resetErrorStore();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)AutoChecker.class, (String)"CTL_Checking_StatusText"));
        Enumeration enumeration = AutoupdateType.autoupdateTypes();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AutoupdateType autoupdateType = (AutoupdateType)((Object)enumeration.nextElement());
            if (!autoupdateType.isEnabled()) continue;
            ++n;
            this.updates = autoupdateType.connectForUpdates();
            this.updates.checkUpdates(this, autoupdateType, true);
            int n3 = Wizard.checkConnect(this.updates, autoupdateType);
            if (n3 == 0 && (this.updates.getTimeStamp() == null || autoupdateType.getLastTimeStamp() == null || autoupdateType.getLastTimeStamp().before(this.updates.getTimeStamp()))) {
                this.allUpdates.put(autoupdateType, this.updates);
                ++n2;
                continue;
            }
            if (n3 != 2 || Wizard.getStoredErrorType() != 4) continue;
            ++n2;
        }
        boolean bl = true;
        if (n2 == 0) {
            StatusDisplayer.getDefault().setStatusText("");
            this.canceled = true;
            if (Wizard.isErrorStored() && 5 == Wizard.getStoredErrorType()) {
                this.notifyError(5);
                bl = false;
            } else if (n != 0 && this.settings.isNegativeResults()) {
                this.notifyNoUpdatesFound();
            }
            return;
        }
        this.reportResults(bl);
    }

    void reportResults(boolean bl) {
        StatusDisplayer.getDefault().setStatusText("");
        if (bl) {
            this.settings.setLastCheck(new Date());
        }
        if (this.canceled || !bl) {
            return;
        }
        if (this.allUpdates.size() == 0) {
            if (this.settings.isNegativeResults()) {
                this.notifyNoUpdatesFound();
            }
            return;
        }
        if (this.getAllModules() != null && this.getAllModules().size() > 0) {
            this.notifyUpdates();
        } else if (this.settings.isNegativeResults()) {
            this.notifyNoUpdatesFound();
        }
    }

    private void notifyUpdates() {
        Runnable runnable = new Runnable(){

            public void run() {
                Wizard.go(AutoChecker.this.allUpdates);
            }
        };
        AvailableUpdateVisualizerProvider.UpdatesFlasher updatesFlasher = AvailableUpdateVisualizerProvider.getFlasher(runnable);
        if (!$assertionsDisabled && updatesFlasher == null) {
            throw new AssertionError((Object)"Updates Flasher cannot be null.");
        }
        updatesFlasher.setToolTipText(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Found_ToolTip"));
        updatesFlasher.startFlashing();
    }

    private void notifyNoUpdatesFound() {
        Runnable runnable = new Runnable(){

            public void run() {
                AutoChecker.this.noUpdatesFound();
            }
        };
        ProblemsVisualizerProvider.UpdatesFlasher updatesFlasher = ProblemsVisualizerProvider.getFlasher(runnable);
        if (!$assertionsDisabled && updatesFlasher == null) {
            throw new AssertionError((Object)"Updates Flasher cannot be null.");
        }
        updatesFlasher.setToolTipText(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Problem"));
        updatesFlasher.startFlashing();
    }

    private void notifyError(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                ConnectingErrorDialog.showDialog(n, null, true);
            }
        };
        ProblemsVisualizerProvider.UpdatesFlasher updatesFlasher = ProblemsVisualizerProvider.getFlasher(runnable);
        if (!$assertionsDisabled && updatesFlasher == null) {
            throw new AssertionError((Object)"Updates Flasher cannot be null.");
        }
        updatesFlasher.setToolTipText(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Problem"));
        updatesFlasher.startFlashing();
    }

    private void noUpdatesFound() {
        AutoCheckInfo autoCheckInfo = new AutoCheckInfo(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_NotFound"), 1);
        autoCheckInfo.showDialog(false);
    }

    private Collection getAllModules() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.allUpdates.values().iterator();
        while (iterator.hasNext()) {
            Collection collection = ((Updates)iterator.next()).getModules();
            if (collection == null) continue;
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    public void setValid(boolean bl) {
    }

    private boolean timeToCheck() {
        if (this.settings.getLastCheck() == null) {
            this.settings.setLastCheck(new Date());
            return false;
        }
        switch (this.settings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        Date date = this.settings.getLastCheck();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(9, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        switch (this.settings.getPeriod()) {
            case 1: {
                gregorianCalendar.add(5, 1);
                break;
            }
            case 2: {
                gregorianCalendar.add(3, 1);
                break;
            }
            case 3: {
                gregorianCalendar.add(3, 2);
                break;
            }
            case 4: {
                gregorianCalendar.add(2, 1);
            }
        }
        return gregorianCalendar.getTime().before(new Date());
    }

    static {
        $assertionsDisabled = !AutoChecker.class.desiredAssertionStatus();
        RANDOM = new Random();
    }
}

