/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.Wizard;
import org.netbeans.updater.UpdateTracking;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class Downloader {
    DownloadProgressPanel progressDialog;
    private int downloadSize;
    private int totalDownloaded;
    private int moduleDownloaded;
    private long modulesCount;
    private boolean urlDownload;
    private static int TIME_TO_CONNECTION_CHECK;
    private static final String NBM_EXTENSION = "nbm";
    private Wizard.Validator validator;
    private static final ErrorManager err;
    private static RequestProcessor.Task READ_TIMEOUT_CHECKER;
    private static RequestProcessor.Task DOWNLOAD_TASK;
    private static RequestProcessor AU_REQUEST_PROCESSOR;
    private static int DOWNLOADER_IS_INIT;
    private static int DOWNLOADER_RUNNING;
    private static int DOWNLOADER_WAITING;
    private static int DOWNLOADER_CANCELED;
    private static int DOWNLOADER_STOPPED;
    private static int DOWNLOADER_FINISHED;
    private static int DOWNLOADER_VERIFIED;
    private int downloadStatus = DOWNLOADER_IS_INIT;
    ProgressHandle partialHandle;
    ProgressHandle overallHandle;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Downloader(DownloadProgressPanel downloadProgressPanel, Wizard.Validator validator, boolean bl) {
        this.validator = validator;
        this.progressDialog = downloadProgressPanel;
        this.urlDownload = bl;
    }

    private static RequestProcessor getAutoupdateRequestProcessor() {
        if (AU_REQUEST_PROCESSOR == null) {
            AU_REQUEST_PROCESSOR = new RequestProcessor("org-netbeans-modules-autoupdate", 10, true);
        }
        return AU_REQUEST_PROCESSOR;
    }

    void doDownload() {
        if (READ_TIMEOUT_CHECKER != null) {
            READ_TIMEOUT_CHECKER.cancel();
        }
        if (!$assertionsDisabled && READ_TIMEOUT_CHECKER != null && !READ_TIMEOUT_CHECKER.isFinished()) {
            throw new AssertionError((Object)"Only one READ_TIMEOUT_CHECKER can be active");
        }
        if (DOWNLOAD_TASK != null) {
            DOWNLOAD_TASK.cancel();
            DOWNLOAD_TASK = null;
        }
        if (!$assertionsDisabled && DOWNLOAD_TASK != null && !DOWNLOAD_TASK.isFinished()) {
            throw new AssertionError((Object)"Only one DOWNLOAD_TASK can be active");
        }
        this.downloadSize = this.getTotalDownloadSize();
        this.progressDialog.setPartialLabel("");
        this.progressDialog.setOverallLabel("");
        this.progressDialog.setExtraLabel("");
        Runnable runnable = new Runnable(){

            public void run() {
                Downloader.this.progressDialog.setPartialLabel(Downloader.this.getBundle("CTL_PreparingDownload_Label"));
                err.log("Start downloading " + Downloader.this.modulesCount + " modules [" + Downloader.this.downloadSize + "]");
                Downloader.this.downloadAll();
                if (DOWNLOADER_STOPPED == Downloader.this.getStatus()) {
                    return;
                }
                Downloader.this.progressDialog.setExtraLabel(Downloader.this.getBundle("DownloadProgressPanel.jLabel1.doneText"));
                Downloader.this.validator.setValid(true);
            }
        };
        DOWNLOAD_TASK = Downloader.getAutoupdateRequestProcessor().post(runnable);
    }

    private int getTotalDownloadSize() {
        long l = 0L;
        this.modulesCount = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected() || moduleUpdate.isDownloadOK()) continue;
            l += moduleUpdate.getDownloadSize();
            ++this.modulesCount;
        }
        return (int)l;
    }

    private void downloadAll() {
        Object object;
        this.getPartialHandle(1);
        this.overallHandle = this.getOverallHandle(this.downloadSize);
        int n = 0;
        this.totalDownloaded = 0;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            if (DOWNLOADER_STOPPED == this.getStatus()) {
                return;
            }
            object = (ModuleUpdate)iterator.next();
            if (!((ModuleUpdate)object).isSelected() || ((ModuleUpdate)object).isDownloadOK()) continue;
            this.progressDialog.setPartialLabel(((ModuleUpdate)object).getName() + " [" + (n + 1) + "/" + this.modulesCount + "]");
            if (this.urlDownload) {
                if (DOWNLOADER_FINISHED == this.getStatus() || DOWNLOADER_IS_INIT == this.getStatus()) {
                    err.log("Do download " + ((ModuleUpdate)object).getName());
                    this.setStatus(DOWNLOADER_IS_INIT);
                    this.downloadModule((ModuleUpdate)object);
                    err.log("Download of " + ((ModuleUpdate)object).getName() + " ends with status " + this.getStatus());
                } else {
                    err.log("Don't download " + ((ModuleUpdate)object).getName() + " due to incorrect status " + this.getStatus());
                }
            } else {
                this.downloadModuleFromLocal((ModuleUpdate)object);
            }
            this.updateOverall();
            if (this.partialHandle == null || !((ModuleUpdate)object).isDownloadOK()) continue;
            this.partialHandle.finish();
            ++n;
        }
        if (DOWNLOADER_STOPPED == this.getStatus()) {
            return;
        }
        this.overallHandle.progress(this.downloadSize);
        this.overallHandle.finish();
        object = MessageFormat.format(this.getBundle("FMT_DownloadedTotal"), new Integer(this.downloadSize / 1024), new Integer(this.downloadSize / 1024));
        this.progressDialog.setOverallLabel((String)object);
        this.progressDialog.setEnableStop(false);
        this.runVerifier();
    }

    private void runVerifier() {
        err.log("Prepare SignVerifier.");
        if (DOWNLOADER_VERIFIED == this.getStatus()) {
            err.log("Error: SignVerifier has run before.");
            return;
        }
        SignVerifier signVerifier = new SignVerifier(this.progressDialog, this.validator);
        this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.securityText"));
        signVerifier.doVerify();
        this.setStatus(DOWNLOADER_VERIFIED);
    }

    private int getStatus() {
        return this.downloadStatus;
    }

    private void setStatus(int n) {
        this.downloadStatus = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ioCopy(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, int n) throws IOException {
        block11: {
            try {
                int n2;
                if (DOWNLOADER_IS_INIT == this.getStatus()) {
                    this.setStatus(DOWNLOADER_RUNNING);
                }
                while ((DOWNLOADER_RUNNING == this.getStatus() || DOWNLOADER_WAITING == this.getStatus()) && (n2 = bufferedInputStream.read()) != -1) {
                    if (READ_TIMEOUT_CHECKER.getDelay() == 0) {
                        READ_TIMEOUT_CHECKER.waitFinished();
                    } else if (READ_TIMEOUT_CHECKER.getDelay() < TIME_TO_CONNECTION_CHECK) {
                        READ_TIMEOUT_CHECKER.schedule(TIME_TO_CONNECTION_CHECK * 2);
                    }
                    bufferedOutputStream.write(n2);
                    ++this.moduleDownloaded;
                    ++this.totalDownloaded;
                    if (this.moduleDownloaded % 4096 != 0) continue;
                    this.updateOverall();
                    this.partialHandle.progress(this.moduleDownloaded < n ? this.moduleDownloaded : n);
                }
                if (DOWNLOADER_RUNNING == this.getStatus()) {
                    this.setStatus(DOWNLOADER_FINISHED);
                }
                Object var6_5 = null;
                if (bufferedInputStream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadModule(final ModuleUpdate moduleUpdate) {
        block10: {
            int n = 0;
            File file = Downloader.getNBM(moduleUpdate);
            try {
                this.moduleDownloaded = 0;
                this.partialHandle = this.getPartialHandle(1);
                moduleUpdate.setDownloadStarted(true);
                this.progressDialog.setEnableStop(true);
                err.log("Setup checker of download " + moduleUpdate.getName());
                READ_TIMEOUT_CHECKER = Downloader.getAutoupdateRequestProcessor().post(new Runnable(){

                    public void run() {
                        Downloader.this.confirmConnectionFailed(moduleUpdate);
                    }
                }, TIME_TO_CONNECTION_CHECK * 4);
                err.log("Try to estabilish a conncetion to " + moduleUpdate.getDistribution());
                this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.Establish"));
                URLConnection uRLConnection = moduleUpdate.getDistribution().openConnection();
                moduleUpdate.setRemoteDistributionFilename(uRLConnection);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                n = uRLConnection.getContentLength();
                if (n == -1) {
                    n = (int)moduleUpdate.getDownloadSize();
                }
                if (!$assertionsDisabled && n <= 0) {
                    throw new AssertionError((Object)("Content of distrConnection of update " + moduleUpdate.getName() + " must be known and more then 0, but was " + n));
                }
                this.partialHandle = this.getPartialHandle(n);
                this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.downloadText"));
                boolean bl = false;
                try {
                    this.ioCopy(bufferedInputStream, bufferedOutputStream, n);
                    if (DOWNLOADER_FINISHED == this.getStatus()) {
                        moduleUpdate.setDownloadOK(true);
                        err.log(moduleUpdate.getName() + " was downloaded correctly.");
                    } else {
                        moduleUpdate.setDownloadOK(false);
                        err.log(moduleUpdate.getName() + " wasn't download correctly.");
                        moduleUpdate.setSecurity(0);
                    }
                    moduleUpdate.setDownloadStarted(false);
                    READ_TIMEOUT_CHECKER.cancel();
                    Object var9_9 = null;
                    if (DOWNLOADER_FINISHED == this.getStatus()) break block10;
                    Downloader.getNBM(moduleUpdate).delete();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (DOWNLOADER_FINISHED != this.getStatus()) {
                        Downloader.getNBM(moduleUpdate).delete();
                    }
                    throw throwable;
                }
                {
                }
            }
            catch (IOException iOException) {
                if (DOWNLOADER_STOPPED == this.getStatus()) {
                    return;
                }
                this.validator.setValid(false);
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                this.confirmConnectionFailed(moduleUpdate);
            }
        }
    }

    private void confirmConnectionFailed(ModuleUpdate moduleUpdate) {
        if (DOWNLOADER_RUNNING != this.getStatus() && DOWNLOADER_IS_INIT != this.getStatus()) {
            return;
        }
        err.log("Connection failed during download " + moduleUpdate.getName());
        this.setStatus(DOWNLOADER_WAITING);
        String string = NbBundle.getMessage((Class)Downloader.class, (String)"FMT_DownloadFailed", (Object)moduleUpdate.getName());
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, this.getBundle("CTL_DownloadFailed"), 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (confirmation.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
            err.log("Confirm of the failed connection was canceled, continue downloading.");
            this.setStatus(DOWNLOADER_RUNNING);
            moduleUpdate.setDownloadStarted(true);
            moduleUpdate.setSecurity(0);
            if (READ_TIMEOUT_CHECKER != null) {
                READ_TIMEOUT_CHECKER.cancel();
                READ_TIMEOUT_CHECKER.schedule(TIME_TO_CONNECTION_CHECK * 2);
            }
            this.validator.setValid(false);
            return;
        }
        if (confirmation.getValue().equals(NotifyDescriptor.NO_OPTION)) {
            err.log("Interrupt download of " + moduleUpdate.getName());
            this.validator.setValid(true);
            this.setStatus(DOWNLOADER_CANCELED);
            moduleUpdate.setDownloadOK(false);
            moduleUpdate.setDownloadStarted(false);
            this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.Broken"));
            moduleUpdate.setSecurity(0);
            DOWNLOAD_TASK.cancel();
            READ_TIMEOUT_CHECKER.cancel();
            this.runVerifier();
            return;
        }
        READ_TIMEOUT_CHECKER.cancel();
        DOWNLOAD_TASK.cancel();
        this.setStatus(DOWNLOADER_STOPPED);
        moduleUpdate.setDownloadStarted(false);
        err.log("Failed connection was confirmed, start download " + moduleUpdate.getName() + " again.");
        this.progressDialog.setExtraLabel(this.getBundle("DownloadProgressPanel.jLabel1.Restart"));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                new Downloader(Downloader.this.progressDialog, Downloader.this.validator, Downloader.this.urlDownload).doDownload();
            }
        }, 100);
    }

    private void downloadModuleFromLocal(ModuleUpdate moduleUpdate) {
        this.partialHandle = this.getPartialHandle(1);
        if (Downloader.downloadFromLocal(moduleUpdate)) {
            this.totalDownloaded = (int)((long)this.totalDownloaded + moduleUpdate.getDownloadSize());
        }
        this.updateOverall();
    }

    private void updateOverall() {
        String string = NbBundle.getMessage((Class)Downloader.class, (String)"FMT_DownloadedTotal", (Object[])new Object[]{new Integer(this.totalDownloaded / 1024), new Integer(this.downloadSize / 1024)});
        this.overallHandle.progress(this.downloadSize > this.totalDownloaded ? this.totalDownloaded : this.downloadSize);
        this.progressDialog.setOverallLabel(string);
    }

    private ProgressHandle getPartialHandle(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)("Count of units " + n + " must be positive."));
        }
        if (!$assertionsDisabled && this.progressDialog == null) {
            throw new AssertionError();
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("DownloadProgressPanel_partialHandle_name"));
        progressHandle.setInitialDelay(0);
        this.progressDialog.setPartialProgressComponent(progressHandle);
        progressHandle.start(n);
        return progressHandle;
    }

    private ProgressHandle getOverallHandle(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)("Count of units " + n + " must be positive."));
        }
        if (!$assertionsDisabled && this.progressDialog == null) {
            throw new AssertionError();
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)this.getBundle("DownloadProgressPanel_overallHandle_name"));
        progressHandle.setInitialDelay(0);
        this.progressDialog.setOverallProgressComponent(progressHandle);
        progressHandle.start(n);
        return progressHandle;
    }

    void cancelDownload() {
        this.setStatus(DOWNLOADER_STOPPED);
        this.validator.setValid(false);
    }

    static boolean downloadFromLocal(ModuleUpdate moduleUpdate) {
        if (Downloader.tryCopy(moduleUpdate.getDistributionFile(), Downloader.getNBM(moduleUpdate))) {
            moduleUpdate.setDownloadOK(true);
            return true;
        }
        Downloader.getNBM(moduleUpdate).delete();
        return false;
    }

    static File getNBM(ModuleUpdate moduleUpdate) {
        File file = new File(Autoupdater.Support.getDownloadDirectory(null), moduleUpdate.getDistributionFilename());
        return file;
    }

    static File getMovedNBM(ModuleUpdate moduleUpdate) {
        File file = null;
        file = moduleUpdate.isToInstallDir() ? Autoupdater.Support.getDownloadDirectory(moduleUpdate.findInstallDirectory()) : Autoupdater.Support.getDownloadDirectory(null);
        return new File(file, moduleUpdate.getDistributionFilename());
    }

    static boolean tryMove(ModuleUpdate moduleUpdate) {
        File file = new File(Autoupdater.Support.getDownloadDirectory(moduleUpdate.findInstallDirectory()), moduleUpdate.getDistributionFilename());
        boolean bl = Downloader.getNBM(moduleUpdate).renameTo(file);
        if (bl) {
            return true;
        }
        bl = Downloader.tryCopy(Downloader.getNBM(moduleUpdate), file);
        if (bl) {
            Downloader.getNBM(moduleUpdate).delete();
        }
        return bl;
    }

    static void saveCopy(ModuleUpdate moduleUpdate, File file) {
        Downloader.tryCopy(Downloader.getNBM(moduleUpdate), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryCopy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            block8: {
                try {
                    int n;
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 4096);
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 4096);
                    while ((n = bufferedInputStream.read()) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(n);
                    }
                    Object var6_6 = null;
                    if (bufferedInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    throw throwable;
                }
                bufferedInputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static void deleteModuleNBM(ModuleUpdate moduleUpdate) {
        Downloader.getNBM(moduleUpdate).delete();
    }

    static void deleteDownload() {
        boolean bl = true;
        PreparedModules preparedModules = null;
        List list = UpdateTracking.clusters(true);
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError((Object)"Clusters cannot be empty.");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!Autoupdater.Support.getInstall_Later((File)iterator.next()).exists()) continue;
            bl = false;
            preparedModules = PreparedModules.getPrepared();
        }
        File[] fileArray = Downloader.getNBMFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!bl && preparedModules.hasNBM(fileArray[i].getName())) continue;
            fileArray[i].delete();
        }
    }

    static boolean bannedWriteToInstall(ModuleUpdate moduleUpdate) {
        File file = moduleUpdate.findInstallDirectory();
        return file == null || !file.canWrite();
    }

    private static File[] getNBMFiles() {
        File[] fileArray = Autoupdater.Support.getDownloadDirectory(null).listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(Downloader.NBM_EXTENSION);
            }
        });
        return fileArray;
    }

    private String getBundle(String string) {
        return NbBundle.getMessage((Class)Downloader.class, (String)string);
    }

    static {
        $assertionsDisabled = !Downloader.class.desiredAssertionStatus();
        TIME_TO_CONNECTION_CHECK = 5000;
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate");
        AU_REQUEST_PROCESSOR = null;
        DOWNLOADER_IS_INIT = -1;
        DOWNLOADER_RUNNING = 0;
        DOWNLOADER_WAITING = 1;
        DOWNLOADER_CANCELED = 2;
        DOWNLOADER_STOPPED = 3;
        DOWNLOADER_FINISHED = 4;
        DOWNLOADER_VERIFIED = 5;
    }
}

