/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.NbmDataLoader;
import org.netbeans.modules.autoupdate.NbmDataNode;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

class NbmDataObject
extends MultiDataObject {
    public NbmDataObject(FileObject fileObject, NbmDataLoader nbmDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)nbmDataLoader);
        this.init();
    }

    private void init() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)new OpenCookie(){

            public void open() {
                FileObject fileObject = NbmDataObject.this.getPrimaryFile();
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    file = Autoupdater.Support.getTempCopyFile(fileObject);
                }
                XMLUpdates.startGroupUpdates(file);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new NbmDataNode(this);
    }
}

