/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class Settings
extends SystemOption {
    private static final String PROP_ASK_BEFORE = "askBefore";
    private static final String PROP_NEGATIVE_RESULTS = "negativeResults";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheck";
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_ACCEPTED_NOTIFICATIONS = "acceptedNotifications";
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int EVERY_NEVER = 5;
    public static final String NODE_DEFAULT_ACTION = "nodeDefaultAction";
    static final long serialVersionUID = 362844553936969452L;

    protected void initialize() {
        super.initialize();
        this.setNegativeResults(false);
        this.setPeriod(2);
        this.setLastCheck(null);
        this.setAskBefore(false);
    }

    static Settings getShared() {
        return (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
    }

    public String displayName() {
        return Settings.getBundle("CTL_Settings_Name");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Settings.class);
    }

    public int getPeriod() {
        return (Integer)this.getProperty(PROP_PERIOD);
    }

    public void setPeriod(int n) {
        this.putProperty(PROP_PERIOD, new Integer(n), true);
    }

    protected AutoupdateType defaultAutoupdateType() {
        return AutoupdateType.getDefault();
    }

    public void setIdeIdentity(String string) {
        this.putProperty(PROP_IDE_IDENTITY, string, true);
    }

    public String getIdeIdentity() {
        return (String)this.getProperty(PROP_IDE_IDENTITY);
    }

    public void setAcceptedNotifications(Map map) {
        this.putProperty(PROP_ACCEPTED_NOTIFICATIONS, map, true);
    }

    public Map getAcceptedNotifications() {
        return (Map)this.getProperty(PROP_ACCEPTED_NOTIFICATIONS);
    }

    public boolean isAskBefore() {
        return (Boolean)this.getProperty(PROP_ASK_BEFORE);
    }

    public void setAskBefore(boolean bl) {
        this.putProperty(PROP_ASK_BEFORE, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean isNegativeResults() {
        return (Boolean)this.getProperty(PROP_NEGATIVE_RESULTS);
    }

    public void setNegativeResults(boolean bl) {
        this.putProperty(PROP_NEGATIVE_RESULTS, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public Date getLastCheck() {
        return (Date)this.getProperty(PROP_LAST_CHECK);
    }

    public void setLastCheck(Date date) {
        this.putProperty(PROP_LAST_CHECK, date, true);
    }

    public void fireNodeDefaultAction() {
        this.firePropertyChange(NODE_DEFAULT_ACTION, null, null);
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage((Class)Settings.class, (String)string);
    }

    public static class LastCheckPropertyEditor
    extends PropertyEditorSupport {
        private static final SimpleDateFormat sdf = new SimpleDateFormat();

        public String getAsText() {
            Date date = (Date)this.getValue();
            return date == null ? "" : sdf.format(date);
        }

        public void setAsText(String string) {
            try {
                Date date = sdf.parse(string);
                this.setValue(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static class PeriodPropertyEditor
    extends PropertyEditorSupport {
        private static final String[] tags = new String[]{Settings.access$000("CTL_PeriodEditor_Startup"), Settings.access$000("CTL_PeriodEditor_Day"), Settings.access$000("CTL_PeriodEditor_Week"), Settings.access$000("CTL_PeriodEditor_2Weeks"), Settings.access$000("CTL_PeriodEditor_Month"), Settings.access$000("CTL_PeriodEditor_Never")};
        private static final int[] values = new int[]{0, 1, 2, 3, 4, 5};

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            long l = ((Integer)this.getValue()).intValue();
            for (int i = 0; i < values.length; ++i) {
                if ((long)values[i] != l) continue;
                return tags[i];
            }
            return Settings.getBundle("CTL_PeriodEditor_Unsupported");
        }

        public void setAsText(String string) {
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] != string) continue;
                this.setValue(new Integer(values[i]));
                return;
            }
            this.setValue(new Integer(0));
        }
    }
}

