/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

class SignVerifier {
    private static final String KS_PSSWD = "open4all";
    private static final String ENTRY_SEPARATOR = "/";
    private static final String NBM_MAIN = "main";
    private static final String NBM_MODULES = "netbeans/modules";
    private static final String NBM_AUTOLOAD = "netbeans/modules/autoload";
    private static final String NBM_EAGER = "netbeans/modules/eager";
    private static final String JAR_EXT = ".jar";
    public static final int NOT_CHECKED = -1;
    public static final int BAD_DOWNLOAD = 0;
    public static final int CORRUPTED = 1;
    public static final int NOT_SIGNED = 2;
    public static final int SIGNED = 3;
    public static final int TRUSTED = 4;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    DownloadProgressPanel progressDialog;
    private Wizard.Validator validator;
    private int verifySize;
    private int totalVerified;
    private long modulesCount;
    private boolean verifyCanceled = false;
    private boolean wizardCanceled = false;
    ProgressHandle partialHandle;
    ProgressHandle overallHandle;
    long startTime;
    private static final ErrorManager err;
    static final /* synthetic */ boolean $assertionsDisabled;

    SignVerifier(DownloadProgressPanel downloadProgressPanel, Wizard.Validator validator) {
        this.validator = validator;
        this.progressDialog = downloadProgressPanel;
    }

    void doVerify() {
        this.verifyCanceled = false;
        this.progressDialog.setPartialLabel(SignVerifier.getBundle("CTL_PreparingVerify_Label"));
        this.verifySize = this.getTotalVerifySize();
        err.log("Runing doVerify, check the total size " + this.verifySize + ", verifyCanceled? " + this.verifyCanceled);
        if (this.verifyCanceled) {
            return;
        }
        this.verifyAll();
        err.log("Verification done.");
        if (this.verifyCanceled) {
            return;
        }
        this.validator.setValid(true);
    }

    private int getTotalVerifySize() {
        int n = 0;
        this.modulesCount = 0L;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected() || !moduleUpdate.isDownloadOK() || moduleUpdate.getSecurity() != -1 && moduleUpdate.getSecurity() != 0) continue;
            File file = Downloader.getNBM(moduleUpdate);
            n = (int)((long)n + file.length());
            ++this.modulesCount;
        }
        return n;
    }

    void verifyAll() {
        Object object;
        this.overallHandle = this.getOverallHandle(this.verifySize);
        this.progressDialog.setPartialLabel("");
        this.progressDialog.setOverallLabel("");
        this.progressDialog.setExtraLabel("");
        int n = 0;
        this.totalVerified = 0;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            if (this.verifyCanceled) {
                return;
            }
            object = (ModuleUpdate)iterator.next();
            if (!((ModuleUpdate)object).isSelected() || !((ModuleUpdate)object).isDownloadOK() || ((ModuleUpdate)object).getSecurity() != -1 && ((ModuleUpdate)object).getSecurity() != 0) continue;
            if (this.verifyCanceled) {
                return;
            }
            this.progressDialog.setPartialLabel(((ModuleUpdate)object).getName() + " [" + (n + 1) + ENTRY_SEPARATOR + this.modulesCount + "]");
            File file = Downloader.getNBM((ModuleUpdate)object);
            try {
                Collection collection = this.verifyJar(file, (ModuleUpdate)object);
                if (collection == null) {
                    err.log(((ModuleUpdate)object).getName() + " was verified as NOT_SIGNED");
                    ((ModuleUpdate)object).setSecurity(2);
                    ((ModuleUpdate)object).setInstallApproved(false);
                } else {
                    ((ModuleUpdate)object).setCerts(collection);
                    if (this.isTrusted(collection)) {
                        err.log(((ModuleUpdate)object).getName() + " was verified as TRUSTED");
                        ((ModuleUpdate)object).setSecurity(4);
                        ((ModuleUpdate)object).setInstallApproved(true);
                    } else {
                        err.log(((ModuleUpdate)object).getName() + " was verified as SIGNED");
                        ((ModuleUpdate)object).setSecurity(3);
                        ((ModuleUpdate)object).setInstallApproved(false);
                    }
                }
            }
            catch (SecurityException securityException) {
                err.log(((ModuleUpdate)object).getName() + " was verified as CORRUPTED");
                ((ModuleUpdate)object).setSecurity(1);
                ((ModuleUpdate)object).setInstallApproved(false);
            }
            catch (IOException iOException) {
                err.log(((ModuleUpdate)object).getName() + " was verified as BAD_DOWNLOAD");
                ((ModuleUpdate)object).setSecurity(0);
                ((ModuleUpdate)object).setInstallApproved(false);
                ((ModuleUpdate)object).setDownloadOK(false);
            }
            ++n;
            this.overallHandle.progress(this.totalVerified);
        }
        this.overallHandle.finish();
        object = NbBundle.getMessage((Class)SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.verifySize / 1024), new Integer(this.verifySize / 1024)});
        this.progressDialog.setOverallLabel((String)object);
    }

    static void processJarEntry(JarEntry jarEntry, ModuleUpdate moduleUpdate) {
        if (jarEntry.getName().startsWith("netbeans/lib")) {
            moduleUpdate.setDepending(true);
        }
        if (jarEntry.getName().startsWith(NBM_MAIN)) {
            moduleUpdate.setSafeToInstall(false);
        }
        String string = null;
        if (jarEntry.getName().startsWith(NBM_AUTOLOAD) && jarEntry.getName().endsWith(JAR_EXT)) {
            string = SignVerifier.getJarModuleName(jarEntry.getName(), "netbeans/modules/autoload/");
            if (string != null) {
                moduleUpdate.addToJarList(string);
            }
        } else if (jarEntry.getName().startsWith(NBM_EAGER) && jarEntry.getName().endsWith(JAR_EXT)) {
            string = SignVerifier.getJarModuleName(jarEntry.getName(), "netbeans/modules/eager/");
            if (string != null) {
                moduleUpdate.addToJarList(string);
            }
        } else if (jarEntry.getName().startsWith(NBM_MODULES) && jarEntry.getName().endsWith(JAR_EXT) && (string = SignVerifier.getJarModuleName(jarEntry.getName(), "netbeans/modules/")) != null) {
            moduleUpdate.addToJarList(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection verifyJar(File var1_1, ModuleUpdate var2_2) throws SecurityException, IOException {
        block16: {
            var3_3 = null;
            var4_4 = false;
            var5_5 = false;
            var6_6 = 0;
            var7_7 = (int)var1_1.length();
            this.partialHandle = this.getPartialHandle(var7_7);
            var8_8 = new JarFile(var1_1);
            var9_9 = var8_8.getManifest();
            var10_10 = var8_8.entries();
            var11_11 = new LinkedList<JarEntry>();
            var12_12 = new byte[8192];
            try {
                while (var10_10.hasMoreElements()) {
                    block15: {
                        var13_13 = var10_10.nextElement();
                        SignVerifier.processJarEntry((JarEntry)var13_13, var2_2);
                        var11_11.add((JarEntry)var13_13);
                        var14_14 = var8_8.getInputStream((ZipEntry)var13_13);
                        try {
                            while ((var15_15 = var14_14.read(var12_12, 0, var12_12.length)) != -1) {
                                if (++var6_6 % 4096 == 0) {
                                    this.partialHandle.progress(var6_6 < var7_7 ? var6_6 : var7_7);
                                }
                                if (!this.verifyCanceled) continue;
                                var16_23 = null;
                                var18_17 = null;
                                break block15;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var17_29) {
                            var18_17 = null;
                            var14_14.close();
                            this.totalVerified = (int)((long)this.totalVerified + var13_13.getCompressedSize());
                            var19_20 = NbBundle.getMessage((Class)SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                            this.progressDialog.setOverallLabel(var19_20);
                            throw var17_29;
                        }
                    }
                    var14_14.close();
                    this.totalVerified = (int)((long)this.totalVerified + var13_13.getCompressedSize());
                    var19_20 = NbBundle.getMessage((Class)SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                    this.progressDialog.setOverallLabel(var19_20);
                    var21_25 = null;
                    var8_8.close();
                    if (this.wizardCanceled == false) return var16_23;
                    Downloader.getNBM(var2_2).delete();
                    return var16_23;
lbl-1000:
                    // 1 sources

                    {
                        var18_17 = null;
                        var14_14.close();
                        this.totalVerified = (int)((long)this.totalVerified + var13_13.getCompressedSize());
                        var19_20 = NbBundle.getMessage((Class)(SignVerifier.class$org$netbeans$modules$autoupdate$SignVerifier == null ? SignVerifier.class$("org.netbeans.modules.autoupdate.SignVerifier") : SignVerifier.class$org$netbeans$modules$autoupdate$SignVerifier), (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                        this.progressDialog.setOverallLabel(var19_20);
                    }
                }
                SignVerifier.err.log("Update " + var2_2.getCodeNameBase() + " was verified as forced to intall global: " + var2_2.isForcedGlobal() + " and safeToInstall: " + var2_2.isSafeToInstall());
                if (!this.verifyCanceled) break block16;
                var13_13 = null;
            }
            catch (Throwable var20_31) {
                var21_28 = null;
                var8_8.close();
                if (this.wizardCanceled == false) throw var20_31;
                Downloader.getNBM(var2_2).delete();
                throw var20_31;
            }
            var21_26 = null;
            var8_8.close();
            if (this.wizardCanceled == false) return var13_13;
            Downloader.getNBM(var2_2).delete();
            return var13_13;
        }
        var21_27 = null;
        var8_8.close();
        if (this.wizardCanceled) {
            Downloader.getNBM(var2_2).delete();
        }
        this.partialHandle.finish();
        var13_13 = new HashSet<E>();
        if (var9_9 != null) {
            var14_14 = var11_11.iterator();
            while (var14_14.hasNext()) {
                var15_16 = (JarEntry)var14_14.next();
                var16_24 = var15_16.getName();
                var17_30 = var15_16.getCertificates();
                var18_19 = var17_30 != null && var17_30.length > 0;
                var4_4 |= var18_19;
                if (var17_30 != null) {
                    for (var19_22 = 0; var19_22 < var17_30.length; ++var19_22) {
                        var13_13.add(var17_30[var19_22]);
                        if (!this.verifyCanceled) continue;
                        return null;
                    }
                    continue;
                }
                if (var15_16.isDirectory() || var16_24.toUpperCase().startsWith("META-INF/") || var15_16.getSize() == 0L) continue;
                var5_5 = true;
            }
        }
        if (var4_4 && var5_5) {
            throw new SecurityException(SignVerifier.getBundle("EXC_NotSignedEntity"));
        }
        if (var4_4 == false) return null;
        v0 = var13_13;
        return v0;
    }

    public static String formatCerts(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 300);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (certificate instanceof X509Certificate) {
                try {
                    stringBuffer.append("\n\n");
                    stringBuffer.append(SignVerifier.X509CertToString((X509Certificate)certificate));
                }
                catch (Exception exception) {
                    stringBuffer.append(certificate.toString());
                }
            } else {
                stringBuffer.append(certificate.toString());
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    boolean isTrusted(Collection collection) {
        Collection collection2 = this.getTrustedCerts();
        if (collection2.size() <= 0 || collection.size() <= 0) {
            return false;
        }
        return collection2.containsAll(collection);
    }

    static void addCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getKSFile(), KS_PSSWD, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (keyStore.getCertificateAlias(certificate) != null) continue;
            String string = null;
            for (int i = 0; i < 9999 && keyStore.containsAlias(string = "genAlias" + i); ++i) {
            }
            if (string == null) {
                throw new KeyStoreException(SignVerifier.getBundle("EXC_TooManyCertificates"));
            }
            keyStore.setCertificateEntry(string, certificate);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getKSFile(), KS_PSSWD, null);
    }

    static void removeCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getKSFile(), KS_PSSWD, null);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            String string = keyStore.getCertificateAlias(certificate);
            if (string == null) continue;
            keyStore.deleteEntry(string);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getKSFile(), KS_PSSWD, null);
    }

    Collection getTrustedCerts() {
        ArrayList arrayList = new ArrayList(10);
        File file = Autoupdater.Support.getKSFile();
        try {
            if (file.canRead()) {
                KeyStore keyStore = SignVerifier.getKeyStore(file, KS_PSSWD, null);
                arrayList.addAll(SignVerifier.getCertificates(keyStore));
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (IOException iOException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return arrayList;
    }

    private static KeyStore getKeyStore(File file, String string, String string2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        KeyStore keyStore = null;
        if (string2 == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, string.toCharArray());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return keyStore;
    }

    public static void saveKeyStore(KeyStore keyStore, File file, String string, String string2) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        if (file == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        keyStore.store(fileOutputStream, string.toCharArray());
        ((OutputStream)fileOutputStream).close();
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(10);
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }

    void cancelVerify(boolean bl) {
        this.verifyCanceled = true;
        this.wizardCanceled = bl;
    }

    private static String X509CertToString(X509Certificate x509Certificate) throws Exception {
        return SignVerifier.getBundle("MSG_Owner") + SPACE + x509Certificate.getSubjectDN() + NEW_LINE + SignVerifier.getBundle("MSG_Issuer") + SPACE + x509Certificate.getIssuerDN() + NEW_LINE + SignVerifier.getBundle("MSG_SerNumber") + SPACE + x509Certificate.getSerialNumber().toString(16) + NEW_LINE + SignVerifier.getBundle("MSG_Valid") + SPACE + x509Certificate.getNotBefore().toString() + SPACE + SignVerifier.getBundle("MSG_Until") + SPACE + x509Certificate.getNotAfter().toString() + NEW_LINE + SignVerifier.getBundle("MSG_CertFinger") + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_MD5") + SPACE + SPACE + SignVerifier.getCertFingerPrint("MD5", x509Certificate) + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_SHA1") + SPACE + SignVerifier.getCertFingerPrint("SHA1", x509Certificate);
    }

    private static String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return SignVerifier.toHexString(byArray2);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            SignVerifier.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private static String getJarModuleName(String string, String string2) {
        if (string.substring(string2.length()).indexOf(ENTRY_SEPARATOR) == -1) {
            String string3 = "netbeans/modules/";
            return string.substring(string3.length());
        }
        return null;
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage((Class)SignVerifier.class, (String)string);
    }

    private ProgressHandle getPartialHandle(int n) {
        if (!$assertionsDisabled && this.progressDialog == null) {
            throw new AssertionError();
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)SignVerifier.getBundle("DownloadProgressPanel_partialHandle_name"));
        this.progressDialog.setPartialProgressComponent(progressHandle);
        progressHandle.start(n);
        return progressHandle;
    }

    private ProgressHandle getOverallHandle(int n) {
        if (!$assertionsDisabled && this.progressDialog == null) {
            throw new AssertionError();
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)SignVerifier.getBundle("DownloadProgressPanel_overallHandle_name"));
        this.progressDialog.setOverallProgressComponent(progressHandle);
        progressHandle.start(n);
        return progressHandle;
    }

    static {
        $assertionsDisabled = !SignVerifier.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate");
    }
}

