/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Action;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.DependencyChecker;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleGroup;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

class UpdateNode {
    private static final String NEW_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/newModule";
    private static final String UPDATE_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/updateModule";
    private static final String MODULE_GROUP_ICON_BASE = "org/openide/loaders/defaultFolder";
    private static final String WAIT_ICON_BASE = "org/openide/src/resources/wait";
    private static final String PURCHASED_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/purchasedModule";
    private static final String SERVER_ICON_BASE = "org/netbeans/modules/autoupdate/resources/updateAction";
    private static final String LOCAL_ICON_BASE = "org/openide/resources/localFS";
    private static final String LOCALE_MODULE_ICON_BASE = "org/netbeans/modules/autoupdate/resources/localeModule";

    private UpdateNode() {
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage((Class)UpdateNode.class, (String)string);
    }

    static AllServers getAllServers() {
        return new AllServers();
    }

    static class ASChildren
    extends FolderContent {
        public ASChildren() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = Wizard.getAllUpdates().keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                arrayList.add(k);
            }
            this.setKeys(arrayList);
        }

        protected void addNotify() {
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof AutoupdateType) {
                return new Node[]{new Server((AutoupdateType)((Object)object))};
            }
            return new Node[]{new LocalServer(object)};
        }

        void refreshContent(boolean bl) {
            if (bl) {
                this.refreshSubFolders();
            }
        }
    }

    static class ATChildren
    extends FolderContent {
        private Object autoupdateType;

        public ATChildren(Object object) {
            this.autoupdateType = object;
            this.refreshContent(false);
        }

        protected void addNotify() {
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            if (object instanceof ModuleUpdate) {
                nodeArray = new Node[]{new Module((ModuleUpdate)object)};
            } else if (object instanceof ModuleGroup) {
                nodeArray = new Node[]{new Group((ModuleGroup)object)};
                int n = ((ModuleGroup)object).getItems().size();
                if (n == 0) {
                    nodeArray = new Node[]{};
                }
            } else {
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        void refreshContent(boolean bl) {
            ArrayList arrayList = new ArrayList();
            ModuleGroup moduleGroup = ((Updates)Wizard.getAllUpdates().get(this.autoupdateType)).getRootGroup();
            if (moduleGroup != null) {
                Iterator iterator = moduleGroup.getItems().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof ModuleGroup) && (!(e instanceof ModuleUpdate) || ((ModuleUpdate)e).isSelected() || !DependencyChecker.checkPlatformDependency(((ModuleUpdate)e).getRemoteModule()))) continue;
                    arrayList.add(e);
                }
            }
            this.setKeys(arrayList);
            if (bl) {
                this.refreshSubFolders();
            }
        }
    }

    static class Children
    extends FolderContent {
        protected ModuleGroup moduleGroup;

        public Children(ModuleGroup moduleGroup) {
            this.moduleGroup = moduleGroup;
            this.refreshContent(false);
        }

        protected void addNotify() {
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof ModuleUpdate) {
                return new Node[]{new Module((ModuleUpdate)object)};
            }
            if (object instanceof ModuleGroup) {
                return new Node[]{new Group((ModuleGroup)object)};
            }
            return new Node[0];
        }

        void refreshContent(boolean bl) {
            ArrayList<ModuleUpdate> arrayList = new ArrayList<ModuleUpdate>();
            Iterator iterator = this.moduleGroup.getItems().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof ModuleUpdate) {
                    ModuleUpdate moduleUpdate = (ModuleUpdate)e;
                    if (moduleUpdate.isSelected() || !DependencyChecker.checkPlatformDependency(moduleUpdate.getRemoteModule())) continue;
                    arrayList.add(moduleUpdate);
                    continue;
                }
                arrayList.add((ModuleUpdate)e);
            }
            this.setKeys(arrayList);
            if (bl) {
                this.refreshSubFolders();
            }
        }
    }

    static class AllServers
    extends Folder {
        AllServers() {
            super(new ASChildren());
        }
    }

    static class LocalServer
    extends Folder {
        LocalServer(Object object) {
            super(new ATChildren(object));
            this.setDisplayName(UpdateNode.getBundle("LBL_LocalUpdate"));
            this.setIconBase(UpdateNode.LOCAL_ICON_BASE);
        }
    }

    static class Server
    extends Folder {
        Server(AutoupdateType autoupdateType) {
            super(new ATChildren((Object)autoupdateType));
            this.setDisplayName(autoupdateType.getName());
            this.setIconBase(UpdateNode.SERVER_ICON_BASE);
        }
    }

    static class Group
    extends Folder {
        private ModuleGroup group;

        Group(ModuleGroup moduleGroup) {
            super(new Children(moduleGroup));
            this.group = moduleGroup;
            this.setDisplayName(moduleGroup.getName());
            this.setIconBase(UpdateNode.MODULE_GROUP_ICON_BASE);
            this.getCookieSet().add((Node.Cookie)moduleGroup);
        }
    }

    static class Folder
    extends AbstractNode {
        protected FolderContent folderContent;

        public Folder(FolderContent folderContent) {
            super((org.openide.nodes.Children)folderContent);
            this.folderContent = folderContent;
        }

        final void refreshContent(boolean bl) {
            this.folderContent.refreshContent(bl);
        }
    }

    static abstract class FolderContent
    extends Children.Keys {
        FolderContent() {
        }

        abstract void refreshContent(boolean var1);

        final void refreshSubFolders() {
            Node[] nodeArray = this.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!(nodeArray[i] instanceof Folder)) continue;
                ((Folder)nodeArray[i]).refreshContent(true);
            }
        }
    }

    static class Wait
    extends AbstractNode {
        Wait() {
            super(org.openide.nodes.Children.LEAF);
            this.setDisplayName(UpdateNode.getBundle("CTL_WaitNode"));
            this.setIconBase(UpdateNode.WAIT_ICON_BASE);
        }
    }

    static class Module
    extends AbstractNode {
        private ModuleUpdate moduleUpdate;
        static CallableSystemAction moduleAction = null;

        Module(ModuleUpdate moduleUpdate) {
            super(org.openide.nodes.Children.LEAF);
            this.moduleUpdate = moduleUpdate;
            this.setDisplayName(moduleUpdate.getName());
            if (moduleUpdate.isPurchased()) {
                this.setIconBase(UpdateNode.PURCHASED_MODULE_ICON_BASE);
            } else if (moduleUpdate instanceof L10NUpdate) {
                this.setIconBase(UpdateNode.LOCALE_MODULE_ICON_BASE);
            } else {
                this.setIconBase(moduleUpdate.isNew() ? UpdateNode.NEW_MODULE_ICON_BASE : UpdateNode.UPDATE_MODULE_ICON_BASE);
            }
            this.getCookieSet().add((Node.Cookie)moduleUpdate);
        }

        CallableSystemAction getModuleAction() {
            if (moduleAction == null) {
                moduleAction = new ModuleAction();
            }
            return moduleAction;
        }

        public Action getPreferredAction() {
            return this.getModuleAction();
        }

        class ModuleAction
        extends CallableSystemAction {
            ModuleAction() {
            }

            public void performAction() {
                Settings.getShared().fireNodeDefaultAction();
            }

            public HelpCtx getHelpCtx() {
                return null;
            }

            public String getName() {
                return null;
            }

            protected boolean asynchronous() {
                return false;
            }
        }
    }
}

