/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLAutoupdateType
extends AutoupdateType {
    static final String PROP_URL = "URL";
    private URL url;
    private String defaultURL;
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    private static final String IDE_HASH_CODE = "netbeans.hash.code";
    public static final String UPDATE_VERSION = "1.15";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";
    static final long serialVersionUID = 362844553432169452L;
    private String displayName = null;
    private FileObject typeFileObject = null;
    private String url_key;
    private String localizingBundleName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XMLAutoupdateType() {
        try {
            this.url = new URL(this.getDefaultURL());
        }
        catch (MalformedURLException malformedURLException) {
            this.url = null;
        }
    }

    public XMLAutoupdateType(URL uRL) {
        this.url = uRL;
    }

    public XMLAutoupdateType(URL uRL, String string, String string2, Boolean bl) {
        this(uRL, string, null, string2, bl);
    }

    public XMLAutoupdateType(URL uRL, String string, FileObject fileObject, String string2, Boolean bl) {
        this(uRL, string, fileObject, string2, bl, null);
    }

    public XMLAutoupdateType(URL uRL, String string, FileObject fileObject, String string2, Boolean bl, String string3) {
        this.typeFileObject = fileObject;
        this.url = uRL;
        this.displayName = string;
        this.url_key = string2;
        this.localizingBundleName = string3;
        if (bl != null) {
            this.setEnabled(bl);
        }
    }

    public static XMLAutoupdateType createXMLAutoupdateType(FileObject fileObject) throws IOException {
        URL uRL;
        Object object;
        String string = (String)fileObject.getAttribute("url_key");
        String string2 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        ResourceBundle resourceBundle = XMLAutoupdateType.getBundleFromName(string2);
        if (string != null) {
            try {
                object = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                object = "http://";
            }
            uRL = new URL((String)object);
        } else {
            object = fileObject.getAttribute("url");
            uRL = object instanceof String ? new URL((String)object) : (URL)object;
        }
        object = (Boolean)fileObject.getAttribute("enabled");
        return new XMLAutoupdateType(uRL, null, fileObject, string, (Boolean)object, string2);
    }

    public String displayName() {
        if (this.displayName == null) {
            if (this.typeFileObject != null) {
                try {
                    FileSystem fileSystem = this.typeFileObject.getFileSystem();
                    FileSystem.Status status = fileSystem.getStatus();
                    String string = status.annotateName("", Collections.singleton(this.typeFileObject));
                    if (!string.equals("")) {
                        this.displayName = string;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (this.displayName == null) {
                this.displayName = NbBundle.getBundle((Class)Settings.class).getString("CTL_XMLAutoupdateType_Name");
            }
        }
        return this.displayName;
    }

    public URL getURL() {
        return this.url;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(XMLAutoupdateType.class);
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.url = uRL;
        this.firePropertyChange(PROP_URL, uRL2, uRL);
    }

    public Updates connectForUpdates() {
        return new XMLUpdates(this.modifyURL(this.url));
    }

    protected URL modifyURL(URL uRL) {
        URL uRL2 = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        if (System.getProperty(IDE_HASH_CODE) == null) {
            String string = "";
            try {
                string = Settings.getShared().getIdeIdentity();
            }
            catch (NullPointerException nullPointerException) {
                ErrorManager.getDefault().log(16, "Warning: Property PROP_IDE_IDENTITY hasn't been initialized yet.");
            }
            String string2 = NbBundle.getBundle((Class)XMLAutoupdateType.class).getString("URL_Prefix_Hash_Code");
            System.setProperty(IDE_HASH_CODE, "".equals(string) ? string2 + "0" : string2 + string);
        }
        try {
            uRL2 = new URL(this.encode(this.replace(uRL.toString())));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify((Throwable)malformedURLException);
        }
        return uRL2;
    }

    protected String replace(String string) {
        XMLAutoupdateType.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("{", n2)) != -1 && n2 < string.length() - 1) {
            if (string.charAt(n2 + 1) == '{' || string.charAt(n2 + 1) != '$') {
                ++n2;
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            int n3 = string.indexOf("}", n2);
            if (n3 != -1) {
                String string2 = string.substring(n2 + 2, n3);
                stringBuffer.append(this.getReplacement(string2));
            }
            n = n3 == -1 ? n2 + 2 : n3 + 1;
            ++n2;
        }
        if (n < string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    protected String getReplacement(String string) {
        return System.getProperty(string, "");
    }

    protected String encode(String string) {
        String string2 = string;
        int n = string.indexOf(63);
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 1));
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = string3.indexOf("=");
                if (n2 < 0) {
                    stringBuffer.append(URLEncoder.encode(string3));
                } else {
                    stringBuffer.append(URLEncoder.encode(string3.substring(0, n2)));
                    stringBuffer.append("=");
                    String string4 = string3.substring(n2 + 1);
                    int n3 = string4.indexOf("%");
                    if (n3 < 0) {
                        stringBuffer.append(URLEncoder.encode(string4));
                    } else {
                        stringBuffer.append(URLEncoder.encode(string4.substring(0, n3)));
                        stringBuffer.append("%");
                        stringBuffer.append(URLEncoder.encode(string4.substring(n3 + 1)));
                    }
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append("&");
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static ResourceBundle getOldLocalizingBundle() {
        return NbBundle.getBundle((Class)XMLAutoupdateType.class);
    }

    private static ResourceBundle getBundleFromName(String string) {
        ResourceBundle resourceBundle = null;
        if (string == null) {
            resourceBundle = XMLAutoupdateType.getOldLocalizingBundle();
        } else {
            try {
                resourceBundle = NbBundle.getBundle((String)string);
            }
            catch (MissingResourceException missingResourceException) {
                ErrorManager.getDefault().notify((Throwable)missingResourceException);
            }
        }
        return resourceBundle;
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    protected String getDefaultURL() {
        if (this.defaultURL == null) {
            ResourceBundle resourceBundle = XMLAutoupdateType.getBundleFromName(this.localizingBundleName);
            if (!$assertionsDisabled && resourceBundle == null) {
                throw new AssertionError((Object)("remoteBundle cannot be null for localizingBundleName: " + this.localizingBundleName));
            }
            try {
                this.defaultURL = this.url_key != null ? resourceBundle.getString(this.url_key) : resourceBundle.getString("URL_Default_N");
            }
            catch (MissingResourceException missingResourceException) {
                this.defaultURL = "http://";
            }
        }
        return this.defaultURL;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.url.toString().equals(this.getDefaultURL())) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(this.url);
        }
        objectOutputStream.writeObject(this.displayName);
        objectOutputStream.writeObject(this.url_key);
        objectOutputStream.writeObject(this.localizingBundleName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        URL uRL = null;
        try {
            String string;
            String string2;
            uRL = (URL)objectInputStream.readObject();
            String string3 = (String)objectInputStream.readObject();
            if (string3 != null) {
                this.displayName = string3;
            }
            if ((string2 = (String)objectInputStream.readObject()) != null) {
                this.url_key = string2;
            }
            if ((string = (String)objectInputStream.readObject()) != null) {
                this.localizingBundleName = string;
            }
        }
        catch (OptionalDataException optionalDataException) {
            if (optionalDataException.eof) {
                uRL = null;
                this.setEnabled(true);
            }
            throw optionalDataException;
        }
        if (uRL == null || uRL.toString().startsWith("http://www.netbeans.org/updates/31_")) {
            this.setURL(new URL(this.getDefaultURL()));
        } else {
            this.setURL(uRL);
        }
    }

    static {
        $assertionsDisabled = !XMLAutoupdateType.class.desiredAssertionStatus();
    }
}

