/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleGroup;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.netbeans.updater.XMLUtil;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLUpdates
extends Updates {
    private static final String TAG_MODULE_UPDATES = "module_updates";
    private static final String TAG_MODULE = "module";
    private static final String TAG_MODULE_GROUP = "module_group";
    private static final String TAG_NOTIFICATION = "notification";
    private static final String ATTR_NOTIFICATION_URL = "url";
    private static final String TAG_ERROR = "error";
    private static final String TAG_AUTH_ERROR = "auth_error";
    private static final String TAG_OTHER_ERROR = "other_error";
    private static final String ATTR_MESSAGE_ERROR = "message";
    private static final ErrorManager err;
    private ArrayList modules;
    private HashMap checkOnceMore;
    private ModuleGroup rootGroup;
    private int pError = 0;
    private String errorMess = null;
    private Date timeStamp = null;
    private String notificationText = null;
    private URL notificationURL = null;
    private URL xmlURL;
    private File[] files;
    private static ArrayList groupFiles;
    private static boolean timerSet;
    private static boolean groupStarted;
    private static int oldGroupSize;
    private InputSource xmlInputSource = null;
    private AutoupdateType currentAT = null;
    private static String GZIP_EXTENSION;
    private BufferedReader reader = null;
    private URL urlToGZip = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    XMLUpdates(URL uRL) {
        this.xmlURL = uRL;
    }

    XMLUpdates(File[] fileArray) {
        this.files = fileArray;
    }

    static void startGroupUpdates(File file) {
        if (groupStarted) {
            new XMLUpdates(new File[]{file}).go();
        } else {
            groupFiles.add(file);
            XMLUpdates.setTimer();
        }
    }

    private static void setTimer() {
        if (!timerSet) {
            timerSet = true;
            oldGroupSize = groupFiles.size();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (oldGroupSize < groupFiles.size()) {
                        oldGroupSize = groupFiles.size();
                        RequestProcessor.getDefault().post((Runnable)this, 500);
                    } else {
                        timerSet = false;
                        groupStarted = true;
                        File[] fileArray = new File[groupFiles.size()];
                        Iterator iterator = groupFiles.iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            File file = (File)iterator.next();
                            if (file != null) {
                                fileArray[n] = file;
                            }
                            ++n;
                        }
                        groupFiles.clear();
                        groupStarted = false;
                        new XMLUpdates(fileArray).go();
                    }
                }
            }, 500);
        }
    }

    private void go() {
        HashMap<XMLUpdates, XMLUpdates> hashMap = new HashMap<XMLUpdates, XMLUpdates>();
        hashMap.put(this, this);
        Wizard wizard = Wizard.go(hashMap, 1);
        if (wizard != null) {
            this.checkDownloadedModules();
            wizard.refreshUpdatePanel();
        }
    }

    public void checkUpdates(Wizard.Validator validator) {
        this.checkUpdates(validator, "");
    }

    public void checkUpdates(Wizard.Validator validator, String string) {
        this.checkUpdates(validator, AutoupdateType.find(string));
    }

    public void checkUpdates(Wizard.Validator validator, AutoupdateType autoupdateType) {
        this.checkUpdates(validator, autoupdateType, false);
    }

    public void checkUpdates(final Wizard.Validator validator, final AutoupdateType autoupdateType, boolean bl) {
        this.currentAT = autoupdateType;
        this.pError = 0;
        this.checkCanceled = false;
        final Dialog dialog = ConnectingDialog.getDialog(autoupdateType != null ? autoupdateType.getName() : null);
        Runnable runnable = new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    block9: {
                        try {
                            Document document = XMLUpdates.this.parseDocument();
                            if (XMLUpdates.this.pError == 0 && document != null) {
                                XMLUpdates.this.buildStructures(document);
                                if (!XMLUpdates.this.checkCanceled) {
                                    Settings.getShared().setLastCheck(new Date());
                                }
                            } else if (XMLUpdates.this.pError == 0 && !$assertionsDisabled && document == null && !XMLUpdates.this.checkCanceled) {
                                throw new AssertionError((Object)"Document is not null or connecting is canceled if no error caught.");
                            }
                            validator.setValid(true);
                            int n = 0;
                            if (XMLUpdates.this.getModules() != null) {
                                n = XMLUpdates.this.getModules().size();
                            }
                            if (n != 0 || XMLUpdates.this.pError != 0) break block9;
                            XMLUpdates.this.errorMess = autoupdateType.getName();
                            XMLUpdates.this.pError = 4;
                        }
                        catch (Exception exception) {
                            XMLUpdates.this.pError = 5;
                            ErrorManager.getDefault().notify(1, (Throwable)exception);
                            Object var4_5 = null;
                            if (dialog == null) return;
                            ConnectingDialog.closeDialog(dialog);
                            return;
                        }
                    }
                    Object var4_4 = null;
                    if (dialog == null) return;
                    ConnectingDialog.closeDialog(dialog);
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (dialog == null) throw throwable;
                    ConnectingDialog.closeDialog(dialog);
                    throw throwable;
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$autoupdate$XMLUpdates == null ? (class$org$netbeans$modules$autoupdate$XMLUpdates = XMLUpdates.class$("org.netbeans.modules.autoupdate.XMLUpdates")) : class$org$netbeans$modules$autoupdate$XMLUpdates).desiredAssertionStatus();
            }
        };
        RequestProcessor.Task task = RequestProcessor.getDefault().post(runnable);
        if (!bl) {
            dialog.setVisible(true);
            if (ConnectingDialog.isCanceled()) {
                this.cancelCheck();
            }
        } else {
            task.waitFinished();
        }
    }

    public void cancelCheck() {
        this.checkCanceled = true;
        if (this.xmlInputSource != null) {
            try {
                if (this.xmlInputSource.getByteStream() != null) {
                    this.xmlInputSource.getByteStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ModuleGroup getRootGroup() {
        return this.rootGroup;
    }

    public Collection getModules() {
        return this.modules;
    }

    public boolean isError() {
        return this.pError > 0;
    }

    public int getError() {
        return this.pError;
    }

    public String getErrorMessage() {
        return this.errorMess;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getNotificationText() {
        return this.notificationText;
    }

    public URL getNotificationURL() {
        return this.notificationURL;
    }

    void checkDownloadedModules() {
        this.modules = new ArrayList();
        this.rootGroup = new ModuleGroup();
        this.checkOnceMore = new HashMap();
        for (int i = 0; i < this.files.length; ++i) {
            ModuleUpdate moduleUpdate = ModuleUpdate.getModuleUpdate(this.files[i]);
            if (moduleUpdate == null) continue;
            if (moduleUpdate.isUpdateAvailable()) {
                this.modules.add(moduleUpdate);
                this.rootGroup.addItem(moduleUpdate);
                continue;
            }
            if (!(moduleUpdate instanceof L10NUpdate)) continue;
            this.checkOnceMore.put(moduleUpdate, this.rootGroup);
        }
        this.checkAvailablesOnceMore();
    }

    void checkAvailablesOnceMore() {
        Iterator iterator = this.checkOnceMore.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            L10NUpdate l10NUpdate = (L10NUpdate)entry.getKey();
            if (!l10NUpdate.isRemoteModuleAvailable(this.modules)) continue;
            this.modules.add(l10NUpdate);
            ((ModuleGroup)entry.getValue()).addItem(l10NUpdate);
        }
    }

    private Document parseDocument() {
        Document document;
        block5: {
            document = null;
            if (this.checkCanceled) {
                return null;
            }
            String string = System.getProperty("autoupdate.show.url");
            if (string != null && Boolean.valueOf(string).booleanValue()) {
                System.out.println("URL : " + this.xmlURL);
            }
            try {
                document = this.parseDocumentImpl();
            }
            catch (SAXException sAXException) {
                this.pError = 6;
                this.showParseError(sAXException);
            }
            catch (IOException iOException) {
                this.pError = 5;
                if (this.checkCanceled) break block5;
                this.showParseError(iOException);
            }
        }
        return document;
    }

    private Document parseDocumentImpl() throws SAXException, IOException {
        Document document = null;
        HttpURLConnection.setFollowRedirects(true);
        err.log("Processing URL : " + this.xmlURL);
        try {
            String string = this.xmlURL.getPath() + GZIP_EXTENSION;
            String string2 = this.xmlURL.getQuery();
            if (string2 != null && string2.trim().length() > 0) {
                string = string + '?' + string2;
            }
            this.urlToGZip = new URL(this.xmlURL.getProtocol(), this.xmlURL.getHost(), this.xmlURL.getPort(), string);
            this.reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(this.urlToGZip.openStream())));
            this.xmlInputSource = new InputSource(this.reader);
            err.log("Successfully read URL " + this.urlToGZip);
        }
        catch (IOException iOException) {
            err.log("Reading GZIP URL " + this.urlToGZip + " failed (" + iOException + "). Try read XML directly " + this.xmlURL);
            this.xmlInputSource = new InputSource(this.xmlURL.toExternalForm());
            err.log("Successfully read URL " + this.xmlURL);
        }
        if (this.checkCanceled) {
            err.log("Connection canceled on user's demand.");
            return null;
        }
        document = XMLUtil.parse(this.xmlInputSource, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
        if (!$assertionsDisabled && document == null) {
            throw new AssertionError((Object)("Parser in XMLUtil return not null document for input " + this.xmlInputSource));
        }
        return document;
    }

    private void showParseError(Throwable throwable) {
        ErrorManager.getDefault().annotate(throwable, 0, "URL: " + this.xmlURL, null, null, null);
        ErrorManager.getDefault().notify(1, throwable);
    }

    private void buildStructures(Document document) {
        if (this.checkCanceled) {
            return;
        }
        if (document.getDocumentElement() != null) {
            this.modules = new ArrayList();
            this.rootGroup = new ModuleGroup();
            this.checkOnceMore = new HashMap();
            if (this.detectErrorType(document)) {
                return;
            }
            NodeList nodeList = document.getElementsByTagName(TAG_MODULE);
            this.processElement(document, document.getDocumentElement(), this.rootGroup);
            Node node = document.getDocumentElement().getAttributes().getNamedItem("timestamp");
            if (node != null) {
                String string = node.getNodeValue() + "/GMT";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy/zzz");
                ParsePosition parsePosition = new ParsePosition(0);
                this.timeStamp = simpleDateFormat.parse(string, parsePosition);
            }
            this.checkAvailablesOnceMore();
        }
    }

    private boolean detectErrorType(Document document) {
        NodeList nodeList = document.getElementsByTagName(TAG_ERROR);
        if (nodeList.getLength() > 0) {
            NodeList nodeList2 = document.getElementsByTagName(TAG_AUTH_ERROR);
            if (nodeList2.getLength() > 0) {
                this.pError = 2;
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexcepted auth_error in document " + document));
                }
            } else {
                this.pError = 6;
                NodeList nodeList3 = document.getElementsByTagName(TAG_OTHER_ERROR);
                if (nodeList3.getLength() > 0) {
                    this.errorMess = nodeList3.item(0).getAttributes().getNamedItem(ATTR_MESSAGE_ERROR).getNodeValue();
                }
            }
        }
        return this.pError > 0;
    }

    private void processElement(Document document, Element element, ModuleGroup moduleGroup) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            if (this.checkCanceled) {
                return;
            }
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (((Element)node).getTagName().equals(TAG_MODULE)) {
                object = ModuleUpdate.getModuleUpdate(this.xmlURL, node, document.getDocumentElement(), this.currentAT);
                if (object == null) continue;
                if (((ModuleUpdate)object).isUpdateAvailable()) {
                    this.modules.add(object);
                    moduleGroup.addItem((ModuleUpdate)object);
                    continue;
                }
                if (!(object instanceof L10NUpdate)) continue;
                this.checkOnceMore.put(object, moduleGroup);
                continue;
            }
            if (((Element)node).getTagName().equals(TAG_MODULE_GROUP)) {
                object = new ModuleGroup(node);
                moduleGroup.addItem((ModuleGroup)object);
                this.processElement(document, (Element)node, (ModuleGroup)object);
                continue;
            }
            if (!((Element)node).getTagName().equals(TAG_NOTIFICATION)) continue;
            this.readNotification(node);
        }
    }

    private void readNotification(Node node) {
        Object object;
        Object object2;
        if (this.getNotificationText() != null) {
            return;
        }
        try {
            object2 = node.getAttributes().getNamedItem(ATTR_NOTIFICATION_URL);
            Object object3 = object = object2 == null ? null : object2.getNodeValue();
            if (object != null) {
                this.notificationURL = new URL((String)object);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        object2 = new StringBuffer();
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            if (object.item(i).getNodeType() != 3) continue;
            ((StringBuffer)object2).append(object.item(i).getNodeValue());
        }
        this.notificationText = ((StringBuffer)object2).length() > 0 ? ((StringBuffer)object2).toString() : null;
    }

    static {
        $assertionsDisabled = !XMLUpdates.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate");
        groupFiles = new ArrayList();
        timerSet = false;
        groupStarted = false;
        oldGroupSize = 0;
        GZIP_EXTENSION = ".gz";
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            XMLUpdates.this.showParseError(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }
    }
}

