/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.RequestProcessor;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleDeleterImpl
implements ModuleDeleter {
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final String UPDATE_TRACKING = "update_tracking";
    private static final String INST_ORIGIN = "updater";
    private static final boolean ONLY_FROM_AUTOUPDATE = false;
    private static final int TIME_TO_CHECK = 2000;
    private static final int MAX_CHECKS_OF_STATE = 50;
    private static final int HOLD_ON_PROPAGATE_DISABLE = 1000;
    private ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate.ModuleDeleterImpl");
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean canDelete(Module module) {
        if (module.isFixed()) {
            this.err.log("Cannot delete module because module " + module.getCodeName() + " isFixed.");
        }
        return !module.isFixed() && this.findUpdateTracking(module, false);
    }

    public void delete(final Module module) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException("Module argument cannot be null.");
        }
        this.err.log("Find and delete " + module.getCodeNameBase() + " module config file.");
        this.removeControlModuleFile(module);
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                try {
                    ModuleDeleterImpl.this.removeModuleFiles(module);
                }
                catch (IOException iOException) {
                    ModuleDeleterImpl.this.err.annotate((Throwable)iOException, "ERROR: During processing removeModuleFiles (" + module.getDisplayName() + ")");
                    ModuleDeleterImpl.this.err.notify((Throwable)iOException);
                }
            }
        });
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new HackModuleListRefresher());
        }
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new ModuleStateChecker(module, task), 2000);
        } else {
            task.run();
        }
    }

    private File locateControlFile(Module module) {
        String string = "config/Modules/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, module.getCodeNameBase(), false);
    }

    private void removeControlModuleFile(Module module) throws IOException {
        File file = null;
        while ((file = this.locateControlFile(module)) != null) {
            if (file != null && file.exists()) {
                this.err.log("Try detele the config File " + file);
                FileUtil.toFileObject((File)file).delete();
                continue;
            }
            this.err.log("Warning: Config File " + file + " doesn't exist!");
        }
    }

    private File locateUpdateTracking(Module module) {
        String string = "update_tracking/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, module.getCodeNameBase(), false);
    }

    private boolean findUpdateTracking(Module module, boolean bl) {
        File file = this.locateUpdateTracking(module);
        if (file != null && file.exists()) {
            if (!file.getParentFile().canWrite()) {
                this.err.log("Cannot delete module " + module.getCodeName() + " because no write permission to directory " + file.getParent());
                return false;
            }
            if (bl) {
                boolean bl2 = this.fromAutoupdate(this.getModuleConfiguration(file));
                this.err.log("Is Module " + module.getCodeName() + " installed by AutoUpdate? " + bl2);
                return bl2;
            }
            return true;
        }
        this.err.log("Cannot delete module " + module.getCodeName() + " because no update_tracking file found.");
        return false;
    }

    private boolean fromAutoupdate(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_ORIGIN);
        if (!$assertionsDisabled && node2 == null) {
            throw new AssertionError((Object)"ELEMENT_VERSION must contain ATTR_ORIGIN attribute.");
        }
        String string = node2.getNodeValue();
        return INST_ORIGIN.equals(string);
    }

    private void removeModuleFiles(Module module) throws IOException {
        File file = null;
        while ((file = this.locateUpdateTracking(module)) != null) {
            this.removeModuleFilesInCluster(module, file);
        }
    }

    private void removeModuleFilesInCluster(Module module, File file) throws IOException {
        Object object;
        this.err.log("Read update_tracking " + file + " file.");
        Set set = this.readModuleFiles(this.getModuleConfiguration(file));
        String string = "config/Modules/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        if (set.contains(string)) {
            object = InstalledFileLocator.getDefault().locate(string, module.getCodeNameBase(), false);
            if (!$assertionsDisabled && object != null && ((File)object).exists()) {
                throw new AssertionError((Object)("Config file " + string + " must be already removed."));
            }
        }
        object = set.iterator();
        while (object.hasNext()) {
            File file2;
            String string2 = (String)object.next();
            if (string2.equals(string) || (file2 = InstalledFileLocator.getDefault().locate(string2, module.getCodeNameBase(), false)).equals(file)) continue;
            if (!$assertionsDisabled && !file2.exists()) {
                throw new AssertionError((Object)("File " + file2 + " exists."));
            }
            if (!file2.exists()) continue;
            this.err.log("File " + file2 + " is deleted.");
            try {
                FileUtil.toFileObject((File)file2).delete();
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Waring: IOException " + iOException.getMessage() + " was caught. Propably file lock on the file."));
                }
                this.err.log("Waring: IOException " + iOException.getMessage() + " was caught. Propably file lock on the file.");
                this.err.log("Try call File.deleteOnExit() on " + file2);
                file2.deleteOnExit();
            }
        }
        FileUtil.toFileObject((File)file).delete();
        this.err.log("File " + file + " is deleted.");
    }

    private Node getModuleConfiguration(File file) {
        Document document = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        if (!$assertionsDisabled && document.getDocumentElement() == null) {
            throw new AssertionError((Object)("File " + file + " must contain <module> element."));
        }
        return this.getModuleElement(document.getDocumentElement());
    }

    private Node getModuleElement(Element element) {
        Node node = null;
        if (!$assertionsDisabled && !ELEMENT_MODULE.equals(element.getTagName())) {
            throw new AssertionError((Object)("The root element is: module but was: " + element.getTagName()));
        }
        NodeList nodeList = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < nodeList.getLength() && (node = this.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_LAST);
        if (!$assertionsDisabled && node2 == null) {
            throw new AssertionError((Object)"ELEMENT_VERSION must contain ATTR_LAST attribute.");
        }
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private Set readModuleFiles(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).hasAttributes()) continue;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            hashSet.add(namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            this.err.log("File to delete: " + namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return hashSet;
    }

    static {
        $assertionsDisabled = !ModuleDeleterImpl.class.desiredAssertionStatus();
    }

    private class HackModuleListRefresher
    implements Runnable {
        private HackModuleListRefresher() {
        }

        public void run() {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
            ModuleDeleterImpl.this.err.log("It's a hack: Call refresh on " + fileObject + " file object.");
            if (fileObject != null) {
                fileObject.refresh();
            }
        }
    }

    private class ModuleStateChecker
    implements Runnable {
        RequestProcessor.Task cleaner;
        Module m;
        int checks;

        public ModuleStateChecker(Module module, RequestProcessor.Task task) {
            this.cleaner = task;
            this.m = module;
            this.checks = 0;
        }

        public void run() {
            ++this.checks;
            if (this.m.isEnabled() && this.m.isValid()) {
                if (this.checks < 50) {
                    ModuleDeleterImpl.this.err.log("Module " + this.m.getCodeNameBase() + " is still valid, repost later.");
                    RequestProcessor.getDefault().post((Runnable)this, 2000);
                } else {
                    ModuleDeleterImpl.this.err.log("Warning: Module " + this.m.getCodeNameBase() + " is still valid but time-out. Task is terminated.");
                }
                return;
            }
            this.cleaner.schedule(1000);
        }
    }
}

