/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.autoupdate.AutoModuleNewType;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.ErrorManager;
import org.openide.actions.NewAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public class ModuleNode
extends AbstractNode {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)ModuleNode.class);
    private static final String MODULE_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/moduleItem.gif";
    private static final String MODULE_ITEM_DISABLED_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemDisabled.gif";
    private static final String MODULE_ITEM_ERROR_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemError.gif";
    private static final String MODULE_TEST_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/testModuleItem.gif";
    private static final String MODULES_ICON_BASE = "org/netbeans/modules/autoupdate/resources/modules.gif";
    private static File lastChosenDir = null;
    private static ModuleDeleter deleter;
    private boolean simple = false;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode;

    public ModuleNode() {
        this(false);
    }

    public ModuleNode(boolean bl) {
        super((Children)new Modules(bl));
        this.setName("Modules");
        this.setDisplayName(bundle.getString("CTL_Modules_name"));
        this.setShortDescription(bundle.getString("CTL_Modules_hint"));
        this.setIconBaseWithExtension(MODULES_ICON_BASE);
        this.simple = bl;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ModuleNode.class);
    }

    public Node cloneNode() {
        return new ModuleNode();
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ModuleNodeActions.SortAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
    }

    protected Sheet createSheet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("sorting");
        set.setDisplayName(bundle.getString("LBL_ModuleNode_sheet_sorting"));
        set.put(((Modules)this.getChildren()).createSortingProperty());
        Sheet sheet = new Sheet();
        sheet.put(set);
        return sheet;
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewType(){

            public String getName() {
                return bundle.getString("CTL_NewModuleByFile");
            }

            public void create() throws IOException {
                ModuleNode.this.addFile(false);
            }
        }, new NewType(){

            public String getName() {
                return bundle.getString("CTL_NewTestModule");
            }

            public void create() throws IOException {
                ModuleNode.this.addFile(true);
            }
        }, new AutoModuleNewType()};
    }

    void addFile(boolean bl) {
        Object object;
        Serializable serializable;
        Object object2;
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        InputMap inputMap = jFileChooser.getInputMap(1);
        if (inputMap != null && (object2 = inputMap.get((KeyStroke)(serializable = KeyStroke.getKeyStroke(10, 0)))) == null) {
            inputMap.put((KeyStroke)serializable, "approveSelection");
        }
        if ((serializable = jFileChooser.getActionMap()) != null && (object2 = ((ActionMap)serializable).getParent()) != null) {
            object = ((ActionMap)object2).get("approveSelection");
            ((ActionMap)object2).put("approveSelection", new AbstractAction((Action)object){
                private final /* synthetic */ Action val$original;
                {
                    this.val$original = action;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        jFileChooser.setCurrentDirectory(file);
                    } else if (this.val$original != null) {
                        this.val$original.actionPerformed(actionEvent);
                    }
                }
            });
        }
        if (lastChosenDir != null) {
            jFileChooser.setCurrentDirectory(lastChosenDir);
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setApproveButtonText(bundle.getString("CTL_ModuleSelect"));
        jFileChooser.setApproveButtonToolTipText(bundle.getString("CTL_ModuleSelectToolTip"));
        jFileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return bundle.getString("CTL_ModuleSelectFilter");
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar");
            }
        });
        int n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        lastChosenDir = jFileChooser.getCurrentDirectory();
        if (n == 0) {
            object = jFileChooser.getSelectedFile();
            ModuleNode.getAllModules().create((File)object, bl);
        }
    }

    private static ModuleBean.AllModulesBean getAllModules() {
        return ModuleBean.AllModulesBean.getDefault();
    }

    private static ModuleDeleter getModuleDeleter() {
        if (deleter == null) {
            deleter = new ModuleDeleterImpl();
        }
        return deleter;
    }

    private static final class CategoryNode
    extends AbstractNode {
        private final boolean libraries;
        private final boolean bridges;

        public CategoryNode(boolean bl) {
            this(bl, false);
        }

        private CategoryNode(boolean bl, boolean bl2) {
            super((Children)new CategoryChildren(bl, bl2));
            this.setName(bl ? "bridges" : "libraries");
            this.setDisplayName(bundle.getString(bl ? "LBL_ModuleNode_bridges" : "LBL_ModuleNode_libraries"));
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
            this.libraries = !bl;
            this.bridges = bl;
        }

        public CategoryNode(String string) {
            this(string, false);
        }

        private CategoryNode(String string, boolean bl) {
            super((Children)new CategoryChildren(string, bl));
            this.setName(string);
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
            this.libraries = false;
            this.bridges = false;
        }

        public boolean canDestroy() {
            return ModuleNodeUtils.canUninstall(new Node[]{this});
        }

        public void destroy() {
            ModuleNodeUtils.doUninstall(new Node[]{this});
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNode$CategoryNode")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNode$CategoryNode);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableDisableAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction)), SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableAllAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$UninstallAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$SortAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            if (this.libraries || this.bridges) {
                return sheet;
            }
            Sheet.Set set = sheet.get("properties");
            class EnabledProp
            extends PropertySupport.ReadWrite
            implements PropertyChangeListener {
                private Set modules;
                private final String category;
                private PropertyEditor editor;
                private final /* synthetic */ CategoryNode this$0;

                public EnabledProp(CategoryNode categoryNode, String string) {
                    this.this$0 = categoryNode;
                    super("enabled", Boolean.TYPE, ModuleNode.access$000().getString("PROP_modules_enabled"), ModuleNode.access$000().getString("HINT_modules_enabled"));
                    this.modules = new HashSet<E>();
                    this.editor = null;
                    this.category = string;
                    this.calculateModules();
                    ModuleNode.access$700().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ModuleNode.access$700()));
                }

                public Object getValue() {
                    Boolean bl = null;
                    Iterator<E> iterator = this.modules.iterator();
                    while (iterator.hasNext()) {
                        ModuleBean moduleBean = (ModuleBean)iterator.next();
                        if (moduleBean.isEnabled()) {
                            if (bl == null) {
                                bl = Boolean.TRUE;
                                continue;
                            }
                            if (bl.booleanValue()) continue;
                            return null;
                        }
                        if (bl == null) {
                            bl = Boolean.FALSE;
                            continue;
                        }
                        if (!bl.booleanValue()) continue;
                        return null;
                    }
                    return bl;
                }

                public void setValue(Object object) {
                    boolean bl = (Boolean)object;
                    Iterator<E> iterator = this.modules.iterator();
                    ModuleNode.access$700().pause();
                    while (iterator.hasNext()) {
                        ModuleBean moduleBean = (ModuleBean)iterator.next();
                        moduleBean.setEnabled(bl);
                    }
                    ModuleNode.access$700().resume();
                }

                public boolean canWrite() {
                    Iterator<E> iterator = this.modules.iterator();
                    while (iterator.hasNext()) {
                        ModuleBean moduleBean = (ModuleBean)iterator.next();
                        if (moduleBean.isAutoload() || moduleBean.getJar() == null || moduleBean.isEager()) {
                            throw new IllegalStateException();
                        }
                        if (!moduleBean.isProblematic()) continue;
                        return false;
                    }
                    return true;
                }

                private void calculateModules() {
                    HashSet<ModuleBean> hashSet = new HashSet<ModuleBean>();
                    ModuleBean[] moduleBeanArray = ModuleNode.access$700().getModules();
                    for (int i = 0; i < moduleBeanArray.length; ++i) {
                        if (moduleBeanArray[i].getJar() == null || moduleBeanArray[i].isAutoload() || moduleBeanArray[i].isEager() || !this.category.equals(moduleBeanArray[i].getCategory())) continue;
                        hashSet.add(moduleBeanArray[i]);
                        if (this.modules.contains(moduleBeanArray[i])) continue;
                        moduleBeanArray[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleBeanArray[i]));
                    }
                    this.modules = hashSet;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CategoryNode.access$1100(this.this$0, "enabled", null, null);
                    this.calculateModules();
                }

                public PropertyEditor getPropertyEditor() {
                    if (this.editor == null) {
                        this.editor = super.getPropertyEditor();
                    }
                    return this.editor;
                }
            }
            set.put((Node.Property)new EnabledProp(this, this.getName()));
            return sheet;
        }

        static /* synthetic */ void access$1100(CategoryNode categoryNode, String string, Object object, Object object2) {
            categoryNode.firePropertyChange(string, object, object2);
        }

        private static final class CategoryChildren
        extends Children.Keys
        implements PropertyChangeListener {
            private final String category;
            private final boolean bridgeNotLib;
            private boolean simple = false;

            public CategoryChildren(boolean bl) {
                this(bl, false);
            }

            public CategoryChildren(String string) {
                this(string, false);
            }

            public CategoryChildren(String string, boolean bl) {
                this.simple = bl;
                this.category = string;
                this.bridgeNotLib = false;
            }

            public CategoryChildren(boolean bl, boolean bl2) {
                this.simple = bl2;
                this.category = null;
                this.bridgeNotLib = bl;
            }

            protected void addNotify() {
                this.refreshKeys();
                ModuleNode.getAllModules().addPropertyChangeListener(this);
            }

            protected void removeNotify() {
                ModuleNode.getAllModules().removePropertyChangeListener(this);
                this.setKeys(Collections.EMPTY_SET);
            }

            public Node findChild(String string) {
                ModuleNode.getAllModules().waitForModules().waitFinished();
                this.refreshKeys();
                return super.findChild(string);
            }

            private void refreshKeys() {
                ArrayList<ModuleBean> arrayList = new ArrayList<ModuleBean>();
                ModuleBean[] moduleBeanArray = ModuleNode.getAllModules().getModules();
                for (int i = 0; i < moduleBeanArray.length; ++i) {
                    boolean bl = moduleBeanArray[i].getJar() == null || moduleBeanArray[i].isAutoload();
                    boolean bl2 = moduleBeanArray[i].isEager();
                    if (this.category != null && !bl && !bl2 && this.category.equals(moduleBeanArray[i].getCategory())) {
                        arrayList.add(moduleBeanArray[i]);
                        continue;
                    }
                    if (this.category == null && !this.bridgeNotLib && bl) {
                        arrayList.add(moduleBeanArray[i]);
                        continue;
                    }
                    if (this.category != null || !this.bridgeNotLib || !bl2) continue;
                    arrayList.add(moduleBeanArray[i]);
                }
                Collator collator = Collator.getInstance();
                Collections.sort(arrayList, new Comparator(this, collator){
                    private final /* synthetic */ Comparator val$collator;
                    private final /* synthetic */ CategoryChildren this$0;
                    {
                        this.this$0 = categoryChildren;
                        this.val$collator = comparator;
                    }

                    public int compare(Object object, Object object2) {
                        ModuleBean moduleBean = (ModuleBean)object;
                        ModuleBean moduleBean2 = (ModuleBean)object2;
                        return this.val$collator.compare(moduleBean.getDisplayName(), moduleBean2.getDisplayName());
                    }
                });
                this.setKeys(arrayList);
            }

            protected Node[] createNodes(Object object) {
                return new Node[]{new Item((ModuleBean)object, this.simple)};
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refreshKeys();
            }
        }
    }

    private static class Modules
    extends Children.Keys
    implements PropertyChangeListener {
        private static final Object LIBRARY_KEY = new Object();
        private static final Object BRIDGE_KEY = new Object();
        private IDESettings settings;
        private boolean simple = false;

        public Modules() {
        }

        public Modules(boolean bl) {
            this.simple = bl;
        }

        private void refreshKeys() {
            if (this.settings == null) {
                this.addNotify();
            }
            Object[] objectArray = ModuleNode.getAllModules().getModules();
            if (this.settings.getModulesSortMode() == 5) {
                Collator collator = Collator.getInstance();
                class CategoryComparator
                implements Comparator {
                    private final /* synthetic */ Comparator val$collator;
                    private final /* synthetic */ Modules this$0;

                    CategoryComparator(Modules modules, Comparator comparator) {
                        this.this$0 = modules;
                        this.val$collator = comparator;
                    }

                    public int compare(Object object, Object object2) {
                        if (object == Modules.access$800()) {
                            if (object2 == Modules.access$800()) {
                                return 0;
                            }
                            return 1;
                        }
                        if (object2 == Modules.access$800()) {
                            return -1;
                        }
                        if (object == Modules.access$900()) {
                            if (object2 == Modules.access$900()) {
                                return 0;
                            }
                            return 1;
                        }
                        if (object2 == Modules.access$900()) {
                            return -1;
                        }
                        String string = object instanceof ModuleBean ? ((ModuleBean)object).getDisplayName() : (String)object;
                        String string2 = object2 instanceof ModuleBean ? ((ModuleBean)object2).getDisplayName() : (String)object2;
                        return this.val$collator.compare(string, string2);
                    }
                }
                TreeSet<Object> treeSet = new TreeSet<Object>(new CategoryComparator(this, collator));
                for (int i = 0; i < objectArray.length; ++i) {
                    if (((ModuleBean)objectArray[i]).getJar() == null || ((ModuleBean)objectArray[i]).isAutoload()) {
                        treeSet.add(LIBRARY_KEY);
                        continue;
                    }
                    if (((ModuleBean)objectArray[i]).isEager()) {
                        treeSet.add(BRIDGE_KEY);
                        continue;
                    }
                    String string = ((ModuleBean)objectArray[i]).getCategory();
                    if (string != null) {
                        treeSet.add(string);
                        continue;
                    }
                    treeSet.add(objectArray[i]);
                }
                this.setKeys(treeSet);
            } else if (this.settings.getModulesSortMode() != 0) {
                if (this.settings.getModulesSortMode() == 3) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((ModuleBean)objectArray[i]).addPropertyChangeListener(this);
                    }
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
                Collections.sort(arrayList, new Comparator(this){
                    private final /* synthetic */ Modules this$0;
                    {
                        this.this$0 = modules;
                    }

                    public int compare(Object object, Object object2) {
                        ModuleBean moduleBean = (ModuleBean)object;
                        ModuleBean moduleBean2 = (ModuleBean)object2;
                        switch (Modules.access$1000(this.this$0).getModulesSortMode()) {
                            case 2: {
                                return moduleBean.getCodeName().compareTo(moduleBean2.getCodeName());
                            }
                            case 3: {
                                int n = (moduleBean.isReloadable() ? 0 : 4) + (moduleBean.isAutoload() || moduleBean.isEager() || moduleBean.getJar() == null ? 2 : 0) + (moduleBean.isEnabled() ? 0 : 1);
                                int n2 = (moduleBean2.isReloadable() ? 0 : 4) + (moduleBean2.isAutoload() || moduleBean2.isEager() || moduleBean2.getJar() == null ? 2 : 0) + (moduleBean2.isEnabled() ? 0 : 1);
                                if (n != n2) {
                                    return n - n2;
                                }
                            }
                            case 1: {
                                return Collator.getInstance().compare(moduleBean.getDisplayName(), moduleBean2.getDisplayName());
                            }
                            case 4: {
                                File file = moduleBean.getJar();
                                File file2 = moduleBean2.getJar();
                                if (file != null) {
                                    if (file2 != null) {
                                        return file.compareTo(file2);
                                    }
                                    return 1;
                                }
                                if (file2 != null) {
                                    return -1;
                                }
                                return 0;
                            }
                        }
                        return 0;
                    }
                });
                this.setKeys(arrayList);
            } else {
                this.setKeys(objectArray);
            }
        }

        Node.Property createSortingProperty() {
            this.settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = ModuleNode.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            return new PropertySupport.ReadWrite(this, "sorted", Integer.TYPE, bundle.getString("PROP_ModuleNode_sorted"), bundle.getString("HINT_ModuleNode_sorted")){
                private final /* synthetic */ Modules this$0;
                {
                    this.this$0 = modules;
                    super(string, clazz, string2, string3);
                }

                public Object getValue() {
                    return new Integer(Modules.access$1000(this.this$0).getModulesSortMode());
                }

                public void setValue(Object object) {
                    Modules.access$1000(this.this$0).setModulesSortMode(((Integer)object).intValue());
                }

                public boolean supportsDefaultValue() {
                    return true;
                }

                public void restoreDefaultValue() {
                    this.setValue(new Integer(5));
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortingModeEditor();
                }
            };
        }

        public void addNotify() {
            this.settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = ModuleNode.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            ModuleNode.getAllModules().addPropertyChangeListener(this);
            this.settings.addPropertyChangeListener((PropertyChangeListener)this);
            this.refreshKeys();
        }

        public void removeNotify() {
            this.settings.removePropertyChangeListener((PropertyChangeListener)this);
            ModuleNode.getAllModules().removePropertyChangeListener(this);
            ModuleBean[] moduleBeanArray = ModuleNode.getAllModules().getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                moduleBeanArray[i].removePropertyChangeListener(this);
            }
        }

        public Node findChild(String string) {
            ModuleNode.getAllModules().waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(string);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refreshKeys();
        }

        protected Node[] createNodes(Object object) {
            if (object == LIBRARY_KEY) {
                return new Node[]{new CategoryNode(false)};
            }
            if (object == BRIDGE_KEY) {
                return new Node[]{new CategoryNode(true)};
            }
            if (object instanceof String) {
                return new Node[]{new CategoryNode((String)object)};
            }
            return new Node[]{new Item((ModuleBean)object, this.simple)};
        }

        static /* synthetic */ Object access$800() {
            return LIBRARY_KEY;
        }

        static /* synthetic */ Object access$900() {
            return BRIDGE_KEY;
        }

        static /* synthetic */ IDESettings access$1000(Modules modules) {
            return modules.settings;
        }

        private static final class SortingModeEditor
        extends PropertyEditorSupport {
            private final String[] tags = new String[]{ModuleNode.access$000().getString("LBL_ModuleNode_SORT_UNSORTED"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_DISPLAYNAME"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_CODENAME"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_ENABLED"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_URL"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_CATEGORY")};

            public String[] getTags() {
                return this.tags;
            }

            public String getAsText() {
                return this.tags[(Integer)this.getValue()];
            }

            public void setAsText(String string) {
                for (int i = 0; i < this.tags.length; ++i) {
                    if (!this.tags[i].equals(string)) continue;
                    this.setValue(new Integer(i));
                    return;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    static class Item
    extends AbstractNode
    implements PropertyChangeListener {
        private ModuleBean item;
        private boolean listeningToAllModules = false;
        private boolean simple = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Item(ModuleBean moduleBean) {
            super(Children.LEAF, Lookups.singleton((Object)moduleBean));
            this.item = moduleBean;
            this.setName(moduleBean.getCodeNameBase());
            moduleBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleBean));
            this.updateDisplayStuff();
        }

        public Item(ModuleBean moduleBean, boolean bl) {
            this(moduleBean);
            this.simple = bl;
        }

        ModuleBean getItem() {
            if (!$assertionsDisabled && this.item == null) {
                throw new AssertionError((Object)"Cannot be called untill item is null.");
            }
            return this.item;
        }

        void uninstall() {
            ModuleDeleter moduleDeleter = ModuleNode.getModuleDeleter();
            if (!$assertionsDisabled && moduleDeleter == null) {
                throw new AssertionError((Object)"ModuleDeleter must be available.");
            }
            boolean bl = moduleDeleter.canDelete(this.item.getModule());
            if (bl) {
                try {
                    moduleDeleter.delete(this.item.getModule());
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(256, (Throwable)iOException);
                }
            } else if (this.canDestroy()) {
                this.item.delete();
            }
        }

        private void updateDisplayStuff() {
            this.setDisplayName(this.item.getDisplayName());
            this.setShortDescription(this.item.getShortDescription());
            this.setIconBaseWithExtension(this.item.isEnabled() ? (this.item.isReloadable() ? ModuleNode.MODULE_TEST_ITEM_ICON_BASE : ModuleNode.MODULE_ITEM_ICON_BASE) : (this.item.isProblematic() ? ModuleNode.MODULE_ITEM_ERROR_BASE : ModuleNode.MODULE_ITEM_DISABLED_BASE));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateDisplayStuff();
            this.firePropertyChange(null, null, null);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNode$Item")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNode$Item);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableDisableAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableDisableAction)), SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$EnableAllAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$EnableAllAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$UninstallAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$UninstallAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNodeActions$SortAction")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNodeActions$SortAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public Action getPreferredAction() {
            return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        }

        public void destroy() {
            if (ModuleNodeUtils.confirmUninstall(new Node[]{this})) {
                this.uninstall();
            }
        }

        public boolean canDestroy() {
            boolean bl = ModuleNode.getModuleDeleter().canDelete(this.item.getModule());
            if (!bl) {
                return this.item.getJar() != null;
            }
            return true;
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            Sheet.Set set2 = Sheet.createExpertSet();
            sheet.put(set2);
            try {
                PropertySupport.Reflection reflection;
                if (!this.simple) {
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getDisplayName", null);
                    reflection.setName("displayName");
                    reflection.setDisplayName(bundle.getString("PROP_modules_name"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_name"));
                    set.put((Node.Property)reflection);
                }
                reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getSpecificationVersion", null);
                reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                reflection.setName("specificationVersion");
                reflection.setDisplayName(bundle.getString("PROP_modules_specversion"));
                reflection.setShortDescription(bundle.getString("HINT_modules_specversion"));
                set.put((Node.Property)reflection);
                if (!this.simple) {
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getImplementationVersion", null);
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setName("implementationVersion");
                    reflection.setDisplayName(bundle.getString("PROP_modules_implversion"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_implversion"));
                    set2.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getBuildVersion", null);
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setName("buildVersion");
                    reflection.setDisplayName(bundle.getString("PROP_modules_buildversion"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_buildversion"));
                    set2.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getShortDescription", null);
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setName("shortDescription");
                    reflection.setDisplayName(bundle.getString("PROP_modules_shortDescription"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_shortDescription"));
                    set.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getLongDescription", null);
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setName("longDescription");
                    reflection.setDisplayName(bundle.getString("PROP_modules_longDescription"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_longDescription"));
                    set.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getCategory", null);
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setName("category");
                    reflection.setDisplayName(bundle.getString("PROP_modules_category"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_category"));
                    set2.put((Node.Property)reflection);
                }
                class EnabledOrReloadableProp
                extends PropertySupport.Reflection {
                    private final /* synthetic */ Item this$0;

                    public EnabledOrReloadableProp(Item item, String string, String string2) throws NoSuchMethodException {
                        this.this$0 = item;
                        super((Object)Item.access$200(item), Boolean.TYPE, string, string2);
                    }

                    public boolean canWrite() {
                        if (!super.canWrite()) {
                            return false;
                        }
                        if (this.getName().equals("enabled")) {
                            return Item.access$200(this.this$0).getJar() != null && !Item.access$200(this.this$0).isProblematic() && !Item.access$200(this.this$0).isAutoload() && !Item.access$200(this.this$0).isEager();
                        }
                        if (this.getName().equals("reloadable")) {
                            return Item.access$200(this.this$0).getJar() != null && (Item.access$200(this.this$0).isReloadable() || Item.access$200(this.this$0).getJar().getParentFile().canWrite());
                        }
                        throw new IllegalStateException();
                    }
                }
                reflection = new EnabledOrReloadableProp(this, "isEnabled", "setEnabled");
                reflection.setName("enabled");
                reflection.setDisplayName(bundle.getString("PROP_modules_enabled"));
                reflection.setShortDescription(bundle.getString("HINT_modules_enabled"));
                set.put((Node.Property)reflection);
                if (!this.simple) {
                    reflection = new EnabledOrReloadableProp(this, "isReloadable", "setReloadable");
                    reflection.setName("reloadable");
                    reflection.setDisplayName(bundle.getString("PROP_modules_reloadable"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_reloadable"));
                    set2.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String, "getCodeName", null);
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setName("codeName");
                    reflection.setDisplayName(bundle.getString("PROP_modules_codename"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_codename"));
                    set2.put((Node.Property)reflection);
                    if (this.item.getJar() != null) {
                        reflection = new PropertySupport.Reflection((Object)this.item, class$java$io$File == null ? (class$java$io$File = ModuleNode.class$("java.io.File")) : class$java$io$File, "getJar", null);
                        reflection.setName("jar");
                        reflection.setDisplayName(bundle.getString("PROP_modules_jar"));
                        reflection.setShortDescription(bundle.getString("HINT_modules_jar"));
                        set2.put((Node.Property)reflection);
                    }
                    class ClasspathProperty
                    extends PropertySupport.ReadOnly {
                        private final /* synthetic */ Item this$0;

                        public ClasspathProperty(Item item) {
                            this.this$0 = item;
                            super("classpath", Item.access$300(), ModuleNode.access$000().getString("PROP_modules_classpath"), ModuleNode.access$000().getString("HINT_modules_classpath"));
                        }

                        public Object getValue() throws InvocationTargetException {
                            String string = Item.access$200(this.this$0).getEffectiveClasspath();
                            if (this.getValueType() == (class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String)) {
                                return string;
                            }
                            try {
                                Constructor<T> constructor = this.getValueType().getConstructor(class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String);
                                return constructor.newInstance(string);
                            }
                            catch (Exception exception) {
                                throw new InvocationTargetException(exception);
                            }
                        }
                    }
                    set2.put((Node.Property)new ClasspathProperty(this));
                    reflection = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isAutoload", null);
                    reflection.setName("autoload");
                    reflection.setDisplayName(bundle.getString("PROP_modules_autoload"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_autoload"));
                    set2.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isEager", null);
                    reflection.setName("eager");
                    reflection.setDisplayName(bundle.getString("PROP_modules_eager"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_eager"));
                    set2.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ModuleNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "getProvides", null);
                    reflection.setName("provides");
                    reflection.setValue("suppressCustomEditor", (Object)Boolean.TRUE);
                    reflection.setDisplayName(bundle.getString("PROP_modules_provides"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_provides"));
                    set2.put((Node.Property)reflection);
                    reflection = new PropertySupport.Reflection((Object)this.item, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ModuleNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "getProblemDescriptions", null);
                    reflection.setName("problemDescriptions");
                    reflection.setDisplayName(bundle.getString("PROP_modules_problemDescriptions"));
                    reflection.setShortDescription(bundle.getString("HINT_modules_problemDescriptions"));
                    set2.put((Node.Property)reflection);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            set2.put((Node.Property)new UsedByProp());
            return sheet;
        }

        private static Class getNbClassPathOrStringClass() {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ModuleNode.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            try {
                return classLoader.loadClass("org.openide.execution.NbClassPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return class$java$lang$String == null ? (class$java$lang$String = ModuleNode.class$("java.lang.String")) : class$java$lang$String;
            }
        }

        static /* synthetic */ Class access$300() {
            return Item.getNbClassPathOrStringClass();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$autoupdate$catalog$ModuleNode == null ? (class$org$netbeans$modules$autoupdate$catalog$ModuleNode = ModuleNode.class$("org.netbeans.modules.autoupdate.catalog.ModuleNode")) : class$org$netbeans$modules$autoupdate$catalog$ModuleNode).desiredAssertionStatus();
        }

        private final class UsedByProp
        extends PropertySupport.ReadOnly
        implements ModuleBean.AllModulesBean.RelationCallback,
        PropertyChangeListener {
            private String[] value;

            public UsedByProp() {
                super("usedBy", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ModuleNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, bundle.getString("PROP_modules_usedby"), bundle.getString("HINT_modules_usedby"));
                this.value = null;
            }

            public Object getValue() {
                if (this.value != null) {
                    return this.value;
                }
                ModuleBean.AllModulesBean allModulesBean = ModuleBean.AllModulesBean.getDefault();
                allModulesBean.getRelations(Item.this.item, 3, this);
                if (!Item.this.listeningToAllModules) {
                    Item.this.listeningToAllModules = true;
                    allModulesBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)allModulesBean));
                    ModuleBean[] moduleBeanArray = allModulesBean.getModules();
                    for (int i = 0; i < moduleBeanArray.length; ++i) {
                        if (moduleBeanArray[i] == Item.this.item) continue;
                        moduleBeanArray[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleBeanArray[i]));
                    }
                }
                return new String[]{bundle.getString("LBL_please_wait_modules_usedby")};
            }

            public void result(Set set) {
                String[] stringArray;
                ArrayList<String> arrayList = new ArrayList<String>(Math.max(set.size(), 1));
                if (Item.this.item.isEnabled()) {
                    stringArray = set.iterator();
                    while (stringArray.hasNext()) {
                        ModuleBean moduleBean = (ModuleBean)stringArray.next();
                        if (!moduleBean.isEnabled()) continue;
                        arrayList.add(moduleBean.getDisplayName());
                    }
                    Collections.sort(arrayList, Collator.getInstance());
                }
                stringArray = this.value;
                this.value = arrayList.toArray(new String[arrayList.size()]);
                Item.this.firePropertyChange("usedBy", stringArray, this.value);
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.value = null;
                Item.this.firePropertyChange("usedBy", null, null);
            }
        }
    }
}

