/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class CustomizableSideBar
extends JPanel {
    private static HashMap components = new HashMap(5);
    private static HashMap lookupResults = new HashMap(5);
    private static HashMap lookupListeners = new HashMap(5);
    private static HashMap changeListeners = new HashMap(5);
    public static final String FOLDER_NAME = "SideBar";
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$editor$SideBarFactory;

    private CustomizableSideBar(List list, SideBarPosition sideBarPosition) {
        BoxLayout boxLayout = new BoxLayout(this, sideBarPosition.getAxis());
        this.setLayout(boxLayout);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add((JComponent)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WeakEventListenerList getListenerList(Class clazz) {
        WeakEventListenerList weakEventListenerList;
        HashMap hashMap = changeListeners;
        synchronized (hashMap) {
            weakEventListenerList = (WeakEventListenerList)changeListeners.get(clazz);
        }
        return weakEventListenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addChangeListener(Class clazz, ChangeListener changeListener) {
        WeakEventListenerList weakEventListenerList;
        HashMap hashMap = changeListeners;
        synchronized (hashMap) {
            weakEventListenerList = (WeakEventListenerList)changeListeners.get(clazz);
            if (weakEventListenerList == null) {
                weakEventListenerList = new WeakEventListenerList();
            }
            changeListeners.put(clazz, weakEventListenerList);
        }
        weakEventListenerList.add(ChangeListener.class, (EventListener)changeListener);
    }

    static void removeChangeListener(Class clazz, ChangeListener changeListener) {
        WeakEventListenerList weakEventListenerList = CustomizableSideBar.getListenerList(clazz);
        if (weakEventListenerList == null) {
            return;
        }
        weakEventListenerList.remove(ChangeListener.class, (EventListener)changeListener);
    }

    private static void fireChange(Class clazz) {
        WeakEventListenerList weakEventListenerList = CustomizableSideBar.getListenerList(clazz);
        if (weakEventListenerList == null) {
            return;
        }
        ChangeListener[] changeListenerArray = (ChangeListener[])weakEventListenerList.getListeners(ChangeListener.class);
        ChangeEvent changeEvent = new ChangeEvent(CustomizableSideBar.class);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    public static Map createSideBars(JTextComponent jTextComponent) {
        Map map = CustomizableSideBar.getPanelComponents(jTextComponent);
        HashMap<SideBarPosition, CustomizableSideBar> hashMap = new HashMap<SideBarPosition, CustomizableSideBar>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SideBarPosition sideBarPosition = (SideBarPosition)entry.getKey();
            hashMap.put(sideBarPosition, new CustomizableSideBar((List)entry.getValue(), sideBarPosition));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getInstanceCookiesPerKitClass(Class clazz) {
        Map map = new HashMap();
        if (clazz == null) {
            return map;
        }
        HashMap hashMap = components;
        synchronized (hashMap) {
            Lookup.Result result;
            if (components.containsKey(clazz)) {
                return (Map)components.get(clazz);
            }
            BaseKit baseKit = BaseKit.getKit((Class)clazz);
            String string = baseKit.getContentType();
            if (string == null) {
                return map;
            }
            MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
            Object object = lookupResults;
            synchronized (object) {
                result = (Lookup.Result)lookupResults.get(clazz);
                if (result == null) {
                    result = mimeLookup.lookup(new Lookup.Template(SideBarFactoryProvider.class));
                    lookupResults.put(clazz, result);
                }
            }
            object = result.allInstances();
            if (object.isEmpty()) {
                return map;
            }
            SideBarFactoryProvider sideBarFactoryProvider = (SideBarFactoryProvider)object.iterator().next();
            HashMap hashMap2 = lookupListeners;
            synchronized (hashMap2) {
                LookupListener lookupListener = (LookupListener)lookupListeners.get(clazz);
                if (lookupListener == null) {
                    lookupListener = new MyLookupListener(clazz);
                    LookupListener lookupListener2 = (LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)lookupListener, (Object)result);
                    result.addLookupListener(lookupListener2);
                    lookupListeners.put(clazz, lookupListener);
                }
            }
            if (sideBarFactoryProvider != null) {
                map = sideBarFactoryProvider.getProviders();
            }
            if (map != null) {
                components.put(clazz, map);
            }
            return map;
        }
    }

    private static Map getPanelComponents(JTextComponent jTextComponent) {
        HashMap hashMap = new HashMap();
        Map map = CustomizableSideBar.getInstanceCookiesPerKitClass(Utilities.getKitClass((JTextComponent)jTextComponent));
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                List list = (List)entry.getValue();
                ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
                for (int i = 0; i < list.size(); ++i) {
                    InstanceCookie instanceCookie = (InstanceCookie)list.get(i);
                    Object object = instanceCookie.instanceCreate();
                    JComponent jComponent = ((SideBarFactory)object).createSideBar(jTextComponent);
                    if (jComponent == null) continue;
                    arrayList.add(jComponent);
                }
                hashMap.put(entry.getKey(), arrayList);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return hashMap;
    }

    private static class MyLookupListener
    implements LookupListener {
        private Class kitClass;

        public MyLookupListener(Class clazz) {
            this.kitClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            HashMap hashMap = components;
            synchronized (hashMap) {
                components.remove(this.kitClass);
            }
            CustomizableSideBar.fireChange(this.kitClass);
        }
    }

    public static class SideBarFactoryProvider
    implements InstanceProvider {
        List ordered;

        public SideBarFactoryProvider() {
        }

        public SideBarFactoryProvider(List list) {
            this.ordered = list;
        }

        public Map getProviders() {
            HashMap<SideBarPosition, ArrayList<InstanceCookie>> hashMap = new HashMap<SideBarPosition, ArrayList<InstanceCookie>>();
            for (int i = 0; i < this.ordered.size(); ++i) {
                DataObject dataObject = (DataObject)this.ordered.get(i);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? CustomizableSideBar.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie == null) continue;
                try {
                    if (!(class$org$netbeans$editor$SideBarFactory == null ? CustomizableSideBar.class$("org.netbeans.editor.SideBarFactory") : class$org$netbeans$editor$SideBarFactory).isAssignableFrom(instanceCookie.instanceClass())) continue;
                    SideBarPosition sideBarPosition = new SideBarPosition(dataObject.getPrimaryFile());
                    ArrayList<InstanceCookie> arrayList = (ArrayList<InstanceCookie>)hashMap.get(sideBarPosition);
                    if (arrayList == null) {
                        arrayList = new ArrayList<InstanceCookie>();
                        hashMap.put(sideBarPosition, arrayList);
                    }
                    arrayList.add(instanceCookie);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            return hashMap;
        }

        public Object createInstance(List list) {
            return new SideBarFactoryProvider(list);
        }
    }

    static final class SideBarPosition {
        public static final int WEST = 1;
        public static final int NORTH = 2;
        public static final int SOUTH = 3;
        public static final int EAST = 4;
        public static final String WEST_NAME = "West";
        public static final String NORTH_NAME = "North";
        public static final String SOUTH_NAME = "South";
        public static final String EAST_NAME = "East";
        private int position;
        private boolean scrollable;
        private static String[] borderLayoutConstants = new String[]{"", "West", "North", "South", "East"};
        private static int[] axisConstants = new int[]{-1, 0, 1, 1, 0};

        SideBarPosition(FileObject fileObject) {
            Object object;
            Object object2 = fileObject.getAttribute("position");
            if (object2 != null && object2 instanceof String) {
                object = (String)object2;
                if (WEST_NAME.equals(object)) {
                    this.position = 1;
                } else if (NORTH_NAME.equals(object)) {
                    this.position = 2;
                } else if (SOUTH_NAME.equals(object)) {
                    this.position = 3;
                } else if (EAST_NAME.equals(object)) {
                    this.position = 4;
                } else {
                    if (ErrorManager.getDefault().isLoggable(1)) {
                        ErrorManager.getDefault().log(1, "Unsupported position: " + (String)object);
                    }
                    this.position = 1;
                }
            } else {
                this.position = 1;
            }
            object = fileObject.getAttribute("scrollable");
            this.scrollable = object != null && object instanceof Boolean ? (Boolean)object : true;
            if (this.scrollable && (this.position == 3 || this.position == 4) && ErrorManager.getDefault().isLoggable(1)) {
                ErrorManager.getDefault().log(1, "Unsupported combination: scrollable == true, position=" + this.getBorderLayoutPosition());
            }
        }

        public int hashCode() {
            return this.scrollable ? this.position : -this.position;
        }

        public boolean equals(Object object) {
            if (object instanceof SideBarPosition) {
                SideBarPosition sideBarPosition = (SideBarPosition)object;
                if (this.scrollable != sideBarPosition.scrollable) {
                    return false;
                }
                return this.position == sideBarPosition.position;
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public String getBorderLayoutPosition() {
            return borderLayoutConstants[this.getPosition()];
        }

        private int getAxis() {
            return axisConstants[this.getPosition()];
        }

        public boolean isScrollable() {
            return this.scrollable;
        }

        public String toString() {
            return "[SideBarPosition: scrollable=" + this.scrollable + ", position=" + this.position + "]";
        }
    }
}

