/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.GlobalContextAction;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class MainMenuAction
extends GlobalContextAction
implements Presenter.Menu,
ChangeListener {
    public static final Icon BLANK_ICON = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/empty.gif"));
    public boolean menuInitialized = false;
    private final Icon forcedIcon;
    private boolean forceIcon;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$JumpBackAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$JumpForwardAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$FormatAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$ShiftLineLeftAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$ShiftLineRightAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$CommentAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$UncommentAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$WordMatchNextAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$WordMatchPrevAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$FindNextAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$StartMacroRecordingAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$MainMenuAction$StopMacroRecordingAction;

    public MainMenuAction() {
        this(true, null);
    }

    public MainMenuAction(boolean bl, Icon icon) {
        Registry.addChangeListener((ChangeListener)this);
        this.forceIcon = bl;
        this.forcedIcon = icon;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setMenu();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setMenu();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return this.getMenuItemText();
    }

    private static JTextComponent getComponent() {
        return Utilities.getFocusedComponent();
    }

    private static Action getActionByName(String string) {
        BaseKit baseKit = MainMenuAction.getKit();
        if (baseKit != null) {
            Action action = baseKit.getActionByName(string);
            return action;
        }
        return null;
    }

    protected static void addAccelerators(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
        Keymap keymap;
        if (jTextComponent == null || action == null || jMenuItem == null) {
            return;
        }
        Action action2 = MainMenuAction.getActionByName((String)action.getValue("Name"));
        if (action2 != null) {
            action = action2;
        }
        if ((keymap = jTextComponent.getKeymap()) != null) {
            KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
            KeyStroke keyStroke = jMenuItem.getAccelerator();
            if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                if (keyStroke == null || !keyStroke.equals(keyStrokeArray[0])) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                }
            } else if (keyStroke != null && action2 != null) {
                jMenuItem.setAccelerator(null);
            }
        }
    }

    private static BaseKit getKit() {
        JTextComponent jTextComponent = MainMenuAction.getComponent();
        return jTextComponent == null ? null : Utilities.getKit((JTextComponent)jTextComponent);
    }

    public boolean isEnabled() {
        return false;
    }

    private static Object getSettingValue(BaseKit baseKit, String string) {
        return Settings.getValue(baseKit.getClass(), (String)string);
    }

    private static boolean getSettingBoolean(BaseKit baseKit, String string) {
        Boolean bl = (Boolean)MainMenuAction.getSettingValue(baseKit, string);
        return bl != null ? bl : false;
    }

    protected Action getGlobalKitAction() {
        return null;
    }

    protected void setMenu() {
        Object object;
        ActionMap actionMap = this.getContextActionMap();
        Action action = null;
        JMenuItem jMenuItem = this.getMenuPresenter();
        if (actionMap != null) {
            action = actionMap.get(this.getActionName());
            if (action == null) {
                action = this.getGlobalKitAction();
            }
            if ((object = jMenuItem.getAction()) == null) {
                if (action != null) {
                    jMenuItem.setAction(action);
                    jMenuItem.setToolTipText(null);
                    this.menuInitialized = false;
                }
            } else if (action != null && !action.equals(object)) {
                jMenuItem.setAction(action);
                jMenuItem.setToolTipText(null);
                this.menuInitialized = false;
            } else if (action == null) {
                jMenuItem.setEnabled(false);
            }
        }
        if (!this.menuInitialized) {
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)this.getMenuItemText());
            this.menuInitialized = true;
        }
        jMenuItem.setEnabled(action != null);
        object = Utilities.getFocusedComponent();
        if (object != null && object instanceof JEditorPane) {
            MainMenuAction.addAccelerators(action, jMenuItem, (JTextComponent)object);
        } else {
            jMenuItem.setAccelerator(this.getDefaultAccelerator());
        }
        if (this.forceIcon) {
            jMenuItem.setIcon(this.forcedIcon);
        }
    }

    protected abstract String getMenuItemText();

    protected abstract String getActionName();

    protected KeyStroke getDefaultAccelerator() {
        List list;
        MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)"text/x-java");
        KeyBindingSettings keyBindingSettings = (KeyBindingSettings)mimeLookup.lookup(KeyBindingSettings.class);
        if (keyBindingSettings != null && (list = keyBindingSettings.getKeyBindings()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                MultiKeyBinding multiKeyBinding = (MultiKeyBinding)list.get(i);
                String string = multiKeyBinding.getActionName();
                if (string == null || !string.equals(this.getActionName()) || multiKeyBinding.getKeyStrokeCount() != 1) continue;
                return multiKeyBinding.getKeyStroke(0);
            }
        }
        return null;
    }

    public static final class StopMacroRecordingAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public StopMacroRecordingAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$StopMacroRecordingAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$StopMacroRecordingAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$StopMacroRecordingAction")) : class$org$netbeans$modules$editor$MainMenuAction$StopMacroRecordingAction)).getString("stop_macro_recording_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "stop-macro-recording";
        }
    }

    public static final class StartMacroRecordingAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public StartMacroRecordingAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$StartMacroRecordingAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$StartMacroRecordingAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$StartMacroRecordingAction")) : class$org$netbeans$modules$editor$MainMenuAction$StartMacroRecordingAction)).getString("start_macro_recording_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "start-macro-recording";
        }
    }

    public static final class FindSelectionAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindSelectionAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$FindNextAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$FindNextAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$FindNextAction")) : class$org$netbeans$modules$editor$MainMenuAction$FindNextAction)).getString("find_selection_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-selection";
        }
    }

    public static final class FindPreviousAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindPreviousAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$FindNextAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$FindNextAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$FindNextAction")) : class$org$netbeans$modules$editor$MainMenuAction$FindNextAction)).getString("find_previous_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-previous";
        }
    }

    public static final class FindNextAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindNextAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$FindNextAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$FindNextAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$FindNextAction")) : class$org$netbeans$modules$editor$MainMenuAction$FindNextAction)).getString("find_next_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-next";
        }
    }

    public static final class WordMatchPrevAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public WordMatchPrevAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$WordMatchPrevAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$WordMatchPrevAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$WordMatchPrevAction")) : class$org$netbeans$modules$editor$MainMenuAction$WordMatchPrevAction)).getString("word_match_previous_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "word-match-prev";
        }
    }

    public static final class WordMatchNextAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public WordMatchNextAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$WordMatchNextAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$WordMatchNextAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$WordMatchNextAction")) : class$org$netbeans$modules$editor$MainMenuAction$WordMatchNextAction)).getString("word_match_next_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "word-match-next";
        }
    }

    public static final class UncommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public UncommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$UncommentAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$UncommentAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$UncommentAction")) : class$org$netbeans$modules$editor$MainMenuAction$UncommentAction)).getString("uncomment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "uncomment";
        }
    }

    public static final class CommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public CommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$CommentAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$CommentAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$CommentAction")) : class$org$netbeans$modules$editor$MainMenuAction$CommentAction)).getString("comment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "comment";
        }
    }

    public static final class ShiftLineRightAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ShiftLineRightAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$ShiftLineRightAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$ShiftLineRightAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$ShiftLineRightAction")) : class$org$netbeans$modules$editor$MainMenuAction$ShiftLineRightAction)).getString("shift_line_right_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "shift-line-right";
        }
    }

    public static final class ShiftLineLeftAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ShiftLineLeftAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$ShiftLineLeftAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$ShiftLineLeftAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$ShiftLineLeftAction")) : class$org$netbeans$modules$editor$MainMenuAction$ShiftLineLeftAction)).getString("shift_line_left_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "shift-line-left";
        }
    }

    public static final class FormatAction
    extends MainMenuAction {
        private JMenuItem formatMenuItem = new JMenuItem(this.getMenuItemText());

        public FormatAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$FormatAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$FormatAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$FormatAction")) : class$org$netbeans$modules$editor$MainMenuAction$FormatAction)).getString("format_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.formatMenuItem;
        }

        protected String getActionName() {
            return "format";
        }
    }

    public static final class JumpForwardAction
    extends MainMenuAction {
        private JMenuItem jumpForwardMenuItem = new JMenuItem(this.getMenuItemText());

        public JumpForwardAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$JumpForwardAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$JumpForwardAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$JumpForwardAction")) : class$org$netbeans$modules$editor$MainMenuAction$JumpForwardAction)).getString("jump_forward_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpForwardMenuItem;
        }

        protected String getActionName() {
            return "jump-list-next";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(76, 8);
        }
    }

    public static final class JumpBackAction
    extends MainMenuAction {
        private JMenuItem jumpBackMenuItem = new JMenuItem(this.getMenuItemText());

        public JumpBackAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction$JumpBackAction == null ? (class$org$netbeans$modules$editor$MainMenuAction$JumpBackAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction$JumpBackAction")) : class$org$netbeans$modules$editor$MainMenuAction$JumpBackAction)).getString("jump_back_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpBackMenuItem;
        }

        protected String getActionName() {
            return "jump-list-prev";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(75, 8);
        }
    }

    public static class GoToDeclarationAction
    extends MainMenuAction {
        private JMenuItem GOTO_DECL_MENU = new JMenuItem(this.getMenuItemText());

        public GoToDeclarationAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction == null ? (class$org$netbeans$modules$editor$MainMenuAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction")) : class$org$netbeans$modules$editor$MainMenuAction)).getString("goto_declaration_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_DECL_MENU;
        }

        protected String getActionName() {
            return "goto-declaration";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(71, 8);
        }
    }

    public static class GoToSuperAction
    extends MainMenuAction {
        private JMenuItem GOTO_SUPER_MENU = new JMenuItem(this.getMenuItemText());

        public GoToSuperAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction == null ? (class$org$netbeans$modules$editor$MainMenuAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction")) : class$org$netbeans$modules$editor$MainMenuAction)).getString("goto_super_implementation_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_SUPER_MENU;
        }

        protected String getActionName() {
            return "goto-super-implementation";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(66, 2);
        }
    }

    public static class GoToSourceAction
    extends MainMenuAction {
        private JMenuItem GOTO_SOURCE_MENU = new JMenuItem(this.getMenuItemText());

        public GoToSourceAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction == null ? (class$org$netbeans$modules$editor$MainMenuAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction")) : class$org$netbeans$modules$editor$MainMenuAction)).getString("goto_source_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_SOURCE_MENU;
        }

        protected String getActionName() {
            return "goto-source";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(79, 8);
        }
    }

    public static class ShowLineNumbersAction
    extends MainMenuAction {
        private JCheckBoxMenuItem SHOW_LINE_MENU = new JCheckBoxMenuItem(this.getMenuItemText());

        public ShowLineNumbersAction() {
            super(false, null);
            this.setMenu();
        }

        protected void setMenu() {
            super.setMenu();
            this.SHOW_LINE_MENU.setState(ShowLineNumbersAction.isLineNumbersVisible());
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction == null ? (class$org$netbeans$modules$editor$MainMenuAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction")) : class$org$netbeans$modules$editor$MainMenuAction)).getString("show_line_numbers_main_menu_view_item");
        }

        public String getName() {
            return this.getMenuItemText();
        }

        public JMenuItem getMenuPresenter() {
            return this.SHOW_LINE_MENU;
        }

        private static boolean isLineNumbersVisible() {
            BaseKit baseKit = MainMenuAction.getKit();
            if (baseKit == null) {
                return false;
            }
            return MainMenuAction.getSettingBoolean(baseKit, "line-number-visible");
        }

        protected String getActionName() {
            return "toggle-line-numbers";
        }
    }

    public static class ShowToolBarAction
    extends MainMenuAction {
        private static JCheckBoxMenuItem SHOW_TOOLBAR_MENU;

        public ShowToolBarAction() {
            super(false, null);
            SHOW_TOOLBAR_MENU = new JCheckBoxMenuItem(this.getMenuItemText());
            this.setMenu();
        }

        protected Action getGlobalKitAction() {
            BaseKit baseKit = BaseKit.getKit((Class)(class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = MainMenuAction.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit));
            return baseKit != null ? baseKit.getActionByName(this.getActionName()) : null;
        }

        protected void setMenu() {
            super.setMenu();
            SHOW_TOOLBAR_MENU.setState(ShowToolBarAction.isToolbarVisible());
        }

        public JMenuItem getMenuPresenter() {
            return SHOW_TOOLBAR_MENU;
        }

        private static boolean isToolbarVisible() {
            BaseKit baseKit = MainMenuAction.getKit();
            if (baseKit == null) {
                return false;
            }
            return MainMenuAction.getSettingBoolean(baseKit, "toolbarVisible");
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$MainMenuAction == null ? (class$org$netbeans$modules$editor$MainMenuAction = MainMenuAction.class$("org.netbeans.modules.editor.MainMenuAction")) : class$org$netbeans$modules$editor$MainMenuAction)).getString("show_editor_toolbar_main_menu_view_item");
        }

        protected String getActionName() {
            return "toggle-toolbar";
        }
    }
}

