/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.Utilities;
import org.openide.text.Annotation;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;

public class NbEditorDocument
extends GuardedDocument
implements NbDocument.PositionBiasable,
NbDocument.WriteLockable,
NbDocument.Printable,
NbDocument.CustomEditor,
NbDocument.CustomToolbar,
NbDocument.Annotatable {
    public static final String FORMATTER = "formatter";
    public static final String MIME_TYPE_PROP = "mimeType";
    public static final String INDENT_ENGINE = "indentEngine";
    private Formatter formatter;
    private HashMap annoMap;
    private WeakHashMap annoBlackList;

    public NbEditorDocument(Class clazz) {
        super(clazz);
        this.addStyleToLayerMapping("NbBreakpointStyle", "NbBreakpointStyleLayer:10");
        this.addStyleToLayerMapping("NbErrorStyle", "NbErrorStyleLayer:20");
        this.addStyleToLayerMapping("NbCurrentStyle", "NbCurrentStyleLayer:30");
        this.setNormalStyleName("NbNormalStyle");
        this.annoMap = new HashMap(20);
        this.annoBlackList = new WeakHashMap();
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        Object object = this.getProperty(MIME_TYPE_PROP);
        if (!(object instanceof String)) {
            BaseKit baseKit = BaseKit.getKit((Class)this.getKitClass());
            this.putProperty(MIME_TYPE_PROP, baseKit.getContentType());
        }
        this.putProperty(INDENT_ENGINE, new BaseDocument.PropertyEvaluator(){
            private Object cached;

            public Object getValue() {
                if (this.cached == null) {
                    this.cached = Settings.getValue((Class)NbEditorDocument.this.getKitClass(), (String)NbEditorDocument.INDENT_ENGINE);
                }
                return this.cached;
            }
        });
        this.formatter = null;
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (attributeSet != null) {
            Object object = attributeSet.getAttribute(NbDocument.GUARDED);
            if (object != null && object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    super.setCharacterAttributes(n, n2, (AttributeSet)guardedSet, bl);
                } else {
                    super.setCharacterAttributes(n, n2, (AttributeSet)unguardedSet, bl);
                }
            } else {
                super.setCharacterAttributes(n, n2, attributeSet, bl);
            }
        }
    }

    public AttributedCharacterIterator[] createPrintIterators() {
        NbPrintContainer nbPrintContainer = new NbPrintContainer();
        this.print(nbPrintContainer);
        return nbPrintContainer.getIterators();
    }

    public Component createEditor(JEditorPane jEditorPane) {
        return Utilities.getEditorUI((JTextComponent)jEditorPane).getExtComponent();
    }

    public JToolBar createToolbar(JEditorPane jEditorPane) {
        return Utilities.getEditorUI((JTextComponent)jEditorPane).getToolBarComponent();
    }

    public Formatter getFormatter() {
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = this.formatter = (Formatter)Settings.getValue((Class)this.getKitClass(), (String)FORMATTER);
        }
        return formatter != null ? formatter : super.getFormatter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(Position position, int n, Annotation annotation) {
        Integer n2 = (Integer)this.annoBlackList.get(annotation);
        if (n2 != null) {
            if (n2 == -1) {
                this.annoBlackList.remove(annotation);
                return;
            }
            if (n2 < -1) {
                this.annoBlackList.put(annotation, new Integer(n2 + 1));
                return;
            }
        }
        this.readLock();
        try {
            int n3 = this.getLength();
            int n4 = position.getOffset();
            n4 = Math.min(n4, n3);
            try {
                position = this.createPosition(n4);
            }
            catch (BadLocationException badLocationException) {
                position = null;
            }
            AnnotationDescDelegate annotationDescDelegate = (AnnotationDescDelegate)((Object)this.annoMap.get(annotation));
            if (annotationDescDelegate != null) {
                annotationDescDelegate.detachListeners();
                this.getAnnotations().removeAnnotation((AnnotationDesc)annotationDescDelegate);
                this.annoMap.remove(annotation);
                this.annoBlackList.put(annotation, new Integer(n2 != null ? n2 + 1 : 1));
            }
            if (annotation.getAnnotationType() != null) {
                annotationDescDelegate = new AnnotationDescDelegate((BaseDocument)this, position, n, annotation);
                this.annoMap.put(annotation, annotationDescDelegate);
                this.getAnnotations().addAnnotation((AnnotationDesc)annotationDescDelegate);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        Integer n = (Integer)this.annoBlackList.get(annotation);
        if (n != null) {
            if (n == 1) {
                this.annoBlackList.remove(annotation);
                return;
            }
            if (n > 1) {
                this.annoBlackList.put(annotation, new Integer(n - 1));
                return;
            }
        }
        this.readLock();
        try {
            if (annotation.getAnnotationType() != null) {
                AnnotationDescDelegate annotationDescDelegate = (AnnotationDescDelegate)((Object)this.annoMap.get(annotation));
                if (annotationDescDelegate == null) {
                    this.annoBlackList.put(annotation, new Integer(n != null ? n - 1 : -1));
                    return;
                }
                annotationDescDelegate.detachListeners();
                this.getAnnotations().removeAnnotation((AnnotationDesc)annotationDescDelegate);
                this.annoMap.remove(annotation);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    Map getAnnoMap() {
        return this.annoMap;
    }

    void addStreamDescriptionChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    void removeStreamDescriptionChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStreamDescriptionChange() {
        ChangeEvent changeEvent = new ChangeEvent((Object)this);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? NbEditorDocument.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    protected Dictionary createDocumentProperties(Dictionary dictionary) {
        return new BaseDocument.LazyPropertyMap(dictionary){

            public Object put(Object object, Object object2) {
                Object object3 = super.put(object, object2);
                if ("stream".equals(object) && (object3 == null || !object3.equals(object2))) {
                    NbEditorDocument.this.fireStreamDescriptionChange();
                }
                return object3;
            }
        };
    }

    class NbPrintContainer
    extends AttributedCharacters
    implements PrintContainer {
        ArrayList acl = new ArrayList();
        AttributedCharacters a = new AttributedCharacters();

        NbPrintContainer() {
        }

        public void add(char[] cArray, Font font, Color color, Color color2) {
            this.a.append(cArray, font, color);
        }

        public void eol() {
            this.acl.add(this.a);
            this.a = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return true;
        }

        public AttributedCharacterIterator[] getIterators() {
            int n = this.acl.size();
            AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[n];
            for (int i = 0; i < n; ++i) {
                AttributedCharacters attributedCharacters = (AttributedCharacters)this.acl.get(i);
                attributedCharacterIteratorArray[i] = attributedCharacters.iterator();
            }
            return attributedCharacterIteratorArray;
        }
    }

    static class AnnotationDescDelegate
    extends AnnotationDesc {
        private Annotation delegate;
        private PropertyChangeListener l;
        private Position pos;
        private BaseDocument doc;

        AnnotationDescDelegate(BaseDocument baseDocument, Position position, int n, Annotation annotation) {
            super(position.getOffset(), n);
            this.pos = position;
            this.delegate = annotation;
            this.doc = baseDocument;
            this.updateAnnotationType();
            this.l = new PropertyChangeListener(this){
                private final /* synthetic */ AnnotationDescDelegate this$0;
                {
                    this.this$0 = annotationDescDelegate;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == "shortDescription") {
                        AnnotationDescDelegate.access$100(this.this$0, "shortDescription", null, null);
                    }
                    if (propertyChangeEvent.getPropertyName() == "moveToFront") {
                        AnnotationDescDelegate.access$200(this.this$0, "moveToFront", null, null);
                    }
                    if (propertyChangeEvent.getPropertyName() == "annotationType") {
                        this.this$0.updateAnnotationType();
                        AnnotationDescDelegate.access$300(this.this$0, "annotationType", null, null);
                    }
                }
            };
            this.delegate.addPropertyChangeListener(this.l);
        }

        public String getAnnotationType() {
            return this.delegate.getAnnotationType();
        }

        public String getShortDescription() {
            return this.delegate.getShortDescription();
        }

        void detachListeners() {
            this.delegate.removePropertyChangeListener(this.l);
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public int getLine() {
            try {
                return Utilities.getLineOffset((BaseDocument)this.doc, (int)this.pos.getOffset());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        static /* synthetic */ void access$100(AnnotationDescDelegate annotationDescDelegate, String string, Object object, Object object2) {
            annotationDescDelegate.firePropertyChange(string, object, object2);
        }

        static /* synthetic */ void access$200(AnnotationDescDelegate annotationDescDelegate, String string, Object object, Object object2) {
            annotationDescDelegate.firePropertyChange(string, object, object2);
        }

        static /* synthetic */ void access$300(AnnotationDescDelegate annotationDescDelegate, String string, Object object, Object object2) {
            annotationDescDelegate.firePropertyChange(string, object, object2);
        }
    }
}

