/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.TopologicalSortException;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

final class NbEditorToolBar
extends JToolBar
implements SettingsChangeListener {
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.toolbar.sort");
    private static final String TOOLBARS_FOLDER_NAME = "Toolbars";
    private static final String DEFAULT_TOOLBAR_NAME = "Default";
    static final String BASE_MIME_TYPE = "text/base";
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    FileChangeListener moduleRegListener;
    private static final Runnable returnFocusRunnable = new Runnable(){

        public void run() {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null) {
                ((Component)jTextComponent).requestFocus();
            }
        }
    };
    private static final ActionListener sharedActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(returnFocusRunnable);
        }
    };
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            JButton jButton;
            if (mouseEvent.getSource() instanceof JButton && (jButton = (JButton)mouseEvent.getSource()).isEnabled()) {
                jButton.setContentAreaFilled(true);
                jButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JButton) {
                JButton jButton = (JButton)mouseEvent.getSource();
                jButton.setContentAreaFilled(false);
                jButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    };
    private Reference componentRef;
    private boolean presentersAdded;
    private boolean addListener = true;
    private static final String NOOP_ACTION_KEY = "noop-action-key";
    private static final Action NOOP_ACTION = new NoOpAction();
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    NbEditorToolBar(JTextComponent jTextComponent) {
        this.componentRef = new WeakReference<JTextComponent>(jTextComponent);
        this.setFloatable(false);
        this.addMouseListener(sharedMouseListener);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        this.installModulesInstallationListener();
        this.installNoOpActionMappings();
    }

    private void installNoOpActionMappings() {
        int n;
        InputMap inputMap = this.getInputMap(1);
        KeyStroke[] keyStrokeArray = this.findEditorKeys("cut-to-clipboard", KeyStroke.getKeyStroke(88, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        keyStrokeArray = this.findEditorKeys("copy-to-clipboard", KeyStroke.getKeyStroke(67, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        keyStrokeArray = this.findEditorKeys("delete-next", KeyStroke.getKeyStroke(127, 0));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        keyStrokeArray = this.findEditorKeys("paste-from-clipboard", KeyStroke.getKeyStroke(86, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            inputMap.put(keyStrokeArray[n], NOOP_ACTION_KEY);
        }
        this.getActionMap().put(NOOP_ACTION_KEY, NOOP_ACTION);
    }

    private void installModulesInstallationListener() {
        this.moduleRegListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (AllOptionsFolder.getDefault().isToolbarVisible()) {
                            NbEditorToolBar.access$200(4.access$100(this.this$1));
                            NbEditorToolBar.access$300(4.access$100(this.this$1));
                        }
                    }
                };
                Utilities.runInEventDispatchThread((Runnable)runnable);
            }

            static /* synthetic */ NbEditorToolBar access$100(4 var0) {
                return var0.NbEditorToolBar.this;
            }
        };
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
        if (fileObject != null) {
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.moduleRegListener, (Object)fileObject));
        }
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    public String getName() {
        return "editorToolbar";
    }

    public void setUI(ToolBarUI toolBarUI) {
        this.addListener = false;
        super.setUI(toolBarUI);
        this.addListener = true;
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.addListener) {
            super.addMouseListener(mouseListener);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.addListener) {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        final boolean bl = NbEditorToolBar.isToolBarVisible();
        JTextComponent jTextComponent = this.getComponent();
        final boolean bl2 = settingsChangeEvent != null && "key-bindings".equals(settingsChangeEvent.getSettingName()) && jTextComponent != null && settingsChangeEvent.getKitClass() == Utilities.getKitClass((JTextComponent)jTextComponent);
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    NbEditorToolBar.this.checkPresentersAdded();
                    if (bl2) {
                        NbEditorToolBar.this.installNoOpActionMappings();
                        int n = NbEditorToolBar.this.getComponentCount();
                        Map map = NbEditorToolBar.this.getKeyBindingMap();
                        Component[] componentArray = NbEditorToolBar.this.getComponents();
                        for (int i = 0; i < componentArray.length; ++i) {
                            MultiKeyBinding multiKeyBinding;
                            int n2;
                            String string;
                            JButton jButton;
                            Action action;
                            Component component = componentArray[i];
                            if (!(component instanceof JButton) || (action = (jButton = (JButton)component).getAction()) == null || (string = (String)action.getValue("Name")) == null) continue;
                            String string2 = jButton.getToolTipText();
                            if (string2 != null && (n2 = string2.indexOf("(")) > 0) {
                                string2 = string2.substring(0, n2 - 1);
                            }
                            if ((multiKeyBinding = (MultiKeyBinding)map.get(string)) != null) {
                                jButton.setToolTipText(string2 + " (" + NbEditorToolBar.getMnemonic(multiKeyBinding) + ")");
                                continue;
                            }
                            jButton.setToolTipText(string2);
                        }
                    }
                } else {
                    NbEditorToolBar.this.checkPresentersRemoved();
                }
                NbEditorToolBar.this.setVisible(bl);
            }
        };
        Utilities.runInEventDispatchThread((Runnable)runnable);
    }

    private void checkPresentersAdded() {
        if (!this.presentersAdded) {
            this.presentersAdded = true;
            DataFolder dataFolder = NbEditorToolBar.getToolBarFolder(BASE_MIME_TYPE, false);
            DataFolder dataFolder2 = NbEditorToolBar.getToolBarFolder(this.getMimeType(), false);
            this.addPresenters(dataFolder, dataFolder2);
        }
    }

    private void checkPresentersRemoved() {
        this.presentersAdded = false;
        this.removeAll();
    }

    private static DataFolder getToolBarFolder(String string, boolean bl) {
        String string2 = "Editors/" + string + "/" + TOOLBARS_FOLDER_NAME + "/" + DEFAULT_TOOLBAR_NAME;
        DataFolder dataFolder = null;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string2);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                dataFolder = (DataFolder)dataObject.getCookie(DataFolder.class);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        } else if (bl) {
            try {
                FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        }
        return dataFolder;
    }

    private static boolean isToolBarVisible() {
        return AllOptionsFolder.getDefault().isToolbarVisible();
    }

    private String getMimeType() {
        JTextComponent jTextComponent = this.getComponent();
        BaseKit baseKit = jTextComponent != null ? Utilities.getKit((JTextComponent)jTextComponent) : null;
        String string = baseKit != null ? baseKit.getContentType() : null;
        return string;
    }

    private static String getMnemonic(MultiKeyBinding multiKeyBinding) {
        StringBuffer stringBuffer = new StringBuffer();
        if (multiKeyBinding.keys != null) {
            for (int i = 0; i < multiKeyBinding.keys.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(NbEditorToolBar.getKeyMnemonic(multiKeyBinding.keys[i]));
            }
        } else {
            stringBuffer.append(NbEditorToolBar.getKeyMnemonic(multiKeyBinding.key));
        }
        return stringBuffer.toString();
    }

    private static String getKeyMnemonic(KeyStroke keyStroke) {
        int n;
        String string = org.openide.util.Utilities.keyToString((KeyStroke)keyStroke);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = keyStroke.getModifiers();
        if ((n2 & 2) != 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("Alt+");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("Shift+");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("Meta+");
        }
        if ((n = string.indexOf(45)) != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private Map getKeyBindingMap() {
        HashMap<String, MultiKeyBinding> hashMap = new HashMap<String, MultiKeyBinding>();
        List list = this.getKeyBindingList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MultiKeyBinding)) continue;
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
            hashMap.put(multiKeyBinding.actionName, multiKeyBinding);
        }
        return hashMap;
    }

    private List getKeyBindingList() {
        BaseKit baseKit;
        Object object;
        ArrayList arrayList = new ArrayList();
        AllOptionsFolder allOptionsFolder = AllOptionsFolder.getDefault();
        if (allOptionsFolder != null && (object = allOptionsFolder.getKeyBindingList()) != null) {
            arrayList.addAll(object);
        }
        BaseKit baseKit2 = baseKit = (object = this.getComponent()) != null ? Utilities.getKit((JTextComponent)object) : null;
        if (baseKit instanceof BaseKit) {
            List list;
            BaseKit baseKit3 = baseKit;
            BaseOptions baseOptions = BaseOptions.getOptions(baseKit.getClass());
            if (baseOptions != null && (list = baseOptions.getKeyBindingList()) != null) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.componentRef.get();
    }

    private void addPresenters(DataFolder dataFolder, DataFolder dataFolder2) {
        BaseKit baseKit;
        List list = this.getKeyBindingList();
        JTextComponent jTextComponent = this.getComponent();
        BaseKit baseKit2 = baseKit = jTextComponent != null ? Utilities.getKit((JTextComponent)jTextComponent) : null;
        if (baseKit instanceof BaseKit) {
            BaseKit baseKit3 = baseKit;
            Iterator iterator = NbEditorToolBar.getToolbarObjects(dataFolder, dataFolder2).iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string;
                DataObject dataObject = (DataObject)iterator.next();
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbEditorToolBar.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie != null) {
                    try {
                        if ((class$javax$swing$JSeparator == null ? NbEditorToolBar.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(instanceCookie.instanceClass())) {
                            this.addSeparator();
                            continue;
                        }
                        string = null;
                        object4 = instanceCookie.instanceCreate();
                        if (object4 instanceof ContextAwareAction) {
                            if (string == null) {
                                string = this.createActionContext();
                            }
                            Object object5 = object3 = string == null ? null : ((ContextAwareAction)object4).createContextAwareInstance((Lookup)string);
                            if (object3 instanceof Presenter.Toolbar || object3 instanceof Component) {
                                object4 = object3;
                            }
                        }
                        if (object4 instanceof Presenter.Toolbar) {
                            object3 = ((Presenter.Toolbar)object4).getToolbarPresenter();
                            this.add((Component)object3);
                            if (!(object3 instanceof AbstractButton)) continue;
                            this.processButton((AbstractButton)object3);
                            continue;
                        }
                        if (!(object4 instanceof Component)) continue;
                        this.add((Component)object4);
                        if (!(object4 instanceof AbstractButton)) continue;
                        this.processButton((AbstractButton)object4);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                    }
                    continue;
                }
                string = dataObject.getName();
                object4 = baseKit3.getActionByName(string);
                if (object4 == null) continue;
                object3 = object4.getValue("SmallIcon");
                if (object3 == null) {
                    object2 = (String)object4.getValue("IconResource");
                    if (object2 == null) {
                        object2 = "org/netbeans/modules/editor/resources/default.gif";
                    }
                    if ((object = org.openide.util.Utilities.loadImage((String)object2)) != null) {
                        object4.putValue("SmallIcon", new ImageIcon((Image)object));
                    }
                }
                object2 = this.add((Action)object4);
                object = list.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (!(e instanceof MultiKeyBinding)) continue;
                    MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
                    if (!string.equals(multiKeyBinding.actionName)) continue;
                    ((JComponent)object2).setToolTipText(((JComponent)object2).getToolTipText() + " (" + NbEditorToolBar.getMnemonic(multiKeyBinding) + ")");
                    break;
                }
                this.processButton((AbstractButton)object2);
            }
        }
    }

    private Lookup createActionContext() {
        DataObject dataObject;
        JTextComponent jTextComponent = this.getComponent();
        DataObject dataObject2 = dataObject = jTextComponent != null ? NbEditorUtilities.getDataObject(jTextComponent.getDocument()) : null;
        if (dataObject != null) {
            Node node = dataObject.getNodeDelegate();
            return Lookups.singleton((Object)node);
        }
        Lookup lookup = null;
        for (Container container = jTextComponent; !(container == null || container instanceof Lookup.Provider && (lookup = ((Lookup.Provider)container).getLookup()) != null); container = container.getParent()) {
        }
        return lookup;
    }

    private void processButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setBorderPainted(false);
        abstractButton.addActionListener(sharedActionListener);
        abstractButton.setMargin(BUTTON_INSETS);
        if (abstractButton instanceof JButton) {
            abstractButton.addMouseListener(sharedMouseListener);
        }
        abstractButton.setFocusable(false);
    }

    static List getToolbarObjects(DataFolder dataFolder, DataFolder dataFolder2) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        if (dataFolder != null) {
            NbEditorToolBar.addDataObjects(hashMap, dataFolder.getChildren());
        }
        if (dataFolder2 != null) {
            NbEditorToolBar.addDataObjects(hashMap, dataFolder2.getChildren());
        }
        if (dataFolder != null) {
            NbEditorToolBar.addEdges(hashMap2, hashMap, dataFolder);
        }
        if (dataFolder2 != null) {
            NbEditorToolBar.addEdges(hashMap2, hashMap, dataFolder2);
        }
        try {
            return org.openide.util.Utilities.topologicalSort(hashMap.values(), hashMap2);
        }
        catch (TopologicalSortException topologicalSortException) {
            ErrorManager.getDefault().notify((Throwable)topologicalSortException);
            return topologicalSortException.partialSort();
        }
    }

    private static void addDataObjects(Map map, DataObject[] dataObjectArray) {
        int n = dataObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DataObject dataObject = dataObjectArray[i];
            String string = dataObject.getPrimaryFile().getNameExt();
            map.put(string, dataObject);
        }
    }

    private static void addEdges(Map map, Map map2, DataFolder dataFolder) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            int n = string.indexOf("/");
            if (n == -1 || !((object = fileObject.getAttribute(string)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (debugSort) {
                System.err.println("SORT-PAIR: [" + string2 + ", " + string3 + "]");
            }
            DataObject dataObject = (DataObject)map2.get(string2);
            DataObject dataObject2 = (DataObject)map2.get(string3);
            if (dataObject == null || dataObject2 == null) continue;
            Collection<DataObject> collection = (List<DataObject>)map.get(dataObject);
            if (collection == null) {
                collection = Collections.singletonList(dataObject2);
                map.put(dataObject, collection);
                continue;
            }
            if (collection.size() == 1) {
                collection = new HashSet<DataObject>(collection);
                collection.add(dataObject2);
                map.put(dataObject, collection);
                continue;
            }
            collection.add(dataObject2);
        }
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        JTextComponent jTextComponent = this.getComponent();
        if (string != null && jTextComponent != null) {
            Action action;
            EditorKit editorKit;
            TextUI textUI = jTextComponent.getUI();
            Keymap keymap = jTextComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(jTextComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null) {
                KeyStroke[] keyStrokeArray2 = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray2 != null && keyStrokeArray2.length > 0) {
                    keyStrokeArray = keyStrokeArray2;
                } else {
                    MultiKeymap multiKeymap = ((BaseKit)editorKit).getKeymap();
                    KeyStroke[] keyStrokeArray3 = multiKeymap.getKeyStrokesForAction(action);
                    if (keyStrokeArray3 != null && keyStrokeArray3.length > 0) {
                        keyStrokeArray = keyStrokeArray3;
                    }
                }
            }
        }
        return keyStrokeArray;
    }

    private static final class NoOpAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

