/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.editor.CustomizableSideBar;
import org.netbeans.modules.editor.NbEditorToolBar;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorUI
extends ExtEditorUI {
    private FocusListener focusL = new FocusAdapter(){

        public void focusGained(FocusEvent focusEvent) {
            FileObject fileObject;
            DataObject dataObject;
            BaseDocument baseDocument = NbEditorUI.this.getDocument();
            if (baseDocument != null && (dataObject = NbEditorUtilities.getDataObject((Document)baseDocument)) != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                RequestProcessor.getDefault().post(new Runnable(this, fileObject){
                    private final /* synthetic */ FileObject val$fo;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$fo = fileObject;
                    }

                    public void run() {
                        this.val$fo.refresh();
                    }
                });
            }
        }
    };
    private boolean attached = false;
    private ChangeListener listener;
    private FontColorSettings fontColorSettings;
    private LookupListener weakLookupListener;
    private Lookup.Result result;
    private LookupListener lookupListener;
    private static final Map mime2Coloring = new HashMap(5);

    protected SystemActionUpdater createSystemActionUpdater(String string, boolean bl, boolean bl2) {
        return new SystemActionUpdater(string, bl, bl2);
    }

    private static Lookup getContextLookup(Component component) {
        Lookup lookup = null;
        for (Component component2 = component; !(component2 == null || component2 instanceof Lookup.Provider && (lookup = ((Lookup.Provider)component2).getLookup()) != null); component2 = component2.getParent()) {
        }
        return lookup;
    }

    protected void attachSystemActionPerformer(String string) {
        new SystemActionPerformer(string);
    }

    private String getDocumentContentType() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return null;
        }
        Document document = jTextComponent.getDocument();
        String string = (String)document.getProperty("mimeType");
        if (string == null) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontColorSettings getFontColorSettings() {
        Class clazz = Settings.class;
        synchronized (clazz) {
            if (this.fontColorSettings == null) {
                String string = this.getDocumentContentType();
                if (string == null) {
                    return null;
                }
                MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
                this.result = mimeLookup.lookup(new Lookup.Template(FontColorSettings.class));
                Collection collection = this.result.allInstances();
                this.lookupListener = new MyLookupListener(string);
                this.weakLookupListener = (LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)this.lookupListener, (Object)this.result);
                this.result.addLookupListener(this.weakLookupListener);
                if (collection.size() > 0) {
                    this.fontColorSettings = (FontColorSettings)collection.iterator().next();
                }
            }
        }
        return this.fontColorSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map createColoringMap() {
        FontColorSettings fontColorSettings = this.getFontColorSettings();
        String string = this.getDocumentContentType();
        if (fontColorSettings == null || string == null) {
            return super.createColoringMap();
        }
        Class clazz = Settings.class;
        synchronized (clazz) {
            Object object;
            HashMap<String, Coloring> hashMap = (HashMap<String, Coloring>)mime2Coloring.get(string);
            if (hashMap != null) {
                return hashMap;
            }
            hashMap = new HashMap<String, Coloring>();
            hashMap.putAll(super.createColoringMap());
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors("default");
            Integer n = null;
            if (attributeSet != null && (object = attributeSet.getAttribute(StyleConstants.FontSize)) instanceof Integer) {
                n = (Integer)object;
            }
            if (n == null) {
                n = new Integer(SettingsDefaults.defaultFont.getSize());
            }
            while (iterator.hasNext()) {
                Font font;
                String string2;
                AttributeSet attributeSet2;
                object = iterator.next();
                if (!(object instanceof String) || (attributeSet2 = fontColorSettings.getTokenFontColors(string2 = (String)object)) == null && (attributeSet2 = fontColorSettings.getFontColors(string2)) == null) continue;
                Font font2 = font = attributeSet2.getAttribute(StyleConstants.FontFamily) != null ? NbEditorUI.toFont(attributeSet2, n) : null;
                if (string2.equals("default") && (font == null || attributeSet2.getAttribute(StyleConstants.Foreground) == null || attributeSet2.getAttribute(StyleConstants.Background) == null)) continue;
                Coloring coloring = new Coloring(font, 7, (Color)attributeSet2.getAttribute(StyleConstants.Foreground), (Color)attributeSet2.getAttribute(StyleConstants.Background), (Color)attributeSet2.getAttribute(StyleConstants.Underline), (Color)attributeSet2.getAttribute(StyleConstants.StrikeThrough), (Color)attributeSet2.getAttribute(EditorStyleConstants.WaveUnderlineColor));
                hashMap.put(string2, coloring);
            }
            mime2Coloring.put(string, hashMap);
            return hashMap;
        }
    }

    static Font toFont(AttributeSet attributeSet, Integer n) {
        Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
        Object object2 = attributeSet.getAttribute(StyleConstants.FontSize);
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            object2 = n;
        }
        int n2 = 0;
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            ++n2;
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            n2 += 2;
        }
        return new Font((String)object, n2, (Integer)object2);
    }

    protected void installUI(JTextComponent jTextComponent) {
        super.installUI(jTextComponent);
        if (!this.attached) {
            this.attachSystemActionPerformer("find");
            this.attachSystemActionPerformer("replace");
            this.attachSystemActionPerformer("goto");
            this.attachSystemActionPerformer("show-popup-menu");
            this.attached = true;
        }
        jTextComponent.addFocusListener(this.focusL);
    }

    protected void uninstallUI(JTextComponent jTextComponent) {
        super.uninstallUI(jTextComponent);
        jTextComponent.removeFocusListener(this.focusL);
    }

    protected JComponent createExtComponent() {
        final JTextComponent jTextComponent = this.getComponent();
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.putClientProperty(JTextComponent.class, jTextComponent);
        final JScrollPane jScrollPane = new JScrollPane(jTextComponent);
        jScrollPane.getViewport().setMinimumSize(new Dimension(4, 4));
        Border border = BorderFactory.createEmptyBorder();
        jScrollPane.setBorder(border);
        jScrollPane.setViewportBorder(border);
        Class clazz = Utilities.getKitClass((JTextComponent)jTextComponent);
        Map map = CustomizableSideBar.createSideBars(jTextComponent);
        if (this.listener == null) {
            this.listener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (Utilities.getEditorUI((JTextComponent)jTextComponent) == null) {
                        return;
                    }
                    Map map = CustomizableSideBar.createSideBars(jTextComponent);
                    NbEditorUI.this.processSideBars(map, jScrollPane, jPanel);
                    jPanel.revalidate();
                    jPanel.repaint();
                }
            };
            CustomizableSideBar.addChangeListener(clazz, this.listener);
        }
        this.processSideBars(map, jScrollPane, jPanel);
        this.initGlyphCorner(jScrollPane);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public boolean isLineNumberEnabled() {
        return AllOptionsFolder.getDefault().getLineNumberVisible();
    }

    public void setLineNumberEnabled(boolean bl) {
        AllOptionsFolder.getDefault().setLineNumberVisible(bl);
    }

    private void processSideBars(Map map, JScrollPane jScrollPane, JComponent jComponent) {
        jComponent.removeAll();
        jScrollPane.setRowHeader(null);
        jScrollPane.setColumnHeaderView(null);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CustomizableSideBar.SideBarPosition sideBarPosition = (CustomizableSideBar.SideBarPosition)entry.getKey();
            JComponent jComponent2 = (JComponent)entry.getValue();
            if (sideBarPosition.isScrollable()) {
                if (sideBarPosition.getPosition() == 1) {
                    jScrollPane.setRowHeaderView(jComponent2);
                    continue;
                }
                if (sideBarPosition.getPosition() == 2) {
                    jScrollPane.setColumnHeaderView(jComponent2);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported side bar position, scrollable = true, position=" + sideBarPosition.getBorderLayoutPosition());
            }
            jComponent.add((Component)jComponent2, sideBarPosition.getBorderLayoutPosition());
        }
        jComponent.add(jScrollPane);
    }

    protected JToolBar createToolBarComponent() {
        return new NbEditorToolBar(this.getComponent());
    }

    public Map getColoringMap() {
        return this.createColoringMap();
    }

    private class MyLookupListener
    implements LookupListener {
        private String mimeType;

        public MyLookupListener(String string) {
            this.mimeType = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = NbEditorUI.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
            synchronized (clazz) {
                mime2Coloring.remove(this.mimeType);
                Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
                Collection collection = result.allInstances();
                if (collection.size() > 0) {
                    NbEditorUI.this.fontColorSettings = (FontColorSettings)collection.iterator().next();
                }
            }
            NbEditorUI.this.settingsChangeImpl(null);
        }
    }

    static class EnabledPropertySyncListener
    implements PropertyChangeListener {
        Action action;

        EnabledPropertySyncListener(Action action) {
            this.action = action;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.action.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    public final class SystemActionUpdater
    implements PropertyChangeListener,
    ActionPerformer {
        private String editorActionName;
        private boolean updatePerformer;
        private boolean syncEnabling;
        private Action editorAction;
        private Action systemAction;
        private PropertyChangeListener enabledPropertySyncL;
        private boolean listeningOnTCRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemActionUpdater(String string, boolean bl, boolean bl2) {
            this.editorActionName = string;
            this.updatePerformer = bl;
            this.syncEnabling = bl2;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent jTextComponent = NbEditorUI.this.getComponent();
                if (jTextComponent != null) {
                    this.propertyChange(new PropertyChangeEvent((Object)NbEditorUI.this, "component", null, jTextComponent));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        public void editorActivated() {
            Action action = this.getEditorAction();
            Action action2 = this.getSystemAction();
            if (action != null && action2 != null) {
                if (this.updatePerformer && action.isEnabled() && action2 instanceof CallbackSystemAction) {
                    ((CallbackSystemAction)action2).setActionPerformer((ActionPerformer)this);
                }
                if (this.syncEnabling) {
                    if (this.enabledPropertySyncL == null) {
                        this.enabledPropertySyncL = new EnabledPropertySyncListener(action2);
                    }
                    action.addPropertyChangeListener(this.enabledPropertySyncL);
                }
            }
        }

        public void editorDeactivated() {
            Action action = this.getEditorAction();
            Action action2 = this.getSystemAction();
            if (action != null && action2 != null && this.syncEnabling && this.enabledPropertySyncL != null) {
                action.removePropertyChangeListener(this.enabledPropertySyncL);
            }
        }

        private void reset() {
            if (this.enabledPropertySyncL != null) {
                this.editorAction.removePropertyChangeListener(this.enabledPropertySyncL);
            }
            this.editorAction = null;
            this.systemAction = null;
            this.enabledPropertySyncL = null;
        }

        public void performAction(SystemAction systemAction) {
            JTextComponent jTextComponent = NbEditorUI.this.getComponent();
            Action action = this.getEditorAction();
            if (jTextComponent != null && action != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
        }

        private void startTCRegistryListening() {
            if (!this.listeningOnTCRegistry) {
                this.listeningOnTCRegistry = true;
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private void stopTCRegistryListening() {
            if (this.listeningOnTCRegistry) {
                this.listeningOnTCRegistry = false;
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("activated".equals(string)) {
                TopComponent topComponent = (TopComponent)propertyChangeEvent.getNewValue();
                if (topComponent instanceof CloneableEditorSupport.Pane) {
                    this.editorActivated();
                } else {
                    this.editorDeactivated();
                }
            } else if ("component".equals(string)) {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                if (jTextComponent != null) {
                    jTextComponent.addPropertyChangeListener(this);
                    if (jTextComponent.isDisplayable()) {
                        this.startTCRegistryListening();
                    }
                } else {
                    jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                    jTextComponent.removePropertyChangeListener(this);
                    this.stopTCRegistryListening();
                }
                this.reset();
            } else if ("editorKit".equals(string)) {
                this.reset();
            } else if ("ancestor".equals(string)) {
                if (((Component)propertyChangeEvent.getSource()).isDisplayable()) {
                    this.startTCRegistryListening();
                } else {
                    this.stopTCRegistryListening();
                }
            }
        }

        private synchronized Action getEditorAction() {
            BaseKit baseKit;
            if (this.editorAction == null && (baseKit = Utilities.getKit((JTextComponent)NbEditorUI.this.getComponent())) != null) {
                this.editorAction = baseKit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction() {
            String string;
            Action action;
            if (this.systemAction == null && (action = this.getEditorAction()) != null && (string = (String)action.getValue("systemActionClassName")) != null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
                if (clazz != null) {
                    this.systemAction = SystemAction.get(clazz);
                }
            }
            return this.systemAction;
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }

    private class SystemActionPerformer
    implements PropertyChangeListener {
        private String editorActionName;
        private Action editorAction;
        private Action systemAction;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemActionPerformer(String string) {
            this.editorActionName = string;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent jTextComponent = NbEditorUI.this.getComponent();
                if (jTextComponent != null) {
                    this.propertyChange(new PropertyChangeEvent((Object)NbEditorUI.this, "component", null, jTextComponent));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        private void attachSystemActionPerformer(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            Action action = this.getEditorAction(jTextComponent);
            if (action == null) {
                return;
            }
            Action action2 = this.getSystemAction(jTextComponent);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof CallbackSystemAction) {
                Object object = ((CallbackSystemAction)action2).getActionMapKey();
                jTextComponent.getActionMap().put(object, action);
            }
        }

        private void detachSystemActionPerformer(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            Action action = this.getEditorAction(jTextComponent);
            if (action == null) {
                return;
            }
            Action action2 = this.getSystemAction(jTextComponent);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof CallbackSystemAction) {
                Object object = ((CallbackSystemAction)action2).getActionMapKey();
                Action action3 = jTextComponent.getActionMap().get(object);
                if (action.equals(action3)) {
                    jTextComponent.getActionMap().remove(object);
                }
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("component".equals(string)) {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                if (jTextComponent != null) {
                    jTextComponent.addPropertyChangeListener(this);
                    this.attachSystemActionPerformer(jTextComponent);
                } else {
                    jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                    jTextComponent.removePropertyChangeListener(this);
                    this.detachSystemActionPerformer(jTextComponent);
                }
            }
        }

        private synchronized Action getEditorAction(JTextComponent jTextComponent) {
            BaseKit baseKit;
            if (this.editorAction == null && (baseKit = Utilities.getKit((JTextComponent)jTextComponent)) != null) {
                this.editorAction = baseKit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction(JTextComponent jTextComponent) {
            String string;
            Action action;
            if (this.systemAction == null && (action = this.getEditorAction(jTextComponent)) != null && (string = (String)action.getValue("systemActionClassName")) != null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
                if (clazz != null) {
                    Lookup lookup;
                    this.systemAction = SystemAction.get(clazz);
                    if (this.systemAction instanceof ContextAwareAction && (lookup = NbEditorUI.getContextLookup(jTextComponent)) != null) {
                        this.systemAction = ((ContextAwareAction)this.systemAction).createContextAwareInstance(lookup);
                    }
                }
            }
            return this.systemAction;
        }
    }
}

