/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnotationTypesFolder
extends FolderInstance {
    private static final String FOLDER = "Editors/AnnotationTypes";
    private static AnnotationTypesFolder folder;
    private Map annotationTypes;
    private FileObject fo;

    private AnnotationTypesFolder(FileObject fileObject, DataFolder dataFolder) {
        super(dataFolder);
        this.recreate();
        this.instanceFinished();
        this.fo = fileObject;
        fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fileEvent) {
                Iterator iterator = AnnotationTypes.getTypes().getAnnotationTypeNames();
                while (iterator.hasNext()) {
                    AnnotationType annotationType = AnnotationTypes.getTypes().getType((String)iterator.next());
                    if (annotationType == null || !((FileObject)annotationType.getProp("file")).equals(fileEvent.getFile())) continue;
                    AnnotationTypes.getTypes().removeType(annotationType.getName());
                    break;
                }
            }
        });
    }

    public static synchronized AnnotationTypesFolder getAnnotationTypesFolder() {
        if (folder != null) {
            return folder;
        }
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER);
        if (fileObject == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataFolder dataFolder = (DataFolder)dataObject.getCookie(DataFolder.class);
            if (dataFolder != null) {
                folder = new AnnotationTypesFolder(fileObject, dataFolder);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
        return folder;
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        this.annotationTypes = new HashMap(instanceCookieArray.length * 4 / 3 + 1);
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Object object = instanceCookieArray[i].instanceCreate();
            if (!(object instanceof AnnotationType)) continue;
            AnnotationType annotationType = (AnnotationType)object;
            this.annotationTypes.put(annotationType.getName(), annotationType);
        }
        AnnotationTypes.getTypes().setTypes(this.annotationTypes);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveAnnotationType(AnnotationType annotationType) {
        block26: {
            Object object;
            Element element;
            FileObject fileObject = (FileObject)annotationType.getProp("file");
            Document document = XMLUtil.createDocument((String)"type", null, (String)"-//NetBeans//DTD annotation type 1.0//EN", (String)"http://www.netbeans.org/dtds/annotation-type-1_0.dtd");
            Element element2 = document.getDocumentElement();
            element2.setAttribute("name", annotationType.getName());
            if (annotationType.getProp("bundle") != null) {
                element2.setAttribute("localizing_bundle", (String)annotationType.getProp("bundle"));
            }
            if (annotationType.getProp("desciptionKey") != null) {
                element2.setAttribute("description_key", (String)annotationType.getProp("desciptionKey"));
            }
            element2.setAttribute("visible", annotationType.isVisible() ? "true" : "false");
            element2.setAttribute("use_highlight_color", annotationType.isUseHighlightColor() ? "true" : "false");
            element2.setAttribute("use_wave_underline_color", annotationType.isUseWaveUnderlineColor() ? "true" : "false");
            element2.setAttribute("inherit_foreground_color", annotationType.isInheritForegroundColor() ? "true" : "false");
            element2.setAttribute("use_custom_sidebar_color", annotationType.isUseCustomSidebarColor() ? "true" : "false");
            element2.setAttribute("type", annotationType.isWholeLine() ? "line" : "linepart");
            if (annotationType.getProp("glyph") != null) {
                element2.setAttribute("glyph", annotationType.getGlyph().toExternalForm());
            }
            if (annotationType.getProp("highlight") != null) {
                element2.setAttribute("highlight", "0x" + Integer.toHexString(annotationType.getHighlight().getRGB() & 0xFFFFFF));
            }
            if (annotationType.getProp("waveunderline") != null) {
                element2.setAttribute("waveunderline", "0x" + Integer.toHexString(annotationType.getWaveUnderlineColor().getRGB() & 0xFFFFFF));
            }
            if (annotationType.getProp("foreground") != null) {
                element2.setAttribute("foreground", "0x" + Integer.toHexString(annotationType.getForegroundColor().getRGB() & 0xFFFFFF));
            }
            if (annotationType.getProp("customSidebarColor") != null) {
                element2.setAttribute("custom_sidebar_color", "0x" + Integer.toHexString(annotationType.getCustomSidebarColor().getRGB() & 0xFFFFFF));
            }
            if (annotationType.getProp("actionsFolder") != null) {
                element2.setAttribute("actions", (String)annotationType.getProp("actionsFolder"));
            }
            if (annotationType.getCombinations() != null) {
                element = document.createElement("combination");
                element.setAttribute("tiptext_key", (String)annotationType.getProp("tooltipTextKey"));
                if (annotationType.getProp("combinationOrder") != null) {
                    element.setAttribute("order", "" + annotationType.getCombinationOrder());
                }
                if (annotationType.getProp("combinationMinimumOptionals") != null) {
                    element.setAttribute("min_optionals", "" + annotationType.getMinimumOptionals());
                }
                element2.appendChild(element);
                object = annotationType.getCombinations();
                for (int i = 0; i < ((AnnotationType.CombinationMember[])object).length; ++i) {
                    Element element3 = document.createElement("combine");
                    element3.setAttribute("annotationtype", object[i].getName());
                    element3.setAttribute("absorb_all", object[i].isAbsorbAll() ? "true" : "false");
                    element3.setAttribute("optional", object[i].isOptional() ? "true" : "false");
                    if (object[i].getMinimumCount() > 0) {
                        element3.setAttribute("min", "" + object[i].getMinimumCount());
                    }
                    element.appendChild(element3);
                }
            }
            element2.setAttribute("severity", annotationType.getSeverity().getName());
            element2.setAttribute("browseable", Boolean.toString(annotationType.isBrowseable()));
            element2.setAttribute("priority", Integer.toString(annotationType.getPriority()));
            document.getDocumentElement().normalize();
            try {
                block25: {
                    element = fileObject.lock();
                    object = null;
                    object = fileObject.getOutputStream((FileLock)element);
                    XMLUtil.write((Document)document, (OutputStream)object, (String)"UTF-8");
                    Object var10_11 = null;
                    if (object == null) break block25;
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                element.releaseLock();
                {
                    break block26;
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                        Object var10_12 = null;
                        if (object != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                        element.releaseLock();
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (object != null) {
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                    }
                    element.releaseLock();
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }
}

