/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.SimpleIndentEngine;
import org.netbeans.modules.editor.options.AbbrevsMIMEProcessor;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.FontsColorsMIMEProcessor;
import org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.MacrosMIMEProcessor;
import org.netbeans.modules.editor.options.MultiPropertyFolder;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.netbeans.modules.editor.options.PropertiesMIMEProcessor;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class BaseOptions
extends OptionSupport {
    protected static final int LATEST_OPTIONS_VERSION = 21;
    protected static final String OPTIONS_VERSION_PROP = "optionsVersion";
    public static final String ABBREV_MAP_PROP = "abbrevMap";
    public static final String BASE = "base";
    public static final String CARET_BLINK_RATE_PROP = "caretBlinkRate";
    public static final String CARET_COLOR_INSERT_MODE_PROP = "caretColorInsertMode";
    public static final String CARET_COLOR_OVERWRITE_MODE_PROP = "caretColorOverwriteMode";
    public static final String CARET_ITALIC_INSERT_MODE_PROP = "caretItalicInsertMode";
    public static final String CARET_ITALIC_OVERWRITE_MODE_PROP = "caretItalicOverwriteMode";
    public static final String CARET_TYPE_INSERT_MODE_PROP = "caretTypeInsertMode";
    public static final String CARET_TYPE_OVERWRITE_MODE_PROP = "caretTypeOverwriteMode";
    public static final String COLORING_MAP_PROP = "coloringMap";
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String FIND_HIGHLIGHT_SEARCH_PROP = "findHighlightSearch";
    public static final String FIND_HISTORY_PROP = "findHistory";
    public static final String FIND_HISTORY_SIZE_PROP = "findHistorySize";
    public static final String FIND_INC_SEARCH_DELAY_PROP = "findIncSearchDelay";
    public static final String FIND_INC_SEARCH_PROP = "findIncSearch";
    public static final String FIND_MATCH_CASE_PROP = "findMatchCase";
    public static final String FIND_REG_EXP_PROP = "findRegExp";
    public static final String FIND_SMART_CASE_PROP = "findSmartCase";
    public static final String FIND_WHOLE_WORDS_PROP = "findWholeWords";
    public static final String FIND_WRAP_SEARCH_PROP = "findWrapSearch";
    public static final String FIND_BLOCK_SEARCH_PROP = "findBlockSearch";
    public static final String FONT_SIZE_PROP = "fontSize";
    public static final String HIGHLIGHT_CARET_ROW_PROP = "highlightCaretRow";
    public static final String HIGHLIGHT_MATCHING_BRACKET_PROP = "highlightMatchingBracket";
    public static final String INDENT_ENGINE_PROP = "indentEngine";
    public static final String KEY_BINDING_LIST_PROP = "keyBindingList";
    public static final String LINE_HEIGHT_CORRECTION_PROP = "lineHeightCorrection";
    public static final String LINE_NUMBER_VISIBLE_PROP = "lineNumberVisible";
    public static final String MACRO_MAP_PROP = "macroMap";
    public static final String MARGIN_PROP = "margin";
    public static final String SCROLL_FIND_INSETS_PROP = "scrollFindInsets";
    public static final String SCROLL_JUMP_INSETS_PROP = "scrollJumpInsets";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    public static final String STATUS_BAR_CARET_DELAY_PROP = "statusBarCaretDelay";
    public static final String STATUS_BAR_VISIBLE_PROP = "statusBarVisible";
    public static final String TAB_SIZE_PROP = "tabSize";
    public static final String TEXT_LIMIT_LINE_COLOR_PROP = "textLimitLineColor";
    public static final String TEXT_LIMIT_LINE_VISIBLE_PROP = "textLimitLineVisible";
    public static final String TEXT_LIMIT_WIDTH_PROP = "textLimitWidth";
    public static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    public static final String TEXT_ANTIALIASING_PROP = "textAntialiasing";
    public static final String CODE_FOLDING_PROPS_PROP = "codeFoldingProps";
    protected static final String[] BASE_PROP_NAMES = new String[]{"abbrevMap", "caretBlinkRate", "caretColorInsertMode", "caretColorOverwriteMode", "caretItalicInsertMode", "caretItalicOverwriteMode", "caretTypeInsertMode", "caretTypeOverwriteMode", "coloringMap", "expandTabs", "fontSize", "highlightCaretRow", "highlightMatchingBracket", "indentEngine", "keyBindingList", "lineHeightCorrection", "macroMap", "margin", "scrollFindInsets", "scrollJumpInsets", "spacesPerTab", "statusBarCaretDelay", "statusBarVisible", "tabSize", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "optionsVersion"};
    static final long serialVersionUID = -5469192431366914841L;
    private static final String NO_INDENT_ENGINE = "NO_INDENT_ENGINE";
    private static final boolean debugFormat = Boolean.getBoolean("netbeans.debug.editor.format");
    private transient Settings.Initializer coloringMapInitializer;
    private transient int optionsVersion;
    private transient IndentEngine readExternalIndentEngine;
    private transient boolean inReadExternal;
    private transient MIMEOptionNode mimeNode;
    private transient Map defaultAbbrevsMap;
    private transient Map defaultMacrosMap;
    private transient Map defaultKeyBindingsMap;
    private transient MIMEOptionFolder settingsFolder;
    private transient boolean usingNewOptions = false;
    private transient FontColorSettings fontColorSettings;
    private transient KeyBindingSettings keyBindingsSettings;
    private transient LookupListener lookupListener;
    private static final HashMap kitClass2Options = new HashMap();
    public static final String CODE_TEMPLATE_EXPAND_KEY = "code-template-expand-key";
    private Lookup.Result resultKB;
    private LookupListener weakLookupListenerKB;
    private LookupListener lookupListenerKB;

    public BaseOptions() {
        this(BaseKit.class, BASE);
        this.optionsVersion = 21;
    }

    public BaseOptions(Class clazz, String string) {
        super(clazz, string);
        kitClass2Options.put(clazz, this);
        if (!BASE.equals(string)) {
            AttributeSet attributeSet;
            BaseKit baseKit = BaseKit.getKit((Class)clazz);
            String string2 = baseKit.getContentType();
            FontColorSettings fontColorSettings = this.getFontColorSettings();
            this.usingNewOptions = false;
            if (fontColorSettings != null && (attributeSet = fontColorSettings.getTokenFontColors("default")) != null) {
                this.usingNewOptions = true;
            }
        }
    }

    public boolean usesNewOptionsDialog() {
        return this.usingNewOptions;
    }

    protected String getContentType() {
        BaseKit baseKit = BaseKit.getKit((Class)this.getKitClass());
        return baseKit.getContentType();
    }

    public static BaseOptions getOptions(Class clazz) {
        BaseOptions baseOptions = null;
        for (Class clazz2 = clazz; baseOptions == null && clazz2 != null && (baseOptions = (BaseOptions)((Object)kitClass2Options.get(clazz2))) == null; clazz2 = clazz2.getSuperclass()) {
            AllOptionsFolder.getDefault().loadMIMEOption(clazz2, false);
            baseOptions = (BaseOptions)((Object)kitClass2Options.get(clazz2));
            if (baseOptions != null) break;
        }
        return baseOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MIMEOptionFolder getMIMEFolder() {
        BaseKit baseKit = BaseKit.getKit((Class)this.getKitClass());
        String string = baseKit.getContentType();
        if (string == null) {
            return null;
        }
        BaseOptions baseOptions = this;
        synchronized (baseOptions) {
            Object object;
            FileObject fileObject;
            if (this.settingsFolder != null) {
                return this.settingsFolder;
            }
            FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string);
            if (fileObject2 == null && (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors")) != null) {
                try {
                    object = new StringTokenizer(string, "/");
                    while (((StringTokenizer)object).hasMoreElements()) {
                        String string2 = ((StringTokenizer)object).nextToken();
                        if (fileObject.getFileObject(string2) == null) {
                            fileObject = fileObject.createFolder(string2);
                            continue;
                        }
                        fileObject = fileObject.getFileObject(string2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string);
            }
            if (fileObject2 != null) {
                try {
                    fileObject = DataObject.find((FileObject)fileObject2);
                    object = (DataFolder)fileObject.getCookie(DataFolder.class);
                    if (object != null) {
                        this.settingsFolder = new MIMEOptionFolder((DataFolder)object, this);
                        return this.settingsFolder;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObjectNotFoundException.printStackTrace();
                }
            }
            return null;
        }
    }

    public synchronized MIMEOptionNode getMimeNode() {
        if (this.mimeNode == null) {
            this.createMIMENode(this.getTypeName());
        }
        return this.mimeNode;
    }

    private void createMIMENode(String string) {
        if (string.equals(BASE)) {
            return;
        }
        try {
            this.mimeNode = new MIMEOptionNode(this);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    protected void updateSettingsMap(Class clazz, Map map) {
        super.updateSettingsMap(clazz, map);
        if (clazz == this.getKitClass()) {
            map.put(INDENT_ENGINE_PROP, new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    return BaseOptions.this.getIndentEngine();
                }
            });
            map.put("formatter", new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    IndentEngine indentEngine = BaseOptions.this.getIndentEngine();
                    return indentEngine != null ? (indentEngine instanceof FormatterIndentEngine ? ((FormatterIndentEngine)indentEngine).getFormatter() : new IndentEngineFormatter(BaseOptions.this.getKitClass(), indentEngine)) : null;
                }
            });
            if (clazz == BaseKit.class) {
                map.put("rendering-hints", new Settings.Evaluator(){

                    public Object getValue(Class clazz, String string) {
                        return BaseOptions.this.computeTextAntialiasingMap(BaseOptions.this.isTextAntialiasing());
                    }
                });
            }
            if (this.coloringMapInitializer != null) {
                this.coloringMapInitializer.updateSettingsMap(clazz, map);
            }
        }
        if (clazz == BaseKit.class && this.coloringMapInitializer != null) {
            this.coloringMapInitializer.updateSettingsMap(BaseKit.class, map);
        }
    }

    private Map computeTextAntialiasingMap(boolean bl) {
        Map<RenderingHints.Key, Object> map;
        if (!bl) {
            return Collections.EMPTY_MAP;
        }
        Map map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map2 != null) {
            Object v = map2.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (v == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT || v == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                map = new HashMap();
                map.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                map = map2;
            }
        } else {
            map = new HashMap<RenderingHints.Key, Object>();
            map.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return map;
    }

    public int getTabSize() {
        return this.getSettingInteger("tab-size");
    }

    public void setTabSize(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("tab-size", n, TAB_SIZE_PROP);
    }

    public void setExpandTabs(boolean bl) {
        this.setSettingBoolean("expand-tabs", bl, EXPAND_TABS_PROP);
    }

    public void setSpacesPerTab(int n) {
        if (n > 0) {
            this.setSettingInteger("spaces-per-tab", n, SPACES_PER_TAB_PROP);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Map getDefaultAbbrevMap() {
        this.loadDefaultAbbreviations();
        return this.defaultAbbrevsMap;
    }

    private void loadDefaultAbbreviations() {
        if (this.defaultAbbrevsMap != null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder = this.getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder2 = mIMEOptionFolder.getFolder("Defaults");
        if (mIMEOptionFolder2 == null) {
            return;
        }
        MIMEOptionFile mIMEOptionFile = mIMEOptionFolder2.getFile(AbbrevsMIMEProcessor.class, false);
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings(false);
            this.defaultAbbrevsMap = new HashMap(mIMEOptionFile.getAllProperties());
        }
    }

    public Map getAbbrevMap() {
        this.loadDefaultAbbreviations();
        this.loadSettings(AbbrevsMIMEProcessor.class);
        Map map = (Map)super.getSettingValue("abbrev-map");
        if (map == null) {
            Utilities.annotateLoggable((Throwable)new NullPointerException("settingsMap is null for kit:" + this.getKitClass()));
        }
        HashMap hashMap = map == null ? new HashMap() : new HashMap(map);
        return hashMap;
    }

    public void setAbbrevMap(Map map, boolean bl) {
        Map map2 = null;
        if (bl) {
            this.loadDefaultAbbreviations();
            map2 = OptionUtilities.getMapDiff(this.getAbbrevMap(), map, true);
            if (map2.size() > 0) {
                this.updateSettings(AbbrevsMIMEProcessor.class, map2);
            }
        }
        super.setSettingValue("abbrev-map", map, ABBREV_MAP_PROP);
    }

    public void setAbbrevMap(Map map) {
        this.setAbbrevMap(map, true);
    }

    public String getCaretTypeInsertMode() {
        return (String)this.getSettingValue("caret-type-insert-mode");
    }

    public void setCaretTypeInsertMode(String string) {
        this.setSettingValue("caret-type-insert-mode", string, CARET_TYPE_INSERT_MODE_PROP);
    }

    public String getCaretTypeOverwriteMode() {
        return (String)this.getSettingValue("caret-type-overwrite-mode");
    }

    public void setCaretTypeOverwriteMode(String string) {
        this.setSettingValue("caret-type-overwrite-mode", string, CARET_TYPE_OVERWRITE_MODE_PROP);
    }

    public boolean getCaretItalicInsertMode() {
        return false;
    }

    public void setCaretItalicInsertMode(boolean bl) {
        this.setSettingBoolean("caret-italic-insert-mode", bl, CARET_ITALIC_INSERT_MODE_PROP);
    }

    public boolean getCaretItalicOverwriteMode() {
        return false;
    }

    public void setCaretItalicOverwriteMode(boolean bl) {
        this.setSettingBoolean("caret-italic-overwrite-mode", bl, CARET_ITALIC_OVERWRITE_MODE_PROP);
    }

    public Color getCaretColorInsertMode() {
        this.loadSettings(FontsColorsMIMEProcessor.class);
        return (Color)super.getSettingValue("caret-color-insert-mode");
    }

    public void setCaretColorInsertMode(Color color) {
        this.setCaretColorInsertMode(color, true);
    }

    public void setCaretColorInsertMode(Color color, boolean bl) {
        if (bl && !this.getCaretColorInsertMode().equals(color) && color != null) {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            hashMap.put("caret-color-insert-mode", color);
            if (hashMap != null) {
                this.updateSettings(FontsColorsMIMEProcessor.class, hashMap);
            }
        }
        super.setSettingValue("caret-color-insert-mode", color, CARET_COLOR_INSERT_MODE_PROP);
    }

    public Color getCaretColorOverwriteMode() {
        this.loadSettings(FontsColorsMIMEProcessor.class);
        return (Color)super.getSettingValue("caret-color-overwrite-mode");
    }

    public void setCaretColorOverwriteMode(Color color) {
        this.setCaretColorOverwriteMode(color, true);
    }

    public void setCaretColorOverwriteMode(Color color, boolean bl) {
        if (bl && !this.getCaretColorOverwriteMode().equals(color) && color != null) {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            hashMap.put("caret-color-overwrite-mode", color);
            if (hashMap != null) {
                this.updateSettings(FontsColorsMIMEProcessor.class, hashMap);
            }
        }
        super.setSettingValue("caret-color-overwrite-mode", color, CARET_COLOR_OVERWRITE_MODE_PROP);
    }

    public int getCaretBlinkRate() {
        return this.getSettingInteger("caret-blink-rate");
    }

    public void setCaretBlinkRate(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("caret-blink-rate", n, CARET_BLINK_RATE_PROP);
    }

    public boolean getLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setLineNumberVisible(boolean bl) {
        this.setSettingBoolean("line-number-visible", bl, LINE_NUMBER_VISIBLE_PROP);
    }

    public Insets getScrollJumpInsets() {
        return (Insets)this.getSettingValue("scroll-jump-insets");
    }

    public void setScrollJumpInsets(Insets insets) {
        this.setSettingValue("scroll-jump-insets", insets, SCROLL_JUMP_INSETS_PROP);
    }

    public Insets getScrollFindInsets() {
        return (Insets)this.getSettingValue("scroll-find-insets");
    }

    public void setScrollFindInsets(Insets insets) {
        this.setSettingValue("scroll-find-insets", insets, SCROLL_FIND_INSETS_PROP);
    }

    public Map getDefaultKeyBindingsMap() {
        this.loadDefaultKeyBindings();
        return this.defaultKeyBindingsMap;
    }

    private void loadDefaultKeyBindings() {
        if (this.defaultKeyBindingsMap != null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder2 = mIMEOptionFolder.getFolder("Defaults");
        if (mIMEOptionFolder2 == null) {
            return;
        }
        MIMEOptionFile mIMEOptionFile = mIMEOptionFolder2.getFile(KeyBindingsMIMEProcessor.class, false);
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings(false);
            this.defaultKeyBindingsMap = new HashMap(mIMEOptionFile.getAllProperties());
        }
        if (!this.usingNewOptions && !BASE.equals(this.getTypeName())) {
            super.setSettingValue("key-bindings", new ArrayList(this.defaultKeyBindingsMap.values()), KEY_BINDING_LIST_PROP);
        }
    }

    private List getKBList() {
        int n;
        if (!this.usingNewOptions) {
            this.loadDefaultKeyBindings();
            this.loadSettings(KeyBindingsMIMEProcessor.class);
        }
        Class clazz = this.getKitClass();
        Settings.KitAndValue[] kitAndValueArray = this.getSettingValueHierarchy("key-bindings");
        List<org.netbeans.editor.MultiKeyBinding> list = null;
        for (n = 0; n < kitAndValueArray.length; ++n) {
            if (kitAndValueArray[n].kitClass != clazz) continue;
            list = (List)kitAndValueArray[n].value;
        }
        if (list == null) {
            list = new ArrayList();
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof org.netbeans.editor.MultiKeyBinding || e == null) continue;
            JTextComponent.KeyBinding keyBinding = (JTextComponent.KeyBinding)e;
            list.set(i, new org.netbeans.editor.MultiKeyBinding(keyBinding.key, keyBinding.actionName));
        }
        return new ArrayList(list);
    }

    public List getKeyBindingList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getKBList());
        arrayList.add(0, this.getKitClass().getName());
        return arrayList;
    }

    public void setKeyBindingList(List list) {
        this.setKeyBindingList(list, true);
    }

    public void setKeyBindingsDiffMap(Map map) {
        if (map != null && map.size() > 0) {
            this.updateSettings(KeyBindingsMIMEProcessor.class, map);
        }
    }

    public void setKeyBindingList(List list, boolean bl) {
        if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
            list.remove(0);
        }
        Map map = null;
        if (bl) {
            this.loadDefaultKeyBindings();
            List list2 = this.getKeyBindingList();
            if (list2.size() > 0 && (list2.get(0) instanceof Class || list2.get(0) instanceof String)) {
                list2.remove(0);
            }
            if ((map = OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(list2), OptionUtilities.makeKeyBindingsMap(list), true)).size() > 0) {
                this.updateSettings(KeyBindingsMIMEProcessor.class, map);
            }
        }
        super.setSettingValue("key-bindings", list, KEY_BINDING_LIST_PROP);
    }

    static Font toFont(AttributeSet attributeSet, Integer n) {
        Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
        Object object2 = attributeSet.getAttribute(StyleConstants.FontSize);
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            object2 = n;
        }
        int n2 = 0;
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            ++n2;
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            n2 += 2;
        }
        return new Font((String)object, n2, (Integer)object2);
    }

    private void updateKeybindingsFromNewOptionsDialogAttributes() {
        KeyBindingSettings keyBindingSettings = this.getKeybindingSettings();
        if (keyBindingSettings == null) {
            return;
        }
        ArrayList<org.netbeans.editor.MultiKeyBinding> arrayList = new ArrayList<org.netbeans.editor.MultiKeyBinding>();
        List list = keyBindingSettings.getKeyBindings();
        for (int i = 0; i < list.size(); ++i) {
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)list.get(i);
            List list2 = multiKeyBinding.getKeyStrokeList();
            KeyStroke[] keyStrokeArray = new KeyStroke[list2.size()];
            list2.toArray(keyStrokeArray);
            org.netbeans.editor.MultiKeyBinding multiKeyBinding2 = new org.netbeans.editor.MultiKeyBinding(keyStrokeArray, multiKeyBinding.getActionName());
            arrayList.add(multiKeyBinding2);
        }
        super.setSettingValue("key-bindings", arrayList, KEY_BINDING_LIST_PROP);
    }

    private void updateColoringsFromNewOptionsDialogAttributes() {
        Serializable serializable;
        Object object;
        Object object2;
        Map map = this.getColoringMap();
        map.remove(null);
        FontColorSettings fontColorSettings = this.getFontColorSettings();
        if (fontColorSettings == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        AttributeSet attributeSet = fontColorSettings.getTokenFontColors("default");
        Integer n = null;
        if (attributeSet != null && (object2 = attributeSet.getAttribute(StyleConstants.FontSize)) instanceof Integer) {
            n = (Integer)object2;
        }
        if (n == null) {
            n = new Integer(SettingsDefaults.defaultFont.getSize());
        }
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (object2 == null) continue;
            object = fontColorSettings.getTokenFontColors((String)object2);
            if (object == null) {
                object = fontColorSettings.getFontColors((String)object2);
            }
            if (object == null) {
                System.out.println("ColorBridge.unknown category " + (String)object2);
                continue;
            }
            Font font = serializable = object.getAttribute(StyleConstants.FontFamily) != null ? BaseOptions.toFont((AttributeSet)object, n) : null;
            if (((String)object2).equals("default")) {
                if (serializable == null) {
                    System.out.println("ColorBridge null font!!! ");
                    continue;
                }
                if (object.getAttribute(StyleConstants.Foreground) == null) {
                    System.out.println("ColorBridge null Foreground!!! ");
                    continue;
                }
                if (object.getAttribute(StyleConstants.Background) == null) {
                    System.out.println("ColorBridge null Background!!! ");
                    continue;
                }
            }
            Coloring coloring = new Coloring(serializable, 7, (Color)object.getAttribute(StyleConstants.Foreground), (Color)object.getAttribute(StyleConstants.Background), (Color)object.getAttribute(StyleConstants.Underline), (Color)object.getAttribute(StyleConstants.StrikeThrough), (Color)object.getAttribute(EditorStyleConstants.WaveUnderlineColor));
            map.put(object2, coloring);
        }
        map.put(null, this.getKitClass().getName());
        this.setColoringMap(map);
        object2 = fontColorSettings.getFontColors("caret-color-insert-mode");
        if (object2 != null) {
            object = (Color)object2.getAttribute(StyleConstants.Foreground);
            serializable = this.getCaretColorInsertMode();
            if (object != null && !((Color)object).equals(serializable)) {
                this.setCaretColorInsertMode((Color)object);
                this.setCaretColorOverwriteMode((Color)object);
            }
        }
        if ((object2 = fontColorSettings.getFontColors("text-limit-line-color")) != null) {
            object = (Color)object2.getAttribute(StyleConstants.Foreground);
            serializable = this.getTextLimitLineColor();
            if (object != null && !((Color)object).equals(serializable)) {
                this.setTextLimitLineColor((Color)object);
            }
        }
    }

    private synchronized KeyBindingSettings getKeybindingSettings() {
        if (this.keyBindingsSettings == null) {
            String string = this.getContentType();
            MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
            this.resultKB = mimeLookup.lookup(new Lookup.Template(KeyBindingSettings.class));
            Collection collection = this.resultKB.allInstances();
            this.lookupListenerKB = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
                    Collection collection = result.allInstances();
                    if (collection.size() > 0) {
                        BaseOptions.this.keyBindingsSettings = (KeyBindingSettings)collection.iterator().next();
                    }
                    BaseOptions.this.updateKeybindingsFromNewOptionsDialogAttributes();
                }
            };
            this.weakLookupListenerKB = (LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)this.lookupListenerKB, (Object)this.resultKB);
            this.resultKB.addLookupListener(this.weakLookupListenerKB);
            if (collection.size() > 0) {
                this.keyBindingsSettings = (KeyBindingSettings)collection.iterator().next();
            }
        }
        return this.keyBindingsSettings;
    }

    private synchronized FontColorSettings getFontColorSettings() {
        if (this.fontColorSettings == null) {
            String string = this.getContentType();
            MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
            Lookup.Result result = mimeLookup.lookup(new Lookup.Template(FontColorSettings.class));
            Collection collection = result.allInstances();
            this.lookupListener = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
                    Collection collection = result.allInstances();
                    if (collection.size() > 0) {
                        BaseOptions.this.fontColorSettings = (FontColorSettings)collection.iterator().next();
                    }
                    BaseOptions.this.updateColoringsFromNewOptionsDialogAttributes();
                }
            };
            result.addLookupListener(this.lookupListener);
            if (collection.size() > 0) {
                this.fontColorSettings = (FontColorSettings)collection.iterator().next();
            }
        }
        return this.fontColorSettings;
    }

    public Map getColoringMap() {
        Map map;
        if (!this.usingNewOptions) {
            this.loadSettings(FontsColorsMIMEProcessor.class);
        }
        if ((map = SettingsUtil.getColoringMap((Class)this.getKitClass(), (boolean)false, (boolean)true)) == null) {
            Utilities.annotateLoggable((Throwable)new NullPointerException("settingsMap is null for kit:" + this.getKitClass()));
        }
        HashMap<Object, String> hashMap = map == null ? new HashMap<Object, String>() : new HashMap(map);
        hashMap.put(null, this.getKitClass().getName());
        return hashMap;
    }

    public void setColoringMap(Map map) {
        this.setColoringMap(map, true);
    }

    public void setColoringMap(final Map map, boolean bl) {
        Map map2 = null;
        if (map != null) {
            if (this.inReadExternal) {
                // empty if block
            }
            if (!this.usingNewOptions && bl && (map2 = OptionUtilities.getMapDiff(this.getColoringMap(), map, false)).size() > 0) {
                this.updateSettings(FontsColorsMIMEProcessor.class, map2);
            }
            map.remove(null);
            Settings.update((Runnable)new Runnable(){

                public void run() {
                    SettingsUtil.setColoringMap((Class)BaseOptions.this.getKitClass(), (Map)map, (boolean)false);
                }
            });
            this.coloringMapInitializer = SettingsUtil.getColoringMapInitializer((Class)this.getKitClass(), (Map)map, (boolean)false, (String)(this.getTypeName() + "-coloring-map-initializer"));
            this.firePropertyChange(COLORING_MAP_PROP, null, null);
        }
    }

    public int getFontSize() {
        Coloring coloring = SettingsUtil.getColoring((Class)this.getKitClass(), (String)"default", (boolean)false);
        return coloring != null ? coloring.getFont().getSize() : SettingsDefaults.defaultFont.getSize();
    }

    public void setFontSize(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        int n2 = this.getFontSize();
        Map map = SettingsUtil.getColoringMap((Class)this.getKitClass(), (boolean)false, (boolean)true);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Coloring coloring;
                Font font;
                Map.Entry entry = iterator.next();
                Object v = entry.getValue();
                if (!(v instanceof Coloring) || (font = (coloring = (Coloring)v).getFont()) == null || font.getSize() == n) continue;
                font = font.deriveFont((float)n);
                Coloring coloring2 = new Coloring(font, coloring.getFontMode(), coloring.getForeColor(), coloring.getBackColor());
                entry.setValue(coloring2);
            }
            this.setColoringMap(map);
            this.firePropertyChange(FONT_SIZE_PROP, null, null);
        }
    }

    public float getLineHeightCorrection() {
        return ((Float)this.getSettingValue("line-height-correction")).floatValue();
    }

    public void setLineHeightCorrection(float f) {
        if (f <= 0.0f) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingValue("line-height-correction", new Float(f), LINE_HEIGHT_CORRECTION_PROP);
    }

    public Map getDefaultMacrosMap() {
        this.loadDefaultMacros();
        return this.defaultMacrosMap;
    }

    private void loadDefaultMacros() {
        if (this.defaultMacrosMap != null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder = this.getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder2 = mIMEOptionFolder.getFolder("Defaults");
        if (mIMEOptionFolder2 == null) {
            return;
        }
        MIMEOptionFile mIMEOptionFile = mIMEOptionFolder2.getFile(MacrosMIMEProcessor.class, false);
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings(false);
            this.defaultMacrosMap = new HashMap(mIMEOptionFile.getAllProperties());
        }
    }

    private void processMacroKeyBindings(Map map, List list) {
        ArrayList<org.netbeans.editor.MultiKeyBinding> arrayList = new ArrayList<org.netbeans.editor.MultiKeyBinding>();
        ArrayList<org.netbeans.editor.MultiKeyBinding> arrayList2 = new ArrayList<org.netbeans.editor.MultiKeyBinding>();
        List list2 = this.getKBList();
        Iterator iterator = map.keySet().iterator();
        block0: while (iterator.hasNext()) {
            org.netbeans.editor.MultiKeyBinding multiKeyBinding;
            int n;
            String string = (String)iterator.next();
            if (!(map.get(string) instanceof String)) continue;
            String string2 = (String)map.get(string);
            String string3 = new String("macro-" + string);
            if (string2.length() != 0) {
                for (n = 0; n < list.size(); ++n) {
                    if (!(list.get(n) instanceof org.netbeans.editor.MultiKeyBinding)) continue;
                    multiKeyBinding = (org.netbeans.editor.MultiKeyBinding)list.get(n);
                    if (!string3.equals(multiKeyBinding.actionName)) continue;
                    arrayList2.add(multiKeyBinding);
                    continue block0;
                }
                continue;
            }
            for (n = 0; n < list2.size(); ++n) {
                if (!(list2.get(n) instanceof org.netbeans.editor.MultiKeyBinding)) continue;
                multiKeyBinding = (org.netbeans.editor.MultiKeyBinding)list2.get(n);
                if (!string3.equals(multiKeyBinding.actionName)) continue;
                arrayList.add(multiKeyBinding);
                continue block0;
            }
        }
        if (arrayList.size() > 0 || arrayList2.size() > 0) {
            list2.removeAll(arrayList);
            list2.addAll(arrayList2);
            this.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(this.getKBList()), OptionUtilities.makeKeyBindingsMap(list2), true));
            Settings.setValue((Class)this.getKitClass(), (String)"key-bindings", (Object)list2);
        }
    }

    public Map getMacroMap() {
        this.loadDefaultMacros();
        this.loadSettings(MacrosMIMEProcessor.class);
        Map map = (Map)super.getSettingValue("macro-map");
        if (map == null) {
            Utilities.annotateLoggable((Throwable)new NullPointerException("settingsMap is null for kit:" + this.getKitClass()));
        }
        HashMap<Object, List> hashMap = map == null ? new HashMap<Object, List>() : new HashMap(map);
        hashMap.put(null, this.getKBList());
        return hashMap;
    }

    public void setMacroDiffMap(Map map) {
        if (map != null && map.size() > 0) {
            this.updateSettings(MacrosMIMEProcessor.class, map);
        }
    }

    public void setMacroMap(Map map, boolean bl) {
        Map map2 = null;
        ArrayList arrayList = new ArrayList();
        if (map.containsKey(null)) {
            arrayList.addAll((List)map.get(null));
            map.remove(null);
        }
        if (bl) {
            this.loadDefaultMacros();
            map2 = OptionUtilities.getMapDiff(this.getMacroMap(), map, true);
            if (map2.containsKey(null)) {
                map2.remove(null);
            }
            if (map2.size() > 0) {
                this.processMacroKeyBindings(map2, arrayList);
                this.updateSettings(MacrosMIMEProcessor.class, map2);
            }
        }
        super.setSettingValue("macro-map", map);
    }

    public void setMacroMap(Map map) {
        this.setMacroMap(map, true);
    }

    public Insets getMargin() {
        return (Insets)this.getSettingValue(MARGIN_PROP);
    }

    public void setMargin(Insets insets) {
        this.setSettingValue(MARGIN_PROP, insets, MARGIN_PROP);
    }

    public boolean getStatusBarVisible() {
        return this.getSettingBoolean("status-bar-visible");
    }

    public void setStatusBarVisible(boolean bl) {
        this.setSettingBoolean("status-bar-visible", bl, STATUS_BAR_VISIBLE_PROP);
    }

    public int getStatusBarCaretDelay() {
        return this.getSettingInteger("status-bar-caret-delay");
    }

    public void setStatusBarCaretDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("status-bar-caret-delay", n, STATUS_BAR_CARET_DELAY_PROP);
    }

    public boolean getFindHighlightSearch() {
        return this.getSettingBoolean("find-highlight-search");
    }

    public void setFindHighlightSearch(boolean bl) {
        this.setSettingBoolean("find-highlight-search", bl, FIND_HIGHLIGHT_SEARCH_PROP);
    }

    public boolean getFindBlockSearch() {
        return this.getSettingBoolean("find-block-search");
    }

    public void setFindBlockSearch(boolean bl) {
        this.setSettingBoolean("find-block-search", bl, FIND_BLOCK_SEARCH_PROP);
    }

    public boolean getFindIncSearch() {
        return this.getSettingBoolean("find-inc-search");
    }

    public void setFindIncSearch(boolean bl) {
        this.setSettingBoolean("find-inc-search", bl, FIND_INC_SEARCH_PROP);
    }

    public int getFindIncSearchDelay() {
        return this.getSettingInteger("find-inc-search-delay");
    }

    public void setFindIncSearchDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("find-inc-search-delay", n, FIND_INC_SEARCH_DELAY_PROP);
    }

    public boolean getFindWrapSearch() {
        return this.getSettingBoolean("find-wrap-search");
    }

    public void setFindWrapSearch(boolean bl) {
        this.setSettingBoolean("find-wrap-search", bl, FIND_WRAP_SEARCH_PROP);
    }

    public boolean getFindSmartCase() {
        return this.getSettingBoolean("find-smart-case");
    }

    public void setFindSmartCase(boolean bl) {
        this.setSettingBoolean("find-smart-case", bl, FIND_SMART_CASE_PROP);
    }

    public Map getFindHistory() {
        return new HashMap((Map)this.getSettingValue("find-history"));
    }

    public void setFindHistory(Map map) {
        this.setSettingValue("find-history", map, FIND_HISTORY_PROP);
    }

    public int getFindHistorySize() {
        return this.getSettingInteger("find-history-size");
    }

    public void setFindHistorySize(int n) {
        this.setSettingInteger("find-history-size", n, FIND_HISTORY_SIZE_PROP);
    }

    public Color getTextLimitLineColor() {
        this.loadSettings(FontsColorsMIMEProcessor.class);
        return (Color)super.getSettingValue("text-limit-line-color");
    }

    public void setTextLimitLineColor(Color color) {
        this.setTextLimitLineColor(color, true);
    }

    public void setTextLimitLineColor(Color color, boolean bl) {
        if (bl && !this.getTextLimitLineColor().equals(color) && color != null) {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            hashMap.put("text-limit-line-color", color);
            if (hashMap != null) {
                this.updateSettings(FontsColorsMIMEProcessor.class, hashMap);
            }
        }
        super.setSettingValue("text-limit-line-color", color, TEXT_LIMIT_LINE_COLOR_PROP);
    }

    public int getTextLimitWidth() {
        return this.getSettingInteger("text-limit-width");
    }

    public void setTextLimitWidth(int n) {
        if (n <= 0) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingInteger("text-limit-width", n, TEXT_LIMIT_WIDTH_PROP);
    }

    public boolean getTextLimitLineVisible() {
        return this.getSettingBoolean("text-limit-line-visible");
    }

    public void setTextLimitLineVisible(boolean bl) {
        this.setSettingBoolean("text-limit-line-visible", bl, TEXT_LIMIT_LINE_VISIBLE_PROP);
    }

    public boolean getHighlightMatchingBracket() {
        return this.getSettingBoolean("highlight-match-brace");
    }

    public void setHighlightMatchingBracket(boolean bl) {
        this.setSettingBoolean("highlight-match-brace", bl, HIGHLIGHT_MATCHING_BRACKET_PROP);
    }

    public boolean getHighlightCaretRow() {
        return this.getSettingBoolean("highlight-caret-row");
    }

    public void setHighlightCaretRow(boolean bl) {
        this.setSettingBoolean("highlight-caret-row", bl, HIGHLIGHT_CARET_ROW_PROP);
    }

    public boolean isToolbarVisible() {
        return this.getSettingBoolean(TOOLBAR_VISIBLE_PROP);
    }

    public void setToolbarVisible(boolean bl) {
        this.setSettingBoolean(TOOLBAR_VISIBLE_PROP, bl, TOOLBAR_VISIBLE_PROP);
    }

    public boolean isTextAntialiasing() {
        Boolean bl = (Boolean)this.getSettingValue(TEXT_ANTIALIASING_PROP);
        if (bl != null) {
            return bl;
        }
        if (Boolean.getBoolean("javax.aatext")) {
            return true;
        }
        if (org.openide.util.Utilities.getOperatingSystem() == 4096) {
            return true;
        }
        return BaseOptions.isSystemAntialias();
    }

    private static boolean isSystemAntialias() {
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            Object v = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            boolean bl = v != null && v != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && v != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            return bl;
        }
        return false;
    }

    public void setTextAntialiasing(boolean bl) {
        this.setSettingBoolean(TEXT_ANTIALIASING_PROP, bl, TEXT_ANTIALIASING_PROP);
        Settings.touchValue((Class)this.getKitClass(), (String)"rendering-hints");
    }

    public Map getCodeFoldingProps() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Boolean bl = (Boolean)this.getSettingValue("code-folding-enable");
        hashMap.put("code-folding-enable", bl);
        return hashMap;
    }

    public void setCodeFoldingProps(Map map) {
        String string = "code-folding-enable";
        this.setSettingValue(string, map.get(string));
    }

    public void initPopupMenuItems() {
        List list = this.getOrderedMultiPropertyFolderFiles("Popup");
    }

    public List getOrderedMultiPropertyFolderFiles(String string) {
        MultiPropertyFolder multiPropertyFolder;
        MIMEOptionFolder mIMEOptionFolder;
        if (!BASE.equals(this.getTypeName()) && (mIMEOptionFolder = this.getMIMEFolder()) != null && (multiPropertyFolder = mIMEOptionFolder.getMPFolder(string, false)) != null) {
            DataFolder dataFolder = multiPropertyFolder.getDataFolder();
            ArrayList arrayList = new ArrayList();
            Object object = dataFolder.getPrimaryFile().getAttributes();
            while (object.hasMoreElements()) {
                arrayList.add(object.nextElement());
            }
            if (multiPropertyFolder.getProperties().size() != 0 || arrayList.size() != 0) {
                object = new HashSet(OptionUtilities.getGlobalMenuItems(string));
                object.addAll(multiPropertyFolder.getProperties());
                HashSet hashSet = new HashSet(OptionUtilities.getGlobalAttribs(string));
                hashSet.addAll(arrayList);
                return OptionUtilities.arrangeMergedFolderObjects((Set)object, hashSet);
            }
        }
        return OptionUtilities.getGlobalMenuItems(string);
    }

    public IndentEngine getIndentEngine() {
        Object object;
        MIMEOptionFolder mIMEOptionFolder;
        if (this.inReadExternal) {
            return this.readExternalIndentEngine;
        }
        if (!BASE.equals(this.getTypeName())) {
            Map map;
            Object v;
            this.loadSettings(PropertiesMIMEProcessor.class);
            mIMEOptionFolder = this.getMIMEFolder();
            if (mIMEOptionFolder != null && (object = mIMEOptionFolder.getFile(PropertiesMIMEProcessor.class, false)) != null && (v = (map = ((MIMEOptionFile)object).getAllProperties()).get(INDENT_ENGINE_PROP)) instanceof String) {
                Object object2 = null;
                String string = (String)v;
                if (string.equals(NO_INDENT_ENGINE)) {
                    return IndentEngine.getDefault();
                }
                Lookup.Template template = new Lookup.Template(null, string, null);
                Lookup.Item item = Lookup.getDefault().lookupItem(template);
                if (item != null && (object2 = item.getInstance()) instanceof IndentEngine) {
                    return (IndentEngine)object2;
                }
            }
        }
        if ((object = this.getProperty(INDENT_ENGINE_PROP)) instanceof ServiceType.Handle) {
            mIMEOptionFolder = (IndentEngine)((ServiceType.Handle)object).getServiceType();
            if (mIMEOptionFolder != null) {
                this.setIndentEngine((IndentEngine)mIMEOptionFolder);
                return mIMEOptionFolder;
            }
        } else if (object instanceof IndentEngine) {
            this.setIndentEngine((IndentEngine)object);
            return (IndentEngine)object;
        }
        if ((mIMEOptionFolder = this.findDefaultIndentEngine()) != null) {
            this.setIndentEngine((IndentEngine)mIMEOptionFolder);
        }
        return mIMEOptionFolder;
    }

    public void setIndentEngine(IndentEngine indentEngine) {
        if (!this.inReadExternal) {
            Object object;
            String string = null;
            if (indentEngine != null) {
                object = new Lookup.Template(null, null, (Object)indentEngine);
                Lookup.Item item = Lookup.getDefault().lookupItem((Lookup.Template)object);
                if (item != null) {
                    string = item.getId();
                }
            }
            if (!BASE.equals(this.getTypeName())) {
                object = new HashMap();
                if (string == null) {
                    string = NO_INDENT_ENGINE;
                }
                object.put(INDENT_ENGINE_PROP, string);
                this.updateSettings(PropertiesMIMEProcessor.class, (Map)object, false);
            }
            this.refreshIndentEngineSettings();
        }
    }

    private void refreshIndentEngineSettings() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Settings.touchValue((Class)BaseOptions.this.getKitClass(), (String)BaseOptions.INDENT_ENGINE_PROP);
                Settings.touchValue((Class)BaseOptions.this.getKitClass(), (String)"formatter");
            }
        });
    }

    protected Class getDefaultIndentEngineClass() {
        return SimpleIndentEngine.class;
    }

    private IndentEngine findDefaultIndentEngine() {
        if (this.getDefaultIndentEngineClass() != null) {
            return (IndentEngine)Lookup.getDefault().lookup(this.getDefaultIndentEngineClass());
        }
        return null;
    }

    public void setOptionsVersion(int n) {
        int n2 = this.optionsVersion;
        this.optionsVersion = n;
        if (n != n2) {
            this.firePropertyChange(OPTIONS_VERSION_PROP, new Integer(n2), new Integer(n));
        }
    }

    public int getOptionsVersion() {
        return this.optionsVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternalIndentEngine = this.getIndentEngine();
        this.inReadExternal = true;
        this.optionsVersion = 0;
        try {
            try {
                super.readExternal(objectInput);
            }
            catch (OptionalDataException optionalDataException) {
                Object var4_3 = null;
                this.refreshIndentEngineSettings();
                this.optionsVersion = 21;
                this.inReadExternal = false;
                this.readExternalIndentEngine = null;
            }
            Object var4_2 = null;
            this.refreshIndentEngineSettings();
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.refreshIndentEngineSettings();
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
            throw throwable;
        }
    }

    protected void upgradeOptions(int n, int n2) {
    }

    private void loadSettings(Class clazz) {
        MIMEOptionFile mIMEOptionFile;
        if (BASE.equals(this.getTypeName())) {
            MIMEOptionFolder mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, false);
        } else {
            MIMEOptionFolder mIMEOptionFolder = this.getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, false);
        }
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings();
        }
    }

    private void updateSettings(Class clazz, Map map) {
        this.updateSettings(clazz, map, true);
    }

    private void updateSettings(Class clazz, Map map, boolean bl) {
        MIMEOptionFile mIMEOptionFile;
        MIMEOptionFolder mIMEOptionFolder;
        if (this.usingNewOptions && clazz == FontsColorsMIMEProcessor.class) {
            return;
        }
        if (BASE.equals(this.getTypeName())) {
            mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, true);
        } else {
            mIMEOptionFolder = this.getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, true);
        }
        final Map map2 = map;
        final MIMEOptionFile mIMEOptionFile2 = mIMEOptionFile;
        if (mIMEOptionFile2 != null) {
            if (bl) {
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        mIMEOptionFile2.updateSettings(map2);
                    }
                });
            } else {
                mIMEOptionFile2.updateSettings(map2);
            }
        } else {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!" + clazz.toString() + " type file haven't been found in folder:" + mIMEOptionFolder.getDataFolder());
        }
    }

    public void setSettingValue(String string, Object object) {
        this.setSettingValue(string, object, string);
    }

    private boolean isTheSame(String string, Object object) {
        if (string == null || string.equals(INDENT_ENGINE_PROP) || string.equals("formatter")) {
            return true;
        }
        Object object2 = this.getSettingValue(string);
        return object2 == null && object == null || object2 != null && object2.equals(object);
    }

    public void setSettingValue(String string, Object object, String string2) {
        if (!this.isTheSame(string, object)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(string, object);
            this.updateSettings(PropertiesMIMEProcessor.class, hashMap);
        }
        super.setSettingValue(string, object, string2);
    }

    public Object getSettingValue(String string) {
        this.loadSettings(PropertiesMIMEProcessor.class);
        return super.getSettingValue(string);
    }

    protected final void setSettingBoolean(String string, boolean bl, String string2) {
        this.setSettingValue(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    protected final void setSettingInteger(String string, int n, String string2) {
        this.setSettingValue(string, new Integer(n));
    }

    protected void loadXMLSettings() {
        if (this.usingNewOptions) {
            this.updateKeybindingsFromNewOptionsDialogAttributes();
        } else {
            this.getKeyBindingList();
        }
        this.getAbbrevMap();
        this.getMacroMap();
        if (this.usingNewOptions) {
            this.updateColoringsFromNewOptionsDialogAttributes();
        } else {
            this.loadSettings(FontsColorsMIMEProcessor.class);
        }
        this.loadSettings(PropertiesMIMEProcessor.class);
    }

    public void writeExternal() throws IOException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    public static void setCodeTemplateExpandKey(KeyStroke keyStroke) {
        String string = OptionUtilities.keyToString(keyStroke);
        BaseOptions baseOptions = BaseOptions.getOptions(BaseKit.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CODE_TEMPLATE_EXPAND_KEY, string);
        baseOptions.updateSettings(PropertiesMIMEProcessor.class, hashMap);
    }

    public static KeyStroke getCodeTemplateExpandKey() {
        MIMEOptionFile mIMEOptionFile;
        MIMEOptionFolder mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mIMEOptionFolder != null && (mIMEOptionFile = mIMEOptionFolder.getFile(PropertiesMIMEProcessor.class, false)) != null) {
            Map map;
            String string;
            if (!mIMEOptionFile.isLoaded()) {
                mIMEOptionFile.loadSettings(false);
            }
            if ((string = (String)(map = mIMEOptionFile.getAllProperties()).get(CODE_TEMPLATE_EXPAND_KEY)) != null) {
                return OptionUtilities.stringToKey(string);
            }
        }
        return KeyStroke.getKeyStroke(32, 0);
    }
}

