/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.KeySequenceInputPanel;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.options.KeyBindingsEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class KeyBindingsEditorPanel
extends JPanel {
    private ActionDescriptor[] acts;
    private int actionIndex;
    private String kitClassName;
    private KeyBindingsEditor editor;
    private ButtonGroup sortGroup;
    private JList sequencesList;
    private JButton addSequenceButton;
    private JPanel sortButtonsPanel;
    private JPanel actionsPanel;
    private JScrollPane sequencesScrollPane;
    private JRadioButton actionSortRadioButton;
    private JPanel sequencesPanel;
    private JScrollPane actionsScrollPane;
    private JRadioButton nameSortRadioButton;
    private JButton removeSequenceButton;
    private JLabel sequencesLabel;
    private JList actionsList;

    public KeyBindingsEditorPanel(KeyBindingsEditor keyBindingsEditor) {
        this.editor = keyBindingsEditor;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Panel"));
        this.sequencesLabel.setDisplayedMnemonic(this.getBundleString("KBEP_Sequences_Mnemonic").charAt(0));
        this.actionsList.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_KBEP_Actions"));
        this.actionsList.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Actions"));
        this.sequencesList.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Sequences"));
        this.nameSortRadioButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_name_sort_button"));
        this.actionSortRadioButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_action_sort_button"));
        this.addSequenceButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Add"));
        this.removeSequenceButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_KBEP_Remove"));
        this.sortGroup = new ButtonGroup();
        this.sortGroup.add(this.actionSortRadioButton);
        this.sortGroup.add(this.nameSortRadioButton);
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage((Class)KeyBindingsEditorPanel.class, (String)string);
    }

    public void setValue(List list) {
        Object object;
        Object object2;
        if (list == null) {
            return;
        }
        this.kitClassName = (String)list.get(0);
        Class<?> clazz = null;
        try {
            object2 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            clazz = Class.forName(this.kitClassName, true, (ClassLoader)object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
            return;
        }
        object2 = clazz;
        if (object2 == BaseKit.class) {
            object2 = NbEditorKit.class;
        }
        Action[] actionArray = BaseKit.getKit((Class)object2).getActions();
        TreeMap<String, Settings.KitAndValue[]> treeMap = new TreeMap<String, Settings.KitAndValue[]>();
        for (int i = 0; i < actionArray.length; ++i) {
            if (actionArray[i] != null && (object = actionArray[i].getValue("no-keybinding")) instanceof Boolean && ((Boolean)object).booleanValue()) continue;
            object = new ActionDescriptor(actionArray[i]);
            treeMap.put(object.name, (Settings.KitAndValue[])object);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        object = Settings.getValueHierarchy(clazz2, (String)"key-bindings");
        for (int i = ((Settings.KitAndValue[])object).length - 1; i >= 0; --i) {
            this.addKeyBindingList(treeMap, ((List)object[i].value).iterator(), true);
        }
        this.addKeyBindingList(treeMap, list.listIterator(1), false);
        this.acts = treeMap.values().toArray(new ActionDescriptor[0]);
        if (this.acts.length > 0) {
            this.addSequenceButton.setEnabled(true);
        }
        Arrays.sort(this.acts);
        this.actionsList.setListData(this.acts);
        this.actionsList.setSelectedIndex(this.actionIndex);
        this.updateSequences(0);
        if (ActionDescriptor.getSortMode() == 0) {
            this.actionSortRadioButton.setSelected(true);
        } else {
            this.nameSortRadioButton.setSelected(true);
        }
    }

    private void addKeyBindingList(Map map, Iterator iterator, boolean bl) {
        while (iterator.hasNext()) {
            KeySequence keySequence;
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)iterator.next();
            ActionDescriptor actionDescriptor = (ActionDescriptor)map.get(multiKeyBinding.actionName);
            if (actionDescriptor == null || (keySequence = this.getKeySequenceForBinding(bl, multiKeyBinding)) == null) continue;
            actionDescriptor.sequences.add(keySequence);
        }
    }

    private KeySequence getKeySequenceForBinding(boolean bl, MultiKeyBinding multiKeyBinding) {
        KeyStroke[] keyStrokeArray = multiKeyBinding.keys;
        if (keyStrokeArray == null) {
            if (multiKeyBinding.key == null) {
                return null;
            }
            keyStrokeArray = new KeyStroke[]{multiKeyBinding.key};
        }
        return new KeySequence(bl, keyStrokeArray);
    }

    public List getValue() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.kitClassName);
        for (int i = 0; i < this.acts.length; ++i) {
            String string = this.acts[i].name;
            Iterator iterator = this.acts[i].sequences.iterator();
            while (iterator.hasNext()) {
                KeySequence keySequence = (KeySequence)iterator.next();
                if (keySequence.isInherited()) continue;
                vector.add((String)new MultiKeyBinding(keySequence.getKeyStrokes(), string));
            }
        }
        return vector;
    }

    private void updateSequences(int n) {
        Vector vector = this.acts[this.actionIndex].sequences;
        this.sequencesList.setListData(vector);
        if (vector.size() > 0) {
            this.sequencesList.setSelectedIndex(n);
        }
    }

    private void updateRemoveButton() {
        int n = this.sequencesList.getSelectedIndex();
        Vector vector = this.acts[this.actionIndex].sequences;
        boolean bl = n >= 0 && n < vector.size() && !((KeySequence)vector.get(n)).isInherited();
        this.removeSequenceButton.setEnabled(bl);
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void sortActionsList() {
        int n = this.actionSortRadioButton.isSelected() ? 0 : 1;
        ActionDescriptor.setSortMode(n);
        ActionDescriptor actionDescriptor = this.acts[this.actionIndex];
        Arrays.sort(this.acts);
        int n2 = 0;
        for (int i = 0; i < this.acts.length; ++i) {
            if (this.acts[i] != actionDescriptor) continue;
            n2 = i;
            break;
        }
        this.actionsList.setListData(this.acts);
        this.actionIndex = n2;
        this.actionsList.setSelectedIndex(this.actionIndex);
        this.actionsList.ensureIndexIsVisible(this.actionIndex);
        this.actionsList.requestFocus();
    }

    private void initComponents() {
        this.actionsPanel = new JPanel();
        this.sortButtonsPanel = new JPanel();
        this.nameSortRadioButton = new JRadioButton();
        this.actionSortRadioButton = new JRadioButton();
        this.actionsScrollPane = new JScrollPane();
        this.actionsList = new JList();
        this.sequencesPanel = new JPanel();
        this.sequencesLabel = new JLabel();
        this.sequencesScrollPane = new JScrollPane();
        this.sequencesList = new JList();
        this.addSequenceButton = new JButton();
        this.removeSequenceButton = new JButton();
        this.setLayout(new BorderLayout(0, 12));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.actionsPanel.setLayout(new GridBagLayout());
        this.actionsPanel.setBorder(new TitledBorder(new EmptyBorder(new Insets(0, 0, 0, 0)), this.getBundleString("KBEP_Actions")));
        this.sortButtonsPanel.setLayout(new GridBagLayout());
        this.nameSortRadioButton.setMnemonic(this.getBundleString("KBEP_name_sort_button_mnemonic").charAt(0));
        this.nameSortRadioButton.setText(this.getBundleString("KBEP_name_sort_button"));
        this.nameSortRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsEditorPanel.this.nameSortRadioButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.sortButtonsPanel.add((Component)this.nameSortRadioButton, gridBagConstraints);
        this.actionSortRadioButton.setMnemonic(this.getBundleString("KBEP_action_sort_button_mnemonic").charAt(0));
        this.actionSortRadioButton.setText(this.getBundleString("KBEP_action_sort_button"));
        this.actionSortRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsEditorPanel.this.actionSortRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.sortButtonsPanel.add((Component)this.actionSortRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.actionsPanel.add((Component)this.sortButtonsPanel, gridBagConstraints);
        this.actionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KeyBindingsEditorPanel.this.actionsListValueChanged(listSelectionEvent);
            }
        });
        this.actionsScrollPane.setViewportView(this.actionsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.actionsPanel.add((Component)this.actionsScrollPane, gridBagConstraints);
        this.add((Component)this.actionsPanel, "Center");
        this.sequencesPanel.setLayout(new GridBagLayout());
        this.sequencesLabel.setLabelFor(this.sequencesList);
        this.sequencesLabel.setText(this.getBundleString("KBEP_Sequences"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 12);
        this.sequencesPanel.add((Component)this.sequencesLabel, gridBagConstraints);
        this.sequencesScrollPane.setPreferredSize(new Dimension(259, 80));
        this.sequencesList.setCellRenderer(new KeySequenceCellRenderer());
        this.sequencesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                KeyBindingsEditorPanel.this.sequencesListValueChanged(listSelectionEvent);
            }
        });
        this.sequencesScrollPane.setViewportView(this.sequencesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.sequencesPanel.add((Component)this.sequencesScrollPane, gridBagConstraints);
        this.addSequenceButton.setMnemonic(this.getBundleString("KBEP_Add_Mnemonic").charAt(0));
        this.addSequenceButton.setText(this.getBundleString("KBEP_Add"));
        this.addSequenceButton.setEnabled(false);
        this.addSequenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsEditorPanel.this.addSequenceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.sequencesPanel.add((Component)this.addSequenceButton, gridBagConstraints);
        this.removeSequenceButton.setMnemonic(this.getBundleString("KBEP_Remove_Mnemonic").charAt(0));
        this.removeSequenceButton.setText(this.getBundleString("KBEP_Remove"));
        this.removeSequenceButton.setEnabled(false);
        this.removeSequenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsEditorPanel.this.removeSequenceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.sequencesPanel.add((Component)this.removeSequenceButton, gridBagConstraints);
        this.add((Component)this.sequencesPanel, "South");
    }

    private void nameSortRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.sortActionsList();
    }

    private void actionSortRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.sortActionsList();
    }

    private void sequencesListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateRemoveButton();
    }

    private void addSequenceButtonActionPerformed(ActionEvent actionEvent) {
        KeySequence keySequence = new KeySequenceRequester().getKeySequence();
        if (keySequence == null) {
            return;
        }
        this.acts[this.actionIndex].sequences.add(keySequence);
        this.updateSequences(this.acts[this.actionIndex].sequences.size() - 1);
        this.notifyEditor();
    }

    private void removeSequenceButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.sequencesList.getSelectedIndex();
        if (n >= 0) {
            this.acts[this.actionIndex].sequences.remove(n);
            if (n >= this.acts[this.actionIndex].sequences.size()) {
                --n;
            }
            this.updateSequences(n);
            this.notifyEditor();
        }
    }

    private void actionsListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.actionsList.getSelectedIndex() < 0) {
            return;
        }
        this.actionIndex = this.actionsList.getSelectedIndex();
        this.updateSequences(0);
    }

    private static final class KeySequenceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public KeySequenceCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            if (object instanceof KeySequence && ((KeySequence)object).isInherited()) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }

    private static final class KeySequence {
        private boolean inherited;
        private KeyStroke[] sequence;

        KeySequence(boolean bl, KeyStroke[] keyStrokeArray) {
            this.inherited = bl;
            this.sequence = keyStrokeArray;
        }

        KeyStroke[] getKeyStrokes() {
            return this.sequence;
        }

        boolean isInherited() {
            return this.inherited;
        }

        public String toString() {
            return Utilities.keySequenceToString((KeyStroke[])this.sequence);
        }
    }

    private static final class ActionDescriptor
    implements Comparable {
        public static final int SORT_BY_ACTION = 0;
        public static final int SORT_BY_NAME = 1;
        private static int sortMode = 1;
        String name;
        String displayName;
        Vector sequences;

        ActionDescriptor(Action action) {
            this.name = (String)action.getValue("Name");
            String string = (String)action.getValue("ShortDescription");
            this.displayName = string == null ? this.name : string + " [" + this.name + "]";
            this.sequences = new Vector();
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object object) {
            if (sortMode == 0) {
                return this.name.compareTo(((ActionDescriptor)object).name);
            }
            return this.displayName.compareToIgnoreCase(((ActionDescriptor)object).displayName);
        }

        public static void setSortMode(int n) {
            sortMode = n;
        }

        public static int getSortMode() {
            return sortMode;
        }
    }

    private class KeySequenceRequester {
        KeySequenceInputPanel input;
        DialogDescriptor dd;
        Dialog dial;
        Object[] buttons;
        KeySequence retVal;

        KeySequenceRequester() {
            this.buttons = new Object[]{new JButton(KeyBindingsEditorPanel.this.getBundleString("KBEP_OK_LABEL")), new JButton(KeyBindingsEditorPanel.this.getBundleString("KBEP_CLEAR_LABEL")), DialogDescriptor.CANCEL_OPTION};
            this.retVal = null;
            ((JButton)this.buttons[0]).getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_KBEP_OK"));
            ((JButton)this.buttons[1]).getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_KBEP_CLEAR"));
            ((JButton)this.buttons[1]).setMnemonic(KeyBindingsEditorPanel.this.getBundleString("KBEP_CLEAR_Mnemonic").charAt(0));
            ((JButton)this.buttons[0]).setEnabled(false);
            this.input = new KeySequenceInputPanel();
            this.input.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ KeySequenceRequester this$1;
                {
                    this.this$1 = keySequenceRequester;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("keySequence" != propertyChangeEvent.getPropertyName()) {
                        return;
                    }
                    KeyStroke[] keyStrokeArray = this.this$1.input.getKeySequence();
                    String string = this.this$1.getCollisionString(keyStrokeArray);
                    this.this$1.input.setInfoText(string == null ? "" : string);
                    ((JButton)this.this$1.buttons[0]).setEnabled(string == null);
                }
            });
            this.dd = new DialogDescriptor((Object)this.input, KeyBindingsEditorPanel.this.getBundleString("KBEP_AddSequence"), true, this.buttons, this.buttons[0], 0, HelpCtx.DEFAULT_HELP, new ActionListener(this){
                private final /* synthetic */ KeySequenceRequester this$1;
                {
                    this.this$1 = keySequenceRequester;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.this$1.buttons[1]) {
                        this.this$1.input.clear();
                        this.this$1.input.requestFocus();
                    } else if (actionEvent.getSource() == this.this$1.buttons[0]) {
                        this.this$1.retVal = new KeySequence(false, this.this$1.input.getKeySequence());
                        this.this$1.dial.dispose();
                    }
                }
            });
        }

        KeySequence getKeySequence() {
            this.dial = DialogDisplayer.getDefault().createDialog(this.dd);
            this.input.requestFocus();
            this.dial.show();
            return this.retVal;
        }

        String getCollisionString(KeyStroke[] keyStrokeArray) {
            if (keyStrokeArray.length == 0) {
                return "";
            }
            for (int i = 0; i < KeyBindingsEditorPanel.this.acts.length; ++i) {
                Iterator iterator = ((KeyBindingsEditorPanel)KeyBindingsEditorPanel.this).acts[i].sequences.iterator();
                while (iterator.hasNext()) {
                    KeyStroke[] keyStrokeArray2 = ((KeySequence)iterator.next()).getKeyStrokes();
                    if (!this.isOverlapingSequence(keyStrokeArray2, keyStrokeArray)) continue;
                    Object[] objectArray = new Object[]{Utilities.keySequenceToString((KeyStroke[])keyStrokeArray2), KeyBindingsEditorPanel.this.acts[i]};
                    return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$options$KeyBindingsEditorPanel == null ? (class$org$netbeans$modules$editor$options$KeyBindingsEditorPanel = KeyBindingsEditorPanel.class$("org.netbeans.modules.editor.options.KeyBindingsEditorPanel")) : class$org$netbeans$modules$editor$options$KeyBindingsEditorPanel), (String)"KBEP_FMT_Collision", (Object[])objectArray);
                }
            }
            return null;
        }

        private boolean isOverlapingSequence(KeyStroke[] keyStrokeArray, KeyStroke[] keyStrokeArray2) {
            int n = Math.min(keyStrokeArray.length, keyStrokeArray2.length);
            while (n-- > 0) {
                if (keyStrokeArray[n].equals(keyStrokeArray2[n])) continue;
                return false;
            }
            return true;
        }
    }
}

