/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyBindingsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "bindings";
    public static final String TAG_BIND = "bind";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_ACTION_NAME = "actionName";
    public static final String ATTR_REMOVE = "remove";
    static final String FILENAME = "keybindings";

    public KeyBindingsMIMEOptionFile(BaseOptions baseOptions, Object object) {
        super(baseOptions, object);
    }

    private List getKBList() {
        int n;
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy((Class)this.base.getKitClass(), (String)"key-bindings");
        List<MultiKeyBinding> list = null;
        for (n = 0; n < kitAndValueArray.length; ++n) {
            if (kitAndValueArray[n].kitClass != this.base.getKitClass()) continue;
            list = (List)kitAndValueArray[n].value;
        }
        if (list == null) {
            list = new ArrayList();
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof MultiKeyBinding || e == null) continue;
            JTextComponent.KeyBinding keyBinding = (JTextComponent.KeyBinding)e;
            list.set(i, new MultiKeyBinding(keyBinding.key, keyBinding.actionName));
        }
        return new ArrayList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings(boolean bl) {
        Class clazz = Settings.class;
        synchronized (clazz) {
            Object object;
            if (this.base.usesNewOptionsDialog()) {
                return;
            }
            Document document = this.dom;
            Element element = document.getDocumentElement();
            if (!TAG_ROOT.equals(element.getTagName())) {
                return;
            }
            List list = this.getKBList();
            Map map = OptionUtilities.makeKeyBindingsMap(list);
            this.properties.clear();
            NodeList nodeList = element.getElementsByTagName(TAG_BIND);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = nodeList.item(i);
                Element element2 = (Element)object;
                if (element2 == null) continue;
                String string = element2.getAttribute(ATTR_KEY);
                String string2 = element2.getAttribute(ATTR_REMOVE);
                String string3 = element2.getAttribute(ATTR_ACTION_NAME);
                if (string3 == null) {
                    string3 = "";
                }
                if (string3.length() != 0 && !Boolean.valueOf(string2).booleanValue()) {
                    MultiKeyBinding multiKeyBinding;
                    if (string.indexOf(36) > 0) {
                        multiKeyBinding = new MultiKeyBinding(OptionUtilities.stringToKeys(string), string3);
                        this.properties.put(string, multiKeyBinding);
                        continue;
                    }
                    multiKeyBinding = new MultiKeyBinding(OptionUtilities.stringToKey(string), string3);
                    this.properties.put(string, multiKeyBinding);
                    continue;
                }
                this.properties.put(string, "");
            }
            if (this.properties.size() > 0) {
                map.putAll(this.properties);
                Iterator iterator = this.properties.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (!(this.properties.get(object) instanceof String)) continue;
                    map.remove(object);
                }
                if (bl) {
                    this.setLoaded(true);
                    this.base.setKeyBindingList(new ArrayList(map.values()), false);
                }
            }
            if (bl) {
                this.setLoaded(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSettings(Map map) {
        Class clazz = Settings.class;
        synchronized (clazz) {
            if (this.base.usesNewOptionsDialog()) {
                return;
            }
            this.properties.putAll(map);
            Document document = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
            Element element = document.getDocumentElement();
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap hashMap = this.base.getDefaultKeyBindingsMap();
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string;
                String string2 = (String)iterator.next();
                if (this.properties.get(string2) instanceof String) {
                    string = KeyBindingsMIMEOptionFile.tryRemoveKeyFromMap(document, this.properties, string2, hashMap, element);
                    if (string == null) continue;
                    arrayList.add(string);
                    string2 = string;
                    continue;
                }
                if (!(this.properties.get(string2) instanceof MultiKeyBinding)) continue;
                string = (MultiKeyBinding)this.properties.get(string2);
                String string3 = ((MultiKeyBinding)string).actionName;
                if (string3 == null) {
                    string3 = "";
                }
                boolean bl = true;
                if (hashMap.get(string2) instanceof MultiKeyBinding) {
                    object = ((MultiKeyBinding)hashMap.get((Object)string2)).actionName;
                    boolean bl2 = hashMap.containsKey(string2);
                    if (!bl2) {
                        String[] stringArray = KeyBindingsMIMEOptionFile.getPermutations(string2);
                        for (int i = 0; i < stringArray.length && !bl2; ++i) {
                            if (!(bl2 |= hashMap.containsKey(stringArray[i]))) continue;
                            string2 = stringArray[i];
                            break;
                        }
                    }
                    if (bl2 && string3.equals(object)) {
                        bl = false;
                    }
                }
                if (!bl) continue;
                object = document.createElement(TAG_BIND);
                object.setAttribute(ATTR_KEY, string2);
                object.setAttribute(ATTR_ACTION_NAME, string3);
                element.appendChild((Node)object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.properties.remove(arrayList.get(i));
            }
            document.getDocumentElement().normalize();
            this.saveSettings(document);
        }
    }

    private static String tryRemoveKeyFromMap(Document document, Map map, String string, Map map2, Element element) {
        if (map2.containsKey(string)) {
            KeyBindingsMIMEOptionFile.removeKeyFromMap(document, map, string, element);
            return string;
        }
        String[] stringArray = KeyBindingsMIMEOptionFile.getPermutations(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!map2.containsKey(stringArray[i])) continue;
            KeyBindingsMIMEOptionFile.removeKeyFromMap(document, map, string, element);
            return stringArray[i];
        }
        return null;
    }

    private static void removeKeyFromMap(Document document, Map map, String string, Element element) {
        Element element2 = document.createElement(TAG_BIND);
        element2.setAttribute(ATTR_KEY, string);
        element2.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
        element.appendChild(element2);
    }

    static String[] getPermutations(String string) {
        String[] stringArray;
        String string2 = 4 == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() ? "M" : "C";
        String string3 = "D";
        String string4 = System.getProperty("mrj.version") != null ? "C" : "A";
        String string5 = "O";
        int n = string.lastIndexOf("-");
        if (n == -1) {
            return new String[]{string};
        }
        String string6 = string.substring(n);
        String string7 = Utilities.replaceString((String)string.substring(0, n), (String)"-", (String)"");
        if (string7.length() > 1) {
            StringBuffer stringBuffer;
            HashSet<String> hashSet = new HashSet<String>(string7.length() * string7.length());
            int n2 = string.indexOf(string2);
            if (n2 != -1) {
                stringBuffer = new StringBuffer(string7);
                stringBuffer.replace(n2, n2 + 1, string3);
                hashSet.add(stringBuffer.toString() + string6);
                KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                n2 = string.indexOf(string4);
                if (n2 != -1) {
                    stringBuffer.replace(n2, n2 + 1, string5);
                    hashSet.add(stringBuffer.toString() + string6);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                } else {
                    n2 = string.indexOf(string5);
                    if (n2 != -1) {
                        stringBuffer.replace(n2, n2 + 1, string4);
                        hashSet.add(stringBuffer.toString() + string6);
                        KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                        KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                    }
                }
            } else {
                n2 = string.indexOf(string3);
                if (n2 != -1) {
                    stringBuffer = new StringBuffer(string7);
                    stringBuffer.replace(n2, n2 + 1, string2);
                    hashSet.add(stringBuffer.toString() + string6);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                    n2 = string.indexOf(string4);
                    if (n2 != -1) {
                        stringBuffer.replace(n2, n2 + 1, string5);
                        hashSet.add(stringBuffer.toString() + string6);
                        KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    } else {
                        n2 = string.indexOf(string5);
                        if (n2 != -1) {
                            stringBuffer.replace(n2, n2 + 1, string4);
                            hashSet.add(stringBuffer.toString() + string6);
                            KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                        }
                    }
                }
            }
            n2 = string.indexOf(string4);
            if (n2 != -1) {
                stringBuffer = new StringBuffer(string7);
                stringBuffer.replace(n2, n2 + 1, string5);
                hashSet.add(stringBuffer.toString() + string6);
                KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
            } else {
                stringBuffer = new StringBuffer(string7);
                n2 = string.indexOf(string5);
                if (n2 != -1) {
                    stringBuffer.replace(n2, n2 + 1, string4);
                    hashSet.add(stringBuffer.toString() + string6);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                }
            }
            KeyBindingsMIMEOptionFile.getAllPossibleOrderings(string7, string6, hashSet);
            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(string7.toCharArray(), hashSet, string6);
            return hashSet.toArray(new String[hashSet.size()]);
        }
        if (string2.equals(string7)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3 + string6;
        } else if (string4.equals(string7)) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = string5 + string6;
        } else if (string5.equals(string7)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = string4 + string6;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    static void getAllPossibleOrderings(String string, String string2, Collection collection) {
        char[] cArray = string.toCharArray();
        KeyBindingsMIMEOptionFile.mutate(cArray, collection, 0, string2);
        String[] stringArray = collection.toArray(new String[collection.size()]);
    }

    private static void mutate(char[] cArray, Collection collection, int n, String string) {
        if (n == cArray.length) {
            collection.add(new String(cArray) + string);
            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(cArray, collection, string);
            return;
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[n];
            cArray[n] = c;
            if (n >= cArray.length) continue;
            KeyBindingsMIMEOptionFile.mutate(cArray, collection, n + 1, string);
        }
    }

    static void createHyphenatedPermutation(char[] cArray, Collection collection, String string) {
        if (cArray.length == 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(new String(cArray));
        for (int i = cArray.length - 1; i >= 1; --i) {
            stringBuffer.insert(i, '-');
        }
        stringBuffer.append(string);
        collection.add(stringBuffer.toString());
    }
}

