/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.modules.editor.options.ScrollInsetsCustomEditor;
import org.openide.util.NbBundle;

public class ScrollInsetsEditor
extends PropertyEditorSupport {
    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new ScrollInsetsCustomEditor(this);
    }

    public String getAsText() {
        Insets insets = (Insets)this.getValue();
        if (insets == null) {
            return null;
        }
        return "[" + this.int2percent(insets.top) + ',' + this.int2percent(insets.left) + ',' + this.int2percent(insets.bottom) + ',' + this.int2percent(insets.right) + ']';
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int[] nArray = new int[4];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[] ,;", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n >= 4) {
                this.badFormat();
            }
            try {
                nArray[n++] = this.percent2int(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.badFormat();
            }
        }
        if (n != 4 && n > 0) {
            int n2 = nArray[n - 1];
            for (int i = n; i < 4; ++i) {
                nArray[i] = n2;
            }
        }
        this.setValue(new Insets(nArray[0], nArray[1], nArray[2], nArray[3]));
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage((Class)ScrollInsetsEditor.class, (String)string);
    }

    private void badFormat() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.getBundleString("SIE_EXC_BadFormatValue"));
    }

    private String int2percent(int n) {
        if (n < 0) {
            return "" + -n + '%';
        }
        return "" + n;
    }

    private int percent2int(String string) throws NumberFormatException {
        if ((string = string.trim()).endsWith("%")) {
            return -Integer.parseInt(string.substring(0, string.length() - 1));
        }
        return Integer.parseInt(string);
    }
}

