/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;

final class ChildrenArray
extends NodeAdapter {
    public Children children;
    private Node[] nodes;
    private Map map;
    private Reference ref;

    public Children getChildren() {
        return this.children;
    }

    protected void finalize() {
        this.children.finalizedChildrenArray(this.ref);
    }

    final void pointedBy(Reference reference) {
        this.ref = reference;
    }

    public Node[] nodes() {
        if (this.children == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.children.justComputeNodes();
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].reassignTo(this.children, this);
            }
            this.children.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    public void clear() {
        if (this.nodes != null) {
            this.nodes = null;
            this.children.registerChildrenArray(this, false);
        }
    }

    public void finalizeNodes() {
        Map map = this.map;
        if (map != null) {
            map.remove(null);
        }
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    public synchronized Collection nodesFor(Children.Info info) {
        Collection collection;
        if (this.map == null) {
            this.map = new WeakHashMap(7);
        }
        if ((collection = (Collection)this.map.get(info)) == null) {
            collection = info.entry.nodes();
            info.length = collection.size();
            this.map.put(info, collection);
        }
        return collection;
    }

    public synchronized void useNodes(Children.Info info, Collection collection) {
        if (this.map == null) {
            this.map = new WeakHashMap(7);
        }
        info.length = collection.size();
        this.map.put(info, collection);
    }

    public String toString() {
        return super.toString() + "  " + this.getChildren();
    }
}

