/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class IndexedPropertySupport
extends Node.IndexedProperty {
    protected Object instance;
    private Method setter;
    private Method getter;
    private Method indexedSetter;
    private Method indexedGetter;

    public IndexedPropertySupport(Object object, Class clazz, Class clazz2, Method method, Method method2, Method method3, Method method4) {
        super(clazz, clazz2);
        this.instance = object;
        this.setter = method2;
        this.getter = method;
        this.indexedSetter = method4;
        this.indexedGetter = method3;
    }

    public final void setDisplayName(String string) {
        super.setDisplayName(string);
    }

    public final void setName(String string) {
        super.setName(string);
    }

    public final void setShortDescription(String string) {
        super.setShortDescription(string);
    }

    public boolean canRead() {
        return this.getter != null;
    }

    public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canRead()) {
            throw new IllegalAccessException();
        }
        Object object = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
        return this.getter.invoke(object, new Object[0]);
    }

    public boolean canWrite() {
        return this.setter != null;
    }

    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canWrite()) {
            throw new IllegalAccessException();
        }
        Object object2 = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
        if (object != null && this.setter.getParameterTypes()[0].getComponentType().isPrimitive() && !object.getClass().getComponentType().isPrimitive()) {
            object = Utilities.toPrimitiveArray((Object[])((Object[])object));
        }
        this.setter.invoke(object2, object);
    }

    public boolean canIndexedRead() {
        return this.indexedGetter != null;
    }

    public Object getIndexedValue(int n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canIndexedRead()) {
            throw new IllegalAccessException();
        }
        Object object = Beans.getInstanceOf(this.instance, this.indexedGetter.getDeclaringClass());
        return this.indexedGetter.invoke(object, new Integer(n));
    }

    public boolean canIndexedWrite() {
        return this.indexedSetter != null;
    }

    public void setIndexedValue(int n, Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canIndexedWrite()) {
            throw new IllegalAccessException();
        }
        Object object2 = Beans.getInstanceOf(this.instance, this.indexedSetter.getDeclaringClass());
        this.indexedSetter.invoke(object2, new Integer(n), object);
    }
}

