/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class PropertySupport
extends Node.Property {
    private boolean canR;
    private boolean canW;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$openide$nodes$PropertySupport;
    static /* synthetic */ Class class$java$lang$String;

    public PropertySupport(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2) {
        super(clazz);
        this.setName(string);
        this.setDisplayName(string2);
        this.setShortDescription(string3);
        this.canR = bl;
        this.canW = bl2;
    }

    public boolean canRead() {
        return this.canR;
    }

    public boolean canWrite() {
        return this.canW;
    }

    public static final class Name
    extends PropertySupport {
        private final Node node;

        public Name(Node node) {
            this(node, NbBundle.getBundle((Class)(class$org$openide$nodes$PropertySupport == null ? (class$org$openide$nodes$PropertySupport = PropertySupport.class$("org.openide.nodes.PropertySupport")) : class$org$openide$nodes$PropertySupport)).getString("CTL_StandardName"), NbBundle.getBundle((Class)(class$org$openide$nodes$PropertySupport == null ? (class$org$openide$nodes$PropertySupport = PropertySupport.class$("org.openide.nodes.PropertySupport")) : class$org$openide$nodes$PropertySupport)).getString("CTL_StandardHint"));
        }

        public Name(Node node, String string, String string2) {
            super("name", class$java$lang$String == null ? (class$java$lang$String = PropertySupport.class$("java.lang.String")) : class$java$lang$String, string, string2, true, node.canRename());
            this.node = node;
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.node.getName();
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (!(object instanceof String)) {
                throw new IllegalAccessException();
            }
            String string = this.node.getName();
            this.node.setName((String)object);
            this.node.firePropertyChange("name", string, object);
        }
    }

    public static abstract class WriteOnly
    extends PropertySupport {
        public WriteOnly(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3, false, true);
        }

        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannod read from WriteOnly property");
        }
    }

    public static abstract class ReadOnly
    extends PropertySupport {
        public ReadOnly(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3, true, false);
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannot write to ReadOnly property");
        }
    }

    public static abstract class ReadWrite
    extends PropertySupport {
        public ReadWrite(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3, true, true);
        }
    }

    public static class Reflection
    extends Node.Property {
        protected Object instance;
        private Method setter;
        private Method getter;
        private Class propertyEditorClass;

        public Reflection(Object object, Class clazz, Method method, Method method2) {
            super(clazz);
            if (method != null && !Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public getter " + method);
            }
            if (method2 != null && !Modifier.isPublic(method2.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public setter " + method2);
            }
            this.instance = object;
            this.setter = method2;
            this.getter = method;
        }

        public Reflection(Object object, Class clazz, String string, String string2) throws NoSuchMethodException {
            this(object, clazz, string == null ? null : Reflection.findAccessibleClass(object.getClass()).getMethod(string, new Class[0]), string2 == null ? null : Reflection.findAccessibleClass(object.getClass()).getMethod(string2, clazz));
        }

        public Reflection(Object object, Class clazz, String string) throws NoSuchMethodException {
            this(object, clazz, Reflection.findGetter(object, clazz, string), Reflection.findAccessibleClass(object.getClass()).getMethod(Reflection.firstLetterToUpperCase(string, "set"), clazz));
        }

        private static Class findAccessibleClass(Class clazz) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                return clazz;
            }
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return class$java$lang$Object == null ? (class$java$lang$Object = PropertySupport.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return Reflection.findAccessibleClass(clazz2);
        }

        private static String firstLetterToUpperCase(String string, String string2) {
            switch (string.length()) {
                case 0: {
                    return string2;
                }
                case 1: {
                    return string2 + Character.toUpperCase(string.charAt(0));
                }
            }
            return string2 + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }

        private static Method findGetter(Object object, Class clazz, String string) throws NoSuchMethodException {
            try {
                return Reflection.findAccessibleClass(object.getClass()).getMethod(Reflection.firstLetterToUpperCase(string, "get"), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz != Boolean.TYPE) {
                    throw noSuchMethodException;
                }
                NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                return Reflection.findAccessibleClass(object.getClass()).getMethod(Reflection.firstLetterToUpperCase(string, "is"), new Class[0]);
            }
        }

        public boolean canRead() {
            return this.getter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.getter == null) {
                throw new IllegalAccessException();
            }
            Object object = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
            try {
                return this.getter.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    this.getter.setAccessible(true);
                    Object object2 = this.getter.invoke(object, new Object[0]);
                    this.getter.setAccessible(false);
                    return object2;
                }
                catch (Throwable throwable) {
                    try {
                        this.getter.setAccessible(false);
                        throw throwable;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        StringBuffer stringBuffer = new StringBuffer("Attempted to invoke method ");
                        stringBuffer.append(this.getter.getName());
                        stringBuffer.append(" from class ");
                        stringBuffer.append(this.getter.getDeclaringClass().getName());
                        stringBuffer.append(" on an instance of ");
                        stringBuffer.append(object.getClass().getName());
                        stringBuffer.append(" Problem:");
                        stringBuffer.append(illegalArgumentException.getMessage());
                        IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException(stringBuffer.toString());
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException2, (Throwable)illegalArgumentException);
                        throw illegalArgumentException2;
                    }
                }
            }
        }

        public boolean canWrite() {
            return this.setter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.setter == null) {
                throw new IllegalAccessException();
            }
            Object object2 = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
            try {
                this.setter.invoke(object2, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    this.setter.setAccessible(true);
                    this.setter.invoke(object2, object);
                }
                finally {
                    this.setter.setAccessible(false);
                }
            }
        }

        public PropertyEditor getPropertyEditor() {
            if (this.propertyEditorClass != null) {
                try {
                    return (PropertyEditor)this.propertyEditorClass.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    ErrorManager.getDefault().notify((Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().notify((Throwable)illegalAccessException);
                }
            }
            return super.getPropertyEditor();
        }

        public void setPropertyEditorClass(Class clazz) {
            this.propertyEditorClass = clazz;
        }
    }
}

