/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.Mutex;
import org.openide.util.actions.NodeAction;

public abstract class CookieAction
extends NodeAction {
    private static final String PROP_COOKIES = "cookies";
    public static final int MODE_ONE = 1;
    public static final int MODE_SOME = 2;
    public static final int MODE_ALL = 4;
    public static final int MODE_EXACTLY_ONE = 8;
    public static final int MODE_ANY = 7;
    private static final long serialVersionUID = 6031319415908298424L;
    private CookiesChangeListener listener = new CookiesChangeListener(this);

    protected abstract int mode();

    protected abstract Class[] cookieClasses();

    private Class[] getCookies() {
        Class[] classArray = (Class[])this.getProperty(PROP_COOKIES);
        if (classArray != null) {
            return classArray;
        }
        classArray = this.cookieClasses();
        this.putProperty(PROP_COOKIES, classArray);
        return classArray;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        this.listener.setNodes(nodeArray);
        return this.doEnable(nodeArray);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new CookieDelegateAction(this, lookup);
    }

    boolean doEnable(Node[] nodeArray) {
        int n = this.resolveSupported(nodeArray);
        if (n == 0) {
            return false;
        }
        int n2 = this.mode();
        return (n2 & 1) != 0 || (n2 & 4) != 0 && n == nodeArray.length || (n2 & 8) != 0 && nodeArray.length == 1 || (n2 & 2) != 0 && n < nodeArray.length;
    }

    private int resolveSupported(Node[] nodeArray) {
        int n = nodeArray.length;
        int n2 = 0;
        Class[] classArray = this.getCookies();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < classArray.length; ++j) {
                if (nodeArray[i].getLookup().lookupItem(new Lookup.Template(classArray[j])) == null) continue;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    static final class CookieDelegateAction
    extends NodeAction.DelegateAction
    implements NodeListener,
    Runnable {
        private NodeListener listener = NodeOp.weakNodeListener(this, null);
        private List nodes;

        public CookieDelegateAction(CookieAction cookieAction, Lookup lookup) {
            super(cookieAction, lookup);
            this.setNodes(this.nodes());
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.setNodes(this.nodes());
            this.superResultChanged(lookupEvent);
        }

        private void superResultChanged(LookupEvent lookupEvent) {
            super.resultChanged(lookupEvent);
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"cookie".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            Mutex.EVENT.readAccess((Runnable)this);
        }

        public void run() {
            this.superResultChanged(null);
        }

        private void setNodes(Node[] nodeArray) {
            this.detachListeners(this.nodes);
            if (nodeArray != null) {
                this.nodes = new ArrayList(nodeArray.length);
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.nodes.add(new WeakReference<Node>(nodeArray[i]));
                }
            }
            this.attachListeners(this.nodes);
        }

        private void detachListeners(List list) {
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)((Reference)iterator.next()).get();
                    if (node == null) continue;
                    node.removeNodeListener(this.listener);
                }
            }
        }

        private void attachListeners(List list) {
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)((Reference)iterator.next()).get();
                    if (node == null) continue;
                    node.addNodeListener(this.listener);
                }
            }
        }

        protected void finalize() {
            this.detachListeners(this.nodes);
        }
    }

    private static final class CookiesChangeListener
    extends NodeAdapter {
        private NodeListener listener = NodeOp.weakNodeListener(this, null);
        private List nodes;
        private Reference action;

        public CookiesChangeListener(CookieAction cookieAction) {
            this.action = new WeakReference<CookieAction>(cookieAction);
        }

        void setNodes(Node[] nodeArray) {
            List list = this.nodes;
            if (list != null) {
                this.detachListeners(list);
            }
            this.nodes = null;
            if (nodeArray != null) {
                this.nodes = new ArrayList(nodeArray.length);
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.nodes.add(new WeakReference<Node>(nodeArray[i]));
                }
                this.attachListeners(this.nodes);
            }
        }

        void detachListeners(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)((Reference)iterator.next()).get();
                if (node == null) continue;
                node.removeNodeListener(this.listener);
            }
        }

        void attachListeners(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)((Reference)iterator.next()).get();
                if (node == null) continue;
                node.addNodeListener(this.listener);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!"cookie".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            CookieAction cookieAction = (CookieAction)((Object)this.action.get());
            if (cookieAction == null) {
                return;
            }
            List list = this.nodes;
            if (list != null) {
                Object object;
                ArrayList<Node[]> arrayList = new ArrayList<Node[]>(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (Node)((Reference)iterator.next()).get();
                    if (object != null) {
                        arrayList.add((Node[])object);
                        continue;
                    }
                    return;
                }
                object = new Node[arrayList.size()];
                arrayList.toArray((T[])object);
                Mutex.EVENT.writeAccess(new Runnable(this, cookieAction, (Node[])object){
                    private final /* synthetic */ CookieAction val$a;
                    private final /* synthetic */ Node[] val$nodes2;
                    private final /* synthetic */ CookiesChangeListener this$0;
                    {
                        this.this$0 = cookiesChangeListener;
                        this.val$a = cookieAction;
                        this.val$nodes2 = nodeArray;
                    }

                    public void run() {
                        this.val$a.setEnabled(this.val$a.enable(this.val$nodes2));
                    }
                });
            }
        }

        protected void finalize() {
            this.detachListeners(this.nodes);
        }
    }
}

