/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;

public class CompoundFinder
implements JCFinder {
    private List finders;
    private Class kitClass;
    private static JCField artificialField = new JavaCompletion.BaseField(JavaCompletion.CLASS_CLASS, "class", JavaCompletion.CLASS_TYPE, 1);

    public CompoundFinder(List list, Class clazz) {
        this.finders = list;
        this.kitClass = clazz;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JCBaseFinder)) continue;
            ((JCBaseFinder)e).setParentFinder(this);
        }
    }

    public List findClasses(JCPackage jCPackage, String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.finders.size(); ++i) {
            JCFinder jCFinder = (JCFinder)this.finders.get(i);
            if (jCPackage == null) {
                arrayList.addAll(jCFinder.findClasses(null, string, bl));
                continue;
            }
            List list = jCFinder.findPackages(jCPackage.getName(), true, false);
            if (list.size() != 1) continue;
            JCPackage jCPackage2 = (JCPackage)list.iterator().next();
            arrayList.addAll(jCFinder.findClasses(jCPackage2, string, bl));
        }
        Collections.sort(arrayList, this.getNaturalSort() ? JCBaseFinder.NATURAL_MEMBER_NAME_COMPARATOR : JCBaseFinder.CLASS_NAME_COMPARATOR);
        return arrayList;
    }

    public List findFields(JCClass jCClass, String string, boolean bl, boolean bl2, boolean bl3) {
        List list = null;
        for (int i = this.finders.size(); i > 0; --i) {
            List list2 = ((JCFinder)this.finders.get(i - 1)).findFields(jCClass, string, bl, bl2, bl3);
            if (list2 == null || list2.size() <= 0) continue;
            if (list2.size() == 1 && list2.get(0).equals(artificialField)) {
                list = list2;
                continue;
            }
            return list2;
        }
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    public List findMethods(JCClass jCClass, String string, boolean bl, boolean bl2, boolean bl3) {
        for (int i = this.finders.size(); i > 0; --i) {
            List list = ((JCFinder)this.finders.get(i - 1)).findMethods(jCClass, string, bl, bl2, bl3);
            if (list == null || list.size() <= 0) continue;
            return list;
        }
        return new ArrayList();
    }

    public List findPackages(String string, boolean bl, boolean bl2) {
        TreeSet treeSet = this.getNaturalSort() ? new TreeSet(JCBaseFinder.INSENSITIVE_CLASS_NAME_COMPARATOR) : new TreeSet();
        for (int i = 0; i < this.finders.size(); ++i) {
            treeSet.addAll(((JCFinder)this.finders.get(i)).findPackages(string, bl, bl2));
        }
        return new ArrayList(treeSet);
    }

    public JCClass getExactClass(String string) {
        for (int i = this.finders.size(); i > 0; --i) {
            JCClass jCClass = ((JCFinder)this.finders.get(i - 1)).getExactClass(string);
            if (jCClass == null) continue;
            return jCClass;
        }
        return null;
    }

    public JCPackage getExactPackage(String string) {
        for (int i = this.finders.size(); i > 0; --i) {
            JCPackage jCPackage = ((JCFinder)this.finders.get(i - 1)).getExactPackage(string);
            if (jCPackage == null) continue;
            return jCPackage;
        }
        return null;
    }

    private boolean getNaturalSort() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
    }
}

