/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCBaseFinder
extends JavaCompletion.AbstractProvider
implements JCFinder {
    public static final Comparator CLASS_NAME_COMPARATOR = new DefaultClassNameComparator();
    public static final Comparator INSENSITIVE_CLASS_NAME_COMPARATOR = new InsensitiveClassNameComparator();
    public static final Comparator NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator(true);
    public static final Comparator INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator();
    private static final int PACKAGE_PRE_ALLOC = 1009;
    private static final int CLASS_PRE_ALLOC = 5003;
    protected JCPackage[] allPackages;
    protected JCClass[] allClassesByName;
    protected HashMap allPackagesMap = new HashMap(1009);
    protected HashMap allClassesMap = new HashMap(5003);
    private Boolean oldCaseSensitive = null;
    private Boolean oldNaturalSort = null;
    private Object sorted;
    private Class kitClass;
    private JCFinder parentFinder;

    public JCBaseFinder(Class clazz) {
        this.kitClass = clazz;
        this.parentFinder = this;
    }

    void setParentFinder(JCFinder jCFinder) {
        this.parentFinder = jCFinder;
    }

    public Iterator getClasses() {
        return new ArrayList<JCClass>(Arrays.asList(this.getAllClasses())).iterator();
    }

    public synchronized boolean append(JCClassProvider jCClassProvider) {
        return super.append(jCClassProvider);
    }

    public synchronized boolean remove(JCClassProvider jCClassProvider) {
        return super.remove(jCClassProvider);
    }

    protected boolean removeClass(JCClass jCClass) {
        this.invalidate();
        return this.allClassesMap.remove(jCClass.getFullName()) != null;
    }

    protected boolean appendClass(JCClass jCClass) {
        if (!this.cheapUpdate(jCClass)) {
            this.invalidate();
        }
        return true;
    }

    public synchronized void reset() {
        this.allClassesMap.clear();
        this.invalidate();
    }

    protected void invalidate() {
        this.allPackagesMap.clear();
        this.allPackages = null;
        this.allClassesByName = null;
    }

    public synchronized JCPackage getExactPackage(String string) {
        if (this.allPackages == null) {
            this.build();
        }
        return (JCPackage)this.allPackagesMap.get(string);
    }

    public synchronized JCClass getExactClass(String string) {
        return (JCClass)this.allClassesMap.get(string);
    }

    protected JCPackage[] getAllPackages() {
        if (this.allPackages == null) {
            this.build();
        }
        return this.allPackages;
    }

    protected JCClass[] getAllClassesByName() {
        if (this.allClassesByName == null) {
            this.build();
        }
        return this.allClassesByName;
    }

    protected JCClass[] getAllClasses() {
        Object[] objectArray = (JCClass[])this.getAllClassesByName().clone();
        Arrays.sort(objectArray);
        return objectArray;
    }

    private boolean cheapUpdate(JCClass jCClass) {
        JCClass jCClass2 = this.allClassesMap.put(jCClass.getFullName(), jCClass);
        if (this.allClassesByName != null && jCClass2 != null) {
            String string = jCClass.getPackageName();
            JCPackage jCPackage = (JCPackage)this.allPackagesMap.get(string);
            if (jCPackage == null) {
                return false;
            }
            Object[] objectArray = jCPackage.getClasses();
            int n = Arrays.binarySearch(objectArray, jCClass);
            if (n < 0) {
                return false;
            }
            objectArray[n] = jCClass;
            int n2 = n = this.getCaseSensitive() ? Arrays.binarySearch(this.allClassesByName, jCClass, CLASS_NAME_COMPARATOR) : Arrays.binarySearch(this.allClassesByName, jCClass, INSENSITIVE_CLASS_NAME_COMPARATOR);
            if (n < 0) {
                n = -n - 1;
            }
            String string2 = jCClass.getName();
            while (n >= 0 && n < this.allClassesByName.length && this.startsWith(this.allClassesByName[n].getName(), string2)) {
                --n;
            }
            ++n;
            boolean bl = false;
            while (n < this.allClassesByName.length) {
                if (jCClass.equals(this.allClassesByName[n])) {
                    this.allClassesByName[n] = jCClass;
                    bl = true;
                    break;
                }
                if (!string2.equals(this.allClassesByName[n].getName())) break;
                ++n;
            }
            return bl;
        }
        return false;
    }

    private void addPackage(JCPackage jCPackage, boolean bl) {
        if (bl || !this.allPackagesMap.containsKey(jCPackage)) {
            if (jCPackage.getName().length() == 0) {
                return;
            }
            this.allPackagesMap.put(jCPackage.getName(), jCPackage);
            String string = jCPackage.getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                this.addPackage(new JavaCompletion.BasePackage(string.substring(0, n)), false);
            }
        }
    }

    protected void build() {
        Object[] objectArray = new JCClass[this.allClassesMap.size()];
        this.allClassesByName = new JCClass[objectArray.length];
        Iterator iterator = this.allClassesMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = (JCClass)iterator.next();
            this.allClassesByName[n] = objectArray[n];
            ++n;
        }
        Arrays.sort(objectArray);
        if (this.getCaseSensitive()) {
            Arrays.sort(this.allClassesByName, CLASS_NAME_COMPARATOR);
            this.sorted = CLASS_NAME_COMPARATOR;
        } else {
            Arrays.sort(this.allClassesByName, INSENSITIVE_CLASS_NAME_COMPARATOR);
            this.sorted = INSENSITIVE_CLASS_NAME_COMPARATOR;
        }
        this.allPackagesMap.clear();
        this.allPackages = JavaCompletion.EMPTY_PACKAGES;
        if (objectArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            JavaCompletion.BasePackage basePackage = new JavaCompletion.BasePackage(objectArray[0].getPackageName());
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].getPackageName();
                if (!((Object)basePackage).equals(string)) {
                    JCClass[] jCClassArray = new JCClass[arrayList.size()];
                    arrayList.toArray(jCClassArray);
                    basePackage.setClasses(jCClassArray);
                    arrayList.clear();
                    this.addPackage(basePackage, true);
                    basePackage = new JavaCompletion.BasePackage(string);
                }
                arrayList.add(objectArray[i]);
            }
            JCClass[] jCClassArray = new JCClass[arrayList.size()];
            arrayList.toArray(jCClassArray);
            basePackage.setClasses(jCClassArray);
            this.addPackage(basePackage, true);
            this.allPackages = new JCPackage[this.allPackagesMap.size()];
            iterator = this.allPackagesMap.values().iterator();
            n = 0;
            while (iterator.hasNext()) {
                this.allPackages[n] = (JCPackage)iterator.next();
                ++n;
            }
        }
        Arrays.sort(this.allPackages);
    }

    public synchronized List findPackages(String string, boolean bl, boolean bl2) {
        String string2;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            object = this.getExactPackage(string);
            if (object != null) {
                arrayList.add(object);
            }
            if (!bl2) {
                return arrayList;
            }
        }
        object = this.getAllPackages();
        JavaCompletion.BasePackage basePackage = new JavaCompletion.BasePackage(string);
        if (!this.getCaseSensitive()) {
            Arrays.sort(object, INSENSITIVE_CLASS_NAME_COMPARATOR);
        }
        int n = Arrays.binarySearch(object, basePackage, this.getCaseSensitive() ? CLASS_NAME_COMPARATOR : INSENSITIVE_CLASS_NAME_COMPARATOR);
        int n2 = string.length();
        if (n < 0) {
            n = -n - 1;
        }
        while (n >= 0 && n < ((JCPackage[])object).length && this.startsWith(object[n].getName(), string)) {
            --n;
        }
        ++n;
        int n3 = basePackage.getDotCount();
        while (n < ((JCPackage[])object).length && this.startsWith(string2 = object[n].getName(), string)) {
            if (bl ? string2.length() > n2 && string2.charAt(n2) == '.' : bl2 || object[n].getDotCount() == n3) {
                arrayList.add(object[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public synchronized List findClasses(JCPackage jCPackage, String string, boolean bl) {
        String string2;
        int n;
        JCClass[] jCClassArray;
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        JavaCompletion.SimpleClass simpleClass = new JavaCompletion.SimpleClass(string, "");
        int n2 = string.length();
        if (jCPackage != null) {
            jCClassArray = jCPackage.getClasses();
            if (!this.getCaseSensitive()) {
                Arrays.sort(jCClassArray, INSENSITIVE_CLASS_NAME_COMPARATOR);
            }
        } else {
            jCClassArray = this.getAllClassesByName();
        }
        if (this.getCaseSensitive()) {
            if (!((Object)CLASS_NAME_COMPARATOR).equals(this.sorted)) {
                Arrays.sort(jCClassArray, CLASS_NAME_COMPARATOR);
                this.sorted = CLASS_NAME_COMPARATOR;
            }
            n = Arrays.binarySearch(jCClassArray, simpleClass, CLASS_NAME_COMPARATOR);
        } else {
            if (!((Object)INSENSITIVE_CLASS_NAME_COMPARATOR).equals(this.sorted)) {
                Arrays.sort(jCClassArray, INSENSITIVE_CLASS_NAME_COMPARATOR);
                this.sorted = INSENSITIVE_CLASS_NAME_COMPARATOR;
            }
            n = Arrays.binarySearch(jCClassArray, simpleClass, INSENSITIVE_CLASS_NAME_COMPARATOR);
        }
        if (n < 0) {
            n = -n - 1;
        }
        while (n >= 0 && n < jCClassArray.length && this.startsWith(jCClassArray[n].getName(), string)) {
            --n;
        }
        ++n;
        while (n < jCClassArray.length && this.startsWith(string2 = jCClassArray[n].getName(), string)) {
            if (!(bl && string2.length() != n2 || !this.showDeprecated() && JCUtilities.isDeprecated(jCClassArray[n]))) {
                arrayList.add(jCClassArray[n]);
            }
            ++n;
        }
        Collections.sort(arrayList, this.getNaturalSort() ? INSENSITIVE_CLASS_NAME_COMPARATOR : CLASS_NAME_COMPARATOR);
        return arrayList;
    }

    private List getOuterClasses(JCClass jCClass) {
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        arrayList.add(jCClass);
        int n = jCClass.getName().lastIndexOf(46);
        while (n >= 0) {
            int n2 = jCClass.getPackageName().length();
            String string = jCClass.getFullName().substring(0, (n2 > 0 ? n2 + 1 : 0) + n);
            if ((jCClass = this.parentFinder.getExactClass(string)) == null) break;
            if (this.showDeprecated() || !JCUtilities.isDeprecated(jCClass)) {
                arrayList.add(jCClass);
            }
            n = jCClass.getName().lastIndexOf(46);
        }
        return arrayList;
    }

    public synchronized List findFields(JCClass jCClass, String string, boolean bl, boolean bl2, boolean bl3) {
        return this.findFields(jCClass.getPackageName(), jCClass, string, bl, bl2, bl3);
    }

    synchronized List findFields(String string, JCClass jCClass, String string2, boolean bl, boolean bl2, boolean bl3) {
        TreeSet<Object> treeSet = this.getNaturalSort() ? new TreeSet<Object>(INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR) : new TreeSet(NATURAL_MEMBER_NAME_COMPARATOR);
        List list = this.getClassList(jCClass);
        String string3 = string;
        HashSet<JCClass> hashSet = new HashSet<JCClass>();
        JCClass jCClass2 = jCClass;
        for (int i = list.size() - 1; i >= 0; --i) {
            int n;
            jCClass = this.parentFinder.getExactClass(((JCClass)list.get(i)).getFullName());
            if (jCClass == null) continue;
            if (jCClass.isInterface()) {
                hashSet.add(jCClass);
            }
            hashSet.addAll(JCUtilities.getAllInterfaces(this.parentFinder, jCClass));
            boolean bl4 = string3 != null && !jCClass.getPackageName().equals(string3);
            List list2 = i == 0 && bl3 && jCClass.getName().indexOf(46) >= 0 ? this.getOuterClasses(jCClass) : null;
            int n2 = n = list2 != null ? list2.size() - 1 : -1;
            do {
                if (n >= 0) {
                    jCClass = (JCClass)list2.get(n--);
                }
                JCField[] jCFieldArray = jCClass.getFields();
                for (int j = 0; j < jCFieldArray.length; ++j) {
                    JCField jCField = jCFieldArray[j];
                    int n3 = jCField.getModifiers();
                    if (bl2 && (n3 & 8) == 0 || i > 0 && (n3 & 2) != 0 || bl4 && (n3 & 5) == 0 || n > -1 && (jCClass2.getModifiers() & 8) != 0 && (n3 & 8) == 0 || (!bl ? !this.startsWith(jCField.getName(), string2) : !jCField.getName().equals(string2))) continue;
                    if (jCClass2.equals(jCClass) && n == -1) {
                        jCField = new JavaCompletion.BaseField(jCClass, jCField.getName(), jCField.getType(), jCField.getModifiers() | 0x20000000);
                    }
                    if (!this.showDeprecated() && JCUtilities.isDeprecated(jCField)) continue;
                    treeSet.add(jCField);
                }
            } while (n >= 0);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            jCClass = this.parentFinder.getExactClass(((JCClass)object.next()).getFullName());
            if (jCClass == null) continue;
            JCField[] jCFieldArray = jCClass.getFields();
            for (int i = 0; i < jCFieldArray.length; ++i) {
                JCField jCField = jCFieldArray[i];
                if (!bl ? !this.startsWith(jCField.getName(), string2) : !jCField.getName().equals(string2)) continue;
                if (!this.showDeprecated() && JCUtilities.isDeprecated(jCField)) continue;
                treeSet.add(jCField);
            }
        }
        if (bl2 && (bl && "class".equals(string2) || !bl && this.startsWith("class", string2))) {
            object = new JavaCompletion.BaseField(JavaCompletion.CLASS_CLASS, "class", JavaCompletion.CLASS_TYPE, 1);
            treeSet.add(object);
        }
        return new ArrayList(treeSet);
    }

    public synchronized List findMethods(JCClass jCClass, String string, boolean bl, boolean bl2, boolean bl3) {
        return this.findMethods(jCClass.getPackageName(), jCClass, string, bl, bl2, bl3);
    }

    synchronized List findMethods(String string, JCClass jCClass, String string2, boolean bl, boolean bl2, boolean bl3) {
        TreeSet<JCMethod> treeSet = this.getNaturalSort() ? new TreeSet(INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR) : new TreeSet<JCMethod>();
        List list = this.getClassList(jCClass);
        String string3 = string;
        JCClass jCClass2 = jCClass;
        for (int i = list.size() - 1; i >= 0; --i) {
            int n;
            jCClass = this.parentFinder.getExactClass(((JCClass)list.get(i)).getFullName());
            if (jCClass == null) continue;
            boolean bl4 = !jCClass.getPackageName().equals(string3);
            List list2 = i == 0 && bl3 && jCClass.getName().indexOf(46) >= 0 ? this.getOuterClasses(jCClass) : null;
            int n2 = n = list2 != null ? list2.size() - 1 : -1;
            do {
                if (n >= 0) {
                    jCClass = (JCClass)list2.get(n--);
                }
                JCMethod[] jCMethodArray = jCClass.getMethods();
                for (int j = 0; j < jCMethodArray.length; ++j) {
                    JCMethod jCMethod = jCMethodArray[j];
                    int n3 = jCMethod.getModifiers();
                    if (bl2 && (n3 & 8) == 0 || i > 0 && (n3 & 2) != 0 || bl4 && (n3 & 5) == 0 || n > -1 && (jCClass2.getModifiers() & 8) != 0 && (n3 & 8) == 0 || (!bl ? !this.startsWith(jCMethod.getName(), string2) : !jCMethod.getName().equals(string2))) continue;
                    if (treeSet.contains(jCMethod)) {
                        treeSet.remove(jCMethod);
                    }
                    if (jCClass2.equals(jCClass) && n == -1) {
                        jCMethod = new JavaCompletion.BaseMethod(jCClass, jCMethod.getName(), jCMethod.getModifiers() | 0x20000000, jCMethod.getReturnType(), jCMethod.getParameters(), jCMethod.getExceptions());
                    }
                    if (!this.showDeprecated() && JCUtilities.isDeprecated(jCMethod)) continue;
                    treeSet.add(jCMethod);
                }
            } while (n >= 0);
        }
        return new ArrayList(treeSet);
    }

    private List getClassList(JCClass jCClass) {
        List<JCClass> list;
        boolean bl = true;
        if ((jCClass = this.getExactClass(jCClass.getFullName())) != null) {
            if (jCClass.isInterface()) {
                list = JCUtilities.getAllInterfaces(this.parentFinder, jCClass, bl);
                list.add(JavaCompletion.OBJECT_CLASS);
            } else {
                list = JCUtilities.getSuperclasses(this.parentFinder, jCClass);
                if ((jCClass.getModifiers() & 0x400) != 0) {
                    list.addAll(JCUtilities.getAllInterfaces(this.parentFinder, jCClass, bl));
                }
            }
            list.add(0, jCClass);
        } else {
            list = new ArrayList();
        }
        return list;
    }

    public String dumpClasses() {
        StringBuffer stringBuffer = new StringBuffer(8192);
        JCClass[] jCClassArray = this.getAllClasses();
        for (int i = 0; i < jCClassArray.length; ++i) {
            stringBuffer.append(JCUtilities.dumpClass(jCClassArray[i]));
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    private boolean getCaseSensitive() {
        boolean bl = SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
        if (this.oldCaseSensitive != null && this.oldCaseSensitive != bl) {
            this.invalidate();
        }
        this.oldCaseSensitive = bl;
        return bl;
    }

    private boolean getNaturalSort() {
        boolean bl = SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
        if (this.oldNaturalSort != null && this.oldNaturalSort != bl) {
            this.invalidate();
        }
        this.oldNaturalSort = bl;
        return bl;
    }

    boolean showDeprecated() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"show-deprecated-members", (Boolean)ExtSettingsDefaults.defaultShowDeprecatedMembers);
    }

    private boolean startsWith(String string, String string2) {
        return this.getCaseSensitive() ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public static final class NaturalMemberNameComparator
    implements Comparator {
        private boolean sensitive;

        public NaturalMemberNameComparator() {
            this(false);
        }

        private NaturalMemberNameComparator(boolean bl) {
            this.sensitive = bl;
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object instanceof JCMethod && object2 instanceof JCMethod) {
                int n;
                JCMethod jCMethod = (JCMethod)object;
                JCMethod jCMethod2 = (JCMethod)object2;
                int n2 = n = this.sensitive ? jCMethod.getName().compareTo(jCMethod2.getName()) : jCMethod.getName().compareToIgnoreCase(jCMethod2.getName());
                if (n == 0) {
                    JCParameter[] jCParameterArray = jCMethod.getParameters();
                    JCParameter[] jCParameterArray2 = jCMethod2.getParameters();
                    int n3 = Math.min(jCParameterArray.length, jCParameterArray2.length);
                    for (int i = 0; i < n3; ++i) {
                        int n4 = n = this.sensitive ? jCParameterArray[i].getType().getClazz().getName().compareTo(jCParameterArray2[i].getType().getClazz().getName()) : jCParameterArray[i].getType().getClazz().getName().compareToIgnoreCase(jCParameterArray2[i].getType().getClazz().getName());
                        if (n == 0) continue;
                        return n;
                    }
                    n = jCParameterArray.length - jCParameterArray2.length;
                }
                int n5 = jCMethod.getName().compareTo(jCMethod2.getName());
                if (n == 0 && n5 != 0) {
                    n = n5;
                }
                return n;
            }
            if (object instanceof JCField && object2 instanceof JCField) {
                JCField jCField = (JCField)object;
                JCField jCField2 = (JCField)object2;
                int n = this.sensitive ? jCField.getName().compareTo(jCField2.getName()) : jCField.getName().compareToIgnoreCase(jCField2.getName());
                int n6 = jCField.getName().compareTo(jCField2.getName());
                if (n == 0 && n6 != 0) {
                    n = n6;
                }
                return n;
            }
            return 0;
        }
    }

    public static final class InsensitiveClassNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object instanceof JCClass && object2 instanceof JCClass) {
                return ((JCClass)object).getName().compareToIgnoreCase(((JCClass)object2).getName());
            }
            if (object instanceof JCPackage && object2 instanceof JCPackage) {
                return ((JCPackage)object).getName().compareToIgnoreCase(((JCPackage)object2).getName());
            }
            return 0;
        }
    }

    public static final class DefaultClassNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object instanceof JCClass && object2 instanceof JCClass) {
                return ((JCClass)object).getName().compareTo(((JCClass)object2).getName());
            }
            if (object instanceof JCPackage && object2 instanceof JCPackage) {
                return ((JCPackage)object).getName().compareTo(((JCPackage)object2).getName());
            }
            return 0;
        }
    }
}

