/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;

public class JCPaintComponent
extends JPanel {
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    protected boolean isSelected;
    private String text;
    protected boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    private static final Color KEYWORD_COLOR = Color.darkGray;
    private static final Color TYPE_COLOR = Color.black;
    private Icon icon;

    public JCPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    protected void setDeprecated(boolean bl) {
        this.isDeprecated = bl;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawType(Graphics graphics, JCType jCType) {
        this.drawType(graphics, jCType, false);
    }

    protected void drawType(Graphics graphics, JCType jCType, boolean bl) {
        Color color = this.getTypeColor(jCType.getClazz().getName());
        this.drawString(graphics, jCType.format(false), color, null, bl);
    }

    protected void drawString(Graphics graphics, String string) {
        this.drawString(graphics, string, false);
    }

    protected void drawString(Graphics graphics, String string, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, string, null, bl);
    }

    protected void drawString(Graphics graphics, String string, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawString(Graphics graphics, String string, Color color, Font font, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, string, font, bl);
        if (graphics != null) {
            graphics.setFont(this.drawFont);
        }
    }

    protected void drawStringToGraphics(Graphics graphics, String string) {
        this.drawStringToGraphics(graphics, string, null, false);
    }

    protected void drawStringToGraphics(Graphics graphics, String string, Font font, boolean bl) {
        if (graphics != null) {
            if (!bl) {
                graphics.drawString(string, this.drawX, this.drawY);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
                graphics2D.drawString(attributedString.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.getWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        Iterator iterator = JavaCompletion.getPrimitiveClassIterator();
        while (iterator.hasNext()) {
            this.storeWidth(((JCClass)iterator.next()).getName());
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    protected Color getTypeColor(String string) {
        return JavaCompletion.isPrimitiveClassName(string) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.text);
        return stringBuffer.toString();
    }

    public static class MethodPaintComponent
    extends ConstructorPaintComponent {
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private Color METHOD_COLOR = Color.red.darker().darker();
        private String typeName;
        private Color typeColor;

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            int n = JavaCompletion.getLevel(this.getModifiers());
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.getTypeName(), this.getTypeColor(), null, bl);
            this.drawString(graphics, " ", bl);
            if ((this.getModifiers() & 0x20000000) != 0) {
                this.drawString(graphics, this.getName(), this.METHOD_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), bl);
            } else {
                this.drawString(graphics, this.getName(), this.METHOD_COLOR, null, bl);
            }
            this.drawParameterList(graphics, this.getParamList(), bl);
            this.drawExceptions(graphics, this.getExceptionList(), bl);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.typeName);
            stringBuffer.append(" ");
            stringBuffer.append(super.getName());
            stringBuffer.append(" (");
            List list = this.getParamList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JCResultItem.ParamStr paramStr = (JCResultItem.ParamStr)iterator.next();
                stringBuffer.append(paramStr.getTypeName());
                stringBuffer.append(" ");
                stringBuffer.append(paramStr.getName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class ConstructorPaintComponent
    extends JCPaintComponent {
        private Color CONSTRUCTOR_COLOR = Color.orange.darker();
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private String name;

        public int getMethodModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.name;
        }

        public void setModifiers(int n) {
            this.modifiers = n;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setParams(List list) {
            this.params = list;
        }

        public void setExceptions(List list) {
            this.excs = list;
        }

        protected List getParamList() {
            return this.params;
        }

        protected List getExceptionList() {
            return this.excs;
        }

        protected void drawParameter(Graphics graphics, JCResultItem.ParamStr paramStr) {
            this.drawParameter(graphics, paramStr, false);
        }

        protected void drawParameter(Graphics graphics, JCResultItem.ParamStr paramStr, boolean bl) {
            this.drawString(graphics, paramStr.getSimpleTypeName(), paramStr.getTypeColor(), null, bl);
            String string = paramStr.getName();
            if (string != null && string.length() > 0) {
                this.drawString(graphics, " ", bl);
                this.drawString(graphics, paramStr.getName(), this.PARAMETER_NAME_COLOR, null, bl);
            }
        }

        protected void drawParameterList(Graphics graphics, List list) {
            this.drawParameterList(graphics, list, false);
        }

        protected void drawParameterList(Graphics graphics, List list, boolean bl) {
            this.drawString(graphics, "(", bl);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.drawParameter(graphics, (JCResultItem.ParamStr)iterator.next(), bl);
                if (!iterator.hasNext()) continue;
                this.drawString(graphics, ", ", bl);
            }
            this.drawString(graphics, ")", bl);
        }

        protected void drawExceptions(Graphics graphics, List list, boolean bl) {
            if (list.size() > 0) {
                this.drawString(graphics, JCPaintComponent.THROWS, KEYWORD_COLOR, null, bl);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JCResultItem.ExcStr excStr = (JCResultItem.ExcStr)iterator.next();
                    this.drawString(graphics, excStr.getName(), excStr.getTypeColor(), null, bl);
                    if (!iterator.hasNext()) continue;
                    this.drawString(graphics, ", ", bl);
                }
            }
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            int n = JavaCompletion.getLevel(this.getModifiers());
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.getName(), this.CONSTRUCTOR_COLOR, null, bl);
            this.drawParameterList(graphics, this.getParamList(), bl);
            this.drawExceptions(graphics, this.getExceptionList(), bl);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getName());
            stringBuffer.append(" (");
            List list = this.getParamList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JCResultItem.ParamStr paramStr = (JCResultItem.ParamStr)iterator.next();
                stringBuffer.append(paramStr.getTypeName());
                stringBuffer.append(" ");
                stringBuffer.append(paramStr.getName());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class FieldPaintComponent
    extends JCPaintComponent {
        private Color FIELD_COLOR = Color.blue.darker();
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;

        public void setName(String string) {
            this.fldName = string;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public void setModifiers(int n) {
            this.modifiers = n;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            int n = JavaCompletion.getLevel(this.modifiers);
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.typeName, this.typeColor, null, bl);
            this.drawString(graphics, " ", bl);
            if ((this.modifiers & 0x20000000) != 0) {
                this.drawString(graphics, this.fldName, this.FIELD_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), bl);
            } else {
                this.drawString(graphics, this.fldName, this.FIELD_COLOR, null, bl);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.typeName);
            stringBuffer.append(" ");
            stringBuffer.append(this.fldName);
            return stringBuffer.toString();
        }
    }

    public static class PackagePaintComponent
    extends JCPaintComponent {
        private JCPackage pkg;
        private String pkgName;
        private boolean displayFullPackagePath;
        private Color PACKAGE_COLOR = Color.green.darker().darker().darker();

        public void setPackageName(String string) {
            this.pkgName = string;
        }

        public void setDisplayFullPackagePath(boolean bl) {
            this.displayFullPackagePath = bl;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            String string = this.pkgName;
            if (!this.displayFullPackagePath) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            this.drawString(graphics, string, this.PACKAGE_COLOR);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.pkgName;
            if (!this.displayFullPackagePath) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
    }

    public static class InterfacePaintComponent
    extends ClassPaintComponent {
        private Color INTERFACE_COLOR = Color.darkGray;

        protected Color getColor() {
            return this.INTERFACE_COLOR;
        }
    }

    public static class ClassPaintComponent
    extends JCPaintComponent {
        String formatClassName;
        private Color CLASS_COLOR = Color.red.darker().darker().darker();
        private boolean displayFQN;

        public void setFormatClassName(String string) {
            this.formatClassName = string;
        }

        protected Color getColor() {
            return this.CLASS_COLOR;
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.formatClassName, this.getColor(), null, bl);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatClassName);
            return stringBuffer.toString();
        }
    }
}

