/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCPaintComponent;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;

public abstract class JCResultItem
implements CompletionQuery.ResultItem,
CompletionQuery.ResultItemAssociatedObject {
    Object associatedObject;
    private static final Color KEYWORD_COLOR = Color.darkGray;
    private static final Color TYPE_COLOR = Color.black;

    public JCResultItem(Object object) {
        this.associatedObject = object;
    }

    public abstract String getItemText();

    protected abstract Component getPaintComponent(boolean var1);

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    protected String getReplaceText() {
        return this.getItemText();
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string = this.getReplaceText();
        int n3 = -1;
        int n4 = -1;
        if (string != null) {
            baseDocument.atomicLock();
            try {
                String string2 = baseDocument.getText(n, n2);
                if (string.equals(string2)) {
                    boolean bl2 = false;
                    return bl2;
                }
                baseDocument.remove(n, n2);
                baseDocument.insertString(n, string, null);
                if (n3 >= 0) {
                    jTextComponent.select(n + n3, n + n4);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        return true;
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        Component component = this.getPaintComponent(bl);
        if (component == null) {
            return null;
        }
        if (bl) {
            component.setBackground(jList.getSelectionBackground());
            component.setForeground(jList.getSelectionForeground());
        } else {
            component.setBackground(jList.getBackground());
            component.setForeground(jList.getForeground());
        }
        component.getAccessibleContext().setAccessibleName(this.getItemText());
        component.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return component;
    }

    protected Color getTypeColor(JCClass jCClass) {
        String string = jCClass.getName();
        return JavaCompletion.isPrimitiveClassName(string) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    protected static String getTypeName(JCType jCType) {
        return jCType.format(false);
    }

    static class ExcStr {
        private String name;
        private Color typeColor;

        public ExcStr(String string, Color color) {
            this.name = string;
            this.typeColor = color;
        }

        public String getName() {
            return this.name;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    static class ParamStr {
        private String type;
        private String simpleType;
        private String prm;
        private Color typeColor;

        public ParamStr(String string, String string2, String string3, Color color) {
            this.type = string;
            this.simpleType = string2;
            this.prm = string3;
            this.typeColor = color;
        }

        public String getTypeName() {
            return this.type;
        }

        public String getSimpleTypeName() {
            return this.simpleType;
        }

        public String getName() {
            return this.prm;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    public static class ClassResultItem
    extends JCResultItem {
        private JCClass cls;
        private boolean isInterface;
        private int classDisplayOffset;
        private boolean isDeprecated;
        private boolean displayFQN;
        private static JCPaintComponent.ClassPaintComponent clsComponent = null;
        private static JCPaintComponent.InterfacePaintComponent interfaceComponent = null;

        public ClassResultItem(JCClass jCClass, boolean bl) {
            this(jCClass, 0, bl);
        }

        public ClassResultItem(JCClass jCClass, int n, boolean bl) {
            super(jCClass);
            this.cls = jCClass;
            this.isInterface = jCClass.isInterface();
            this.classDisplayOffset = n;
            this.isDeprecated = JCUtilities.isDeprecated(jCClass);
            this.displayFQN = bl;
        }

        protected String getName() {
            return this.cls.getName();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                string = string.substring(this.classDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? this.cls.getFullName() : this.cls.getName();
        }

        protected JCPaintComponent.InterfacePaintComponent createInterfacePaintComponent() {
            return new JCPaintComponent.InterfacePaintComponent();
        }

        protected JCPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new JCPaintComponent.ClassPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (this.isInterface) {
                if (interfaceComponent == null) {
                    interfaceComponent = this.createInterfacePaintComponent();
                }
                interfaceComponent.setSelected(bl);
                interfaceComponent.setDeprecated(this.isDeprecated);
                interfaceComponent.setFormatClassName(this.getName());
                return interfaceComponent;
            }
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(bl);
            clsComponent.setDeprecated(this.isDeprecated);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class PackageResultItem
    extends JCResultItem {
        private boolean displayFullPackagePath;
        private JCPackage pkg;
        private String pkgName;
        private static JCPaintComponent.PackagePaintComponent pkgComponent;

        public PackageResultItem(JCPackage jCPackage, boolean bl) {
            super(jCPackage);
            this.pkg = jCPackage;
            this.displayFullPackagePath = bl;
            this.pkgName = jCPackage.getName();
        }

        public String getItemText() {
            return this.displayFullPackagePath ? this.pkg.getName() : this.pkg.getLastName();
        }

        protected JCPaintComponent.PackagePaintComponent createPaintComponent() {
            return new JCPaintComponent.PackagePaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (pkgComponent == null) {
                pkgComponent = this.createPaintComponent();
            }
            pkgComponent.setSelected(bl);
            pkgComponent.setPackageName(this.pkgName);
            pkgComponent.setDisplayFullPackagePath(this.displayFullPackagePath);
            return pkgComponent;
        }
    }

    public static class ConstructorResultItem
    extends JCResultItem {
        private JCConstructor ctr;
        private JCExpression substituteExp;
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private boolean isDeprecated;
        private static JCPaintComponent.ConstructorPaintComponent ctrComponent = null;

        public ConstructorResultItem(JCConstructor jCConstructor, JCExpression jCExpression) {
            super(jCConstructor);
            Comparable comparable;
            this.ctr = jCConstructor;
            this.substituteExp = jCExpression;
            this.modifiers = jCConstructor.getModifiers();
            this.isDeprecated = JCUtilities.isDeprecated(jCConstructor);
            JCParameter[] jCParameterArray = jCConstructor.getParameters();
            for (int i = 0; i < jCParameterArray.length; ++i) {
                JCParameter jCParameter = jCParameterArray[i];
                comparable = jCParameter.getType();
                this.params.add(new ParamStr(comparable.format(true), comparable.format(false), jCParameter.getName(), this.getTypeColor(comparable.getClazz())));
            }
            JCClass[] jCClassArray = jCConstructor.getExceptions();
            for (int i = 0; i < jCClassArray.length; ++i) {
                comparable = jCClassArray[i];
                this.excs.add(new ExcStr(comparable.getName(), this.getTypeColor((JCClass)comparable)));
            }
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.ctr.getClazz().getName();
        }

        public List getParams() {
            return this.params;
        }

        public List getExceptions() {
            return this.excs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            int n3;
            Object object;
            String string = null;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n4 = -1;
            int n5 = -1;
            switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                case 11: {
                    break;
                }
                case 10: {
                    Object object2;
                    object = this.ctr.getParameters();
                    if (((JCParameter[])object).length == 0) {
                        try {
                            n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                            if (n3 > -1 && baseDocument.getChars(n3, 1)[0] == ')') {
                                string = baseDocument.getText(n + n2, n3 + 1 - n - n2);
                                n2 = n3 + 1 - n;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (string != null) break;
                        string = ")";
                        break;
                    }
                    n3 = this.substituteExp.getParameterCount() - 1;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Formatter formatter = baseDocument.getFormatter();
                    if (formatter instanceof ExtFormatter) {
                        object2 = ((ExtFormatter)formatter).getSettingValue("java-format-space-after-comma");
                        if (object2 instanceof Boolean && ((Boolean)object2).booleanValue()) {
                            bl2 = true;
                        }
                        if ((object2 = ((ExtFormatter)formatter).getSettingValue("pair-characters-completion")) instanceof Boolean && ((Boolean)object2).booleanValue()) {
                            bl3 = true;
                        }
                    }
                    try {
                        if (bl2 && (n3 == 0 || n > 0 && Character.isWhitespace(baseDocument.getText(n - 1, 1).charAt(0)))) {
                            bl2 = false;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (n3 >= ((JCParameter[])object).length) break;
                    string = bl2 ? " " : "";
                    n4 = string.length();
                    string = string + object[n3].getName();
                    n5 = string.length();
                    if (!bl3 || n3 != ((JCParameter[])object).length - 1) break;
                    object2 = null;
                    try {
                        int n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n6 > -1 && baseDocument.getChars(n6, 1)[0] == ')') {
                            object2 = baseDocument.getText(n + n2, n6 + 1 - n - n2);
                            string = string + (String)object2;
                            n2 = n6 + 1 - n;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (object2 != null) break;
                    string = string + ')';
                    break;
                }
                default: {
                    Object object3;
                    string = this.getItemText();
                    n3 = 0;
                    boolean bl4 = false;
                    Formatter formatter = baseDocument.getFormatter();
                    if (formatter instanceof ExtFormatter) {
                        object3 = ((ExtFormatter)formatter).getSettingValue("java-format-space-before-parenthesis");
                        if (object3 instanceof Boolean && ((Boolean)object3).booleanValue()) {
                            n3 = 1;
                        }
                        if ((object3 = ((ExtFormatter)formatter).getSettingValue("pair-characters-completion")) instanceof Boolean && ((Boolean)object3).booleanValue()) {
                            bl4 = true;
                        }
                    }
                    object3 = null;
                    try {
                        int n7 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n7 > -1 && baseDocument.getChars(n7, 1)[0] == '(') {
                            object3 = baseDocument.getText(n + n2, n7 + 1 - n - n2);
                            if (n3 != 0 && ((String)object3).length() < 2) {
                                string = string + ' ';
                            }
                            n2 = n7 + 1 - n;
                            string = string + (String)object3;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    object = this.ctr.getParameters();
                    if (object3 == null) {
                        if (n3 != 0) {
                            string = string + ' ';
                        }
                        string = string + '(';
                        if (((JCParameter[])object).length > 0) {
                            n4 = string.length();
                            string = string + object[0].getName();
                            n5 = string.length();
                        }
                        if (((JCParameter[])object).length != 0 && (!bl4 || ((JCParameter[])object).length != 1)) break;
                        string = string + ")";
                        break;
                    }
                    try {
                        int n8 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n8 <= -1 || baseDocument.getChars(n8, 1)[0] != ')') break;
                        object3 = baseDocument.getText(n + n2, n8 + 1 - n - n2);
                        n2 = n8 + 1 - n;
                        if (((JCParameter[])object).length > 0) {
                            n4 = string.length();
                            string = string + object[0].getName();
                            n5 = string.length();
                        }
                        string = string + (String)object3;
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (string != null) {
                baseDocument.atomicLock();
                try {
                    object = baseDocument.getText(n, n2);
                    if (string.equals(object)) {
                        jTextComponent.setCaretPosition(n + n2);
                        n3 = 0;
                        return n3 != 0;
                    }
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n, string, null);
                    if (n4 >= 0) {
                        jTextComponent.select(n + n4, n + n5);
                    }
                    n3 = 1;
                    return n3 != 0;
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            return false;
        }

        public String getItemText() {
            return this.ctr.getClazz().getName();
        }

        protected JCPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new JCPaintComponent.ConstructorPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (ctrComponent == null) {
                ctrComponent = this.createPaintComponent();
            }
            ctrComponent.setName(this.getItemText());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setDeprecated(this.isDeprecated);
            ctrComponent.setSelected(bl);
            return ctrComponent;
        }
    }

    public static class MethodResultItem
    extends ConstructorResultItem {
        private static JCPaintComponent.MethodPaintComponent mtdComponent = null;
        private String typeName;
        private Color typeColor;
        private String mtdName;

        public MethodResultItem(JCMethod jCMethod, JCExpression jCExpression) {
            super(jCMethod, jCExpression);
            this.typeName = MethodResultItem.getTypeName(jCMethod.getReturnType());
            this.mtdName = jCMethod.getName();
            this.typeColor = this.getTypeColor(jCMethod.getReturnType().getClazz());
        }

        public String getName() {
            return this.mtdName;
        }

        public String getItemText() {
            return this.getName();
        }

        protected JCPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new JCPaintComponent.MethodPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (mtdComponent == null) {
                mtdComponent = (JCPaintComponent.MethodPaintComponent)this.createPaintComponent();
            }
            mtdComponent.setName(this.getName());
            mtdComponent.setModifiers(this.getModifiers());
            mtdComponent.setTypeName(this.typeName);
            mtdComponent.setTypeColor(this.typeColor);
            mtdComponent.setParams(this.getParams());
            mtdComponent.setExceptions(this.getExceptions());
            mtdComponent.setDeprecated(this.isDeprecated());
            mtdComponent.setSelected(bl);
            return mtdComponent;
        }
    }

    public static class FieldResultItem
    extends JCResultItem {
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isDeprecated;
        private static JCPaintComponent.FieldPaintComponent fieldComponent = null;

        public FieldResultItem(JCField jCField) {
            super(jCField);
            this.fldName = jCField.getName();
            this.modifiers = jCField.getModifiers();
            this.typeName = FieldResultItem.getTypeName(jCField.getType());
            this.typeColor = this.getTypeColor(jCField.getType().getClazz());
            this.isDeprecated = JCUtilities.isDeprecated(jCField);
        }

        public String getItemText() {
            return this.fldName;
        }

        protected JCPaintComponent.FieldPaintComponent createPaintComponent() {
            return new JCPaintComponent.FieldPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (fieldComponent == null) {
                fieldComponent = this.createPaintComponent();
            }
            fieldComponent.setTypeName(this.typeName);
            fieldComponent.setName(this.fldName);
            fieldComponent.setTypeColor(this.typeColor);
            fieldComponent.setModifiers(this.modifiers);
            fieldComponent.setSelected(bl);
            fieldComponent.setDeprecated(this.isDeprecated);
            return fieldComponent;
        }
    }
}

