/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaTokenContext;

final class JCTokenProcessor
implements TokenProcessor {
    private static final int CONSTANT = 0;
    private static final int VARIABLE = 1;
    private static final int OPERATOR = 2;
    private static final int UNARY_OPERATOR = 3;
    private static final int DOT = 4;
    private static final int DOT_OPEN = 5;
    private static final int ARRAY_OPEN = 6;
    private static final int ARRAY = 7;
    private static final int PARENTHESIS_OPEN = 8;
    private static final int PARENTHESIS = 9;
    private static final int METHOD_OPEN = 10;
    private static final int METHOD = 11;
    private static final int CONSTRUCTOR = 12;
    private static final int CONVERSION = 13;
    private static final int TYPE = 14;
    private static final int NEW = 15;
    private static final int INSTANCEOF = 16;
    private static final int GENERIC_TYPE = 17;
    private static final int GENERIC_TYPE_OPEN = 18;
    private static final int GENERIC_WILD_CHAR = 19;
    private static final int ANNOTATION = 20;
    private static final int ANNOTATION_OPEN = 21;
    private static final int IMPORT = 22;
    private static final int CASE = 23;
    private static final int NO_EXP = -1;
    private char[] buffer;
    private int bufferStartPos;
    private int bufferOffsetDelta;
    private boolean stopped;
    private ArrayList expStack = new ArrayList();
    private TokenID lastValidTokenID;
    private String lastValidTokenText;
    private TokenID curTokenID;
    private int curTokenPosition;
    private String curTokenText;
    private int endScanOffset;
    private boolean java15;

    JCTokenProcessor(int n) {
        this.endScanOffset = n;
    }

    void setJava15(boolean bl) {
        this.java15 = bl;
    }

    final List getStack() {
        return this.expStack;
    }

    final TokenID getLastValidTokenID() {
        return this.lastValidTokenID;
    }

    final String getLastValidTokenText() {
        return this.lastValidTokenText;
    }

    final int getCurrentOffest() {
        return this.curTokenPosition;
    }

    final boolean isStopped() {
        return this.stopped;
    }

    final JCExpression getResultExp() {
        JCExpression jCExpression = this.peekExp();
        return jCExpression;
    }

    final JCExpression getResultEnclosingExp() {
        return this.peekExp2();
    }

    private void clearStack() {
        this.expStack.clear();
    }

    private void pushExp(JCExpression jCExpression) {
        this.expStack.add(jCExpression);
    }

    private JCExpression popExp() {
        int n = this.expStack.size();
        return n > 0 ? (JCExpression)this.expStack.remove(n - 1) : null;
    }

    private JCExpression peekExp() {
        int n = this.expStack.size();
        return n > 0 ? (JCExpression)this.expStack.get(n - 1) : null;
    }

    private JCExpression peekExp2() {
        int n = this.expStack.size();
        return n > 1 ? (JCExpression)this.expStack.get(n - 2) : null;
    }

    private JCExpression peekExp(int n) {
        int n2 = this.expStack.size();
        return n2 >= n ? (JCExpression)this.expStack.get(n2 - n) : null;
    }

    private JCExpression createTokenExp(int n) {
        JCExpression jCExpression = new JCExpression(n);
        this.addTokenTo(jCExpression);
        return jCExpression;
    }

    private void addTokenTo(JCExpression jCExpression) {
        jCExpression.addToken(this.curTokenID, this.curTokenPosition, this.curTokenText);
    }

    private int getValidExpID(JCExpression jCExpression) {
        return jCExpression != null ? jCExpression.getExpID() : -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkJoin(TokenID tokenID) {
        JCExpression jCExpression;
        boolean bl = true;
        boolean bl2 = true;
        block35: while (bl2) {
            bl2 = false;
            JCExpression jCExpression2 = this.peekExp();
            jCExpression = this.peekExp2();
            int n = this.getValidExpID(jCExpression);
            switch (this.getValidExpID(jCExpression2)) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    block3 : switch (n) {
                        case 3: {
                            switch (tokenID.getNumericID()) {
                                case 48: 
                                case 53: 
                                case 55: 
                                case 59: 
                                case 60: {
                                    break block3;
                                }
                            }
                            if (jCExpression.getParameterCount() != 0) break;
                            this.popExp();
                            jCExpression.addParameter(jCExpression2);
                            break;
                        }
                        case 5: {
                            if (tokenID.getCategory() != JavaTokenContext.OPERATORS) break;
                            switch (tokenID.getNumericID()) {
                                case 53: {
                                    break block3;
                                }
                            }
                            this.popExp();
                            jCExpression.addParameter(jCExpression2);
                            jCExpression.setExpID(4);
                            bl2 = true;
                            break;
                        }
                        case 13: {
                            if (tokenID.getCategory() != JavaTokenContext.OPERATORS) break;
                            switch (tokenID.getNumericID()) {
                                case 49: 
                                case 54: {
                                    JCExpression jCExpression3 = this.peekExp(3);
                                    if (jCExpression3 == null) break block3;
                                    switch (jCExpression3.getExpID()) {
                                        case 2: 
                                        case 8: 
                                        case 10: {
                                            this.popExp();
                                            jCExpression.addParameter(jCExpression2);
                                        }
                                    }
                                    break block3;
                                }
                            }
                        }
                    }
                    continue block35;
                }
            }
        }
        int n = JCExpression.getOperatorID(tokenID);
        if (n < 0) return bl;
        switch (JCExpression.getOperatorPrecedence(n)) {
            case 0: {
                int n2;
                jCExpression = null;
                JCExpression jCExpression4 = this.peekExp();
                int n3 = -1;
                n3 = JCExpression.getOperatorID(jCExpression4);
                block23 : switch (JCExpression.getOperatorPrecedence(n3)) {
                    case 0: {
                        jCExpression4 = null;
                        break;
                    }
                    case 1: {
                        jCExpression = jCExpression4;
                        jCExpression4 = this.peekExp2();
                        n3 = JCExpression.getOperatorID(jCExpression4);
                        switch (JCExpression.getOperatorPrecedence(n3)) {
                            case 0: {
                                jCExpression4 = null;
                                break block23;
                            }
                            case 1: {
                                return false;
                            }
                        }
                        this.popExp();
                        jCExpression4.addParameter(jCExpression);
                        jCExpression = null;
                        break;
                    }
                }
                if (jCExpression4 == null) return bl;
                this.popExp();
                bl2 = true;
                ArrayList<JCExpression> arrayList = new ArrayList<JCExpression>();
                JCExpression jCExpression5 = null;
                do {
                    if (jCExpression5 == null) {
                        jCExpression5 = this.popExp();
                        if (jCExpression5 == null) break;
                        n = JCExpression.getOperatorID(jCExpression5);
                    }
                    switch (JCExpression.getOperatorPrecedence(n)) {
                        case 0: {
                            this.pushExp(jCExpression5);
                            bl2 = false;
                            break;
                        }
                        case 1: {
                            jCExpression = jCExpression5;
                            jCExpression5 = null;
                            break;
                        }
                        default: {
                            n2 = JCExpression.getOperatorPrecedence(n);
                            int n4 = JCExpression.getOperatorPrecedence(n3);
                            boolean bl3 = n2 > n4 ? false : (n2 < n4 ? true : JCExpression.isOperatorRightAssociative(n3));
                            if (bl3) {
                                if (jCExpression != null) {
                                    jCExpression4.addParameter(jCExpression);
                                }
                                if (arrayList.size() > 0) {
                                    jCExpression = jCExpression4;
                                    jCExpression4 = (JCExpression)arrayList.remove(arrayList.size() - 1);
                                    n3 = JCExpression.getOperatorID(jCExpression4);
                                    break;
                                }
                                jCExpression5.addParameter(jCExpression4);
                                jCExpression = null;
                                jCExpression4 = jCExpression5;
                                n3 = n;
                                jCExpression5 = null;
                                break;
                            }
                            if (jCExpression != null) {
                                jCExpression5.addParameter(jCExpression);
                                jCExpression = null;
                            }
                            arrayList.add(jCExpression4);
                            jCExpression4 = jCExpression5;
                            n3 = n;
                            jCExpression5 = null;
                        }
                    }
                } while (bl2);
                if (jCExpression != null) {
                    jCExpression4.addParameter(jCExpression);
                }
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    JCExpression jCExpression6 = (JCExpression)arrayList.get(n2);
                    jCExpression6.addParameter(jCExpression4);
                    jCExpression4 = jCExpression6;
                }
                jCExpression4.swapOperatorParms();
                this.pushExp(jCExpression4);
                return bl;
            }
        }
        return bl;
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
        TokenCategory tokenCategory;
        if (tokenID != null && JavaTokenContext.KEYWORDS.equals(tokenCategory = tokenID.getCategory()) && (n += this.bufferOffsetDelta) + n2 + this.bufferStartPos == this.endScanOffset) {
            tokenID = JavaTokenContext.IDENTIFIER;
        }
        if (tokenID != null) {
            this.lastValidTokenID = tokenID;
        }
        this.curTokenID = tokenID;
        this.curTokenPosition = this.bufferStartPos + n;
        this.lastValidTokenText = this.curTokenText = new String(this.buffer, n, n2);
        boolean bl = false;
        this.stopped = false;
        this.checkJoin(tokenID);
        JCExpression jCExpression = this.peekExp();
        int n3 = this.getValidExpID(jCExpression);
        JCExpression jCExpression2 = null;
        JavaCompletion.BaseType baseType = null;
        if (tokenID == null) {
            bl = true;
        } else if (tokenContextPath.contains(JavaTokenContext.contextPath)) {
            block0 : switch (tokenID.getNumericID()) {
                case 63: {
                    baseType = JavaCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 64: {
                    baseType = JavaCompletion.BYTE_TYPE;
                    break;
                }
                case 65: {
                    baseType = JavaCompletion.CHAR_TYPE;
                    break;
                }
                case 66: {
                    baseType = JavaCompletion.DOUBLE_TYPE;
                    break;
                }
                case 67: {
                    baseType = JavaCompletion.FLOAT_TYPE;
                    break;
                }
                case 68: {
                    baseType = JavaCompletion.INT_TYPE;
                    break;
                }
                case 69: {
                    baseType = JavaCompletion.LONG_TYPE;
                    break;
                }
                case 70: {
                    baseType = JavaCompletion.SHORT_TYPE;
                    break;
                }
                case 85: 
                case 112: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("boolean");
                    break;
                }
                case 97: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("null");
                    break;
                }
                case 77: {
                    if (n3 == 5) {
                        this.pushExp(this.createTokenExp(1));
                        break;
                    }
                    bl = true;
                    break;
                }
                case 96: {
                    switch (n3) {
                        case 1: 
                        case 15: {
                            bl = true;
                            break block0;
                        }
                    }
                    this.pushExp(this.createTokenExp(15));
                    break;
                }
                case 92: {
                    this.pushExp(this.createTokenExp(22));
                    break;
                }
                case 103: {
                    switch (n3) {
                        case 22: {
                            jCExpression.addParameter(this.createTokenExp(22));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 105: {
                    if (n3 == 19) break;
                }
                case 108: {
                    this.pushExp(this.createTokenExp(1));
                    break;
                }
                case 123: {
                    this.pushExp(this.createTokenExp(20));
                    break;
                }
                case 93: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(16));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 75: {
                    this.pushExp(this.createTokenExp(23));
                    break;
                }
                case 84: {
                    if (n3 == 19) break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 76: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 94: 
                case 95: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 104: 
                case 106: 
                case 107: 
                case 109: 
                case 110: 
                case 111: 
                case 113: 
                case 114: 
                case 115: {
                    bl = true;
                    break;
                }
                case 6: {
                    switch (n3) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 13: 
                        case 15: 
                        case 16: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: {
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        case 19: {
                            jCExpression.setExpID(1);
                            this.addTokenTo(jCExpression);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 52: {
                    if (n3 == 18) {
                        this.pushExp(new JCExpression(19));
                        break;
                    }
                }
                case 17: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 61: 
                case 62: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 18: {
                    boolean bl2 = false;
                    if (this.java15) {
                        switch (n3) {
                            case 1: 
                            case 4: {
                                this.popExp();
                                JCExpression jCExpression3 = this.createTokenExp(18);
                                jCExpression3.addParameter(jCExpression);
                                this.pushExp(jCExpression3);
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    if (bl || bl2) break;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 19: {
                    boolean bl3 = false;
                    if (this.java15) {
                        block73 : switch (n3) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression jCExpression4 = this.peekExp2();
                                switch (this.getValidExpID(jCExpression4)) {
                                    case 18: {
                                        this.popExp();
                                        jCExpression4.addParameter(jCExpression);
                                        jCExpression4.setExpID(17);
                                        this.addTokenTo(jCExpression4);
                                        bl3 = true;
                                        jCExpression = jCExpression4;
                                        break block73;
                                    }
                                }
                                bl = n3 == 17;
                                break;
                            }
                        }
                    }
                    if (bl || bl3) break;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 21: {
                    boolean bl4 = false;
                    if (this.java15) {
                        block82 : switch (n3) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression jCExpression5 = this.peekExp2();
                                switch (this.getValidExpID(jCExpression5)) {
                                    case 18: {
                                        JCExpression jCExpression6 = this.peekExp(3);
                                        if (this.getValidExpID(jCExpression6) == 18) {
                                            bl4 = true;
                                            this.popExp();
                                            jCExpression5.addParameter(jCExpression);
                                            jCExpression5.setExpID(17);
                                            this.addTokenTo(jCExpression5);
                                            this.popExp();
                                            jCExpression6.addParameter(jCExpression5);
                                            jCExpression6.setExpID(17);
                                            this.addTokenTo(jCExpression6);
                                            jCExpression = jCExpression6;
                                            break block82;
                                        }
                                        bl = true;
                                        break block82;
                                    }
                                }
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (bl || bl4) break;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 22: {
                    boolean bl5 = false;
                    if (this.java15) {
                        block91 : switch (n3) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression jCExpression7 = this.peekExp2();
                                switch (this.getValidExpID(jCExpression7)) {
                                    case 18: {
                                        JCExpression jCExpression8 = this.peekExp(3);
                                        JCExpression jCExpression9 = this.peekExp(4);
                                        if (this.getValidExpID(jCExpression8) == 18 && this.getValidExpID(jCExpression9) == 18) {
                                            bl5 = true;
                                            this.popExp();
                                            jCExpression7.addParameter(jCExpression);
                                            jCExpression7.setExpID(17);
                                            this.addTokenTo(jCExpression7);
                                            this.popExp();
                                            jCExpression8.addParameter(jCExpression7);
                                            jCExpression8.setExpID(17);
                                            this.addTokenTo(jCExpression8);
                                            this.popExp();
                                            jCExpression9.addParameter(jCExpression8);
                                            jCExpression9.setExpID(17);
                                            this.addTokenTo(jCExpression9);
                                            jCExpression = jCExpression9;
                                            break block91;
                                        }
                                        bl = true;
                                        break block91;
                                    }
                                }
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (bl || bl5) break;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 59: 
                case 60: {
                    switch (n3) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 10: {
                            JCExpression jCExpression10 = this.createTokenExp(3);
                            this.pushExp(jCExpression10);
                            break block0;
                        }
                        case 1: {
                            JCExpression jCExpression11 = this.createTokenExp(3);
                            this.popExp();
                            jCExpression11.addParameter(jCExpression);
                            this.pushExp(jCExpression11);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 23: 
                case 24: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: {
                            JCExpression jCExpression12 = this.createTokenExp(2);
                            this.pushExp(jCExpression12);
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 6: 
                        case 8: 
                        case 10: {
                            JCExpression jCExpression13 = this.createTokenExp(3);
                            this.pushExp(jCExpression13);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 31: 
                case 32: {
                    switch (n3) {
                        case -1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 8: 
                        case 10: {
                            JCExpression jCExpression14 = this.createTokenExp(3);
                            this.pushExp(jCExpression14);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 48: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 14: 
                        case 17: {
                            this.popExp();
                            JCExpression jCExpression15 = this.createTokenExp(5);
                            jCExpression15.addParameter(jCExpression);
                            this.pushExp(jCExpression15);
                            break block0;
                        }
                        case 4: {
                            this.addTokenTo(jCExpression);
                            jCExpression.setExpID(5);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 49: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 19: {
                            JCExpression jCExpression16 = this.peekExp2();
                            switch (this.getValidExpID(jCExpression16)) {
                                case 10: {
                                    this.popExp();
                                    jCExpression16.addParameter(jCExpression);
                                    jCExpression = jCExpression16;
                                    break block0;
                                }
                                case 21: {
                                    this.popExp();
                                    jCExpression16.addParameter(jCExpression);
                                    this.addTokenTo(jCExpression16);
                                    jCExpression = jCExpression16;
                                    break block0;
                                }
                                case 18: {
                                    switch (n3) {
                                        case 1: 
                                        case 4: 
                                        case 17: 
                                        case 19: {
                                            this.popExp();
                                            jCExpression16.addParameter(jCExpression);
                                            this.addTokenTo(jCExpression16);
                                            jCExpression = jCExpression16;
                                            break block0;
                                        }
                                    }
                                    bl = true;
                                    break block0;
                                }
                            }
                            bl = true;
                            break block0;
                        }
                        case 10: {
                            this.addTokenTo(jCExpression);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 51: {
                    bl = true;
                    break;
                }
                case 53: {
                    switch (n3) {
                        case 1: 
                        case 17: {
                            this.popExp();
                            JCExpression jCExpression17 = this.peekExp();
                            switch (this.getValidExpID(jCExpression17)) {
                                case 20: {
                                    jCExpression17.setExpID(21);
                                    jCExpression17.addParameter(jCExpression);
                                    break block0;
                                }
                                case 5: {
                                    JCExpression jCExpression18 = this.peekExp2();
                                    if (this.getValidExpID(jCExpression18) != 20) break;
                                    jCExpression17.setExpID(4);
                                    jCExpression17.addParameter(jCExpression);
                                    jCExpression18.setExpID(21);
                                    jCExpression18.addParameter(jCExpression17);
                                    this.popExp();
                                    break block0;
                                }
                            }
                            JCExpression jCExpression19 = this.createTokenExp(10);
                            jCExpression19.addParameter(jCExpression);
                            this.pushExp(jCExpression19);
                            break block0;
                        }
                        case 7: {
                            this.popExp();
                            JCExpression jCExpression20 = this.createTokenExp(11);
                            jCExpression20.addParameter(jCExpression);
                            this.pushExp(jCExpression20);
                            break block0;
                        }
                        case -1: 
                        case 2: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 13: 
                        case 18: {
                            this.pushExp(this.createTokenExp(8));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 54: {
                    JCExpression jCExpression21;
                    boolean bl6 = false;
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: {
                            jCExpression21 = this.peekExp2();
                            block140 : switch (this.getValidExpID(jCExpression21)) {
                                case 8: {
                                    this.popExp();
                                    jCExpression21.addParameter(jCExpression);
                                    jCExpression21.setExpID(JCExpression.isValidType(jCExpression) ? 13 : 9);
                                    this.addTokenTo(jCExpression21);
                                    break;
                                }
                                case 18: {
                                    this.popExp();
                                    jCExpression21.setExpID(2);
                                    jCExpression21.addParameter(jCExpression);
                                    jCExpression = jCExpression21;
                                    jCExpression21 = this.peekExp2();
                                    if (this.getValidExpID(jCExpression21) != 10) break;
                                }
                                case 10: {
                                    this.popExp();
                                    jCExpression21.addParameter(jCExpression);
                                    jCExpression = jCExpression21;
                                    bl6 = true;
                                    break;
                                }
                                case 13: {
                                    this.popExp();
                                    jCExpression21.addParameter(jCExpression);
                                    jCExpression = jCExpression21;
                                    jCExpression21 = this.peekExp2();
                                    switch (this.getValidExpID(jCExpression21)) {
                                        case 8: {
                                            this.popExp();
                                            jCExpression21.addParameter(jCExpression);
                                            jCExpression21.setExpID(9);
                                            jCExpression = jCExpression21;
                                            break block140;
                                        }
                                        case 10: {
                                            this.popExp();
                                            jCExpression21.addParameter(jCExpression);
                                            jCExpression = jCExpression21;
                                            bl6 = true;
                                        }
                                    }
                                    break;
                                }
                                default: {
                                    bl = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 10: {
                            bl6 = true;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (!bl6) break;
                    this.addTokenTo(jCExpression);
                    jCExpression.setExpID(11);
                    jCExpression21 = this.peekExp2();
                    switch (this.getValidExpID(jCExpression21)) {
                        case 5: {
                            JCExpression jCExpression22 = this.peekExp(3);
                            if (this.getValidExpID(jCExpression22) != 15) break;
                            this.popExp();
                            jCExpression21.addParameter(jCExpression);
                            jCExpression21.setExpID(4);
                            this.popExp();
                            jCExpression22.setExpID(12);
                            jCExpression22.addParameter(jCExpression21);
                            break;
                        }
                        case 15: {
                            jCExpression21.setExpID(12);
                            jCExpression21.addParameter(jCExpression);
                            this.popExp();
                        }
                    }
                    break;
                }
                case 55: {
                    switch (n3) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 14: 
                        case 17: {
                            this.popExp();
                            JCExpression jCExpression23 = this.createTokenExp(6);
                            jCExpression23.addParameter(jCExpression);
                            this.pushExp(jCExpression23);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 124: {
                    switch (n3) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 14: 
                        case 17: {
                            this.popExp();
                            JCExpression jCExpression24 = this.createTokenExp(7);
                            this.addTokenTo(jCExpression24);
                            jCExpression24.addParameter(jCExpression);
                            this.pushExp(jCExpression24);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 56: {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 16: {
                            JCExpression jCExpression25 = this.peekExp2();
                            switch (this.getValidExpID(jCExpression25)) {
                                case 6: {
                                    JCExpression jCExpression26 = this.peekExp(3);
                                    this.popExp();
                                    if (this.getValidExpID(jCExpression26) == 15) {
                                        this.popExp();
                                        jCExpression26.setExpID(7);
                                        jCExpression26.addParameter(jCExpression25.getParameter(0));
                                        jCExpression26.addToken(jCExpression25.getTokenID(0), jCExpression25.getTokenOffset(0), jCExpression25.getTokenText(0));
                                        this.addTokenTo(jCExpression25);
                                        break block0;
                                    }
                                    jCExpression25.setExpID(7);
                                    jCExpression25.addParameter(jCExpression);
                                    this.addTokenTo(jCExpression25);
                                    break block0;
                                }
                            }
                            bl = true;
                            break block0;
                        }
                        case 6: {
                            jCExpression.setExpID(7);
                            this.addTokenTo(jCExpression);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 57: {
                    JCExpression jCExpression27;
                    if (n3 == 7 && this.getValidExpID(jCExpression27 = this.peekExp2()) == 15) {
                        this.popExp();
                        jCExpression27.setExpID(7);
                        jCExpression27.addParameter(jCExpression.getParameter(0));
                        jCExpression27.addToken(jCExpression.getTokenID(0), jCExpression.getTokenOffset(0), jCExpression.getTokenText(0));
                        jCExpression27.addToken(jCExpression.getTokenID(1), jCExpression.getTokenOffset(1), jCExpression.getTokenText(1));
                        this.stopped = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 58: {
                    bl = true;
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("char");
                    break;
                }
                case 10: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("java.lang.String");
                    break;
                }
                case 11: 
                case 13: 
                case 14: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("int");
                    break;
                }
                case 12: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("long");
                    break;
                }
                case 15: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("float");
                    break;
                }
                case 16: {
                    jCExpression2 = this.createTokenExp(0);
                    jCExpression2.setType("double");
                }
            }
        }
        if (jCExpression2 != null) {
            switch (n3) {
                case 5: {
                    bl = true;
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 21: {
                    this.pushExp(jCExpression2);
                    break;
                }
                case 18: {
                    jCExpression.setExpID(2);
                    jCExpression.addParameter(jCExpression2);
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (baseType != null) {
            switch (n3) {
                case -1: 
                case 2: 
                case 8: 
                case 15: {
                    JCExpression jCExpression28 = this.createTokenExp(14);
                    this.addTokenTo(jCExpression28);
                    jCExpression28.setType(baseType.getClazz().getFullName());
                    this.pushExp(jCExpression28);
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.clearStack();
            if (tokenID == JavaTokenContext.IDENTIFIER) {
                this.pushExp(this.createTokenExp(1));
            }
        }
        return !this.stopped;
    }

    public int eot(int n) {
        boolean bl = true;
        while (bl) {
            bl = false;
            JCExpression jCExpression = this.peekExp();
            JCExpression jCExpression2 = this.peekExp2();
            int n2 = this.getValidExpID(jCExpression2);
            if (jCExpression != null) {
                block0 : switch (this.getValidExpID(jCExpression)) {
                    case 1: {
                        switch (n2) {
                            case 5: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(4);
                                bl = true;
                                break block0;
                            }
                            case 15: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(12);
                                bl = true;
                                break block0;
                            }
                            case 22: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                break block0;
                            }
                            case 18: 
                            case 20: 
                            case 21: 
                            case 23: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                bl = false;
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (n2) {
                            case 5: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(4);
                                bl = true;
                                jCExpression = jCExpression2;
                                jCExpression2 = this.peekExp2();
                                n2 = this.getValidExpID(jCExpression2);
                                if (n2 != 15) break;
                            }
                            case 15: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(12);
                                bl = true;
                            }
                        }
                        this.pushExp(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + n));
                        break;
                    }
                    case 11: {
                        switch (n2) {
                            case 5: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(4);
                                bl = true;
                                break block0;
                            }
                            case 15: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(12);
                                bl = true;
                            }
                        }
                        break;
                    }
                    case 12: {
                        switch (n2) {
                            case 5: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(4);
                                bl = true;
                            }
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        JCExpression jCExpression3;
                        switch (n2) {
                            case 15: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                jCExpression2.setExpID(12);
                                bl = true;
                                break block0;
                            }
                            case 22: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                break block0;
                            }
                            case 18: 
                            case 20: 
                            case 21: {
                                this.popExp();
                                jCExpression2.addParameter(jCExpression);
                                bl = false;
                                break block0;
                            }
                            case 2: {
                                jCExpression3 = this.peekExp(4);
                                if (this.getValidExpID(jCExpression3) != 21) break;
                                jCExpression2.addParameter(this.peekExp(3));
                                jCExpression2.addParameter(jCExpression);
                                jCExpression3.addParameter(jCExpression2);
                                this.popExp();
                                this.popExp();
                                this.popExp();
                                bl = false;
                            }
                        }
                        break;
                    }
                    case 8: {
                        this.pushExp(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + n));
                        break;
                    }
                    case 17: {
                        if (n2 != 15) break;
                        this.popExp();
                        jCExpression2.addParameter(jCExpression);
                        jCExpression2.setExpID(12);
                        bl = true;
                        break;
                    }
                    case 18: {
                        if (jCExpression.getParameterCount() > 1) break;
                    }
                    case 22: 
                    case 23: {
                        jCExpression.addParameter(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + n));
                        break;
                    }
                    case 2: {
                        JCExpression jCExpression3;
                        if (n2 != 1 || this.getValidExpID(jCExpression3 = this.peekExp(3)) != 21) break;
                        jCExpression.addParameter(jCExpression2);
                        jCExpression.addParameter(JCExpression.createEmptyVariable(n));
                        jCExpression3.addParameter(jCExpression);
                        this.popExp();
                        this.popExp();
                    }
                }
                continue;
            }
            this.pushExp(JCExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + n));
        }
        return 0;
    }

    public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        this.buffer = new char[n2 + n4];
        System.arraycopy(cArray, n - n4, this.buffer, 0, n2 + n4);
        this.bufferOffsetDelta = n4 - n;
        this.bufferStartPos = n3 - n4;
    }

    public String toString() {
        int n = this.expStack.size();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.stopped) {
            stringBuffer.append("Parsing STOPPED by request.\n");
        }
        stringBuffer.append("Stack size is " + n + "\n");
        if (n > 0) {
            stringBuffer.append("Stack expressions:\n");
            for (int i = 0; i < n; ++i) {
                JCExpression jCExpression = (JCExpression)this.expStack.get(i);
                stringBuffer.append("Stack[");
                stringBuffer.append(i);
                stringBuffer.append("]: ");
                stringBuffer.append(jCExpression.toString(0));
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }
}

