/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JCUtilities {
    private static final int javaTokenIDsLength = JavaTokenContext.context.getTokenIDs().length;
    private static final boolean[][] primitivesAssignable = new boolean[javaTokenIDsLength][];
    private static final JCClass[][] primitivesCommonClass = new JCClass[javaTokenIDsLength][];

    private static boolean stringEqual(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    private static boolean classEqual(JCClass jCClass, JCClass jCClass2) {
        return jCClass == null ? jCClass2 == null : jCClass.equals(jCClass2);
    }

    private static boolean typeEqual(JCType jCType, JCType jCType2) {
        return jCType == null ? jCType2 == null : JCUtilities.classEqual(jCType.getClazz(), jCType2.getClazz()) && jCType.getArrayDepth() == jCType2.getArrayDepth();
    }

    private static boolean parameterEqual(JCParameter jCParameter, JCParameter jCParameter2) {
        return jCParameter == null ? jCParameter2 == null : JCUtilities.typeEqual(jCParameter.getType(), jCParameter2.getType()) && JCUtilities.stringEqual(jCParameter.getName(), jCParameter2.getName());
    }

    private static boolean constructorEqual(JCConstructor jCConstructor, JCConstructor jCConstructor2) {
        return jCConstructor == null ? jCConstructor2 == null : jCConstructor.getClazz().equals(jCConstructor2.getClazz()) && jCConstructor.getModifiers() == jCConstructor2.getModifiers() && JCUtilities.parameterArrayEqual(jCConstructor.getParameters(), jCConstructor2.getParameters()) && JCUtilities.classArrayEqual(jCConstructor.getExceptions(), jCConstructor2.getExceptions());
    }

    private static boolean parameterArrayEqual(JCParameter[] jCParameterArray, JCParameter[] jCParameterArray2) {
        if (jCParameterArray.length != jCParameterArray2.length) {
            return false;
        }
        for (int i = jCParameterArray.length - 1; i >= 0; --i) {
            if (JCUtilities.parameterEqual(jCParameterArray[i], jCParameterArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean classArrayEqual(JCClass[] jCClassArray, JCClass[] jCClassArray2) {
        if (jCClassArray.length != jCClassArray2.length) {
            return false;
        }
        for (int i = jCClassArray.length - 1; i >= 0; --i) {
            if (JCUtilities.classEqual(jCClassArray[i], jCClassArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean fieldArraysEqual(JCField[] jCFieldArray, JCField[] jCFieldArray2) {
        if (jCFieldArray.length != jCFieldArray2.length) {
            return false;
        }
        for (int i = jCFieldArray.length - 1; i >= 0; --i) {
            JCField jCField = jCFieldArray[i];
            JCField jCField2 = jCFieldArray2[i];
            if (JCUtilities.parameterEqual(jCField, jCField2) && jCField.getClazz().equals(jCField2.getClazz()) && jCField.getModifiers() == jCField2.getModifiers()) continue;
            return false;
        }
        return true;
    }

    private static boolean constructorArrayEqual(JCConstructor[] jCConstructorArray, JCConstructor[] jCConstructorArray2) {
        if (jCConstructorArray.length != jCConstructorArray2.length) {
            return false;
        }
        for (int i = jCConstructorArray.length - 1; i >= 0; --i) {
            if (JCUtilities.constructorEqual(jCConstructorArray[i], jCConstructorArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean methodArraysEqual(JCMethod[] jCMethodArray, JCMethod[] jCMethodArray2) {
        if (jCMethodArray.length != jCMethodArray2.length) {
            return false;
        }
        for (int i = jCMethodArray.length - 1; i >= 0; --i) {
            JCMethod jCMethod = jCMethodArray[i];
            JCMethod jCMethod2 = jCMethodArray2[i];
            if (JCUtilities.constructorEqual(jCMethod, jCMethod2) && JCUtilities.stringEqual(jCMethod.getName(), jCMethod2.getName()) && JCUtilities.typeEqual(jCMethod.getReturnType(), jCMethod2.getReturnType())) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(JCClass jCClass, JCClass jCClass2) {
        if (jCClass == null && jCClass2 == null) {
            return true;
        }
        if (jCClass == null || jCClass2 == null) {
            return false;
        }
        if (!jCClass.equals(jCClass2) || jCClass.isInterface() != jCClass2.isInterface() || jCClass.getModifiers() != jCClass2.getModifiers() || !JCUtilities.classEqual(jCClass.getSuperclass(), jCClass2.getSuperclass())) {
            return false;
        }
        return JCUtilities.fieldArraysEqual(jCClass.getFields(), jCClass2.getFields()) && JCUtilities.constructorArrayEqual(jCClass.getConstructors(), jCClass2.getConstructors()) && JCUtilities.methodArraysEqual(jCClass.getMethods(), jCClass2.getMethods()) && JCUtilities.classArrayEqual(jCClass.getInterfaces(), jCClass2.getInterfaces());
    }

    private static boolean isDeprecated(int n) {
        return (n & 0x100000) != 0;
    }

    public static boolean isDeprecated(Object object) {
        if (object instanceof JCClass) {
            return JCUtilities.isDeprecated(((JCClass)object).getModifiers());
        }
        if (object instanceof JCConstructor) {
            return JCUtilities.isDeprecated(((JCConstructor)object).getModifiers());
        }
        if (object instanceof JCField) {
            return JCUtilities.isDeprecated(((JCField)object).getModifiers());
        }
        return false;
    }

    public static String dumpClass(JCClass jCClass) {
        JCMethod[] jCMethodArray;
        JCConstructor[] jCConstructorArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(jCClass.getModifiers()));
        stringBuffer.append(jCClass.isInterface() ? " interface " : " class ");
        stringBuffer.append(jCClass);
        stringBuffer.append(" extends ");
        stringBuffer.append(jCClass.getSuperclass());
        JCClass[] jCClassArray = jCClass.getInterfaces();
        int n = jCClassArray.length - 1;
        if (n >= 0) {
            stringBuffer.append(" implements ");
            for (int i = 0; i <= n; ++i) {
                stringBuffer.append(jCClassArray[i].toString());
                if (i >= n) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append('\n');
        String string = "    ";
        JCField[] jCFieldArray = jCClass.getFields();
        if (jCFieldArray.length > 0) {
            stringBuffer.append("FIELDS:\n");
            for (int i = 0; i < jCFieldArray.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(jCFieldArray[i]);
                stringBuffer.append('\n');
            }
        }
        if ((jCConstructorArray = jCClass.getConstructors()).length > 0) {
            stringBuffer.append("CONSTRUCTORS:\n");
            for (int i = 0; i < jCConstructorArray.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(jCConstructorArray[i]);
                stringBuffer.append('\n');
            }
        }
        if ((jCMethodArray = jCClass.getMethods()).length > 0) {
            stringBuffer.append("METHODS:\n");
            for (int i = 0; i < jCMethodArray.length; ++i) {
                stringBuffer.append(string);
                stringBuffer.append(jCMethodArray[i]);
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    public static JCClass getExactClass(JCFinder jCFinder, String string, String string2) {
        return jCFinder.getExactClass(string2.length() != 0 ? string2 + "." + string : string);
    }

    public static List getConstructors(JCClass jCClass) {
        return JCUtilities.getConstructors(jCClass, true);
    }

    public static List getConstructors(JCClass jCClass, boolean bl) {
        TreeSet<JCConstructor> treeSet = new TreeSet<JCConstructor>();
        JCConstructor[] jCConstructorArray = jCClass.getConstructors();
        for (int i = jCConstructorArray.length - 1; i >= 0; --i) {
            if (!bl && JCUtilities.isDeprecated(jCConstructorArray[i])) continue;
            treeSet.add(jCConstructorArray[i]);
        }
        if (jCConstructorArray.length == 0) {
            treeSet.add(new JavaCompletion.BaseConstructor(jCClass, 1, JavaCompletion.EMPTY_PARAMETERS, JavaCompletion.EMPTY_CLASSES));
        }
        return new ArrayList(treeSet);
    }

    public static List getAllInterfaces(JCFinder jCFinder, JCClass jCClass) {
        return JCUtilities.getAllInterfaces(jCFinder, jCClass, true);
    }

    public static List getAllInterfaces(JCFinder jCFinder, JCClass jCClass, boolean bl) {
        ArrayList arrayList = new ArrayList();
        JCUtilities.collectInterfaces(jCFinder, jCClass, arrayList, bl);
        return arrayList;
    }

    private static void collectInterfaces(JCFinder jCFinder, JCClass jCClass, ArrayList arrayList, boolean bl) {
        JCClass[] jCClassArray = jCClass.getInterfaces();
        if (jCClassArray != null) {
            for (int i = 0; i < jCClassArray.length; ++i) {
                if (arrayList.contains(jCClassArray[i])) continue;
                if (bl || !JCUtilities.isDeprecated(jCClassArray[i])) {
                    arrayList.add(jCClassArray[i]);
                }
                if ((jCClass = jCFinder.getExactClass(jCClassArray[i].getFullName())) == null) continue;
                JCUtilities.collectInterfaces(jCFinder, jCClass, arrayList, bl);
            }
        }
    }

    public static List getSuperclasses(JCFinder jCFinder, JCClass jCClass) {
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        if ((jCClass = jCFinder.getExactClass(jCClass.getFullName())) != null) {
            jCClass = jCClass.getSuperclass();
        }
        while (jCClass != null && arrayList.indexOf(jCClass) < 0) {
            arrayList.add(jCClass);
            if ((jCClass = jCFinder.getExactClass(jCClass.getFullName())) == null) continue;
            jCClass = jCClass.getSuperclass();
        }
        return arrayList;
    }

    public static JCClass createSimpleClass(Class clazz) {
        if (clazz == null || clazz.getName() == null) {
            return JavaCompletion.INVALID_CLASS;
        }
        return JCUtilities.createSimpleClassImpl(clazz.getName());
    }

    private static JCClass createSimpleClassImpl(String string) {
        int n = string.lastIndexOf(46);
        return JavaCompletion.getSimpleClass(string.replace('$', '.'), n >= 0 ? n : 0);
    }

    public static JavaCompletion.BaseType createType(Class clazz) {
        if (clazz == null) {
            return JavaCompletion.INVALID_TYPE;
        }
        String string = clazz.getName();
        int n = 0;
        while (string.length() > 0 && string.charAt(0) == '[') {
            ++n;
            string = string.substring(1);
        }
        if (n > 0) {
            switch (string.charAt(0)) {
                case 'L': {
                    string = string.substring(1, string.length() - 1);
                    break;
                }
                case 'B': {
                    string = "byte";
                    break;
                }
                case 'C': {
                    string = "char";
                    break;
                }
                case 'D': {
                    string = "double";
                    break;
                }
                case 'F': {
                    string = "float";
                    break;
                }
                case 'I': {
                    string = "int";
                    break;
                }
                case 'J': {
                    string = "long";
                    break;
                }
                case 'S': {
                    string = "short";
                    break;
                }
                case 'Z': {
                    string = "boolean";
                }
            }
        }
        return new JavaCompletion.BaseType(JCUtilities.createSimpleClassImpl(string), n);
    }

    public static List getClassList(List list, boolean bl, int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            block5: {
                String string = (String)iterator.next();
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Class '" + string + "' not found.");
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    System.err.println("Exception thrown during class rebuild:");
                    throwable.printStackTrace();
                    if (!(throwable instanceof OutOfMemoryError)) break block5;
                    throw (OutOfMemoryError)throwable;
                }
            }
            if (clazz == null) continue;
            arrayList.addAll(JCUtilities.createClassList(clazz, bl, n, n2, n3));
        }
        return arrayList;
    }

    private static String strip(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        if (string.startsWith(string2)) {
            n = string2.length();
        }
        if (string.endsWith(string3)) {
            n2 = string3.length();
        }
        return string.substring(n, string.length() - n2);
    }

    private static String separatorToDot(String string) {
        return string.replace(File.separatorChar, '.');
    }

    private static List createClassList(Class clazz, boolean bl, int n, int n2, int n3) {
        ArrayList<BaseJCClass> arrayList = new ArrayList<BaseJCClass>();
        if (clazz == null) {
            return arrayList;
        }
        if (JavaCompletion.getLevel(clazz.getModifiers()) >= n) {
            arrayList.add(new BaseJCClass(clazz, n, n2, n3));
        }
        if (bl) {
            try {
                Class<?>[] classArray = clazz.getDeclaredClasses();
                for (int i = 0; i < classArray.length; ++i) {
                    if (JavaCompletion.getLevel(classArray[i].getModifiers()) < n) continue;
                    arrayList.addAll(JCUtilities.createClassList(classArray[i], bl, n, n2, n3));
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        return arrayList;
    }

    public static List getClassNameList(String string) {
        File file = new File(string);
        ArrayList arrayList = new ArrayList();
        string = string + File.separator;
        if (file.exists()) {
            JCUtilities.getClassListFromSourcesRec(arrayList, string, file);
        }
        return arrayList;
    }

    private static void getClassListFromSourcesRec(final List list, final String string, File file) {
        file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    JCUtilities.getClassListFromSourcesRec(list, string, file);
                }
                if (file.getName().endsWith(".java")) {
                    list.add(JCUtilities.separatorToDot(JCUtilities.strip(file.getAbsolutePath(), string, ".java")));
                }
                return false;
            }
        });
    }

    public static boolean getPrimitivesAssignable(int n, int n2) {
        return primitivesAssignable[n][n2];
    }

    public static boolean isPrimitiveClass(JCClass jCClass) {
        return jCClass.getPackageName().length() == 0 && JavaTokenContext.isTypeOrVoid(jCClass.getName());
    }

    public static JCClass getPrimitivesCommonClass(int n, int n2) {
        return primitivesCommonClass[n][n2];
    }

    static {
        int[] nArray = new int[]{63, 64, 65, 66, 67, 68, 69, 70, 71};
        boolean[][] blArrayArray = new boolean[][]{{true, false, false, false, false, false, false, false, false}, {false, true, false, true, true, true, true, true, false}, {false, false, true, true, true, true, true, false, false}, {false, false, false, true, false, false, false, false, false}, {false, false, false, true, true, false, false, false, false}, {false, false, false, true, true, true, true, false, false}, {false, false, false, true, true, false, true, false, false}, {false, false, false, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, true}};
        JCClass[][] jCClassArrayArray = new JCClass[][]{{JavaCompletion.BOOLEAN_CLASS, null, null, null, null, null, null, null, null}, {null, JavaCompletion.BYTE_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.CHAR_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.DOUBLE_CLASS, null}, {null, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.FLOAT_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.INT_CLASS, null}, {null, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.LONG_CLASS, null}, {null, JavaCompletion.INT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.DOUBLE_CLASS, JavaCompletion.FLOAT_CLASS, JavaCompletion.INT_CLASS, JavaCompletion.LONG_CLASS, JavaCompletion.SHORT_CLASS, null}, {null, null, null, null, null, null, null, null, JavaCompletion.VOID_CLASS}};
        for (int i = 0; i < nArray.length; ++i) {
            JCUtilities.primitivesAssignable[nArray[i]] = new boolean[javaTokenIDsLength];
            JCUtilities.primitivesCommonClass[nArray[i]] = new JCClass[javaTokenIDsLength];
            for (int j = 0; j < nArray.length; ++j) {
                JCUtilities.primitivesAssignable[nArray[i]][nArray[j]] = blArrayArray[i][j];
                JCUtilities.primitivesCommonClass[nArray[i]][nArray[j]] = jCClassArrayArray[i][j];
            }
        }
    }

    public static class BaseJCClass
    extends JavaCompletion.AbstractClass {
        Class c;
        int classLevel;
        int fieldLevel;
        int methodLevel;

        public BaseJCClass(Class clazz, int n, int n2, int n3) {
            this.c = clazz;
            this.classLevel = n;
            this.fieldLevel = n2;
            this.methodLevel = n3;
            JCClass jCClass = JCUtilities.createSimpleClass(clazz);
            this.name = jCClass.getName();
            this.packageName = jCClass.getPackageName();
            this.modifiers = clazz.getModifiers();
            if (clazz.isInterface()) {
                this.modifiers |= 0x200;
            }
        }

        protected void init() {
            int n;
            Class<?>[] classArray;
            Object[] objectArray;
            JCParameter[] jCParameterArray;
            int n2;
            AccessibleObject[] accessibleObjectArray;
            this.body = new JavaCompletion.AbstractClass.Body();
            ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
            this.body.superClass = JCUtilities.createSimpleClass(this.c.getSuperclass());
            Class<?>[] classArray2 = this.c.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                if (JavaCompletion.getLevel(classArray2[i].getModifiers()) < this.classLevel) continue;
                arrayList.add(JCUtilities.createSimpleClass(classArray2[i]));
            }
            this.body.interfaces = new JCClass[arrayList.size()];
            arrayList.toArray(this.body.interfaces);
            arrayList.clear();
            try {
                accessibleObjectArray = this.c.getDeclaredFields();
                for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                    if (JavaCompletion.getLevel(((Field)accessibleObjectArray[n2]).getModifiers()) < this.fieldLevel) continue;
                    arrayList.add(new JavaCompletion.BaseField(this, ((Field)accessibleObjectArray[n2]).getName(), JCUtilities.createType(((Field)accessibleObjectArray[n2]).getType()), ((Field)accessibleObjectArray[n2]).getModifiers()));
                }
                this.body.fields = new JCField[arrayList.size()];
                arrayList.toArray(this.body.fields);
                arrayList.clear();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            try {
                accessibleObjectArray = this.c.getDeclaredConstructors();
                for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                    if (JavaCompletion.getLevel(((Constructor)accessibleObjectArray[n2]).getModifiers()) < this.methodLevel) continue;
                    jCParameterArray = JavaCompletion.EMPTY_PARAMETERS;
                    try {
                        objectArray = ((Constructor)accessibleObjectArray[n2]).getParameterTypes();
                        jCParameterArray = new JCParameter[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            jCParameterArray[i] = new JavaCompletion.BaseParameter("", JCUtilities.createType((Class)objectArray[i]));
                        }
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                    }
                    objectArray = JavaCompletion.EMPTY_CLASSES;
                    try {
                        classArray = ((Constructor)accessibleObjectArray[n2]).getExceptionTypes();
                        objectArray = new JCClass[classArray.length];
                        for (n = 0; n < classArray.length; ++n) {
                            objectArray[n] = JCUtilities.createSimpleClass(classArray[n]);
                        }
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                    }
                    arrayList.add(new JavaCompletion.BaseConstructor(this, ((Constructor)accessibleObjectArray[n2]).getModifiers(), jCParameterArray, (JCClass[])objectArray));
                }
                this.body.constructors = new JCConstructor[arrayList.size()];
                arrayList.toArray(this.body.constructors);
                arrayList.clear();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            try {
                accessibleObjectArray = this.c.getDeclaredMethods();
                for (n2 = 0; n2 < accessibleObjectArray.length; ++n2) {
                    if (JavaCompletion.getLevel(((Method)accessibleObjectArray[n2]).getModifiers()) < this.methodLevel) continue;
                    jCParameterArray = JavaCompletion.EMPTY_PARAMETERS;
                    try {
                        objectArray = ((Method)accessibleObjectArray[n2]).getParameterTypes();
                        jCParameterArray = new JCParameter[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            jCParameterArray[i] = new JavaCompletion.BaseParameter("", JCUtilities.createType((Class)objectArray[i]));
                        }
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                    }
                    objectArray = JavaCompletion.EMPTY_CLASSES;
                    try {
                        classArray = ((Method)accessibleObjectArray[n2]).getExceptionTypes();
                        objectArray = new JCClass[classArray.length];
                        for (n = 0; n < classArray.length; ++n) {
                            objectArray[n] = JCUtilities.createSimpleClass(classArray[n]);
                        }
                    }
                    catch (SecurityException securityException) {
                        securityException.printStackTrace();
                    }
                    arrayList.add(new JavaCompletion.BaseMethod(this, ((Method)accessibleObjectArray[n2]).getName(), ((Method)accessibleObjectArray[n2]).getModifiers(), JCUtilities.createType(((Method)accessibleObjectArray[n2]).getReturnType()), jCParameterArray, (JCClass[])objectArray));
                }
                this.body.methods = new JCMethod[arrayList.size()];
                arrayList.toArray(this.body.methods);
                arrayList.clear();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            this.c = null;
        }
    }
}

