/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JCTokenProcessor;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;

public abstract class JavaCompletionQuery
implements CompletionQuery {
    private BaseDocument baseDocument;
    private boolean java15;
    private static JCItemFactory itemFactory;

    protected BaseDocument getBaseDocument() {
        return this.baseDocument;
    }

    protected abstract JCFinder getFinder();

    public JavaCompletionQuery() {
        this.initFactory();
    }

    protected void initFactory() {
        this.setJCItemFactory(new DefaultJCItemFactory());
    }

    protected void setJava15(boolean bl) {
        this.java15 = bl;
    }

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport) {
        return this.query(jTextComponent, n, syntaxSupport, false);
    }

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport, boolean bl) {
        BaseDocument baseDocument;
        this.baseDocument = baseDocument = (BaseDocument)jTextComponent.getDocument();
        JavaSyntaxSupport javaSyntaxSupport = (JavaSyntaxSupport)syntaxSupport.get(JavaSyntaxSupport.class);
        CompletionQuery.Result result = null;
        try {
            int n2 = javaSyntaxSupport.getLastCommandSeparator(n);
            JCTokenProcessor jCTokenProcessor = new JCTokenProcessor(n);
            jCTokenProcessor.setJava15(this.java15);
            boolean bl2 = true;
            while (bl2) {
                javaSyntaxSupport.tokenizeText(jCTokenProcessor, n2 + 1 <= n ? n2 + 1 : n, n, true);
                bl2 = jCTokenProcessor.isStopped() && (n2 = javaSyntaxSupport.findMatchingBlock(jCTokenProcessor.getCurrentOffest(), true)[0]) < n - 1;
            }
            boolean bl3 = false;
            TokenID tokenID = jCTokenProcessor.getLastValidTokenID();
            if (tokenID != null) {
                switch (tokenID.getNumericID()) {
                    case 25: {
                        bl3 = true;
                        break;
                    }
                    case 8: {
                        if (jCTokenProcessor.getLastValidTokenText() != null && jCTokenProcessor.getLastValidTokenText().endsWith("*/")) break;
                        bl3 = true;
                        break;
                    }
                    case 7: {
                        bl3 = true;
                    }
                }
            }
            if (!bl3) {
                javaSyntaxSupport.refreshClassInfo();
                JCExpression jCExpression = jCTokenProcessor.getResultExp();
                result = this.getResult(jTextComponent, javaSyntaxSupport, bl, n, jCExpression);
                if (result != null && this instanceof EnclosingResultProcessor) {
                    JCExpression jCExpression2;
                    CompletionQuery.Result result2 = null;
                    if (jCExpression != null && jCExpression.getExpID() == 1 && jCExpression.getTokenCount() == 1 && "".equals(jCExpression.getTokenText(0)) && (jCExpression2 = jCTokenProcessor.getResultEnclosingExp()) != null && (result2 = this.getResult(jTextComponent, javaSyntaxSupport, bl, n, jCExpression2)) != null) {
                        ((EnclosingResultProcessor)((Object)this)).processEnclosingResult(result2, jCExpression2, result);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return result;
    }

    public CompletionQuery.Result tipQuery(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport, boolean bl) {
        CompletionQuery.Result result;
        block17: {
            BaseDocument baseDocument;
            this.baseDocument = baseDocument = (BaseDocument)jTextComponent.getDocument();
            JavaSyntaxSupport javaSyntaxSupport = (JavaSyntaxSupport)syntaxSupport.get(JavaSyntaxSupport.class);
            result = null;
            try {
                int n2 = javaSyntaxSupport.getLastCommandSeparator(n);
                JCTokenProcessor jCTokenProcessor = new JCTokenProcessor(n);
                jCTokenProcessor.setJava15(this.java15);
                boolean bl2 = true;
                int n3 = 20;
                while (bl2 && --n3 > 0) {
                    javaSyntaxSupport.tokenizeText(jCTokenProcessor, n2 + 1 <= n ? n2 + 1 : n, n, true);
                    bl2 = jCTokenProcessor.isStopped();
                    if (!bl2) continue;
                    int[] nArray = javaSyntaxSupport.findMatchingBlock(jCTokenProcessor.getCurrentOffest(), true);
                    if (nArray != null) {
                        n2 = nArray[0];
                        continue;
                    }
                    bl2 = false;
                }
                if (n3 == 0) {
                    new Exception("Infinite loop broken: offset=" + n + ", lastSepOffset=" + n2 + ". If possible please save the source file and attach it to " + " http://www.netbeans.org/issues/show_bug.cgi?id=61281").printStackTrace();
                    return null;
                }
                boolean bl3 = false;
                TokenID tokenID = jCTokenProcessor.getLastValidTokenID();
                if (tokenID != null) {
                    switch (tokenID.getNumericID()) {
                        case 25: {
                            bl3 = true;
                            break;
                        }
                        case 8: {
                            if (jCTokenProcessor.getLastValidTokenText() != null && jCTokenProcessor.getLastValidTokenText().endsWith("*/")) break;
                            bl3 = true;
                            break;
                        }
                        case 7: {
                            bl3 = true;
                        }
                    }
                }
                if (bl3) break block17;
                javaSyntaxSupport.refreshClassInfo();
                List list = jCTokenProcessor.getStack();
                for (int i = list.size() - 1; i >= 0; --i) {
                    JCExpression jCExpression;
                    JCExpression jCExpression2 = (JCExpression)list.get(i);
                    if (10 == jCExpression2.getExpID()) {
                        jCTokenProcessor.eot(n);
                        jCExpression2 = (JCExpression)jCTokenProcessor.getStack().get(jCTokenProcessor.getStack().size() - 2);
                        result = this.getResult(jTextComponent, javaSyntaxSupport, bl, n, jCExpression2);
                        break;
                    }
                    if (4 == jCExpression2.getExpID()) {
                        if (10 == jCExpression2.getParameter(jCExpression2.getParameterCount() - 1).getExpID()) {
                            result = this.getResult(jTextComponent, javaSyntaxSupport, bl, n, jCExpression2);
                            break;
                        }
                    } else if (12 == jCExpression2.getExpID() && (4 == (jCExpression = jCExpression2.getParameter(jCExpression2.getParameterCount() - 1)).getExpID() && 10 == jCExpression.getParameter(jCExpression.getParameterCount() - 1).getExpID() || 10 == jCExpression.getExpID())) {
                        result = this.getResult(jTextComponent, javaSyntaxSupport, bl, n, jCExpression2);
                        break;
                    }
                    list.remove(i);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return result;
    }

    protected CompletionQuery.Result getResult(JTextComponent jTextComponent, JavaSyntaxSupport javaSyntaxSupport, boolean bl, int n, JCExpression jCExpression) {
        Context context = new Context(jTextComponent, javaSyntaxSupport, bl, n, this.getFinder());
        context.resolveExp(jCExpression);
        return context.result;
    }

    static List findFieldsAndMethods(JCFinder jCFinder, String string, JCClass jCClass, String string2, boolean bl, boolean bl2, boolean bl3) {
        JCPackage jCPackage;
        List list = new ArrayList();
        if (bl2 && (jCPackage = jCFinder.getExactPackage(jCClass.getPackageName())) != null) {
            list = jCFinder.findClasses(jCPackage, jCClass.getName() + '.' + string2, false);
        }
        if (jCFinder instanceof JCBaseFinder) {
            list.addAll(((JCBaseFinder)jCFinder).findFields(string, jCClass, string2, bl, bl2, bl3));
            list.addAll(((JCBaseFinder)jCFinder).findMethods(string, jCClass, string2, bl, bl2, bl3));
        } else {
            list.addAll(jCFinder.findFields(jCClass, string2, bl, bl2, bl3));
            list.addAll(jCFinder.findMethods(jCClass, string2, bl, bl2, bl3));
        }
        return list;
    }

    private static String formatTypeList(List list, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            int n = list.size() - 1;
            for (int i = 0; i <= n; ++i) {
                JCType jCType = (JCType)list.get(i);
                if (jCType != null) {
                    stringBuffer.append(jCType.format(false));
                } else {
                    stringBuffer.append('?');
                }
                if (i >= n) continue;
                stringBuffer.append(", ");
            }
            if (bl) {
                stringBuffer.append(", *");
            }
        } else if (bl) {
            stringBuffer.append("*");
        }
        return stringBuffer.toString();
    }

    protected void setJCItemFactory(JCItemFactory jCItemFactory) {
        itemFactory = jCItemFactory;
    }

    public static JCItemFactory getJCItemFactory() {
        return itemFactory;
    }

    public static interface EnclosingResultProcessor {
        public void processEnclosingResult(CompletionQuery.Result var1, JCExpression var2, CompletionQuery.Result var3);
    }

    public static class DefaultJCItemFactory
    implements JCItemFactory {
        public JCResultItem.PackageResultItem createPackageResultItem(JCPackage jCPackage, boolean bl) {
            return new JCResultItem.PackageResultItem(jCPackage, bl);
        }

        public JCResultItem.ClassResultItem createClassResultItem(JCClass jCClass, int n, boolean bl) {
            return new JCResultItem.ClassResultItem(jCClass, n, bl);
        }

        public JCResultItem.FieldResultItem createFieldResultItem(JCField jCField) {
            return new JCResultItem.FieldResultItem(jCField);
        }

        public JCResultItem.MethodResultItem createMethodResultItem(JCMethod jCMethod, JCExpression jCExpression) {
            return new JCResultItem.MethodResultItem(jCMethod, jCExpression);
        }

        public JCResultItem.ConstructorResultItem createConstructorResultItem(JCConstructor jCConstructor, JCExpression jCExpression) {
            return new JCResultItem.ConstructorResultItem(jCConstructor, jCExpression);
        }
    }

    public static interface JCItemFactory {
        public JCResultItem.PackageResultItem createPackageResultItem(JCPackage var1, boolean var2);

        public JCResultItem.ClassResultItem createClassResultItem(JCClass var1, int var2, boolean var3);

        public JCResultItem.FieldResultItem createFieldResultItem(JCField var1);

        public JCResultItem.MethodResultItem createMethodResultItem(JCMethod var1, JCExpression var2);

        public JCResultItem.ConstructorResultItem createConstructorResultItem(JCConstructor var1, JCExpression var2);
    }

    public static class JavaResult
    extends CompletionQuery.DefaultResult {
        private int classDisplayOffset;
        private JCExpression substituteExp;
        private int substituteOffset;
        private int substituteLength;
        private JTextComponent component;

        public JavaResult(JTextComponent jTextComponent, List list, String string, JCExpression jCExpression, int n) {
            this(jTextComponent, list, string, jCExpression, jCExpression.getTokenOffset(0), jCExpression.getTokenLength(0), n);
        }

        public JavaResult(JTextComponent jTextComponent, List list, String string, JCExpression jCExpression, int n, int n2, int n3) {
            super(jTextComponent, string, JavaResult.convertData(list, n3, jCExpression), n, n2);
            this.component = jTextComponent;
            this.substituteExp = jCExpression;
            this.substituteOffset = n;
            this.substituteLength = n2;
            this.classDisplayOffset = n3;
        }

        private static List convertData(List list, int n, JCExpression jCExpression) {
            Iterator iterator = list.iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CompletionQuery.ResultItem) {
                    arrayList.add(e);
                    continue;
                }
                arrayList.add(JavaResult.createResultItem(e, n, jCExpression));
            }
            return arrayList;
        }

        private static CompletionQuery.ResultItem createResultItem(Object object, int n, JCExpression jCExpression) {
            if (object instanceof JCPackage) {
                return JavaCompletionQuery.getJCItemFactory().createPackageResultItem((JCPackage)object, false);
            }
            if (object instanceof JCClass) {
                return JavaCompletionQuery.getJCItemFactory().createClassResultItem((JCClass)object, n, false);
            }
            if (object instanceof JCField) {
                return JavaCompletionQuery.getJCItemFactory().createFieldResultItem((JCField)object);
            }
            if (object instanceof JCMethod) {
                return JavaCompletionQuery.getJCItemFactory().createMethodResultItem((JCMethod)object, jCExpression);
            }
            if (object instanceof JCConstructor) {
                return JavaCompletionQuery.getJCItemFactory().createConstructorResultItem((JCConstructor)object, jCExpression);
            }
            return null;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        protected int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected JCExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected int getClassDisplayOffset() {
            return this.classDisplayOffset;
        }

        protected String getMainText(Object object) {
            String string = null;
            if (object instanceof JCPackage) {
                string = ((JCPackage)object).getLastName();
            } else if (object instanceof JCClass) {
                string = ((JCClass)object).getName();
                if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                    string = string.substring(this.classDisplayOffset);
                }
            } else if (object instanceof JCField) {
                string = ((JCField)object).getName();
            } else if (object instanceof JCMethod) {
                JCMethod jCMethod = (JCMethod)object;
                string = jCMethod.getName();
            } else if (object instanceof JCConstructor) {
                string = ((JCConstructor)object).getClazz().getName();
            }
            return string;
        }

        protected String getCommonText(String string) {
            List list = this.getData();
            int n = list.size();
            int n2 = string.length();
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                int n3;
                String string3 = this.getMainText(list.get(i));
                if (string3 == null || !string3.startsWith(string)) continue;
                string3 = string3.substring(n2);
                if (string2 == null) {
                    string2 = string3;
                }
                int n4 = Math.min(string3.length(), string2.length());
                for (n3 = 0; n3 < n4 && string3.charAt(n3) == string2.charAt(n3); ++n3) {
                }
                if (n3 != 0) {
                    string2 = string2.substring(0, n3);
                    continue;
                }
                return null;
            }
            return string + (string2 != null ? string2 : "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteCommonText(int n) {
            block8: {
                List list = this.getData();
                if (list.size() == 0) {
                    return false;
                }
                Object e = this.getData().get(n);
                if (e instanceof CompletionQuery.ResultItem) {
                    // empty if block
                }
                BaseDocument baseDocument = (BaseDocument)this.component.getDocument();
                try {
                    String string = baseDocument.getText(this.substituteOffset, this.substituteLength);
                    String string2 = this.getCommonText(string);
                    if (string2 == null) break block8;
                    if (this.substituteExp != null && (this.substituteExp.getExpID() == 10 || this.substituteExp.getExpID() == 11)) {
                        return true;
                    }
                    baseDocument.atomicLock();
                    try {
                        baseDocument.remove(this.substituteOffset, this.substituteLength);
                        baseDocument.insertString(this.substituteOffset, string2, null);
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(int n, boolean bl) {
            Object object;
            int n2;
            int n3;
            String string;
            BaseDocument baseDocument;
            block27: {
                Object e;
                block30: {
                    block29: {
                        block28: {
                            block26: {
                                Object e2 = this.getData().get(n);
                                if (e2 instanceof CompletionQuery.ResultItem) {
                                    return super.substituteText(n, bl);
                                }
                                baseDocument = (BaseDocument)this.component.getDocument();
                                string = null;
                                n3 = -1;
                                n2 = -1;
                                e = this.getData().get(n);
                                if (!(e instanceof JCPackage)) break block26;
                                string = ((JCPackage)e).getLastName();
                                break block27;
                            }
                            if (!(e instanceof JCClass)) break block28;
                            string = ((JCClass)e).getName();
                            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                                string = string.substring(this.classDisplayOffset);
                            }
                            break block27;
                        }
                        if (!(e instanceof JCField)) break block29;
                        string = ((JCField)e).getName();
                        break block27;
                    }
                    if (!(e instanceof JCConstructor)) break block30;
                    object = (JCConstructor)e;
                    switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                        case 11: {
                            break;
                        }
                        case 10: {
                            Object object2;
                            JCParameter[] jCParameterArray = object.getParameters();
                            if (jCParameterArray.length == 0) {
                                string = ")";
                                break;
                            }
                            int n4 = this.substituteExp.getParameterCount();
                            boolean bl2 = false;
                            Formatter formatter = baseDocument.getFormatter();
                            if (formatter instanceof ExtFormatter && (object2 = ((ExtFormatter)formatter).getSettingValue("java-format-space-after-comma")) instanceof Boolean && ((Boolean)object2).booleanValue()) {
                                bl2 = true;
                            }
                            try {
                                if (bl2 && (n4 == 0 || this.substituteOffset > 0 && Character.isWhitespace(baseDocument.getText(this.substituteOffset - 1, 1).charAt(0)))) {
                                    bl2 = false;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            if (n4 < jCParameterArray.length) {
                                string = bl2 ? " " : "";
                                n3 = string.length();
                                string = string + jCParameterArray[n4].getName();
                                n2 = string.length();
                                break;
                            }
                            break block27;
                        }
                        default: {
                            Object object3;
                            string = this.getMainText(e);
                            boolean bl3 = false;
                            Formatter formatter = baseDocument.getFormatter();
                            if (formatter instanceof ExtFormatter && (object3 = ((ExtFormatter)formatter).getSettingValue("java-format-space-before-parenthesis")) instanceof Boolean && ((Boolean)object3).booleanValue()) {
                                bl3 = true;
                            }
                            if (bl3) {
                                string = string + ' ';
                            }
                            string = string + '(';
                            JCParameter[] jCParameterArray = object.getParameters();
                            if (jCParameterArray.length > 0) {
                                n3 = string.length();
                                string = string + jCParameterArray[0].getName();
                                n2 = string.length();
                                break;
                            }
                            string = string + ")";
                            break;
                        }
                    }
                    break block27;
                }
                if (e instanceof JCConstructor) {
                    string = ((JCConstructor)e).getClazz().getName();
                }
            }
            if (string != null) {
                baseDocument.atomicLock();
                try {
                    object = baseDocument.getText(this.substituteOffset, this.substituteLength);
                    if (string.equals(object)) {
                        boolean bl4 = false;
                        return bl4;
                    }
                    baseDocument.remove(this.substituteOffset, this.substituteLength);
                    baseDocument.insertString(this.substituteOffset, string, null);
                    if (n3 >= 0) {
                        this.component.select(this.substituteOffset + n3, this.substituteOffset + n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            return true;
        }
    }

    static class Context {
        private JTextComponent component;
        private JavaSyntaxSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = true;
        private JCPackage lastPkg;
        private JCType lastType;
        private JavaResult result;
        private boolean isConstructor;
        private JCFinder finder;

        public Context(JTextComponent jTextComponent, JavaSyntaxSupport javaSyntaxSupport, boolean bl, int n, JCFinder jCFinder) {
            this.component = jTextComponent;
            this.sup = javaSyntaxSupport;
            this.openingSource = bl;
            this.endOffset = n;
            this.finder = jCFinder;
        }

        public void setFindType(boolean bl) {
            this.findType = bl;
        }

        protected Object clone() {
            return new Context(this.component, this.sup, this.openingSource, this.endOffset, this.finder);
        }

        private String formatType(JCType jCType, boolean bl, boolean bl2, boolean bl3) {
            StringBuffer stringBuffer = new StringBuffer();
            if (jCType != null) {
                stringBuffer.append(jCType.format(bl));
            }
            if (bl2) {
                stringBuffer.append('.');
            }
            if (bl3) {
                stringBuffer.append('*');
            }
            return stringBuffer.toString();
        }

        private JCType resolveType(JCExpression jCExpression) {
            Context context = (Context)this.clone();
            context.setFindType(true);
            JCType jCType = null;
            if (context.resolveExp(jCExpression)) {
                jCType = context.lastType;
            }
            return jCType;
        }

        boolean resolveExp(JCExpression jCExpression) {
            boolean bl = false;
            boolean bl2 = true;
            if (jCExpression.getExpID() == 22) {
                jCExpression = jCExpression.getParameterCount() == 2 ? jCExpression.getParameter(1) : jCExpression.getParameter(0);
            }
            switch (jCExpression.getExpID()) {
                case 5: {
                    bl = true;
                }
                case 4: {
                    List list;
                    int n;
                    int n2 = jCExpression.getParameterCount();
                    for (n = 0; n < n2 && bl2; ++n) {
                        bl2 = this.resolveItem(jCExpression.getParameter(n), n == 0, !bl && n == n2 - 1);
                    }
                    if (!bl2 || !bl) break;
                    n = jCExpression.getTokenCount() - 1;
                    int n3 = jCExpression.getTokenOffset(n) + jCExpression.getTokenLength(n);
                    if (this.lastType != null) {
                        List<JCClass> list2;
                        JCClass jCClass = this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY;
                        if (this.openingSource) {
                            list2 = new ArrayList<JCClass>();
                            list2.add(this.lastType.getClazz());
                        } else {
                            JCClass jCClass2 = this.sup.getClass(jCExpression.getTokenOffset(n));
                            list2 = JavaCompletionQuery.findFieldsAndMethods(this.finder, jCClass2 == null ? null : jCClass2.getPackageName(), jCClass, "", false, this.staticOnly, false);
                        }
                        this.result = new JavaResult(this.component, list2, this.formatType(this.lastType, true, true, true), jCExpression, n3, 0, jCClass.getName().length() + 1);
                        break;
                    }
                    String string = this.lastPkg.getName() + '.';
                    if (this.openingSource) {
                        list = new ArrayList<JCPackage>();
                        list.add(this.lastPkg);
                    } else {
                        list = this.finder.findPackages(string, false, false);
                        String string2 = null;
                        try {
                            int n4 = jCExpression.getTokenOffset(0);
                            int n5 = this.sup.getLastCommandSeparator(n4);
                            if (n5 < 0) {
                                string2 = this.sup.getDocument().getText(0, n4);
                                n5 = string2.lastIndexOf(10);
                                if (n5 != -1) {
                                    string2 = string2.substring(n5 + 1);
                                }
                            } else {
                                string2 = this.sup.getDocument().getText(n5, n4 - n5);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (string2 != null && -1 == string2.indexOf("package")) {
                            list.addAll(this.finder.findClasses(this.lastPkg, "", false));
                        }
                    }
                    this.result = new JavaResult(this.component, list, string + '*', jCExpression, n3, 0, 0);
                    break;
                }
                case 15: {
                    List list = this.finder.findClasses(null, "", false);
                    this.result = new JavaResult(this.component, list, "*", jCExpression, this.endOffset, 0, 0);
                    break;
                }
                default: {
                    bl2 = this.resolveItem(jCExpression, true, true);
                }
            }
            return bl2;
        }

        boolean resolveItem(JCExpression jCExpression, boolean bl, boolean bl2) {
            boolean bl3 = true;
            boolean bl4 = false;
            block0 : switch (jCExpression.getExpID()) {
                case 0: {
                    if (bl) {
                        this.lastType = JavaCompletion.getPredefinedType(jCExpression.getType());
                        this.staticOnly = false;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 1: {
                    switch (jCExpression.getTokenID(0).getNumericID()) {
                        case 108: {
                            if (bl) {
                                JCClass jCClass = this.sup.getClass(jCExpression.getTokenOffset(0));
                                if (jCClass == null) break block0;
                                this.lastType = JavaCompletion.getType(jCClass, 0);
                                this.staticOnly = false;
                                break block0;
                            }
                            this.staticOnly = false;
                            break block0;
                        }
                        case 105: {
                            if (bl) {
                                JCClass jCClass = this.sup.getClass(jCExpression.getTokenOffset(0));
                                if (jCClass == null || (jCClass = this.finder.getExactClass(jCClass.getFullName())) == null || (jCClass = jCClass.getSuperclass()) == null) break block0;
                                this.lastType = JavaCompletion.getType(jCClass, 0);
                                this.staticOnly = false;
                                break block0;
                            }
                            bl3 = false;
                            break block0;
                        }
                        case 77: {
                            if (!bl) {
                                this.lastType = JavaCompletion.CLASS_TYPE;
                                this.staticOnly = false;
                                break block0;
                            }
                            bl3 = false;
                            break block0;
                        }
                    }
                    String string = jCExpression.getTokenText(0);
                    int n = jCExpression.getTokenOffset(0);
                    if (bl) {
                        if (bl2 && !this.findType) {
                            ArrayList arrayList = new ArrayList();
                            JCClass jCClass = this.sup.getClass(n);
                            if (jCClass != null) {
                                arrayList.addAll(JavaCompletionQuery.findFieldsAndMethods(this.finder, jCClass.getPackageName(), jCClass, string, false, this.sup.isStaticBlock(n), true));
                            }
                            if (string.length() > 0 || !this.openingSource) {
                                arrayList.addAll(this.finder.findPackages(string, false, false));
                                if (string.length() > 0) {
                                    Object object;
                                    arrayList.addAll(this.finder.findClasses(null, string, false));
                                    if (jCClass != null) {
                                        object = this.finder.getExactPackage(jCClass.getPackageName());
                                        List list = this.finder.findClasses((JCPackage)object, jCClass.getName() + "." + string, false);
                                        for (int i = 0; i < list.size(); ++i) {
                                            if (arrayList.contains(list.get(i))) continue;
                                            arrayList.add(list.get(i));
                                        }
                                    }
                                    object = this.sup.getImportedInnerClasses();
                                    for (int i = 0; i < object.size(); ++i) {
                                        JCClass jCClass2 = (JCClass)object.get(i);
                                        if (jCClass2.getName().indexOf("." + string) <= 0 || arrayList.contains(jCClass2)) continue;
                                        arrayList.add(jCClass2);
                                    }
                                }
                            }
                            this.result = new JavaResult(this.component, arrayList, string + '*', jCExpression, 0);
                            break;
                        }
                        this.lastType = (JCType)this.sup.findType(string, n);
                        if (this.lastType != null) {
                            this.staticOnly = false;
                            break;
                        }
                        this.lastPkg = this.finder.getExactPackage(string);
                        if (this.lastPkg != null) break;
                        JCClass jCClass = this.sup.getClassFromName(string, true);
                        if (jCClass != null) {
                            this.lastType = JavaCompletion.getType(jCClass, 0);
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    if (this.lastType != null) {
                        if (this.findType || !bl2) {
                            Object object;
                            boolean bl5 = false;
                            int n2 = this.lastType.getArrayDepth();
                            if (this.staticOnly && n2 == 0 && (object = this.finder.getExactClass(this.lastType.getClazz().getFullName() + "." + string)) != null) {
                                this.lastType = JavaCompletion.getType((JCClass)object, 0);
                                bl5 = true;
                            }
                            if (bl5) break;
                            if (n2 == 0) {
                                object = this.finder.findFields(this.lastType.getClazz(), string, true, this.staticOnly, false);
                                if (object.size() > 0) {
                                    JCField jCField = (JCField)object.get(0);
                                    this.lastType = jCField.getType();
                                    this.staticOnly = false;
                                    break;
                                }
                                this.lastType = null;
                                bl3 = false;
                                break;
                            }
                            bl3 = false;
                            break;
                        }
                        JCClass jCClass = this.sup.getClass(n);
                        JCClass jCClass3 = this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY;
                        this.result = new JavaResult(this.component, JavaCompletionQuery.findFieldsAndMethods(this.finder, jCClass == null ? null : jCClass.getPackageName(), jCClass3, string, false, this.staticOnly, false), this.formatType(this.lastType, true, true, false) + string + '*', jCExpression, jCClass3.getName().length() + 1);
                        break;
                    }
                    String string2 = this.lastPkg.getName() + '.' + string;
                    if (this.findType || !bl2) {
                        this.lastPkg = this.finder.getExactPackage(string2);
                        if (this.lastPkg != null) break;
                        JCClass jCClass = this.finder.getExactClass(string2);
                        if (jCClass != null) {
                            this.lastType = JavaCompletion.getType(jCClass, 0);
                            break;
                        }
                        this.lastType = null;
                        bl3 = false;
                        break;
                    }
                    if (!bl2) break;
                    String string3 = this.lastPkg.getName() + '.' + string;
                    List list = this.finder.findPackages(string3, false, false);
                    list.addAll(this.finder.findClasses(this.lastPkg, string, false));
                    this.result = new JavaResult(this.component, list, string3 + '*', jCExpression, 0);
                    break;
                }
                case 7: {
                    bl3 = this.resolveItem(jCExpression.getParameter(0), bl, false);
                    if (!bl3) break;
                    bl3 = false;
                    if (this.lastType == null) break;
                    if (jCExpression.getParameterCount() == 2) {
                        JCType jCType = this.resolveType(jCExpression.getParameter(1));
                        if (jCType == null || !jCType.equals(JavaCompletion.INT_TYPE)) break;
                        this.lastType = JavaCompletion.getType(this.lastType.getClazz(), Math.max(this.lastType.getArrayDepth() - 1, 0));
                        bl3 = true;
                        break;
                    }
                    this.lastType = JavaCompletion.getType(this.lastType.getClazz(), this.lastType.getArrayDepth() + 1);
                    bl3 = true;
                    break;
                }
                case 16: {
                    this.lastType = JavaCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 2: {
                    ArrayList arrayList = new ArrayList();
                    JCClass jCClass = this.sup.getClass(jCExpression.getTokenOffset(0));
                    if (jCClass != null) {
                        arrayList.addAll(JavaCompletionQuery.findFieldsAndMethods(this.finder, jCClass.getPackageName(), jCClass, "", false, this.sup.isStaticBlock(jCExpression.getTokenOffset(0)), true));
                    }
                    arrayList.addAll(this.finder.findPackages("", false, false));
                    arrayList.addAll(this.finder.findClasses(null, "", false));
                    this.result = new JavaResult(this.component, arrayList, "*", jCExpression, this.endOffset, 0, 0);
                    switch (jCExpression.getTokenID(0).getNumericID()) {
                        case 17: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: {
                            if (jCExpression.getParameterCount() <= 0) break;
                            this.lastType = this.resolveType(jCExpression.getParameter(0));
                            this.staticOnly = false;
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 47: 
                        case 61: 
                        case 62: {
                            this.lastType = JavaCompletion.BOOLEAN_TYPE;
                            break;
                        }
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            switch (jCExpression.getParameterCount()) {
                                case 2: {
                                    JCType jCType = this.resolveType(jCExpression.getParameter(0));
                                    JCType jCType2 = this.resolveType(jCExpression.getParameter(1));
                                    if (jCType == null || jCType2 == null || jCType.getArrayDepth() != 0 || jCType2.getArrayDepth() != 0 || !JavaCompletion.isPrimitiveClass(jCType.getClazz()) || !JavaCompletion.isPrimitiveClass(jCType2.getClazz())) break;
                                    this.lastType = this.sup.getCommonType(jCType, jCType2);
                                    break;
                                }
                                case 1: {
                                    JCType jCType = this.resolveType(jCExpression.getParameter(0));
                                    if (jCType == null || !JavaCompletion.isPrimitiveClass(jCType.getClazz())) break;
                                    this.lastType = jCType;
                                }
                            }
                            break;
                        }
                        case 50: {
                            switch (jCExpression.getParameterCount()) {
                                case 2: {
                                    JCType jCType = this.resolveType(jCExpression.getParameter(0));
                                    JCType jCType3 = this.resolveType(jCExpression.getParameter(1));
                                    if (jCType == null || jCType3 == null) break;
                                    this.lastType = this.sup.getCommonType(jCType, jCType3);
                                    break;
                                }
                                case 1: {
                                    this.lastType = this.resolveType(jCExpression.getParameter(0));
                                }
                            }
                            break;
                        }
                        case 52: {
                            if (jCExpression.getParameterCount() < 2) break;
                            this.lastType = this.resolveType(jCExpression.getParameter(1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (jCExpression.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(jCExpression.getParameter(0));
                    break;
                }
                case 13: {
                    this.lastType = this.resolveType(jCExpression.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 14: {
                    this.lastType = JavaCompletion.getPredefinedType(jCExpression.getType());
                    break;
                }
                case 9: {
                    bl3 = this.resolveItem(jCExpression.getParameter(0), bl, bl2);
                    break;
                }
                case 12: {
                    this.isConstructor = true;
                    bl3 = this.resolveExp(jCExpression.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 10: {
                    bl4 = true;
                }
                case 11: {
                    List list;
                    List list2;
                    String string;
                    List list3;
                    JCClass jCClass;
                    JCExpression jCExpression2 = jCExpression.getParameter(0);
                    String string4 = jCExpression2.getTokenText(0);
                    if ("this".equals(string4) && jCExpression.getTokenCount() > 0 && (jCClass = this.sup.getClass(jCExpression.getTokenOffset(0))) != null && (jCClass = this.finder.getExactClass(jCClass.getFullName())) != null) {
                        this.isConstructor = true;
                        string4 = jCClass.getName();
                    }
                    if ("super".equals(string4) && jCExpression.getTokenCount() > 0 && (jCClass = this.sup.getClass(jCExpression.getTokenOffset(0))) != null && (jCClass = this.finder.getExactClass(jCClass.getFullName())) != null && (jCClass = jCClass.getSuperclass()) != null) {
                        this.isConstructor = true;
                        string4 = jCClass.getName();
                    }
                    if (this.isConstructor) {
                        jCClass = null;
                        if (bl) {
                            jCClass = this.sup.getClassFromName(string4, true);
                        } else if (bl2 && this.lastPkg != null) {
                            jCClass = JCUtilities.getExactClass(this.finder, string4, this.lastPkg.getName());
                        } else if (this.lastType != null) {
                            jCClass = bl2 ? JCUtilities.getExactClass(this.finder, string4, this.lastType.getClazz().getFullName()) : (this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY);
                        }
                        if (jCClass != null) {
                            List list4;
                            this.lastType = JavaCompletion.getType(jCClass, 0);
                            list3 = this.finder instanceof JCBaseFinder ? JCUtilities.getConstructors(jCClass, ((JCBaseFinder)this.finder).showDeprecated()) : JCUtilities.getConstructors(jCClass);
                            string = "*";
                            list2 = this.getTypeList(jCExpression, 1);
                            list = this.sup.filterMethods(list3, list2, bl4);
                            if (list.size() > 0) {
                                list3 = list;
                                string = JavaCompletionQuery.formatTypeList(list2, bl4);
                            }
                            if ((list4 = this.finder.findMethods(jCClass, string4, true, false, bl)).size() > 0) {
                                if (bl2 && !this.findType) {
                                    this.result = new JavaResult(this.component, list4, this.formatType(this.lastType, true, true, false) + string4 + '(' + string + ')', jCExpression, this.endOffset, 0, 0);
                                } else {
                                    this.lastType = ((JCMethod)list4.get(0)).getReturnType();
                                    this.staticOnly = false;
                                }
                            } else {
                                this.result = new JavaResult(this.component, list3, this.formatType(this.lastType, true, false, false) + '(' + string + ')', jCExpression, this.endOffset, 0, 0);
                            }
                        } else {
                            this.isConstructor = false;
                        }
                    }
                    if (this.isConstructor) break;
                    if (bl && (jCClass = this.sup.getClass(jCExpression.getTokenOffset(0))) != null) {
                        this.lastType = JavaCompletion.getType(jCClass, 0);
                    }
                    if (this.lastType != null) {
                        jCClass = this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY;
                        list3 = this.finder.findMethods(jCClass, string4, true, false, bl);
                        string = "*";
                        list2 = this.getTypeList(jCExpression, 1);
                        list = this.sup.filterMethods(list3, list2, bl4);
                        if (list.size() > 0) {
                            list3 = list;
                            string = JavaCompletionQuery.formatTypeList(list2, bl4);
                        }
                        if (list3.size() > 0) {
                            if (bl2 && !this.findType) {
                                this.result = new JavaResult(this.component, list3, this.formatType(this.lastType, true, true, false) + string4 + '(' + string + ')', jCExpression, this.endOffset, 0, 0);
                                break;
                            }
                            if (list3.size() <= 0) break;
                            this.lastType = ((JCMethod)list3.get(0)).getReturnType();
                            this.staticOnly = false;
                            break;
                        }
                        this.lastType = null;
                        bl3 = false;
                        break;
                    }
                    this.lastPkg = null;
                    bl3 = false;
                }
            }
            if (this.lastType == null && this.lastPkg == null) {
                bl3 = false;
            }
            return bl3;
        }

        private List getTypeList(JCExpression jCExpression, int n) {
            int n2 = jCExpression.getParameterCount();
            ArrayList<JCType> arrayList = new ArrayList<JCType>();
            if (n2 > n) {
                for (int i = n; i < n2; ++i) {
                    JCExpression jCExpression2 = jCExpression.getParameter(i);
                    JCType jCType = this.resolveType(jCExpression2);
                    arrayList.add(jCType);
                }
            }
            return arrayList;
        }
    }
}

