/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.openide.ErrorManager;

class JavaDeclarationProcessor
implements ExtSyntaxSupport.DeclarationTokenProcessor,
ExtSyntaxSupport.VariableMapTokenProcessor {
    private static final int INIT = 0;
    private static final int TYPE_VAR = 1;
    private static final int TYPE_EXP = 2;
    private static final int VAR_EXP = 3;
    private static final int EQ_EXP = 4;
    private static final int VARIABLE = 1;
    private static final int DOT = 4;
    private static final int DOT_OPEN = 5;
    private static final int ARRAY_OPEN = 6;
    private static final int ARRAY = 7;
    private static final int PARENTHESIS_OPEN = 8;
    private static final int PARENTHESIS = 9;
    private static final int TYPE = 14;
    private static final int GENERIC_TYPE = 17;
    private static final int GENERIC_TYPE_OPEN = 18;
    private static final int GENERIC_WILD_CHAR = 19;
    private static final int NO_EXP = -1;
    private int state;
    private List expStack = new ArrayList();
    private JCExpression typeExp;
    private JavaSyntaxSupport sup;
    private int decStartPos = -1;
    private int typeVarTokenOffset;
    private int typeVarTokenLength;
    private TokenID typeVarTokenID;
    private int parenDepth;
    private int eqExpBraceDepth;
    private TokenID curTokenID;
    private int curTokenPosition;
    private int curTokenLength;
    private char[] buffer;
    private int bufferStartPos;
    private String varName;
    private StackedMap varMap;
    private boolean forScope;
    private int forScopeParenDepth;
    private Stack stackedConfigs = new Stack();

    JavaDeclarationProcessor(JavaSyntaxSupport javaSyntaxSupport, String string) {
        this.sup = javaSyntaxSupport;
        this.varName = string;
        if (string == null) {
            this.varMap = new StackedMap();
        }
    }

    public int getDeclarationPosition() {
        return this.decStartPos;
    }

    public Map getVariableMap() {
        return this.varMap;
    }

    private void clearStack() {
        this.expStack.clear();
    }

    private void pushExp(JCExpression jCExpression) {
        this.expStack.add(jCExpression);
    }

    private JCExpression popExp() {
        int n = this.expStack.size();
        return n > 0 ? (JCExpression)this.expStack.remove(n - 1) : null;
    }

    private JCExpression peekExp() {
        int n = this.expStack.size();
        return n > 0 ? (JCExpression)this.expStack.get(n - 1) : null;
    }

    private JCExpression peekExp2() {
        int n = this.expStack.size();
        return n > 1 ? (JCExpression)this.expStack.get(n - 2) : null;
    }

    private JCExpression peekExp(int n) {
        int n2 = this.expStack.size();
        return n2 >= n ? (JCExpression)this.expStack.get(n2 - n) : null;
    }

    private JCExpression createTokenExp(int n) {
        JCExpression jCExpression = new JCExpression(n);
        this.addTokenTo(jCExpression);
        return jCExpression;
    }

    private void addTokenTo(JCExpression jCExpression) {
        jCExpression.addToken(this.curTokenID, this.curTokenPosition, this.getTokenText(this.curTokenPosition, this.curTokenLength));
    }

    private int getValidExpID(JCExpression jCExpression) {
        return jCExpression != null ? jCExpression.getExpID() : -1;
    }

    private void pushTypeVar() {
        BaseTokenID baseTokenID;
        int n;
        if (this.state != 1) {
            throw new IllegalArgumentException();
        }
        this.state = 2;
        if (this.typeVarTokenID != null) {
            n = 14;
            baseTokenID = this.typeVarTokenID;
        } else {
            n = 1;
            baseTokenID = JavaTokenContext.IDENTIFIER;
        }
        JCExpression jCExpression = new JCExpression(n);
        jCExpression.addToken((TokenID)baseTokenID, this.typeVarTokenOffset, this.getTokenText(this.typeVarTokenOffset, this.typeVarTokenLength));
        this.pushExp(jCExpression);
    }

    private void reset() {
        this.state = 0;
        this.clearStack();
        this.typeExp = null;
    }

    private void pushConfig() {
        this.stackedConfigs.push(new Integer(this.parenDepth));
        this.stackedConfigs.push(new Integer(this.eqExpBraceDepth));
        this.stackedConfigs.push(new Integer(this.state));
        this.stackedConfigs.push(this.typeExp);
        this.stackedConfigs.push(this.expStack);
        this.parenDepth = 0;
        this.eqExpBraceDepth = 0;
        this.state = 0;
        this.typeExp = null;
        this.expStack = new ArrayList();
    }

    private void popConfig() {
        this.expStack = (List)this.stackedConfigs.pop();
        this.typeExp = (JCExpression)this.stackedConfigs.pop();
        this.state = (Integer)this.stackedConfigs.pop();
        this.eqExpBraceDepth = (Integer)this.stackedConfigs.pop();
        this.parenDepth = (Integer)this.stackedConfigs.pop();
    }

    private boolean formTypeExp() {
        if (this.expStack.size() == 1) {
            this.typeExp = this.popExp();
            switch (this.typeExp.getExpID()) {
                case 5: 
                case 6: {
                    this.reset();
                    return false;
                }
            }
            this.state = 3;
            return true;
        }
        this.reset();
        return false;
    }

    private boolean formVarExp(boolean bl) {
        JCExpression jCExpression;
        if (this.expStack.size() == 1) {
            jCExpression = this.popExp();
            if (jCExpression != null) {
                switch (jCExpression.getExpID()) {
                    case 1: 
                    case 7: {
                        break;
                    }
                    default: {
                        jCExpression = null;
                        break;
                    }
                }
            }
        } else {
            jCExpression = null;
        }
        if (jCExpression != null) {
            this.processDeclaration(this.typeExp, jCExpression);
            if (bl) {
                this.reset();
            }
            return true;
        }
        this.reset();
        return false;
    }

    private String getTokenText(int n, int n2) {
        try {
            return this.sup.getDocument().getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return "";
        }
    }

    private void processDeclaration(JCExpression jCExpression, JCExpression jCExpression2) {
        if (this.varName == null) {
            String string = this.getVarName(jCExpression2);
            JavaVar javaVar = new JavaVar(jCExpression, jCExpression2, this.getDeclarationPosition());
            this.varMap.put(string, javaVar);
        } else if (this.varName.equals(this.getVarName(jCExpression2))) {
            this.decStartPos = this.typeVarTokenOffset;
        }
    }

    private String getVarName(JCExpression jCExpression) {
        switch (jCExpression.getExpID()) {
            case 1: {
                return jCExpression.getTokenText(0);
            }
            case 7: {
                JCExpression jCExpression2 = jCExpression.getParameter(0);
                return jCExpression2.getTokenText(0);
            }
        }
        throw new IllegalStateException();
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
        int n3 = this.bufferStartPos + n;
        this.curTokenID = tokenID;
        this.curTokenPosition = n3;
        this.curTokenLength = n2;
        if (!tokenContextPath.contains(JavaTokenContext.contextPath)) {
            this.state = 0;
            return true;
        }
        block0 : switch (tokenID.getNumericID()) {
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        this.typeVarTokenOffset = n3;
                        this.typeVarTokenLength = n2;
                        this.typeVarTokenID = tokenID;
                        this.state = 1;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 88: {
                if (this.varMap == null) break;
                this.varMap.pushNewScope();
                this.forScope = true;
                break;
            }
            case 6: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        this.typeVarTokenOffset = n3;
                        this.typeVarTokenLength = n2;
                        this.typeVarTokenID = null;
                        this.state = 1;
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 14: 
                            case 17: {
                                if (!this.formTypeExp()) break block0;
                                this.pushExp(this.createTokenExp(1));
                                break;
                            }
                            case 5: {
                                jCExpression.setExpID(4);
                                jCExpression.addParameter(this.createTokenExp(1));
                                break;
                            }
                            case 18: {
                                this.pushExp(this.createTokenExp(1));
                                break;
                            }
                            case 19: {
                                jCExpression.setExpID(1);
                                this.addTokenTo(jCExpression);
                                break;
                            }
                            default: {
                                this.reset();
                                break;
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        if (this.expStack.size() == 0) {
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            case 48: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 17: {
                                this.popExp();
                                JCExpression jCExpression2 = this.createTokenExp(5);
                                jCExpression2.addParameter(jCExpression);
                                this.pushExp(jCExpression2);
                                break block0;
                            }
                            case 4: {
                                jCExpression.setExpID(5);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 55: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: 
                            case 14: 
                            case 17: {
                                this.popExp();
                                JCExpression jCExpression3 = this.createTokenExp(6);
                                jCExpression3.addParameter(jCExpression);
                                this.pushExp(jCExpression3);
                                break block0;
                            }
                            case 7: {
                                jCExpression.setExpID(6);
                                this.addTokenTo(jCExpression);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: {
                                this.popExp();
                                JCExpression jCExpression4 = this.createTokenExp(6);
                                jCExpression4.addParameter(jCExpression);
                                this.pushExp(jCExpression4);
                                break block0;
                            }
                            case 7: {
                                jCExpression.setExpID(6);
                                this.addTokenTo(jCExpression);
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 124: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: 
                            case 14: 
                            case 17: {
                                this.popExp();
                                JCExpression jCExpression5 = this.createTokenExp(7);
                                this.addTokenTo(jCExpression5);
                                jCExpression5.addParameter(jCExpression);
                                this.pushExp(jCExpression5);
                                break block0;
                            }
                            case 7: {
                                this.addTokenTo(jCExpression);
                                this.addTokenTo(jCExpression);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 56: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.reset();
                        break block0;
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 6: {
                                this.addTokenTo(jCExpression);
                                jCExpression.setExpID(7);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 3: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 6: {
                                this.addTokenTo(jCExpression);
                                jCExpression.setExpID(7);
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case 18: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: {
                                this.popExp();
                                JCExpression jCExpression6 = this.createTokenExp(18);
                                jCExpression6.addParameter(jCExpression);
                                this.pushExp(jCExpression6);
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 19: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: 
                            case 7: 
                            case 17: 
                            case 19: {
                                JCExpression jCExpression7 = this.peekExp2();
                                switch (this.getValidExpID(jCExpression7)) {
                                    case 18: {
                                        this.popExp();
                                        jCExpression7.addParameter(jCExpression);
                                        jCExpression7.setExpID(17);
                                        this.addTokenTo(jCExpression7);
                                        jCExpression = jCExpression7;
                                        break block0;
                                    }
                                }
                                this.reset();
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 21: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: 
                            case 17: 
                            case 19: {
                                JCExpression jCExpression8 = this.peekExp2();
                                switch (this.getValidExpID(jCExpression8)) {
                                    case 18: {
                                        JCExpression jCExpression9 = this.peekExp(3);
                                        if (this.getValidExpID(jCExpression9) == 18) {
                                            this.popExp();
                                            jCExpression8.addParameter(jCExpression);
                                            jCExpression8.setExpID(17);
                                            this.addTokenTo(jCExpression8);
                                            this.popExp();
                                            jCExpression9.addParameter(jCExpression8);
                                            jCExpression9.setExpID(17);
                                            this.addTokenTo(jCExpression9);
                                            break block0;
                                        }
                                        this.reset();
                                        break block0;
                                    }
                                }
                                this.reset();
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 22: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 2: {
                        JCExpression jCExpression = this.peekExp();
                        switch (this.getValidExpID(jCExpression)) {
                            case 1: 
                            case 4: 
                            case 17: 
                            case 19: {
                                JCExpression jCExpression10 = this.peekExp2();
                                switch (this.getValidExpID(jCExpression10)) {
                                    case 18: {
                                        JCExpression jCExpression11 = this.peekExp(3);
                                        JCExpression jCExpression12 = this.peekExp(4);
                                        if (this.getValidExpID(jCExpression11) == 18 && this.getValidExpID(jCExpression12) == 18) {
                                            this.popExp();
                                            jCExpression10.addParameter(jCExpression);
                                            jCExpression10.setExpID(17);
                                            this.addTokenTo(jCExpression10);
                                            this.popExp();
                                            jCExpression11.addParameter(jCExpression10);
                                            jCExpression11.setExpID(17);
                                            this.addTokenTo(jCExpression11);
                                            this.popExp();
                                            jCExpression12.addParameter(jCExpression11);
                                            jCExpression12.setExpID(17);
                                            this.addTokenTo(jCExpression12);
                                            break block0;
                                        }
                                        this.reset();
                                        break block0;
                                    }
                                }
                                this.reset();
                                break block0;
                            }
                        }
                        this.reset();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 53: {
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        this.reset();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++this.parenDepth;
                if (!this.forScope) break;
                ++this.forScopeParenDepth;
                break;
            }
            case 54: {
                switch (this.state) {
                    case 1: {
                        this.pushTypeVar();
                    }
                    case 0: 
                    case 2: {
                        this.reset();
                        break;
                    }
                    case 3: {
                        if (this.parenDepth == 1) {
                            this.formVarExp(true);
                            break;
                        }
                        this.reset();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (this.parenDepth > 0) {
                    --this.parenDepth;
                }
                if (!this.forScope || this.forScopeParenDepth <= 0) break;
                --this.forScopeParenDepth;
                break;
            }
            case 57: {
                if (this.state != 4) {
                    this.reset();
                    this.parenDepth = 0;
                    if (!this.forScope && this.varMap != null) {
                        this.varMap.pushNewScope();
                    }
                    this.forScope = false;
                    if (this.stackedConfigs.isEmpty()) break;
                    ++this.eqExpBraceDepth;
                    break;
                }
                this.pushConfig();
                if (!this.forScope && this.varMap != null) {
                    this.varMap.pushNewScope();
                }
                this.forScope = false;
                break;
            }
            case 58: {
                if (!this.stackedConfigs.isEmpty() && this.eqExpBraceDepth == 0) {
                    this.popConfig();
                    if (this.varMap == null) break;
                    this.varMap.removeScope();
                    break;
                }
                this.reset();
                this.parenDepth = 0;
                if (this.varMap != null) {
                    this.varMap.removeScope();
                }
                if (this.stackedConfigs.isEmpty()) break;
                --this.eqExpBraceDepth;
                break;
            }
            case 51: {
                if (this.forScope && this.forScopeParenDepth == 0) {
                    if (this.varMap != null) {
                        this.varMap.removeScope();
                    }
                    this.forScope = false;
                }
                switch (this.state) {
                    case 3: {
                        this.formVarExp(true);
                        break block0;
                    }
                    case 4: {
                        if (this.parenDepth != 0 && (this.parenDepth != 1 || !this.forScope)) break;
                        this.formVarExp(false);
                    }
                }
                this.reset();
                break;
            }
            case 49: {
                if (this.parenDepth > 1) break;
                block148 : switch (this.state) {
                    case 2: {
                        JCExpression jCExpression = this.peekExp2();
                        if (this.getValidExpID(jCExpression) == 18) {
                            JCExpression jCExpression13 = this.peekExp();
                            switch (this.getValidExpID(jCExpression13)) {
                                case 1: 
                                case 4: 
                                case 17: 
                                case 19: {
                                    this.popExp();
                                    jCExpression.addParameter(jCExpression13);
                                    this.addTokenTo(jCExpression);
                                    break block148;
                                }
                            }
                            this.reset();
                            break;
                        }
                        this.reset();
                        break;
                    }
                    case 3: {
                        this.formVarExp(this.parenDepth == 1);
                        break;
                    }
                    case 4: {
                        if (this.parenDepth != 0) break block0;
                        this.formVarExp(false);
                        this.state = 3;
                        break;
                    }
                    default: {
                        this.reset();
                        break;
                    }
                }
                break;
            }
            case 17: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 3: {
                        this.state = 4;
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 50: {
                if (this.parenDepth > 1) break;
                switch (this.state) {
                    case 3: {
                        this.formVarExp(true);
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                this.reset();
                break;
            }
            case 52: {
                JCExpression jCExpression;
                if (this.parenDepth <= 1 && this.state == 2 && this.getValidExpID(jCExpression = this.peekExp()) == 18) {
                    this.pushExp(new JCExpression(19));
                    break;
                }
                if (this.state == 4) break;
                this.reset();
                break;
            }
            case 84: 
            case 105: {
                if (this.parenDepth <= 1 && this.state == 2 && this.getValidExpID(this.peekExp()) == 19) break;
            }
            default: {
                if (this.state == 4) break;
                this.reset();
            }
        }
        return true;
    }

    public int eot(int n) {
        return 0;
    }

    public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        this.buffer = cArray;
        this.bufferStartPos = n3 - n;
    }

    private static class StackedMap
    implements Map {
        private Stack stack = new Stack();

        private StackedMap() {
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                n += ((Map)iterator.next()).size();
            }
            return n;
        }

        public boolean isEmpty() {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                if (((Map)iterator.next()).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean containsKey(Object object) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                if (!((Map)iterator.next()).containsKey(object)) continue;
                return true;
            }
            return false;
        }

        public boolean containsValue(Object object) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                if (!((Map)iterator.next()).containsValue(object)) continue;
                return true;
            }
            return false;
        }

        public Object get(Object object) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                Object v = ((Map)iterator.next()).get(object);
                if (v == null) continue;
                return v;
            }
            return null;
        }

        public Object put(Object object, Object object2) {
            if (this.stack.isEmpty()) {
                this.pushNewScope();
            }
            return ((Map)this.stack.peek()).put(object, object2);
        }

        public Object remove(Object object) {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                Object v = ((Map)iterator.next()).remove(object);
                if (v == null) continue;
                return v;
            }
            return null;
        }

        public void putAll(Map map) {
            if (this.stack.isEmpty()) {
                this.pushNewScope();
            }
            ((Map)this.stack.peek()).putAll(map);
        }

        public void clear() {
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                ((Map)iterator.next()).clear();
            }
        }

        public Set keySet() {
            TreeSet treeSet = new TreeSet();
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                treeSet.addAll(((Map)iterator.next()).keySet());
            }
            return treeSet;
        }

        public Collection values() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((Map)iterator.next()).values());
            }
            return arrayList;
        }

        public Set entrySet() {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.stack.iterator();
            while (iterator.hasNext()) {
                hashSet.addAll(((Map)iterator.next()).entrySet());
            }
            return hashSet;
        }

        public void pushNewScope() {
            this.stack.push(new HashMap());
        }

        public void removeScope() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }
    }

    private static class JavaVar
    implements JavaSyntaxSupport.OffsetJavaVariable {
        private JCExpression typeExp;
        private JCExpression varExp;
        private int offset;

        JavaVar(JCExpression jCExpression, JCExpression jCExpression2, int n) {
            this.typeExp = jCExpression;
            this.varExp = jCExpression2;
            this.offset = n;
        }

        public JCExpression getTypeExpression() {
            return this.typeExp;
        }

        public JCExpression getVariableExpression() {
            return this.varExp;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return "TYPE:\n" + this.typeExp + "\nVAR:\n" + this.varExp;
        }
    }
}

